/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.stackunit;

import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbstractAnnuityStackableExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class CreateContactEU
extends AbstractAnnuityStackableExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    boolean enableVerify = true;
    AcmeLogger logger;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setEUParams();
            IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
            contact.setConfiguration(this.getConfiguration());
            this.logger.fine("ready to create contact: " + contact);
            IContact result = this.getServerAdapter().createContact(contact);
            this.logger.fine("created contact: " + result);
            if (this.enableVerify) {
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, result, "Contact Value from client did not match DB. ", "Mismatch was Found");
            }
            this.getStackMap().put("contactId", result.getId());
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setEUParams() {
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.enableVerify = true;
        }
    }
}

