/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.persistence.impl.jpasa;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneficiary;
import com.ibm.wssvt.acme.annuity.common.bean.IFund;
import com.ibm.wssvt.acme.annuity.common.bean.IPersisteble;
import com.ibm.wssvt.acme.annuity.common.bean.IPolicy;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.persistence.PolicyPersistence;
import com.ibm.wssvt.acme.annuity.common.persistence.impl.jpasa.BasicPersistenceJPASAImpl;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.List;
import java.util.logging.Level;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class PolicyPersistenceJPASAImpl<T>
extends BasicPersistenceJPASAImpl<T>
implements PolicyPersistence<IPersisteble<T>, String, String> {
    private AcmeLogger logger;

    public PolicyPersistenceJPASAImpl(AcmeLogger logger) {
        super(logger);
        this.logger = logger;
    }

    @Override
    public List<IPolicy> getHolderPolicies(IAnnuityHolder holder) throws InvalidArgumentException, ServerPersistenceModuleException {
        this.logger.fine("getHolderPolicies");
        if (holder == null) {
            this.logger.fine("Invalid annuity holder - its null, returning Exception" + this.logger.getAllLogs());
            throw new InvalidArgumentException("Invalid Annuity Holder argument");
        }
        EntityManagerFactory factory = null;
        EntityManager em = null;
        String queryType = (String)holder.getConfiguration().getParameterValue((Object)"queryType");
        try {
            List l;
            Query query;
            factory = super.getEntityManagerFactory(holder);
            em = factory.createEntityManager();
            if (queryType != null && queryType.toLowerCase().equals("criteria")) {
                this.logger.fine("Performing criteria query for getHolderPolicies");
                String policyClassName = holder.getClass().getPackage().getName() + ".Policy";
                this.logger.finest("Policy implementation: " + policyClassName);
                CriteriaBuilder qb = em.getCriteriaBuilder();
                CriteriaQuery cq = qb.createQuery();
                Root p = cq.from(Class.forName(policyClassName));
                cq.select((Selection)p).where((Expression)qb.equal((Expression)p.get("annuityHolderId"), holder.getId()));
                query = em.createQuery(cq);
            } else {
                this.logger.fine("Performing JPQL query for getHolderPolicies");
                query = em.createNamedQuery("GetHolderPolicies");
                query.setParameter("holderId", holder.getId());
            }
            List list = l = query.getResultList();
            return list;
        }
        catch (PersistenceException e) {
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public List<IBeneficiary> getHolderBeneficiaries(IAnnuityHolder holder) throws InvalidArgumentException, ServerPersistenceModuleException {
        this.logger.fine("getHolderBeneficiaries");
        if (holder == null) {
            this.logger.fine("Invalid anuity holder - its null, returning Exception " + this.logger.getAllLogs());
            throw new InvalidArgumentException("Invalid Annuity Holder argument");
        }
        EntityManagerFactory factory = null;
        EntityManager em = null;
        String queryType = (String)holder.getConfiguration().getParameterValue((Object)"queryType");
        try {
            List l;
            Query query;
            factory = super.getEntityManagerFactory(holder);
            em = factory.createEntityManager();
            if (queryType != null && queryType.toLowerCase().equals("criteria")) {
                this.logger.fine("Performing criteria query for getHolderBeneficiaries");
                String beneficiaryClassName = holder.getClass().getPackage().getName() + ".Beneficiary";
                this.logger.finest("Beneficiary implementation: " + beneficiaryClassName);
                CriteriaBuilder qb = em.getCriteriaBuilder();
                CriteriaQuery cq = qb.createQuery();
                Root p = cq.from(Class.forName(beneficiaryClassName));
                cq.select((Selection)p).where((Expression)qb.equal((Expression)p.get("annuityHolderId"), holder.getId()));
                query = em.createQuery(cq);
            } else {
                this.logger.fine("Performing JPQL query for getHolderBeneficiaries");
                query = em.createNamedQuery("GetHolderBeneficiaries");
                query.setParameter("holderId", holder.getId());
            }
            List list = l = query.getResultList();
            return list;
        }
        catch (PersistenceException e) {
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public List<String> getHolderBeneficiaryContactEmails(IAnnuityHolder holder) throws InvalidArgumentException, ServerPersistenceModuleException {
        this.logger.fine("getHolderBeneficiaryContactEmails");
        if (holder == null) {
            this.logger.fine("Invalid anuity holder - its null, returning Exception " + this.logger.getAllLogs());
            throw new InvalidArgumentException("Invalid Annuity Holder argument");
        }
        EntityManagerFactory factory = null;
        EntityManager em = null;
        String queryType = (String)holder.getConfiguration().getParameterValue((Object)"queryType");
        try {
            List l;
            Query query;
            factory = super.getEntityManagerFactory(holder);
            em = factory.createEntityManager();
            if (queryType != null && queryType.toLowerCase().equals("criteria")) {
                this.logger.fine("Performing criteria query for getHolderBeneficiaryContactEmails");
                String beneContactClassName = holder.getClass().getPackage().getName() + ".BeneContact";
                this.logger.finest("BeneContact implementation: " + beneContactClassName);
                CriteriaBuilder qb = em.getCriteriaBuilder();
                CriteriaQuery cq = qb.createQuery();
                Root p = cq.from(Class.forName(beneContactClassName));
                cq.select((Selection)p.get("email")).where((Expression)qb.equal((Expression)p.get("beneficiary").get("annuityHolderId"), holder.getId())).orderBy(new Order[]{qb.asc((Expression)p.get("email"))});
                List sorting = cq.getOrderList();
                sorting.add(0, qb.asc((Expression)p.get("id").get("contactType")));
                cq.orderBy(sorting);
                query = em.createQuery(cq);
            } else {
                this.logger.fine("Performing JPQL query for getHolderBeneficiaryContactEmails");
                query = em.createNamedQuery("GetHolderBeneficiaryContactEmails");
                query.setParameter("holderId", holder.getId());
            }
            List list = l = query.getResultList();
            return list;
        }
        catch (PersistenceException e) {
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public IFund getFundIndexRateFromFundName(IAnnuityHolder holder, String fundName) throws InvalidArgumentException, ServerPersistenceModuleException {
        this.logger.fine("getFundIndexRateFromFundName");
        if (holder == null) {
            this.logger.fine("Invalid anuity holder - its null, returning Exception " + this.logger.getAllLogs());
            throw new InvalidArgumentException("Invalid Annuity Holder argument");
        }
        EntityManagerFactory factory = null;
        EntityManager em = null;
        String queryType = (String)holder.getConfiguration().getParameterValue((Object)"queryType");
        try {
            Query query;
            factory = super.getEntityManagerFactory(holder);
            em = factory.createEntityManager();
            if (queryType != null && queryType.toLowerCase().equals("criteria")) {
                this.logger.fine("Performing criteria query for getFundIndexRateFromFundName");
                String policyClassName = holder.getClass().getPackage().getName() + ".Policy";
                this.logger.finest("Policy implementation: " + policyClassName);
                CriteriaBuilder qb = em.getCriteriaBuilder();
                CriteriaQuery cq = qb.createQuery();
                Root policy = cq.from(Class.forName(policyClassName));
                MapJoin fund = policy.joinMap("Funds");
                cq.select((Selection)fund).where(new Predicate[]{qb.equal((Expression)fund.get("fundName"), (Object)fundName), qb.equal((Expression)policy.get("annuityHolderId"), holder.getId())});
                query = em.createQuery(cq);
            } else {
                this.logger.fine("Performing JPQL query for getFundIndexRateFromFundName");
                query = em.createNamedQuery("GetFundIndexRateFromFundName");
                query.setParameter("holderId", holder.getId());
                query.setParameter("fName", (Object)fundName);
            }
            Object o = query.getSingleResult();
            IFund iFund = (IFund)o;
            return iFund;
        }
        catch (PersistenceException e) {
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public List<IFund> getFundsInState(IAnnuityHolder holder, String state) throws InvalidArgumentException, ServerPersistenceModuleException {
        this.logger.fine("getFundsInState");
        if (holder == null) {
            this.logger.fine("Invalid anuity holder - its null, returning Exception " + this.logger.getAllLogs());
            throw new InvalidArgumentException("Invalid Annuity Holder argument");
        }
        EntityManagerFactory factory = null;
        EntityManager em = null;
        String queryType = (String)holder.getConfiguration().getParameterValue((Object)"queryType");
        try {
            List l;
            Query query;
            factory = super.getEntityManagerFactory(holder);
            em = factory.createEntityManager();
            if (queryType != null && queryType.toLowerCase().equals("criteria")) {
                this.logger.fine("Performing criteria query for getFundsInState");
                String policyClassName = holder.getClass().getPackage().getName() + ".Policy";
                this.logger.finest("Policy implementation: " + policyClassName);
                CriteriaBuilder qb = em.getCriteriaBuilder();
                CriteriaQuery cq = qb.createQuery();
                Root policy = cq.from(Class.forName(policyClassName));
                MapJoin fund = policy.joinMap("Funds");
                cq.where((Expression)qb.equal((Expression)policy.get("annuityHolderId"), holder.getId()));
                cq.where(new Predicate[]{cq.getRestriction(), qb.equal((Expression)fund.get("theAddress").get("state"), (Object)state)}).select((Selection)fund);
                query = em.createQuery(cq);
            } else {
                this.logger.fine("Performing JPQL query for getFundsInState");
                query = em.createNamedQuery("GetHolderFundsInState");
                query.setParameter("holderId", holder.getId());
                query.setParameter("state", (Object)state);
            }
            List list = l = query.getResultList();
            return list;
        }
        catch (PersistenceException e) {
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public List<IPersisteble<T>> customQuery(IAnnuityHolder holder) throws InvalidArgumentException, ServerPersistenceModuleException {
        EntityManagerFactory factory = null;
        EntityManager em = null;
        String rootClass = (String)holder.getConfiguration().getParameterValue((Object)"queryRoot");
        try {
            List l;
            factory = super.getEntityManagerFactory(holder);
            em = factory.createEntityManager();
            this.logger.fine("Performing custom criteria query");
            String rootClassName = holder.getClass().getPackage().getName() + "." + rootClass;
            this.logger.finest("Root class: " + rootClassName);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery();
            Root root = cq.from(Class.forName(rootClassName));
            cq.select((Selection)root).where((Expression)qb.equal((Expression)root.get("annuityHolderId"), holder.getId()));
            TypedQuery query = em.createQuery(cq);
            List list = l = query.getResultList();
            return list;
        }
        catch (PersistenceException e) {
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }
}

