/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.jaxrs;

import com.ibm.ws.util.Base64;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityObject;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityJAXRSReturn;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.ListOfObjects;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.jaxrs.MyJAXBResolver;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.util.MultivaluedMapImpl;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.wink.client.ApacheHttpClientConfig;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.BasicAuthSecurityHandler;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.LtpaAuthSecurityHandler;
import org.apache.wink.common.model.atom.AtomContent;
import org.apache.wink.common.model.atom.AtomEntry;
import org.apache.wink.common.model.wadl.Application;
import org.apache.wink.common.model.wadl.ObjectFactory;
import org.apache.wink.common.model.wadl.Resources;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class AnnuityJAXRSServicePorxy
implements IAnnuityService {
    private static final String POST = "post";
    private static final String PUT = "put";
    private static final String GET = "get";
    private static final String DELETE = "delete";
    private static final String JAXB = "jaxb";
    private static final String JSON = "json";
    private static final String ATOM = "atom";
    private static final int DEFAULT_READ_TIMEOUT = 600000;
    private AcmeLogger logger;
    private String serverURL;
    private byte[] spnegoKey;
    private String contentType;
    private Configrable<String, String> configs;

    public AnnuityJAXRSServicePorxy(Configrable<String, String> configs, String serverURL, String contentType, AcmeLogger logger, byte[] spnegoKey) {
        this.logger = logger;
        this.serverURL = serverURL;
        this.contentType = contentType;
        this.logger.fine("inited ok");
        this.spnegoKey = spnegoKey;
        this.configs = configs;
        if (JAXB.equalsIgnoreCase(contentType)) {
            this.contentType = JAXB;
        } else if (JSON.equalsIgnoreCase(contentType)) {
            this.contentType = JSON;
        } else if (ATOM.equalsIgnoreCase(contentType)) {
            this.contentType = ATOM;
        } else {
            logger.fine("contentType is not JAXB, JSON, or ATOM.  Defaulting to JAXB.  Current value is: " + this.contentType);
            this.contentType = JAXB;
        }
    }

    private RestClient getRestClient() throws ServerAdapterCommunicationException {
        String useApacheClient = (String)this.configs.getConfiguration().getParameterValue((Object)"useApacheClient");
        Object config = useApacheClient.equalsIgnoreCase("true") ? new ApacheHttpClientConfig() : new ClientConfig();
        String useSecurity = (String)this.configs.getConfiguration().getParameterValue((Object)"useSecurity");
        String userTimeout = (String)this.configs.getConfiguration().getParameterValue((Object)"readTimeout");
        String useSSL = null;
        boolean isSSLRequired = true;
        if (this.configs.getConfiguration().getParameterValue((Object)"useSSL") != null) {
            useSSL = (String)this.configs.getConfiguration().getParameterValue((Object)"useSSL");
        }
        if ("BASIC_AUTH".equalsIgnoreCase(useSecurity)) {
            this.logger.fine("useSecurity is enabled and set to BASIC_AUTH.");
            String userName = (String)this.configs.getConfiguration().getParameterValue((Object)"userName");
            String userPassword = (String)this.configs.getConfiguration().getParameterValue((Object)"userPassword");
            if (userName == null || userName.trim().length() == 0) {
                throw new ServerAdapterCommunicationException("Connection to REST service is set to use security, but the userName is null or empty.  Current value is: " + userName);
            }
            if (userPassword == null || userPassword.trim().length() == 0) {
                throw new ServerAdapterCommunicationException("Connection to REST service is set to use security, but the userPassword is null or empty.  Current value is: " + userPassword);
            }
            this.logger.fine("userName: " + userName);
            this.logger.fine("userPassword: " + userPassword);
            BasicAuthSecurityHandler secHandler = new BasicAuthSecurityHandler();
            if ("false".equalsIgnoreCase(useSSL)) {
                isSSLRequired = false;
            }
            secHandler.setSSLRequired(isSSLRequired);
            secHandler.setUserName(userName);
            secHandler.setPassword(userPassword);
            config.handlers(new ClientHandler[]{secHandler});
        }
        if ("DOWN_STREAM".equalsIgnoreCase(useSecurity)) {
            this.logger.fine("useSecurity is enabled and set to DOWN_STREAM.");
            LtpaAuthSecurityHandler ltpaSecHandler = new LtpaAuthSecurityHandler();
            config.handlers(new ClientHandler[]{ltpaSecHandler});
        }
        if (userTimeout != null) {
            config.readTimeout(Integer.parseInt(userTimeout));
            this.logger.fine("Read timeout value is set to: " + userTimeout);
        } else {
            config.readTimeout(600000);
            this.logger.fine("Read timeout value is set to: 600000");
        }
        return new RestClient(config.applications(new javax.ws.rs.core.Application[]{new MyJAXRSApplication()}));
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(ann, null, POST, "/annuity", AnnuityValueObject.class);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityAlreadyExistsException.class.getName())) {
            throw new EntityAlreadyExistsException(ret.getErrorMsg());
        }
        AnnuityValueObject result = (AnnuityValueObject)ret.getReturnObject();
        return result.getAnnuity();
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(annHolder, null, POST, "/annuityholder", null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityAlreadyExistsException.class.getName())) {
            throw new EntityAlreadyExistsException(ret.getErrorMsg());
        }
        return (IAnnuityHolder)ret.getReturnObject();
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(payor, null, POST, "/payor", null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityAlreadyExistsException.class.getName())) {
            throw new EntityAlreadyExistsException(ret.getErrorMsg());
        }
        return (IPayor)ret.getReturnObject();
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(payout, null, POST, "/payout", PayoutValueObject.class);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityAlreadyExistsException.class.getName())) {
            throw new EntityAlreadyExistsException(ret.getErrorMsg());
        }
        PayoutValueObject result = (PayoutValueObject)ret.getReturnObject();
        return result.getPayout();
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        this.executeAndVerify(null, annuity, DELETE, "/annuity/" + (String)annuity.getId(), null);
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        this.executeAndVerify(null, annHolder, DELETE, "/annuityholder/" + (String)annHolder.getId(), null);
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        this.executeAndVerify(null, payor, DELETE, "/payor/" + (String)payor.getId(), null);
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        this.executeAndVerify(null, payout, DELETE, "/payout/" + (String)payout.getId(), null);
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        this.executeAndVerify(null, rider, DELETE, "/rider/" + (String)rider.getId(), null);
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(null, annuity, GET, "/annuity/" + (String)annuity.getId(), null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityNotFoundException.class.getName())) {
            throw new EntityNotFoundException(ret.getErrorMsg());
        }
        AnnuityValueObject result = (AnnuityValueObject)ret.getReturnObject();
        return result.getAnnuity();
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(null, annuity, GET, "/annuityholder/annuity/" + (String)annuity.getId(), null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityNotFoundException.class.getName())) {
            throw new EntityNotFoundException(ret.getErrorMsg());
        }
        return (IAnnuityHolder)ret.getReturnObject();
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(contact, null, POST, "/contact", null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityAlreadyExistsException.class.getName())) {
            throw new EntityAlreadyExistsException(ret.getErrorMsg());
        }
        IContact result = (IContact)ret.getReturnObject();
        return result;
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(contact, null, PUT, "/contact", null);
        IContact result = (IContact)ret.getReturnObject();
        return result;
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(null, contact, GET, "/contact/" + (String)contact.getId(), null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityNotFoundException.class.getName())) {
            throw new EntityNotFoundException(ret.getErrorMsg());
        }
        IContact result = (IContact)ret.getReturnObject();
        return result;
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        this.executeAndVerify(null, contact, DELETE, "/contact/" + (String)contact.getId(), null);
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(null, annuityHolder, GET, "/annuity/holder/" + (String)annuityHolder.getId(), null);
        ListOfObjects result = (ListOfObjects)ret.getReturnObject();
        ArrayList<IAnnuity> annuities = new ArrayList<IAnnuity>();
        if (result != null) {
            for (Object obj : result.getObjects()) {
                if (!(obj instanceof AnnuityValueObject)) {
                    String msg = "expected a return of AnnuityValueObject, but found: " + obj.getClass().getName() + " internal logs: " + this.logger.getAllLogs();
                    this.logger.info(msg);
                    throw new RuntimeException(msg);
                }
                annuities.add(((AnnuityValueObject)obj).getAnnuity());
            }
        }
        return annuities;
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(null, annuityHolder, GET, "/annuityholder/" + (String)annuityHolder.getId(), null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityNotFoundException.class.getName())) {
            throw new EntityNotFoundException(ret.getErrorMsg());
        }
        IAnnuityHolder result = (IAnnuityHolder)ret.getReturnObject();
        return result;
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(null, payor, GET, "/annuity/payor/" + (String)payor.getId(), null);
        ListOfObjects result = (ListOfObjects)ret.getReturnObject();
        ArrayList<IAnnuity> annuities = new ArrayList<IAnnuity>();
        if (result != null) {
            for (Object obj : result.getObjects()) {
                if (!(obj instanceof AnnuityValueObject)) {
                    String msg = "expected a return of AnnuityValueObject, but found: " + obj.getClass().getName() + " internal logs: " + this.logger.getAllLogs();
                    this.logger.info(msg);
                    throw new RuntimeException(msg);
                }
                annuities.add(((AnnuityValueObject)obj).getAnnuity());
            }
        }
        return annuities;
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(null, payor, GET, "/payor/" + (String)payor.getId(), null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityNotFoundException.class.getName())) {
            throw new EntityNotFoundException(ret.getErrorMsg());
        }
        IPayor result = (IPayor)ret.getReturnObject();
        return result;
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(null, payout, GET, "/payout/" + (String)payout.getId(), null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityNotFoundException.class.getName())) {
            throw new EntityNotFoundException(ret.getErrorMsg());
        }
        PayoutValueObject result = (PayoutValueObject)ret.getReturnObject();
        return result.getPayout();
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(null, rider, GET, "/rider/" + (String)rider.getId(), null);
        if (ret.getErrorClass() != null && ret.getErrorClass().equals(EntityNotFoundException.class.getName())) {
            throw new EntityNotFoundException(ret.getErrorMsg());
        }
        IRider result = (IRider)ret.getReturnObject();
        return result;
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity ann) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(ann, null, PUT, "/annuity", AnnuityValueObject.class);
        AnnuityValueObject result = (AnnuityValueObject)ret.getReturnObject();
        return result.getAnnuity();
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(annHolder, null, PUT, "/annuityholder", null);
        IAnnuityHolder result = (IAnnuityHolder)ret.getReturnObject();
        return result;
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(payor, null, PUT, "/payor", null);
        IPayor result = (IPayor)ret.getReturnObject();
        return result;
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityJAXRSReturn ret = this.executeAndVerify(payout, null, PUT, "/payout", PayoutValueObject.class);
        PayoutValueObject result = (PayoutValueObject)ret.getReturnObject();
        return result.getPayout();
    }

    private AnnuityJAXRSReturn executeAndVerify(IAnnuityObject requestObject, Configrable<String, String> configrable, String methodType, String urlPath, Class wrapperObjectClass) throws InvalidArgumentException, ServerBusinessModuleException, ServerPersistenceModuleException {
        AnnuityJAXRSReturn retVal = null;
        IAnnuityObject realRequestObject = requestObject;
        if (wrapperObjectClass != null) {
            Object wrapperObject;
            try {
                wrapperObject = wrapperObjectClass.newInstance();
            }
            catch (Exception e) {
                this.logger.fine(AnnuityJAXRSServicePorxy.stackToString(e));
                throw new RuntimeException(e);
            }
            if (wrapperObject instanceof AnnuityValueObject) {
                ((AnnuityValueObject)wrapperObject).setAnnuity((IAnnuity)requestObject);
                realRequestObject = wrapperObject;
            } else if (wrapperObject instanceof PayoutValueObject) {
                ((PayoutValueObject)wrapperObject).setPayout((IPayout)requestObject);
                realRequestObject = wrapperObject;
            }
        }
        AnnuityJAXRSReturn ret = this.execute(realRequestObject, configrable, methodType, urlPath);
        if (retVal == null) {
            retVal = ret;
        }
        if (methodType.equals(GET) || methodType.equals(PUT)) {
            if (ret.getErrorClass() != null) {
                this.processCommonExceptions(ret);
            } else if (!ret.getReturnObjectClass().equals(ret.getReturnObject().getClass().getName())) {
                String msg = "expected a return of " + ret.getReturnObjectClass() + ", but found: " + ret.getReturnObject().getClass().getName() + " internal logs: " + this.logger.getAllLogs();
                this.logger.info(msg);
                throw new RuntimeException(msg);
            }
        }
        return retVal;
    }

    private AnnuityJAXRSReturn execute(Object requestObject, Configrable<String, String> configrable, String methodType, String urlPath) {
        int responseCode = 0;
        try {
            String msg;
            URL url = null;
            try {
                url = new URL(this.serverURL);
            }
            catch (MalformedURLException e) {
                throw new ServerAdapterCommunicationException("a URL provided in the execution unit is not a valid URL. Current value is: " + this.serverURL + " Error is: " + e);
            }
            this.logger.fine("Host: " + url.getHost());
            this.logger.fine("Port: " + url.getPort());
            RestClient client = this.getRestClient();
            Resource resource = client.resource(this.serverURL + urlPath);
            this.logger.fine("contentType is set to: " + this.contentType);
            if (JAXB.equalsIgnoreCase(this.contentType)) {
                resource.contentType("application/xml");
                resource.accept(new String[]{"application/xml"});
            } else if (ATOM.equalsIgnoreCase(this.contentType)) {
                resource.contentType("application/atom+xml");
                resource.accept(new String[]{"application/atom+xml"});
                if (requestObject != null) {
                    AtomContent atomContent = new AtomContent();
                    atomContent.setType("application/xml");
                    atomContent.setValue(requestObject);
                    AtomEntry atomEntry = new AtomEntry();
                    atomEntry.setContent(atomContent);
                    requestObject = atomEntry;
                }
            } else {
                resource.contentType("application/json");
                resource.accept(new String[]{"application/json"});
            }
            AnnuityJAXRSReturn annuityReturn = null;
            try {
                if (this.spnegoKey != null) {
                    this.logger.fine("SPNEGO key is set to: " + this.spnegoKey);
                    resource.header("Authorization", new String[]{"Negotiate " + Base64.encode((byte[])this.spnegoKey)});
                    resource.cookie("ClientAuthenticationToken=FFEEBCC");
                }
                ClientResponse clientResponse = null;
                if (this.configs.getConfiguration().getParameterValue((Object)"useWADL") != null && "true".equalsIgnoreCase((String)this.configs.getConfiguration().getParameterValue((Object)"useWADL"))) {
                    this.logger.info("useWADL is set to true");
                    clientResponse = client.resource(this.serverURL + urlPath).accept(new String[]{"application/xml"}).options();
                    Application wadlDoc = (Application)clientResponse.getEntity(Application.class);
                    if (wadlDoc != null) {
                        this.logger.info("Got WADL");
                        List resourcesFromWADL = wadlDoc.getResources();
                        int count = resourcesFromWADL.size();
                        this.logger.info("size of the WADL resources is: " + count);
                        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class}).createMarshaller();
                        for (int i = 0; i < count; ++i) {
                            Resources r = (Resources)resourcesFromWADL.get(i);
                            this.logger.info("Resources in the WADL");
                            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                            StringWriter writer = new StringWriter();
                            marshaller.marshal((Object)r, (Writer)writer);
                            this.logger.info(writer.getBuffer().toString());
                        }
                    }
                }
                if (methodType.equalsIgnoreCase(GET)) {
                    this.logger.fine("processing GET method. URL: " + this.serverURL + urlPath);
                    resource.queryParams(this.toMultivaluedMap(configrable));
                    clientResponse = resource.get();
                } else if (methodType.equalsIgnoreCase(POST)) {
                    this.logger.fine("processing POST method. URL: " + this.serverURL + urlPath);
                    clientResponse = resource.post(requestObject);
                } else if (methodType.equalsIgnoreCase(PUT)) {
                    this.logger.fine("processing PUT method. URL: " + this.serverURL + urlPath);
                    clientResponse = resource.put(requestObject);
                } else if (methodType.equalsIgnoreCase(DELETE)) {
                    this.logger.fine("processing DELETE method. URL: " + this.serverURL + urlPath);
                    resource.queryParams(this.toMultivaluedMap(configrable));
                    clientResponse = resource.delete();
                }
                responseCode = clientResponse.getStatusCode();
                this.logger.fine("Executed method " + methodType + ".  response code is: " + responseCode);
                if (responseCode != 200) {
                    String msg2 = "Expected the response code to be 200, but found: " + responseCode;
                    this.logger.info(msg2);
                    throw new RuntimeException(msg2);
                }
                annuityReturn = ATOM.equalsIgnoreCase(this.contentType) ? (AnnuityJAXRSReturn)((AtomEntry)clientResponse.getEntity(AtomEntry.class)).getContent().getValue(AnnuityJAXRSReturn.class) : (AnnuityJAXRSReturn)clientResponse.getEntity(AnnuityJAXRSReturn.class);
            }
            catch (Exception e) {
                this.logger.fine(AnnuityJAXRSServicePorxy.stackToString(e));
                throw new RuntimeException(e.getMessage());
            }
            if (annuityReturn == null) {
                msg = "Unexpected error . got a null return object. response code is: " + responseCode + " internal logs: " + this.logger.getAllLogs();
                this.logger.info(msg);
                throw new RuntimeException(msg);
            }
            if (annuityReturn.getReturnObjectClass() != null && annuityReturn.getReturnObject() == null) {
                msg = "Unexpected error . get a return object with a class String, but with null object. response code is: " + responseCode + " internal logs: " + this.logger.getAllLogs();
                this.logger.info(msg);
                throw new RuntimeException(msg);
            }
            if (annuityReturn.getReturnObjectClass() == null && annuityReturn.getReturnObject() != null) {
                msg = "Unexpected error . get a return object with null class String, but with a non null object. response code is: " + responseCode + " internal logs: " + this.logger.getAllLogs();
                this.logger.info(msg);
                throw new RuntimeException(msg);
            }
            if (annuityReturn.getErrorClass() == null && annuityReturn.getErrorMsg() != null) {
                msg = "Unexpected error . get a return object with No error class, but with error message. response code is: " + responseCode + " internal logs: " + this.logger.getAllLogs();
                this.logger.info(msg);
                throw new RuntimeException(msg);
            }
            if (annuityReturn.getErrorClass() != null && annuityReturn.getErrorMsg() == null) {
                msg = "Unexpected error . get a return object with error class, but with no error message. response code is: " + responseCode + " internal logs: " + this.logger.getAllLogs();
                this.logger.info(msg);
                throw new RuntimeException(msg);
            }
            return annuityReturn;
        }
        catch (ServerAdapterCommunicationException e) {
            this.logger.fine(AnnuityJAXRSServicePorxy.stackToString(e));
            throw new RuntimeException(e.getMessage());
        }
        catch (Throwable t) {
            this.logger.fine(AnnuityJAXRSServicePorxy.stackToString(t));
            throw new RuntimeException(t.getMessage());
        }
    }

    private void processCommonExceptions(AnnuityJAXRSReturn ar) throws InvalidArgumentException, ServerBusinessModuleException, ServerPersistenceModuleException {
        if (InvalidArgumentException.class.getName().equals(ar.getErrorClass())) {
            throw new InvalidArgumentException(ar.getErrorMsg());
        }
        if (ServerBusinessModuleException.class.getName().equals(ar.getErrorClass())) {
            throw new ServerBusinessModuleException(ar.getErrorMsg());
        }
        if (ServerPersistenceModuleException.class.getName().equals(ar.getErrorClass())) {
            throw new ServerPersistenceModuleException(ar.getErrorMsg());
        }
        if (EntityNotFoundException.class.getName().equals(ar.getErrorClass())) {
            return;
        }
        if (EntityAlreadyExistsException.class.getName().equals(ar.getErrorClass())) {
            return;
        }
        throw new RuntimeException("Unexpected exception class. Error class is: " + ar.getErrorClass() + "error message is: " + ar.getErrorMsg() + " internal logs: " + this.logger.getAllLogs());
    }

    private MultivaluedMap<String, String> toMultivaluedMap(Configrable<String, String> configrable) {
        MultivaluedMapImpl<String, String> multiValuedMap = new MultivaluedMapImpl<String, String>();
        if (configrable == null || configrable.getConfiguration() == null || configrable.getConfiguration().getParameters() == null) {
            return multiValuedMap;
        }
        for (String key : configrable.getConfiguration().getParameters().keySet()) {
            String value = (String)configrable.getConfiguration().getParameterValue((Object)key);
            if (value == null || value.trim().length() <= 0) continue;
            multiValuedMap.add(key, value);
        }
        this.logger.fine("Params: " + multiValuedMap);
        return multiValuedMap;
    }

    private static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = text.substring(text.indexOf("at"));
        text = AnnuityJAXRSServicePorxy.replace(text, "at ", "DEBUG_FRAME = ");
        return text;
    }

    private static final String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return new String(sb);
    }

    private class MyJAXRSApplication
    extends javax.ws.rs.core.Application {
        private MyJAXRSApplication() {
        }

        public Set<Class<?>> getClasses() {
            HashSet set = new HashSet();
            set.add(MyJAXBResolver.class);
            return set;
        }

        public Set<Object> getSingletons() {
            HashSet<Object> set = new HashSet<Object>();
            set.add(this.getJacksonProvider());
            return set;
        }

        private JacksonJsonProvider getJacksonProvider() {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enableDefaultTyping();
            JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector();
            mapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)jaxbIntrospector);
            mapper.getSerializationConfig().set(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, true);
            mapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)jaxbIntrospector);
            JacksonJsonProvider jacksonProvider = new JacksonJsonProvider();
            jacksonProvider.setMapper(mapper);
            return jacksonProvider;
        }
    }
}

