/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.pojojaxrpc;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Contact;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Payor;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.Rider;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.beanconverter.JavaBeanToJaxrpcClientBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.beanconverter.JaxrpcClientBeanToJavaBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.pojoimpl.AnnuityMgmtSvcPojoJAXRPCSEI;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class AnnuityJAXRPCServiceProxy
implements IAnnuityService {
    private AnnuityMgmtSvcPojoJAXRPCSEI webService;

    public AnnuityJAXRPCServiceProxy(AnnuityMgmtSvcPojoJAXRPCSEI webServiceInterface) {
        this.webService = webServiceInterface;
    }

    private void processCommonExceptions(Exception e) throws InvalidArgumentException, ServerInternalErrorException {
        if (e instanceof com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.InvalidArgumentException) {
            throw new InvalidArgumentException(e);
        }
        if (e instanceof ServerBusinessModuleException) {
            throw new com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException(e);
        }
        if (e instanceof ServerPersistenceModuleException) {
            throw new com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException(e);
        }
        if (e instanceof RemoteException) {
            throw new ServerInternalErrorException("Remote Exception was thrown.  Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        e.printStackTrace();
        throw new RuntimeException("Unexpected error. Erros is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJaxrpcClientBean.getAnnuity(ann));
            result = this.webService.createAnnuity(annuityValueObject);
            annuityValueObject.getAnnuity();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getAnnuity(result.getAnnuity());
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.createAnnuityHolder(JavaBeanToJaxrpcClientBean.getAnnuityHolder(annHolder));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.createContact(JavaBeanToJaxrpcClientBean.getContact(contact));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.createPayor(JavaBeanToJaxrpcClientBean.getPayor(payor));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJaxrpcClientBean.getPayout(payout));
            result = this.webService.createPayout(payoutValueObject);
            payoutValueObject.getPayout();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getPayout(result.getPayout());
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJaxrpcClientBean.getAnnuity(annuity));
            this.webService.deleteAnnuity(annuityValueObject);
            annuityValueObject.getAnnuity();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteAnnuityHolder(JavaBeanToJaxrpcClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteContact(JavaBeanToJaxrpcClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deletePayor(JavaBeanToJaxrpcClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJaxrpcClientBean.getPayout(payout));
            this.webService.deletePayout(payoutValueObject);
            payoutValueObject.getPayout();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteRider(JavaBeanToJaxrpcClientBean.getRider(rider));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJaxrpcClientBean.getAnnuity(annuity));
            result = this.webService.findAnnuityById(annuityValueObject);
            annuityValueObject.getAnnuity();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getAnnuity(result.getAnnuity());
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJaxrpcClientBean.getAnnuity(annuity));
            result = this.webService.findAnnuityHolder(annuityValueObject);
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.findContactById(JavaBeanToJaxrpcClientBean.getContact(contact));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getContact(result);
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject[] result = null;
        try {
            result = this.webService.findHolderAnnuities(JavaBeanToJaxrpcClientBean.getAnnuityHolder(annuityHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return this.getAnnuityListFromAnnuityVOList(result);
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.findHolderById(JavaBeanToJaxrpcClientBean.getAnnuityHolder(annuityHolder));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject[] result = null;
        try {
            result = this.webService.findPayorAnnuities(JavaBeanToJaxrpcClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return this.getAnnuityListFromAnnuityVOList(result);
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.findPayorById(JavaBeanToJaxrpcClientBean.getPayor(payor));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJaxrpcClientBean.getPayout(payout));
            result = this.webService.findPayoutById(payoutValueObject);
            payoutValueObject.getPayout();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getPayout(result.getPayout());
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Rider result = null;
        try {
            result = this.webService.findRiderById(JavaBeanToJaxrpcClientBean.getRider(rider));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getRider(result);
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity ann) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJaxrpcClientBean.getAnnuity(ann));
            result = this.webService.updateAnnuity(annuityValueObject);
            annuityValueObject.getAnnuity();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getAnnuity(result.getAnnuity());
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.updateAnnuityHolder(JavaBeanToJaxrpcClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.updateContact(JavaBeanToJaxrpcClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.updatePayor(JavaBeanToJaxrpcClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJaxrpcClientBean.getPayout(payout));
            result = this.webService.updatePayout(payoutValueObject);
            payoutValueObject.getPayout();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JaxrpcClientBeanToJavaBean.getPayout(result.getPayout());
    }

    private List<IAnnuity> getAnnuityListFromAnnuityVOList(AnnuityValueObject[] result) {
        if (result == null) {
            return null;
        }
        ArrayList<IAnnuity> list = new ArrayList<IAnnuity>();
        for (int i = 0; i < result.length; ++i) {
            AnnuityValueObject o = result[i];
            list.add(JaxrpcClientBeanToJavaBean.getAnnuity(o.getAnnuityData()));
        }
        return list;
    }
}

