/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.util;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.wssvt.acme.common.bean.Configrable;

public class RunningServerInfo {
    private String cellName;
    private String nodeName;
    private String processName;
    private static RunningServerInfo instance = null;

    private RunningServerInfo() {
        AdminService admin = AdminServiceFactory.getAdminService();
        this.cellName = admin.getCellName();
        this.nodeName = admin.getNodeName();
        this.processName = admin.getProcessName();
    }

    public static synchronized RunningServerInfo getInstance() {
        if (instance == null) {
            instance = new RunningServerInfo();
        }
        return instance;
    }

    public String getRunningServerInfo() {
        StringBuffer name = new StringBuffer();
        try {
            name.append(this.cellName);
            name.append("/");
            name.append(this.nodeName);
            name.append("/");
            name.append(this.processName);
        }
        catch (Exception e) {
            name.append(" Unable to get serverName");
        }
        return name.toString();
    }

    public void setRunningServerInfo(Configrable<String, String> configrable) {
        if (configrable == null) {
            return;
        }
        String runningOnServers = (String)configrable.getConfiguration().getParameterValue((Object)"internal.runningOnServerInfo");
        if (runningOnServers == null) {
            configrable.getConfiguration().addParameter((Object)"internal.runningOnServerInfo", (Object)this.getRunningServerInfo());
        } else {
            configrable.getConfiguration().addParameter((Object)"internal.runningOnServerInfo", (Object)(runningOnServers + ";;" + this.getRunningServerInfo()));
        }
    }

    public String getCellName() {
        if (null == this.cellName) {
            AdminService admin = AdminServiceFactory.getAdminService();
            this.cellName = admin.getCellName();
        }
        return this.cellName;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }
}

