/*******************************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.logging.hpel;

import com.ibm.ws.logging.object.hpel.RepositoryPointerImpl;

/**
 * Interface representing browsing capability over directories containing log files
 * from different restarts of a server.
 */
public interface MainLogRepositoryBrowser {
	/**
	 * finds browser over log files written by a process active at the
	 * specified time.
	 * 
	 * @param timestamp time in milliseconds when process in question was active.
	 * @return browser listing log files written by the process or <code>null</code> if
	 *        all processes were started after that time.
	 */
	LogRepositoryBrowser findByMillis(long timestamp);
	
	/**
	 * finds browser over log files written by a process which was active
	 * after the process generated log files in the specified location.
	 * 
	 * @param current browser over log files generated by the previously active process.
	 * @param timelimit do not search beyond that time.
	 * @return browser listing all log files written by the process or 'null' if
	 *        previous process was still active at the <code>timelimit</code> time.
	 */
	LogRepositoryBrowser findNext(LogRepositoryBrowser current, long timelimit);
	
	/**
	 * finds browser containing file corresponding to the specified <code>location</code>.
	 * 
	 * @param location the log record position indicator received in an API call.
	 * @param ignoreTimestamp ignore timestamp on the directory when comparing instance
	 * 		directory name. Necessary to find browser for files written by the same
	 * 		process but in different repository.
	 * @return browser with the file containing the log record or <code>null</code>
	 * 		if the file is not found in the repository.
	 */
	LogRepositoryBrowser find(RepositoryPointerImpl location, boolean ignoreTimestamp);
	
	/**
	 * finds browser next to the one containing file specified by <code>location</code>.
	 * The behavior is similar to the {@link #findNext(LogRepositoryBrowser, long)}.
	 * 
	 * @param location the log record position indicator received in an API call.
	 * @param timelimit the time threshold after which we are not interested in log records.
	 * @return browser containing log records written by the next process after the one
	 *     	which wrote the file corresponding to <code>location</code> or <code>null</code>
	 * 		if the file was written by the last active process.
	 */
	LogRepositoryBrowser findNext(RepositoryPointerImpl location, long timelimit);
	
}

