/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.io.Serializable;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.derby.iapi.db.ConsistencyChecker;
import org.apache.derby.iapi.db.Factory;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedDatabaseMetaData;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.load.Export;
import org.apache.derby.impl.load.Import;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINTableDescriptor;
import org.apache.derby.impl.sql.execute.JarUtil;
import org.apache.derby.jdbc.InternalDriver;

public class SystemProcedures {
    private static final int SQL_BEST_ROWID = 1;
    private static final int SQL_ROWVER = 2;
    private static final String DRIVER_TYPE_OPTION = "DATATYPE";
    private static final String ODBC_DRIVER_OPTION = "'ODBC'";
    public static final String SQLERRMC_MESSAGE_DELIMITER = new String(new char[]{'\u0014', '\u0014', '\u0014'});

    public static void SQLCAMESSAGE(int sqlcode, short errmcLen, String sqlerrmc, String sqlerrp, int errd0, int errd1, int errd2, int errd3, int errd4, int errd5, String warn, String sqlState, String file, String localeStr, String[] msg, int[] rc) {
        int numMessages = 1;
        int index = 0;
        while (sqlerrmc.indexOf(SQLERRMC_MESSAGE_DELIMITER, index) != -1) {
            index = sqlerrmc.indexOf(SQLERRMC_MESSAGE_DELIMITER, index) + SQLERRMC_MESSAGE_DELIMITER.length();
            ++numMessages;
        }
        if (numMessages == 1) {
            MessageService.getLocalizedMessage(sqlcode, errmcLen, sqlerrmc, sqlerrp, errd0, errd1, errd2, errd3, errd4, errd5, warn, sqlState, file, localeStr, msg, rc);
        } else {
            int startIdx = 0;
            String[] errMsg = new String[2];
            for (int i = 0; i < numMessages; ++i) {
                int endIdx = sqlerrmc.indexOf(SQLERRMC_MESSAGE_DELIMITER, startIdx);
                String sqlError = i == numMessages - 1 ? sqlerrmc.substring(startIdx) : sqlerrmc.substring(startIdx, endIdx);
                if (i > 0) {
                    sqlState = sqlError.substring(0, 5);
                    sqlError = sqlError.substring(6);
                    msg[0] = msg[0] + " SQLSTATE: " + sqlState + ": ";
                }
                MessageService.getLocalizedMessage(sqlcode, (short)sqlError.length(), sqlError, sqlerrp, errd0, errd1, errd2, errd3, errd4, errd5, warn, sqlState, file, localeStr, errMsg, rc);
                if (rc[0] == 0) {
                    msg[0] = i == 0 ? errMsg[0] : msg[0] + errMsg[0];
                }
                startIdx = endIdx + SQLERRMC_MESSAGE_DELIMITER.length();
            }
        }
    }

    private static Connection getDefaultConn() throws SQLException {
        Connection conn;
        InternalDriver id = InternalDriver.activeDriver();
        if (id != null && (conn = id.connect("jdbc:default:connection", null, 0)) != null) {
            return conn;
        }
        throw Util.noCurrentConnection();
    }

    private static DatabaseMetaData getDMD() throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        return conn.getMetaData();
    }

    public static void SQLPROCEDURES(String catalogName, String schemaName, String procName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProceduresForODBC(catalogName, schemaName, procName) : SystemProcedures.getDMD().getProcedures(catalogName, schemaName, procName);
    }

    public static void SQLFUNCTIONS(String catalogName, String schemaName, String funcName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctions(catalogName, schemaName, funcName);
    }

    public static void SQLTABLES(String catalogName, String schemaName, String tableName, String tableType, String options, ResultSet[] rs) throws SQLException {
        String optionValue = SystemProcedures.getOption("GETCATALOGS", options);
        if (optionValue != null && optionValue.trim().equals("1")) {
            rs[0] = SystemProcedures.getDMD().getCatalogs();
            return;
        }
        optionValue = SystemProcedures.getOption("GETTABLETYPES", options);
        if (optionValue != null && optionValue.trim().equals("1")) {
            rs[0] = SystemProcedures.getDMD().getTableTypes();
            return;
        }
        optionValue = SystemProcedures.getOption("GETSCHEMAS", options);
        if (optionValue != null) {
            if ((optionValue = optionValue.trim()).equals("1")) {
                rs[0] = SystemProcedures.getDMD().getSchemas();
                return;
            }
            if (optionValue.equals("2")) {
                EmbedDatabaseMetaData edmd = (EmbedDatabaseMetaData)SystemProcedures.getDMD();
                rs[0] = edmd.getSchemas(catalogName, schemaName);
                return;
            }
        }
        String[] typeArray = null;
        if (tableType != null) {
            StringTokenizer st = new StringTokenizer(tableType, "',");
            typeArray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                typeArray[i] = st.nextToken();
                ++i;
            }
        }
        rs[0] = SystemProcedures.getDMD().getTables(catalogName, schemaName, tableName, typeArray);
    }

    public static void SQLFOREIGNKEYS(String pkCatalogName, String pkSchemaName, String pkTableName, String fkCatalogName, String fkSchemaName, String fkTableName, String options, ResultSet[] rs) throws SQLException {
        String exportedKeyProp = SystemProcedures.getOption("EXPORTEDKEY", options);
        String importedKeyProp = SystemProcedures.getOption("IMPORTEDKEY", options);
        rs[0] = importedKeyProp != null && importedKeyProp.trim().equals("1") ? SystemProcedures.getDMD().getImportedKeys(fkCatalogName, fkSchemaName, fkTableName) : (exportedKeyProp != null && exportedKeyProp.trim().equals("1") ? SystemProcedures.getDMD().getExportedKeys(pkCatalogName, pkSchemaName, pkTableName) : (SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getCrossReferenceForODBC(pkCatalogName, pkSchemaName, pkTableName, fkCatalogName, fkSchemaName, fkTableName) : SystemProcedures.getDMD().getCrossReference(pkCatalogName, pkSchemaName, pkTableName, fkCatalogName, fkSchemaName, fkTableName)));
    }

    private static String getOption(String pattern, String options) {
        if (options == null) {
            return null;
        }
        int start = options.lastIndexOf(pattern);
        if (start < 0) {
            return null;
        }
        int valueStart = options.indexOf(61, start);
        if (valueStart < 0) {
            return null;
        }
        int valueEnd = options.indexOf(59, valueStart);
        if (valueEnd < 0) {
            return options.substring(valueStart + 1);
        }
        return options.substring(valueStart + 1, valueEnd);
    }

    public static void SQLPROCEDURECOLS(String catalogName, String schemaName, String procName, String paramName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProcedureColumnsForODBC(catalogName, schemaName, procName, paramName) : SystemProcedures.getDMD().getProcedureColumns(catalogName, schemaName, procName, paramName);
    }

    public static void SQLFUNCTIONPARAMS(String catalogName, String schemaName, String funcName, String paramName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctionColumns(catalogName, schemaName, funcName, paramName);
    }

    public static void SQLCOLUMNS(String catalogName, String schemaName, String tableName, String columnName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getColumnsForODBC(catalogName, schemaName, tableName, columnName) : SystemProcedures.getDMD().getColumns(catalogName, schemaName, tableName, columnName);
    }

    public static void SQLCOLPRIVILEGES(String catalogName, String schemaName, String tableName, String columnName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.getDMD().getColumnPrivileges(catalogName, schemaName, tableName, columnName);
    }

    public static void SQLTABLEPRIVILEGES(String catalogName, String schemaName, String tableName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.getDMD().getTablePrivileges(catalogName, schemaName, tableName);
    }

    public static void SQLPRIMARYKEYS(String catalogName, String schemaName, String tableName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.getDMD().getPrimaryKeys(catalogName, schemaName, tableName);
    }

    public static void SQLGETTYPEINFO(short dataType, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getTypeInfoForODBC() : SystemProcedures.getDMD().getTypeInfo();
    }

    public static void SQLSTATISTICS(String catalogName, String schemaName, String tableName, short unique, short approximate, String options, ResultSet[] rs) throws SQLException {
        boolean boolUnique = unique == 0;
        boolean boolApproximate = approximate == 1;
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getIndexInfoForODBC(catalogName, schemaName, tableName, boolUnique, boolApproximate) : SystemProcedures.getDMD().getIndexInfo(catalogName, schemaName, tableName, boolUnique, boolApproximate);
    }

    public static void SQLSPECIALCOLUMNS(short colType, String catalogName, String schemaName, String tableName, short scope, short nullable, String options, ResultSet[] rs) throws SQLException {
        boolean boolNullable;
        boolean bl = boolNullable = nullable == 1;
        rs[0] = colType == 1 ? (SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getBestRowIdentifierForODBC(catalogName, schemaName, tableName, scope, boolNullable) : SystemProcedures.getDMD().getBestRowIdentifier(catalogName, schemaName, tableName, scope, boolNullable)) : (SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getVersionColumnsForODBC(catalogName, schemaName, tableName) : SystemProcedures.getDMD().getVersionColumns(catalogName, schemaName, tableName));
    }

    public static void SQLUDTS(String catalogName, String schemaPattern, String typeNamePattern, String udtTypes, String options, ResultSet[] rs) throws SQLException {
        int[] types = null;
        if (udtTypes != null && udtTypes.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(udtTypes, " \t\n\t,");
            int udtTypeCount = tokenizer.countTokens();
            types = new int[udtTypeCount];
            String udtType = "";
            try {
                for (int i = 0; i < udtTypeCount; ++i) {
                    udtType = tokenizer.nextToken();
                    types[i] = Integer.parseInt(udtType);
                }
            }
            catch (NumberFormatException nfe) {
                throw new SQLException("Invalid type, " + udtType + ", passed to getUDTs.");
            }
            catch (NoSuchElementException nsee) {
                throw new SQLException("Internal failure: NoSuchElementException in getUDTs.");
            }
        }
        rs[0] = SystemProcedures.getDMD().getUDTs(catalogName, schemaPattern, typeNamePattern, types);
    }

    public static void METADATA(ResultSet[] rs) throws SQLException {
        rs[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getClientCachedMetaData();
    }

    private static boolean isForODBC(String options) {
        String optionValue = SystemProcedures.getOption(DRIVER_TYPE_OPTION, options);
        return optionValue != null && optionValue.toUpperCase().equals(ODBC_DRIVER_OPTION);
    }

    public static void SYSCS_SET_DATABASE_PROPERTY(String key, String value) throws SQLException {
        SystemProcedures.setDatabaseProperty(key, value, Securable.SET_DATABASE_PROPERTY);
    }

    private static void setDatabaseProperty(String key, String value, Securable authorizationCheck) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        try {
            if (authorizationCheck != null) {
                SecurityUtil.authorize(authorizationCheck);
            }
            Authorizer a = lcc.getAuthorizer();
            a.authorize((Activation)null, 5);
            TransactionController tc = lcc.getTransactionExecute();
            tc.setProperty(key, (Serializable)((Object)value), false);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static String SYSCS_GET_DATABASE_PROPERTY(String key) throws SQLException {
        return SystemProcedures.getProperty(key, Securable.GET_DATABASE_PROPERTY);
    }

    private static String getProperty(String key, Securable authorizationCheck) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        try {
            if (authorizationCheck != null) {
                SecurityUtil.authorize(authorizationCheck);
            }
            return PropertyUtil.getDatabaseProperty(lcc.getTransactionExecute(), key);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void SYSCS_UPDATE_STATISTICS(String schemaname, String tablename, String indexname) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("alter table ");
        query.append(SystemProcedures.basicSchemaTableValidation(schemaname, tablename));
        if (indexname != null && indexname.length() == 0) {
            throw PublicAPI.wrapStandardException(StandardException.newException("42X65", indexname));
        }
        if (indexname == null) {
            query.append(" all update statistics ");
        } else {
            query.append(" update statistics " + IdUtil.normalToDelimited(indexname));
        }
        Connection conn = SystemProcedures.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement(query.toString());
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static void SYSCS_DROP_STATISTICS(String schemaname, String tablename, String indexname) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("alter table ");
        query.append(SystemProcedures.basicSchemaTableValidation(schemaname, tablename));
        if (indexname != null && indexname.length() == 0) {
            throw PublicAPI.wrapStandardException(StandardException.newException("42X65", indexname));
        }
        if (indexname == null) {
            query.append(" all drop statistics ");
        } else {
            query.append(" statistics drop " + IdUtil.normalToDelimited(indexname));
        }
        Connection conn = SystemProcedures.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement(query.toString());
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    private static String basicSchemaTableValidation(String schemaname, String tablename) throws SQLException {
        if (schemaname != null && schemaname.length() == 0) {
            throw PublicAPI.wrapStandardException(StandardException.newException("42Y07", schemaname));
        }
        if (tablename == null || tablename.length() == 0) {
            throw PublicAPI.wrapStandardException(StandardException.newException("42X05", tablename));
        }
        return IdUtil.mkQualifiedName(schemaname, tablename);
    }

    public static void SYSCS_COMPRESS_TABLE(String schemaname, String tablename, short sequential) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("alter table ");
        query.append(SystemProcedures.basicSchemaTableValidation(schemaname, tablename));
        query.append(" compress" + (sequential != 0 ? " sequential" : ""));
        Connection conn = SystemProcedures.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement(query.toString());
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static void SYSCS_FREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().freeze();
    }

    public static void SYSCS_UNFREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().unfreeze();
    }

    public static void SYSCS_CHECKPOINT_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().checkpoint();
    }

    public static void SYSCS_BACKUP_DATABASE(String backupDir) throws SQLException {
        Factory.getDatabaseOfConnection().backup(backupDir, true);
    }

    public static void SYSCS_BACKUP_DATABASE_NOWAIT(String backupDir) throws SQLException {
        Factory.getDatabaseOfConnection().backup(backupDir, false);
    }

    public static void SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(String backupDir, short deleteOnlineArchivedLogFiles) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles != 0, true);
    }

    public static void SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(String backupDir, short deleteOnlineArchivedLogFiles) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles != 0, false);
    }

    public static void SYSCS_DISABLE_LOG_ARCHIVE_MODE(short deleteOnlineArchivedLogFiles) throws SQLException {
        Factory.getDatabaseOfConnection().disableLogArchiveMode(deleteOnlineArchivedLogFiles != 0);
    }

    public static void SYSCS_SET_RUNTIMESTATISTICS(short enable) throws SQLException {
        ConnectionUtil.getCurrentLCC().setRunTimeStatisticsMode(enable != 0);
    }

    public static void SYSCS_SET_STATISTICS_TIMING(short enable) throws SQLException {
        ConnectionUtil.getCurrentLCC().setStatisticsTiming(enable != 0);
    }

    public static int SYSCS_CHECK_TABLE(String schema, String tablename) throws SQLException {
        boolean ret_val = ConsistencyChecker.checkTable(schema, tablename);
        return ret_val ? 1 : 0;
    }

    public static void SYSCS_INPLACE_COMPRESS_TABLE(String schema, String tablename, short purgeRows, short defragmentRows, short truncateEnd) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            DataDictionary data_dictionary = lcc.getDataDictionary();
            SchemaDescriptor sd = data_dictionary.getSchemaDescriptor(schema, tc, true);
            TableDescriptor td = data_dictionary.getTableDescriptor(tablename, sd, tc);
            if (td != null && td.getTableType() == 5) {
                return;
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        String escapedSchema = IdUtil.normalToDelimited(schema);
        String escapedTableName = IdUtil.normalToDelimited(tablename);
        String query = "alter table " + escapedSchema + "." + escapedTableName + " compress inplace" + (purgeRows != 0 ? " purge" : "") + (defragmentRows != 0 ? " defragment" : "") + (truncateEnd != 0 ? " truncate_end" : "");
        Connection conn = SystemProcedures.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static String SYSCS_GET_RUNTIMESTATISTICS() throws SQLException {
        RunTimeStatistics rts = ConnectionUtil.getCurrentLCC().getRunTimeStatisticsObject();
        if (rts == null) {
            return null;
        }
        return rts.toString();
    }

    public static void INSTALL_JAR(String url, String jar, int deploy) throws SQLException {
        try {
            String sqlName;
            String schemaName;
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = IdUtil.parseMultiPartSQLIdentifier(jar.trim());
            if (st.length == 1) {
                schemaName = lcc.getCurrentSchemaName();
                sqlName = st[0];
            } else {
                schemaName = st[0];
                sqlName = st[1];
            }
            SystemProcedures.checkJarSQLName(sqlName);
            JarUtil.install(lcc, schemaName, sqlName, url);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void REPLACE_JAR(String url, String jar) throws SQLException {
        try {
            String sqlName;
            String schemaName;
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = IdUtil.parseMultiPartSQLIdentifier(jar.trim());
            if (st.length == 1) {
                schemaName = lcc.getCurrentSchemaName();
                sqlName = st[0];
            } else {
                schemaName = st[0];
                sqlName = st[1];
            }
            SystemProcedures.checkJarSQLName(sqlName);
            JarUtil.replace(lcc, schemaName, sqlName, url);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void REMOVE_JAR(String jar, int undeploy) throws SQLException {
        try {
            String sqlName;
            String schemaName;
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = IdUtil.parseMultiPartSQLIdentifier(jar.trim());
            if (st.length == 1) {
                schemaName = lcc.getCurrentSchemaName();
                sqlName = st[0];
            } else {
                schemaName = st[0];
                sqlName = st[1];
            }
            SystemProcedures.checkJarSQLName(sqlName);
            JarUtil.drop(lcc, schemaName, sqlName);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private static void checkJarSQLName(String sqlName) throws StandardException {
        if (sqlName.length() == 0 || sqlName.indexOf(58) != -1) {
            throw StandardException.newException("XCXA0.S", new Object[0]);
        }
    }

    public static void SYSCS_EXPORT_TABLE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset);
        conn.commit();
    }

    public static void SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, String lobsFileName) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, lobsFileName);
        conn.commit();
    }

    public static void SYSCS_EXPORT_QUERY(String selectStatement, String fileName, String columnDelimiter, String characterDelimiter, String codeset) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportQuery(conn, selectStatement, fileName, columnDelimiter, characterDelimiter, codeset);
        conn.commit();
    }

    public static void SYSCS_EXPORT_QUERY_LOBS_TO_EXTFILE(String selectStatement, String fileName, String columnDelimiter, String characterDelimiter, String codeset, String lobsFileName) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportQuery(conn, selectStatement, fileName, columnDelimiter, characterDelimiter, codeset, lobsFileName);
        conn.commit();
    }

    public static void SYSCS_IMPORT_TABLE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, replace, false);
        }
        catch (SQLException se) {
            SystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    private static void rollBackAndThrowSQLException(Connection conn, SQLException se) throws SQLException {
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            se.setNextException(e);
        }
        throw se;
    }

    public static void SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, replace, true);
        }
        catch (SQLException se) {
            SystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    public static void SYSCS_IMPORT_DATA(String schemaName, String tableName, String insertColumnList, String columnIndexes, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importData(conn, schemaName, tableName, insertColumnList, columnIndexes, fileName, columnDelimiter, characterDelimiter, codeset, replace, false);
        }
        catch (SQLException se) {
            SystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    public static void SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(String schemaName, String tableName, String insertColumnList, String columnIndexes, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importData(conn, schemaName, tableName, insertColumnList, columnIndexes, fileName, columnDelimiter, characterDelimiter, codeset, replace, true);
        }
        catch (SQLException se) {
            SystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    public static void SYSCS_BULK_INSERT(String schemaName, String tableName, String vtiName, String vtiArg) throws SQLException {
        try {
            SecurityUtil.authorize(Securable.BULK_INSERT);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        Connection conn = SystemProcedures.getDefaultConn();
        String entityName = IdUtil.mkQualifiedName(schemaName, tableName);
        String binsertSql = "insert into " + entityName + " --DERBY-PROPERTIES insertMode=bulkInsert \n" + "select * from new " + IdUtil.normalToDelimited(vtiName) + "(" + StringUtil.quoteStringLiteral(schemaName) + ", " + StringUtil.quoteStringLiteral(tableName) + ", " + StringUtil.quoteStringLiteral(vtiArg) + ")" + " as t";
        PreparedStatement ps = conn.prepareStatement(binsertSql);
        ps.executeUpdate();
        ps.close();
    }

    public static void SYSCS_RELOAD_SECURITY_POLICY() throws SQLException {
        try {
            SecurityUtil.authorize(Securable.RELOAD_SECURITY_POLICY);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        if (System.getSecurityManager() == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Policy.getPolicy().refresh();
                    return null;
                }
            });
        }
        catch (SecurityException se) {
            throw Util.policyNotReloaded(se);
        }
    }

    public static double PI() {
        return Math.PI;
    }

    public static double COT(double value) {
        return 1.0 / StrictMath.tan(value);
    }

    public static int SIGN(double value) {
        return value < 0.0 ? -1 : (value > 0.0 ? 1 : 0);
    }

    public static double RAND(int seed) {
        return new Random(seed).nextDouble();
    }

    public static void SYSCS_SET_USER_ACCESS(String userName, String connectionPermission) throws SQLException {
        try {
            String addListProperty;
            if (userName == null) {
                throw StandardException.newException("28502", userName);
            }
            if ("FULLACCESS".equals(connectionPermission)) {
                addListProperty = "derby.database.fullAccessUsers";
            } else if ("READONLYACCESS".equals(connectionPermission)) {
                addListProperty = "derby.database.readOnlyAccessUsers";
            } else if (connectionPermission == null) {
                addListProperty = null;
            } else {
                throw StandardException.newException("XCZ00.S", connectionPermission);
            }
            SystemProcedures.removeFromAccessList("derby.database.fullAccessUsers", userName);
            SystemProcedures.removeFromAccessList("derby.database.readOnlyAccessUsers", userName);
            if (addListProperty != null) {
                String addList = SystemProcedures.getProperty(addListProperty, Securable.SET_USER_ACCESS);
                SystemProcedures.setDatabaseProperty(addListProperty, IdUtil.appendNormalToList(userName, addList), null);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private static void removeFromAccessList(String listProperty, String userName) throws SQLException, StandardException {
        String removeList = SystemProcedures.getProperty(listProperty, Securable.SET_USER_ACCESS);
        if (removeList != null) {
            SystemProcedures.setDatabaseProperty(listProperty, IdUtil.deleteId(userName, removeList), null);
        }
    }

    public static String SYSCS_GET_USER_ACCESS(String userName) throws SQLException {
        try {
            if (userName == null) {
                throw StandardException.newException("28502", userName);
            }
            String fullUserList = SystemProcedures.getProperty("derby.database.fullAccessUsers", Securable.GET_USER_ACCESS);
            if (IdUtil.idOnList(userName, fullUserList)) {
                return "FULLACCESS";
            }
            String readOnlyUserList = SystemProcedures.getProperty("derby.database.readOnlyAccessUsers", Securable.GET_USER_ACCESS);
            if (IdUtil.idOnList(userName, readOnlyUserList)) {
                return "READONLYACCESS";
            }
            String defaultAccess = SystemProcedures.getProperty("derby.database.defaultConnectionMode", Securable.GET_USER_ACCESS);
            defaultAccess = defaultAccess != null ? StringUtil.SQLToUpperCase(defaultAccess) : "FULLACCESS";
            return defaultAccess;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void SYSCS_INVALIDATE_STORED_STATEMENTS() throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        DataDictionary dd = lcc.getDataDictionary();
        try {
            SecurityUtil.authorize(Securable.INVALIDATE_STORED_STATEMENTS);
            dd.invalidateAllSPSPlans(lcc);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void SYSCS_EMPTY_STATEMENT_CACHE() throws SQLException {
        try {
            SecurityUtil.authorize(Securable.EMPTY_STATEMENT_CACHE);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        CacheManager statementCache = lcc.getLanguageConnectionFactory().getStatementCache();
        if (statementCache != null) {
            statementCache.ageOut();
        }
    }

    public static void SYSCS_SET_XPLAIN_MODE(int mode) throws SQLException, StandardException {
        try {
            SecurityUtil.authorize(Securable.SET_XPLAIN_MODE);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        ConnectionUtil.getCurrentLCC().setXplainOnlyMode(mode != 0);
    }

    public static int SYSCS_GET_XPLAIN_MODE() throws SQLException, StandardException {
        try {
            SecurityUtil.authorize(Securable.GET_XPLAIN_MODE);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        return ConnectionUtil.getCurrentLCC().getXplainOnlyMode() ? 1 : 0;
    }

    public static void SYSCS_SET_XPLAIN_SCHEMA(String schemaName) throws SQLException, StandardException {
        try {
            SecurityUtil.authorize(Securable.SET_XPLAIN_SCHEMA);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        if (schemaName == null || schemaName.trim().length() == 0) {
            lcc.setXplainSchema(null);
            return;
        }
        boolean statsSave = lcc.getRunTimeStatisticsMode();
        lcc.setRunTimeStatisticsMode(false);
        SystemProcedures.createXplainSchema(schemaName);
        SystemProcedures.createXplainTable(lcc, schemaName, new XPLAINStatementDescriptor());
        SystemProcedures.createXplainTable(lcc, schemaName, new XPLAINStatementTimingsDescriptor());
        SystemProcedures.createXplainTable(lcc, schemaName, new XPLAINResultSetDescriptor());
        SystemProcedures.createXplainTable(lcc, schemaName, new XPLAINResultSetTimingsDescriptor());
        SystemProcedures.createXplainTable(lcc, schemaName, new XPLAINScanPropsDescriptor());
        SystemProcedures.createXplainTable(lcc, schemaName, new XPLAINSortPropsDescriptor());
        lcc.setRunTimeStatisticsMode(statsSave);
        lcc.setXplainSchema(schemaName);
    }

    private static boolean hasSchema(Connection conn, String schemaName) throws SQLException {
        ResultSet rs = conn.getMetaData().getSchemas();
        boolean schemaFound = false;
        while (rs.next() && !schemaFound) {
            schemaFound = schemaName.equals(rs.getString("TABLE_SCHEM"));
        }
        rs.close();
        return schemaFound;
    }

    private static boolean hasTable(Connection conn, String schemaName, String tableName) throws SQLException {
        ResultSet rs = conn.getMetaData().getTables(null, schemaName, tableName, new String[]{"TABLE"});
        boolean tableFound = rs.next();
        rs.close();
        return tableFound;
    }

    private static void createXplainSchema(String schemaName) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        if (!SystemProcedures.hasSchema(conn, schemaName)) {
            String escapedSchema = IdUtil.normalToDelimited(schemaName);
            Statement s = conn.createStatement();
            s.executeUpdate("CREATE SCHEMA " + escapedSchema);
            s.close();
        }
        conn.close();
    }

    private static void createXplainTable(LanguageConnectionContext lcc, String schemaName, XPLAINTableDescriptor t) throws SQLException {
        String[] ddl = t.getTableDDL(schemaName);
        Connection conn = SystemProcedures.getDefaultConn();
        if (!SystemProcedures.hasTable(conn, schemaName, t.getCatalogName())) {
            Statement s = conn.createStatement();
            for (int i = 0; i < ddl.length; ++i) {
                s.executeUpdate(ddl[i]);
            }
            s.close();
        }
        String ins = t.getTableInsert();
        conn.prepareStatement(ins).close();
        conn.close();
        lcc.setXplainStatement(t.getCatalogName(), ins);
    }

    public static String SYSCS_GET_XPLAIN_SCHEMA() throws SQLException, StandardException {
        try {
            SecurityUtil.authorize(Securable.GET_XPLAIN_SCHEMA);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        String sd = ConnectionUtil.getCurrentLCC().getXplainSchema();
        if (sd == null) {
            return "";
        }
        return sd;
    }

    public static void SYSCS_CREATE_USER(String userName, String password) throws SQLException {
        userName = SystemProcedures.normalizeUserName(userName);
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            SecurityUtil.authorize(Securable.CREATE_USER);
            DataDictionary dd = lcc.getDataDictionary();
            String dbo = dd.getAuthorizationDatabaseOwner();
            if (!dbo.equals(userName)) {
                if (dd.getUser(dbo) == null) {
                    throw StandardException.newException("4251K", new Object[0]);
                }
            } else {
                String currentUser = lcc.getStatementContext().getSQLSessionContext().getCurrentUser();
                if (!dbo.equals(currentUser)) {
                    throw StandardException.newException("4251D", new Object[0]);
                }
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        SystemProcedures.addUser(userName, password, tc);
    }

    public static void addUser(String userName, String password, TransactionController tc) throws SQLException {
        try {
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            DataDictionary dd = lcc.getDataDictionary();
            dd.startWriting(lcc);
            UserDescriptor userDescriptor = SystemProcedures.makeUserDescriptor(dd, tc, userName, password);
            dd.addDescriptor(userDescriptor, null, 22, false, tc);
            if (dd.getAuthorizationDatabaseOwner().equals(userName)) {
                tc.setProperty("derby.authentication.provider", (Serializable)((Object)"NATIVE::LOCAL"), true);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private static UserDescriptor makeUserDescriptor(DataDictionary dd, TransactionController tc, String userName, String password) throws StandardException {
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        PasswordHasher hasher = dd.makePasswordHasher(tc.getProperties());
        if (hasher == null) {
            throw StandardException.newException("4251G", new Object[0]);
        }
        String hashingScheme = hasher.encodeHashingScheme();
        String hashedPassword = hasher.hashPasswordIntoString(userName, password);
        Timestamp currentTimestamp = new Timestamp(new Date().getTime());
        UserDescriptor userDescriptor = ddg.newUserDescriptor(userName, hashingScheme, hashedPassword.toCharArray(), currentTimestamp);
        return userDescriptor;
    }

    public static void SYSCS_RESET_PASSWORD(String userName, String password) throws SQLException {
        try {
            SecurityUtil.authorize(Securable.RESET_PASSWORD);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        SystemProcedures.resetAuthorizationIDPassword(SystemProcedures.normalizeUserName(userName), password);
    }

    private static void resetAuthorizationIDPassword(String userName, String password) throws SQLException {
        try {
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            DataDictionary dd = lcc.getDataDictionary();
            TransactionController tc = lcc.getTransactionExecute();
            SystemProcedures.checkLegalUser(dd, userName);
            dd.startWriting(lcc);
            UserDescriptor userDescriptor = SystemProcedures.makeUserDescriptor(dd, tc, userName, password);
            dd.updateUser(userDescriptor, tc);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void SYSCS_MODIFY_PASSWORD(String password) throws SQLException {
        String currentUser = ConnectionUtil.getCurrentLCC().getStatementContext().getSQLSessionContext().getCurrentUser();
        SystemProcedures.resetAuthorizationIDPassword(currentUser, password);
    }

    public static void SYSCS_DROP_USER(String userName) throws SQLException {
        userName = SystemProcedures.normalizeUserName(userName);
        try {
            SecurityUtil.authorize(Securable.DROP_USER);
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            DataDictionary dd = lcc.getDataDictionary();
            String dbo = dd.getAuthorizationDatabaseOwner();
            if (dbo.equals(userName)) {
                throw StandardException.newException("4251F", new Object[0]);
            }
            SystemProcedures.checkLegalUser(dd, userName);
            dd.startWriting(lcc);
            dd.dropUser(userName, lcc.getTransactionExecute());
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private static void checkLegalUser(DataDictionary dd, String userName) throws StandardException {
        if (dd.getUser(userName) == null) {
            throw StandardException.newException("XK001.S", new Object[0]);
        }
    }

    private static String normalizeUserName(String userName) throws SQLException {
        try {
            return IdUtil.getUserAuthorizationId(userName);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static Long SYSCS_PEEK_AT_SEQUENCE(String schemaName, String sequenceName) throws SQLException {
        try {
            return ConnectionUtil.getCurrentLCC().getDataDictionary().peekAtSequence(schemaName, sequenceName);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static Long SYSCS_PEEK_AT_IDENTITY(String schemaName, String tableName) throws SQLException {
        try {
            return ConnectionUtil.getCurrentLCC().getDataDictionary().peekAtIdentity(schemaName, tableName);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }
}

