/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class DRDAServerStarter
implements ModuleControl,
Runnable {
    private Object server;
    private Method runServerMethod;
    private Method serverShutdownMethod;
    private Thread serverThread;
    private static final String serverClassName = "org.apache.derby.impl.drda.NetworkServerControlImpl";
    private Class<?> serverClass;
    private InetAddress listenAddress = null;
    private int portNumber = -1;
    private String userArg = null;
    private String passwordArg = null;
    private PrintWriter consoleWriter = null;

    public void setStartInfo(InetAddress listenAddress, int portNumber, String userName, String password, PrintWriter consoleWriter) {
        this.userArg = userName;
        this.passwordArg = password;
        this.setStartInfo(listenAddress, portNumber, consoleWriter);
    }

    public void setStartInfo(InetAddress listenAddress, int portNumber, PrintWriter consoleWriter) {
        this.listenAddress = listenAddress;
        this.portNumber = portNumber;
        this.consoleWriter = consoleWriter != null ? new PrintWriter((Writer)consoleWriter, true) : consoleWriter;
    }

    private void findStartStopMethods(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
        this.runServerMethod = serverClass.getMethod("blockingStart", PrintWriter.class);
        this.serverShutdownMethod = serverClass.getMethod("directShutdown", null);
    }

    @Override
    public void boot(boolean create, Properties properties) {
        if (this.server != null) {
            SanityManager.THROWASSERT("Network server starter module booted twice.");
            return;
        }
        try {
            this.serverClass = Class.forName(serverClassName);
        }
        catch (ClassNotFoundException cnfe) {
            Monitor.logTextMessage("J100", serverClassName);
            return;
        }
        catch (Error e) {
            Monitor.logTextMessage("J101", serverClassName, e.getMessage());
            return;
        }
        try {
            Constructor serverConstructor;
            try {
                serverConstructor = AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor>(){

                    @Override
                    public Constructor run() throws NoSuchMethodException, SecurityException {
                        if (DRDAServerStarter.this.listenAddress == null) {
                            return DRDAServerStarter.this.serverClass.getConstructor(String.class, String.class);
                        }
                        return DRDAServerStarter.this.serverClass.getConstructor(InetAddress.class, Integer.TYPE, String.class, String.class);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                Monitor.logTextMessage("J102", e1.getMessage());
                e.printStackTrace(Monitor.getStream().getPrintWriter());
                return;
            }
            this.findStartStopMethods(this.serverClass);
            this.server = this.listenAddress == null ? serverConstructor.newInstance(this.userArg, this.passwordArg) : serverConstructor.newInstance(this.listenAddress, new Integer(this.portNumber), this.userArg, this.passwordArg);
            this.serverThread = Monitor.getMonitor().getDaemonThread(this, "NetworkServerStarter", false);
            this.serverThread.start();
        }
        catch (Exception e) {
            Monitor.logTextMessage("J102", e.getMessage());
            this.server = null;
            e.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    @Override
    public void run() {
        try {
            this.runServerMethod.invoke(this.server, this.consoleWriter);
        }
        catch (InvocationTargetException ite) {
            Monitor.logTextMessage("J102", ite.getTargetException().getMessage());
            ite.printStackTrace(Monitor.getStream().getPrintWriter());
            this.server = null;
        }
        catch (Exception e) {
            Monitor.logTextMessage("J102", e.getMessage());
            this.server = null;
            e.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    @Override
    public void stop() {
        try {
            if (this.serverThread != null && this.serverThread.isAlive()) {
                this.serverShutdownMethod.invoke(this.server, null);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        DRDAServerStarter.this.serverThread.interrupt();
                        return null;
                    }
                });
                this.serverThread = null;
            }
        }
        catch (InvocationTargetException ite) {
            Monitor.logTextMessage("J103", ite.getTargetException().getMessage());
            ite.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        catch (Exception e) {
            Monitor.logTextMessage("J103", e.getMessage());
            e.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        this.serverThread = null;
        this.server = null;
        this.serverClass = null;
        this.listenAddress = null;
        this.portNumber = -1;
        this.consoleWriter = null;
    }
}

