/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class SQLInteger
extends NumberDataType {
    static final int INTEGER_LENGTH = 4;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLInteger.class);
    private int value;
    private boolean isnull;

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.value > 127 || this.value < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() throws StandardException {
        if (this.value > Short.MAX_VALUE || this.value < Short.MIN_VALUE) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        return (short)this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Integer.toString(this.value);
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Integer(this.value);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String getTypeName() {
        return "INTEGER";
    }

    @Override
    public int getTypeFormatId() {
        return 80;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        out.writeInt(this.value);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException {
        this.value = in.readInt();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        int otherValue;
        int thisValue = this.getInt();
        if (thisValue == (otherValue = arg.getInt())) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        SQLInteger nsi = new SQLInteger(this.value);
        nsi.isnull = this.isnull;
        return nsi;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLInteger();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getInt(colNumber);
        this.isnull = this.value == 0 ? isNullable && resultSet.wasNull() : false;
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, 4);
            return;
        }
        ps.setInt(position, this.value);
    }

    @Override
    public final void setInto(ResultSet rs, int position) throws SQLException {
        rs.updateInt(position, this.value);
    }

    public SQLInteger() {
        this.isnull = true;
    }

    public SQLInteger(int val) {
        this.value = val;
    }

    public SQLInteger(char val) {
        this.value = val;
    }

    public SQLInteger(Integer obj) {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = obj;
        }
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0;
            this.isnull = true;
        } else {
            try {
                this.value = Integer.parseInt(theValue.trim());
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    @Override
    public void setValue(int theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(long theValue) throws StandardException {
        if (theValue > Integer.MAX_VALUE || theValue < Integer.MIN_VALUE) {
            throw this.outOfRange();
        }
        this.value = (int)theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeREAL(theValue)) > 2.1474836E9f || theValue < -2.1474836E9f) {
            throw this.outOfRange();
        }
        float floorValue = (float)Math.floor(theValue);
        this.value = (int)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeDOUBLE(theValue)) > 2.147483647E9 || theValue < -2.147483648E9) {
            throw this.outOfRange();
        }
        double floorValue = Math.floor(theValue);
        this.value = (int)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(boolean theValue) {
        this.value = theValue ? 1 : 0;
        this.isnull = false;
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getInt());
    }

    @Override
    public int typePrecedence() {
        return 50;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getInt() == right.getInt());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getInt() != right.getInt());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getInt() < right.getInt());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getInt() > right.getInt());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getInt() <= right.getInt());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getInt() >= right.getInt());
    }

    @Override
    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        long tempResult = left.getLong() * right.getLong();
        result.setValue(tempResult);
        return result;
    }

    @Override
    public NumberDataValue mod(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        int intDivisor = divisor.getInt();
        if (intDivisor == 0) {
            throw StandardException.newException("22012", new Object[0]);
        }
        result.setValue(dividend.getInt() % intDivisor);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        int operandValue = this.getInt();
        if (operandValue == Integer.MIN_VALUE) {
            throw this.outOfRange();
        }
        result.setValue(-operandValue);
        return result;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

