/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.services.daemon.BasicDaemon;

public class SingleThreadDaemonFactory
implements DaemonFactory {
    private final ContextService contextService = ContextService.getFactory();

    @Override
    public DaemonService createNewDaemon(String name) {
        BasicDaemon daemon = new BasicDaemon(this.contextService);
        final Thread daemonThread = Monitor.getMonitor().getDaemonThread(daemon, name, false);
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    daemonThread.setContextClassLoader(null);
                    return null;
                }
            });
        }
        catch (SecurityException se) {
            // empty catch block
        }
        daemonThread.start();
        return daemon;
    }
}

