/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.jce;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.services.jce.JCECipherProvider;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

public final class JCECipherFactory
implements CipherFactory {
    private static final String MESSAGE_DIGEST = "MD5";
    private static final String DEFAULT_ALGORITHM = "DES/CBC/NoPadding";
    private static final String DES = "DES";
    private static final String DESede = "DESede";
    private static final String TripleDES = "TripleDES";
    private static final String AES = "AES";
    private static final int BLOCK_LENGTH = 8;
    private static final int AES_IV_LENGTH = 16;
    private int keyLengthBits;
    private int encodedKeyLength;
    private String cryptoAlgorithm;
    private String cryptoAlgorithmShort;
    private String cryptoProvider;
    private String cryptoProviderShort;
    private MessageDigest messageDigest;
    private SecretKey mainSecretKey;
    private byte[] mainIV;
    private Properties persistentProperties;
    private static final int VERIFYKEY_DATALEN = 4096;

    public JCECipherFactory(boolean create, Properties props, boolean newAttributes) throws StandardException {
        this.init(create, props, newAttributes);
    }

    static String providerErrorName(String cps) {
        return cps == null ? "default" : cps;
    }

    private byte[] generateUniqueBytes() throws StandardException {
        try {
            KeyGenerator keyGen;
            String provider = this.cryptoProviderShort;
            if (provider == null) {
                keyGen = KeyGenerator.getInstance(this.cryptoAlgorithmShort);
            } else {
                if (provider.equals("BouncyCastleProvider")) {
                    provider = "BC";
                }
                keyGen = KeyGenerator.getInstance(this.cryptoAlgorithmShort, provider);
            }
            keyGen.init(this.keyLengthBits);
            SecretKey key = keyGen.generateKey();
            return key.getEncoded();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw StandardException.newException("XBCXC.S", this.cryptoAlgorithm, JCECipherFactory.providerErrorName(this.cryptoProviderShort));
        }
        catch (NoSuchProviderException nspe) {
            throw StandardException.newException("XBCXG.S", JCECipherFactory.providerErrorName(this.cryptoProviderShort));
        }
    }

    private EncryptedKeyResult encryptKey(byte[] secretKey, byte[] bootPassword) throws StandardException {
        int muckLength = secretKey.length;
        if (this.cryptoAlgorithmShort.equals(AES)) {
            muckLength = 16;
        }
        byte[] muck = this.getMuckFromBootPassword(bootPassword, muckLength);
        SecretKey key = this.generateKey(muck);
        byte[] IV = this.generateIV(muck);
        CipherProvider tmpCipherProvider = this.createNewCipher(1, key, IV);
        this.encodedKeyLength = secretKey.length;
        secretKey = this.padKey(secretKey, tmpCipherProvider.getEncryptionBlockSize());
        byte[] result = new byte[secretKey.length];
        tmpCipherProvider.encrypt(secretKey, 0, secretKey.length, result, 0);
        String hexOutput = StringUtil.toHexString(result, 0, result.length);
        return new EncryptedKeyResult(hexOutput, secretKey);
    }

    private byte[] padKey(byte[] secretKey, int blockSizeAlign) {
        byte[] result = secretKey;
        if (secretKey.length % blockSizeAlign != 0) {
            int encryptedLength = secretKey.length + blockSizeAlign - secretKey.length % blockSizeAlign;
            result = new byte[encryptedLength];
            System.arraycopy(secretKey, 0, result, 0, secretKey.length);
        }
        return result;
    }

    private byte[] decryptKey(String encryptedKey, int encodedKeyCharLength, byte[] bootPassword) throws StandardException {
        byte[] secretKey = StringUtil.fromHexString(encryptedKey, 0, encodedKeyCharLength);
        int muckLength = this.cryptoAlgorithmShort.equals(AES) ? 16 : secretKey.length;
        byte[] muck = this.getMuckFromBootPassword(bootPassword, muckLength);
        SecretKey key = this.generateKey(muck);
        byte[] IV = this.generateIV(muck);
        this.createNewCipher(2, key, IV).decrypt(secretKey, 0, secretKey.length, secretKey, 0);
        return secretKey;
    }

    private byte[] getMuckFromBootPassword(byte[] bootPassword, int encodedKeyByteLength) {
        int i;
        int ulength = bootPassword.length;
        byte[] muck = new byte[encodedKeyByteLength];
        int rotation = 0;
        for (i = 0; i < bootPassword.length; ++i) {
            rotation += bootPassword[i];
        }
        for (i = 0; i < encodedKeyByteLength; ++i) {
            muck[i] = (byte)(bootPassword[(i + rotation) % ulength] ^ bootPassword[i % ulength] << 4);
        }
        return muck;
    }

    private SecretKey generateKey(byte[] secretKey) throws StandardException {
        int length = secretKey.length;
        if (length < 8) {
            throw StandardException.newException("XBCX2.S", new Integer(8));
        }
        try {
            if (this.cryptoAlgorithmShort.equals(DES) && DESKeySpec.isWeak(secretKey, 0)) {
                byte[] spice = StringUtil.getAsciiBytes("louDScap");
                for (int i = 0; i < 7; ++i) {
                    secretKey[i] = (byte)(spice[i] << 3 ^ secretKey[i]);
                }
            }
            return new SecretKeySpec(secretKey, this.cryptoAlgorithmShort);
        }
        catch (InvalidKeyException ike) {
            throw StandardException.newException("XBCX0.S", ike, new Object[0]);
        }
    }

    private byte[] generateIV(byte[] secretKey) {
        int IVlen = 8;
        byte[] iv = null;
        if (this.cryptoAlgorithmShort.equals(AES)) {
            int i;
            IVlen = 16;
            iv = new byte[IVlen];
            iv[0] = (byte)((secretKey[secretKey.length - 1] << 2 | 0xF) ^ secretKey[0]);
            for (i = 1; i < 8; ++i) {
                iv[i] = (byte)((secretKey[i - 1] << i % 5 | 0xF) ^ secretKey[i]);
            }
            for (i = 8; i < 16; ++i) {
                iv[i] = iv[i - 8];
            }
        } else {
            iv = new byte[8];
            iv[0] = (byte)((secretKey[secretKey.length - 1] << 2 | 0xF) ^ secretKey[0]);
            for (int i = 1; i < 8; ++i) {
                iv[i] = (byte)((secretKey[i - 1] << i % 5 | 0xF) ^ secretKey[i]);
            }
        }
        return iv;
    }

    private int digest(byte[] input) {
        this.messageDigest.reset();
        byte[] digest = this.messageDigest.digest(input);
        byte[] condenseDigest = new byte[2];
        for (int i = 0; i < digest.length; ++i) {
            int n = i % 2;
            condenseDigest[n] = (byte)(condenseDigest[n] ^ digest[i]);
        }
        int retval = condenseDigest[0] & 0xFF | condenseDigest[1] << 8 & 0xFF00;
        return retval;
    }

    @Override
    public SecureRandom getSecureRandom() {
        return new SecureRandom(this.mainIV);
    }

    @Override
    public CipherProvider createNewCipher(int mode) throws StandardException {
        return this.createNewCipher(mode, this.mainSecretKey, this.mainIV);
    }

    private CipherProvider createNewCipher(int mode, SecretKey secretKey, byte[] iv) throws StandardException {
        return new JCECipherProvider(mode, secretKey, iv, this.cryptoAlgorithm, this.cryptoProviderShort);
    }

    private void init(boolean create, Properties properties, boolean newAttrs) throws StandardException {
        Throwable t;
        String feedbackMode;
        boolean provider_or_algo_specified = false;
        boolean storeProperties = create;
        this.persistentProperties = new Properties();
        String externalKey = properties.getProperty(newAttrs ? "newEncryptionKey" : "encryptionKey");
        if (externalKey != null) {
            storeProperties = false;
        }
        this.cryptoProvider = properties.getProperty("encryptionProvider");
        if (this.cryptoProvider != null) {
            provider_or_algo_specified = true;
            int dotPos = this.cryptoProvider.lastIndexOf(46);
            this.cryptoProviderShort = dotPos == -1 ? this.cryptoProvider : this.cryptoProvider.substring(dotPos + 1);
        }
        this.cryptoAlgorithm = properties.getProperty("encryptionAlgorithm");
        if (this.cryptoAlgorithm == null) {
            this.cryptoAlgorithm = DEFAULT_ALGORITHM;
        } else {
            provider_or_algo_specified = true;
        }
        if (storeProperties) {
            this.persistentProperties.put("encryptionAlgorithm", this.cryptoAlgorithm);
        }
        int firstSlashPos = this.cryptoAlgorithm.indexOf(47);
        int lastSlashPos = this.cryptoAlgorithm.lastIndexOf(47);
        if (firstSlashPos < 0 || lastSlashPos < 0 || firstSlashPos == lastSlashPos) {
            throw StandardException.newException("XBCXH.S", this.cryptoAlgorithm);
        }
        this.cryptoAlgorithmShort = this.cryptoAlgorithm.substring(0, firstSlashPos);
        if (provider_or_algo_specified) {
            try {
                Class<?> c = Class.forName("javax.crypto.ExemptionMechanism");
            }
            catch (Throwable t2) {
                throw StandardException.newException("XBCXJ.S", new Object[0]);
            }
        }
        if (!create && properties.getProperty("encryptionKeyLength") != null) {
            String keyLengths = properties.getProperty("encryptionKeyLength");
            int pos = keyLengths.lastIndexOf(45);
            this.encodedKeyLength = Integer.parseInt(keyLengths.substring(pos + 1));
            if (pos != -1) {
                this.keyLengthBits = Integer.parseInt(keyLengths.substring(0, pos));
            }
        }
        if (externalKey == null && create) {
            this.keyLengthBits = properties.getProperty("encryptionKeyLength") != null ? Integer.parseInt(properties.getProperty("encryptionKeyLength")) : (this.cryptoAlgorithmShort.equals(DES) ? 56 : (this.cryptoAlgorithmShort.equals(DESede) || this.cryptoAlgorithmShort.equals(TripleDES) ? 168 : 128));
        }
        if (!((feedbackMode = this.cryptoAlgorithm.substring(firstSlashPos + 1, lastSlashPos)).equals("CBC") || feedbackMode.equals("CFB") || feedbackMode.equals("ECB") || feedbackMode.equals("OFB"))) {
            throw StandardException.newException("XBCXI.S", feedbackMode);
        }
        String padding = this.cryptoAlgorithm.substring(lastSlashPos + 1, this.cryptoAlgorithm.length());
        if (!padding.equals("NoPadding")) {
            throw StandardException.newException("XBCXB.S", padding);
        }
        try {
            byte[] generatedKey;
            if (this.cryptoProvider != null && Security.getProvider(this.cryptoProviderShort) == null) {
                Class<?> cryptoClass = Class.forName(this.cryptoProvider);
                if (!Provider.class.isAssignableFrom(cryptoClass)) {
                    throw StandardException.newException("XBCXF.S.1", this.cryptoProvider);
                }
                final Provider provider = (Provider)cryptoClass.newInstance();
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Security.addProvider(provider);
                        return null;
                    }
                });
            }
            this.messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST);
            if (externalKey != null) {
                if (properties.getProperty(newAttrs ? "newBootPassword" : "bootPassword") != null) {
                    throw StandardException.newException("XBM06.D", new Object[0]);
                }
                generatedKey = StringUtil.fromHexString(externalKey, 0, externalKey.length());
                if (generatedKey == null) {
                    throw StandardException.newException(externalKey.length() % 2 == 0 ? "XBCXN.S" : "XBCXM.S", new Object[0]);
                }
            } else {
                generatedKey = this.handleBootPassword(create, properties, newAttrs);
                if (create || newAttrs) {
                    this.persistentProperties.put("encryptionKeyLength", this.keyLengthBits + "-" + generatedKey.length);
                }
            }
            this.mainSecretKey = this.generateKey(generatedKey);
            this.mainIV = this.generateIV(generatedKey);
            if (create) {
                this.persistentProperties.put("dataEncryption", "true");
                this.persistentProperties.put("data_encrypt_algorithm_version", String.valueOf(1));
                this.persistentProperties.put("log_encrypt_algorithm_version", String.valueOf(1));
            }
            return;
        }
        catch (ClassNotFoundException cnfe) {
            t = StandardException.newException("XBCXF.S", cnfe, this.cryptoProvider);
        }
        catch (InstantiationException ie) {
            t = ie;
        }
        catch (IllegalAccessException iae) {
            t = iae;
        }
        catch (NoSuchAlgorithmException nsae) {
            t = nsae;
        }
        catch (SecurityException se) {
            t = se;
        }
        catch (LinkageError le) {
            t = le;
        }
        catch (ClassCastException cce) {
            t = cce;
        }
        throw StandardException.newException("XBM0G.D", t, new Object[0]);
    }

    private byte[] handleBootPassword(boolean create, Properties properties, boolean newPasswd) throws StandardException {
        byte[] generatedKey;
        String inputKey = properties.getProperty(newPasswd ? "newBootPassword" : "bootPassword");
        if (inputKey == null) {
            throw StandardException.newException("XBM06.D", new Object[0]);
        }
        byte[] bootPassword = StringUtil.getAsciiBytes(inputKey);
        if (bootPassword.length < 8) {
            String messageId = create ? "XBM07.D" : "XBM06.D";
            throw StandardException.newException(messageId, new Object[0]);
        }
        if (create || newPasswd) {
            generatedKey = this.generateUniqueBytes();
            this.persistentProperties.put("encryptedBootPassword", this.saveSecretKey(generatedKey, bootPassword));
        } else {
            generatedKey = this.getDatabaseSecretKey(properties, bootPassword, "XBM06.D");
        }
        return generatedKey;
    }

    @Override
    public void saveProperties(Properties properties) {
        Enumeration<Object> e = this.persistentProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            properties.put(key, this.persistentProperties.get(key));
        }
        this.persistentProperties = null;
    }

    private byte[] getDatabaseSecretKey(Properties properties, byte[] bootPassword, String errorState) throws StandardException {
        String keyString = properties.getProperty("encryptedBootPassword");
        if (keyString == null) {
            throw StandardException.newException(errorState, new Object[0]);
        }
        int encodedKeyCharLength = keyString.indexOf(45);
        if (encodedKeyCharLength == -1) {
            throw StandardException.newException(errorState, new Object[0]);
        }
        int verifyKey = Integer.parseInt(keyString.substring(encodedKeyCharLength + 1));
        byte[] generatedKey = this.decryptKey(keyString, encodedKeyCharLength, bootPassword);
        int checkKey = this.digest(generatedKey);
        if (checkKey != verifyKey) {
            throw StandardException.newException(errorState, new Object[0]);
        }
        if (this.encodedKeyLength != 0) {
            byte[] result = new byte[this.encodedKeyLength];
            System.arraycopy(generatedKey, 0, result, 0, this.encodedKeyLength);
            return result;
        }
        return generatedKey;
    }

    private String saveSecretKey(byte[] secretKey, byte[] bootPassword) throws StandardException {
        EncryptedKeyResult ekr = this.encryptKey(secretKey, bootPassword);
        String encryptedKey = ekr.hexOutput;
        int verifyKey = this.digest(ekr.paddedInputKey);
        return encryptedKey.concat("-" + verifyKey);
    }

    @Override
    public String changeBootPassword(String changeString, Properties properties, CipherProvider verify) throws StandardException {
        int seperator = changeString.indexOf(44);
        if (seperator == -1) {
            throw StandardException.newException("XBCX7.S", new Object[0]);
        }
        String oldBP = changeString.substring(0, seperator).trim();
        byte[] oldBPAscii = StringUtil.getAsciiBytes(oldBP);
        if (oldBPAscii == null || oldBPAscii.length < 8) {
            throw StandardException.newException("XBCXA.S", new Object[0]);
        }
        String newBP = changeString.substring(seperator + 1).trim();
        byte[] newBPAscii = StringUtil.getAsciiBytes(newBP);
        if (newBPAscii == null || newBPAscii.length < 8) {
            throw StandardException.newException("XBCX2.S", new Integer(8));
        }
        byte[] generatedKey = this.getDatabaseSecretKey(properties, oldBPAscii, "XBCXA.S");
        byte[] IV = this.generateIV(generatedKey);
        if (!((JCECipherProvider)verify).verifyIV(IV)) {
            throw StandardException.newException("XBCXA.S", new Object[0]);
        }
        CipherProvider newDecrypter = this.createNewCipher(2, this.generateKey(generatedKey), IV);
        this.vetCipherProviders(newDecrypter, verify, "XBCXA.S");
        String newkey = this.saveSecretKey(generatedKey, newBPAscii);
        properties.put("encryptionKeyLength", this.keyLengthBits + "-" + this.encodedKeyLength);
        return this.saveSecretKey(generatedKey, newBPAscii);
    }

    private void vetCipherProviders(CipherProvider decrypter, CipherProvider encrypter, String sqlState) throws StandardException {
        int clearTextLength = 1024;
        int byteSize = 256;
        byte[] clearText = new byte[clearTextLength];
        byte[] cipherText = new byte[clearTextLength];
        byte[] unencryptedText = new byte[clearTextLength];
        for (int i = 0; i < clearTextLength; ++i) {
            clearText[i] = (byte)(i % byteSize);
        }
        int bytesEncrypted = encrypter.encrypt(clearText, 0, clearTextLength, cipherText, 0);
        int bytesDecrypted = decrypter.decrypt(cipherText, 0, bytesEncrypted, unencryptedText, 0);
        if (bytesEncrypted != clearTextLength || bytesDecrypted != clearTextLength) {
            throw StandardException.newException(sqlState, new Object[0]);
        }
        for (int i = 0; i < clearTextLength; ++i) {
            if (clearText[i] == unencryptedText[i]) continue;
            throw StandardException.newException(sqlState, new Object[0]);
        }
    }

    @Override
    public void verifyKey(boolean create, StorageFactory sf, Properties properties) throws StandardException {
        if (properties.getProperty("encryptionKey") == null) {
            return;
        }
        InputStream verifyKeyInputStream = null;
        StorageRandomAccessFile verifyKeyFile = null;
        byte[] data = new byte[4096];
        try {
            if (create) {
                this.getSecureRandom().nextBytes(data);
                byte[] checksum = this.getMD5Checksum(data);
                CipherProvider tmpCipherProvider = this.createNewCipher(1, this.mainSecretKey, this.mainIV);
                tmpCipherProvider.encrypt(data, 0, data.length, data, 0);
                verifyKeyFile = this.privAccessFile(sf, "verifyKey.dat", "rw");
                verifyKeyFile.writeInt(checksum.length);
                verifyKeyFile.write(checksum);
                verifyKeyFile.write(data);
                verifyKeyFile.sync();
            } else {
                verifyKeyInputStream = this.privAccessGetInputStream(sf, "verifyKey.dat");
                DataInputStream dis = new DataInputStream(verifyKeyInputStream);
                int checksumLen = dis.readInt();
                byte[] originalChecksum = new byte[checksumLen];
                dis.readFully(originalChecksum);
                dis.readFully(data);
                CipherProvider tmpCipherProvider = this.createNewCipher(2, this.mainSecretKey, this.mainIV);
                tmpCipherProvider.decrypt(data, 0, data.length, data, 0);
                byte[] verifyChecksum = this.getMD5Checksum(data);
                if (!MessageDigest.isEqual(originalChecksum, verifyChecksum)) {
                    throw StandardException.newException("XBCXK.S", new Object[0]);
                }
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XBCXL.S", ioe, new Object[0]);
        }
        finally {
            try {
                if (verifyKeyFile != null) {
                    verifyKeyFile.close();
                }
                if (verifyKeyInputStream != null) {
                    verifyKeyInputStream.close();
                }
            }
            catch (IOException ioee) {
                throw StandardException.newException("XBCXL.S", ioee, new Object[0]);
            }
        }
    }

    private byte[] getMD5Checksum(byte[] data) throws StandardException {
        try {
            MessageDigest md5 = MessageDigest.getInstance(MESSAGE_DIGEST);
            return md5.digest(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw StandardException.newException("XBCXH.S", MESSAGE_DIGEST);
        }
    }

    private StorageRandomAccessFile privAccessFile(StorageFactory storageFactory, String fileName, final String filePerms) throws IOException {
        final StorageFile verifyKeyFile = storageFactory.newStorageFile("", fileName);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<StorageRandomAccessFile>(){

                @Override
                public StorageRandomAccessFile run() throws IOException {
                    return verifyKeyFile.getRandomAccessFile(filePerms);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private InputStream privAccessGetInputStream(StorageFactory storageFactory, String fileName) throws StandardException {
        final StorageFile verifyKeyFile = storageFactory.newStorageFile("", fileName);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws FileNotFoundException {
                    return verifyKeyFile.getInputStream();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.newException("XBCXL.S", pae.getCause(), this.cryptoProvider);
        }
    }

    private static final class EncryptedKeyResult {
        public String hexOutput;
        public byte[] paddedInputKey;

        public EncryptedKeyResult(String hexOutput, byte[] paddedInputKey) {
            this.hexOutput = hexOutput;
            this.paddedInputKey = paddedInputKey;
        }
    }
}

