/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.services.locks.TableNameInfo;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class Timeout {
    public static final int TABLE_AND_ROWLOCK = 2;
    public static final int ALL = -1;
    public static final String newline = "\n";
    private TransactionController tc;
    private TableNameInfo tabInfo;
    private Latch currentLock;
    private char[] outputRow;
    private StringBuffer sb;
    private Hashtable currentRow;
    private final long currentTime;
    private final Enumeration lockTable;
    private static final String[] column = new String[9];
    private static final int LENGTHOFTABLE;
    private static final char LINE = '-';
    private static final char SEPARATOR = '|';

    private Timeout(Latch myTimeoutLock, Enumeration myLockTable, long time) {
        this.currentLock = myTimeoutLock;
        this.lockTable = myLockTable;
        this.currentTime = time;
        SanityManager.ASSERT(this.currentTime > 0L, "TIMEOUT_MONITOR: currentTime is not set correctly");
    }

    private StandardException createException() {
        try {
            this.buildLockTableString();
        }
        catch (StandardException se) {
            return se;
        }
        StandardException se = StandardException.newException("40XL1.T.1", this.sb.toString());
        se.setReport(2);
        return se;
    }

    private String buildLockTableString() throws StandardException {
        int i;
        this.sb = new StringBuffer(8192);
        this.outputRow = new char[LENGTHOFTABLE];
        LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        if (lcc != null) {
            this.tc = lcc.getTransactionExecute();
        }
        try {
            this.tabInfo = new TableNameInfo(lcc, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sb.append(newline);
        this.sb.append(new Date(this.currentTime));
        this.sb.append(newline);
        for (i = 0; i < column.length; ++i) {
            this.sb.append(column[i]);
            this.sb.append('|');
        }
        this.sb.append(newline);
        for (i = 0; i < LENGTHOFTABLE; ++i) {
            this.sb.append('-');
        }
        this.sb.append(newline);
        if (this.currentLock != null) {
            this.dumpLock();
            if (this.timeoutInfoHash()) {
                this.sb.append("*** The following row is the victim ***");
                this.sb.append(newline);
                this.sb.append(this.outputRow);
                this.sb.append(newline);
                this.sb.append("*** The above row is the victim ***");
                this.sb.append(newline);
            } else {
                this.sb.append("*** A victim was chosen, but it cannot be printed because the lockable object, " + this.currentLock + ", does not want to participate ***");
                this.sb.append(newline);
            }
        }
        if (this.lockTable != null) {
            while (this.lockTable.hasMoreElements()) {
                this.currentLock = (Latch)this.lockTable.nextElement();
                this.dumpLock();
                if (this.timeoutInfoHash()) {
                    this.sb.append(this.outputRow);
                    this.sb.append(newline);
                    continue;
                }
                this.sb.append("*** A latch/lock, " + this.currentLock + ", exist in the lockTable that cannot be printed ***");
                this.sb.append(newline);
            }
            for (i = 0; i < LENGTHOFTABLE; ++i) {
                this.sb.append('-');
            }
            this.sb.append(newline);
        }
        return this.sb.toString();
    }

    static StandardException buildException(Latch timeoutLock, Enumeration table, long time) {
        Timeout myTimeout = new Timeout(timeoutLock, table, time);
        return myTimeout.createException();
    }

    public static String buildString(Enumeration table, long time) throws StandardException {
        Timeout myTimeout = new Timeout(null, table, time);
        return myTimeout.buildLockTableString();
    }

    private void dumpLock() throws StandardException {
        Long containerId;
        Long conglomId;
        Hashtable<String, Object> attributes = new Hashtable<String, Object>(17);
        Object lock_type = this.currentLock.getQualifier();
        Lockable lockable = this.currentLock.getLockable();
        if (!lockable.lockAttributes(-1, attributes)) {
            this.currentRow = null;
            return;
        }
        SanityManager.ASSERT(attributes.get("LOCKNAME") != null, "lock table can only represent locks that have a LOCKNAME");
        SanityManager.ASSERT(attributes.get("TYPE") != null, "lock table can only represent locks that have a LOCKTYPE");
        if (attributes.get("CONTAINERID") == null && attributes.get("CONGLOMID") == null) {
            SanityManager.THROWASSERT("lock table can only represent locks that are associated with a container or conglomerate");
        }
        if ((conglomId = (Long)attributes.get("CONGLOMID")) == null && attributes.get("CONTAINERID") != null && this.tc != null) {
            Long value = (Long)attributes.get("CONTAINERID");
            conglomId = new Long(this.tc.findConglomid(value));
            attributes.put("CONGLOMID", conglomId);
        }
        if ((containerId = (Long)attributes.get("CONTAINERID")) == null && conglomId != null && this.tc != null) {
            try {
                containerId = new Long(this.tc.findContainerid(conglomId));
                attributes.put("CONTAINERID", containerId);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        attributes.put("LOCKOBJ", this.currentLock);
        attributes.put("XID", String.valueOf(this.currentLock.getCompatabilitySpace().getOwner()));
        attributes.put("MODE", lock_type.toString());
        attributes.put("LOCKCOUNT", Integer.toString(this.currentLock.getCount()));
        attributes.put("STATE", this.currentLock.getCount() != 0 ? "GRANT" : "WAIT");
        if (this.tabInfo != null && conglomId != null) {
            try {
                String tableName = this.tabInfo.getTableName(conglomId);
                attributes.put("TABLENAME", tableName);
            }
            catch (NullPointerException e) {
                attributes.put("TABLENAME", conglomId);
            }
            try {
                String indexName = this.tabInfo.getIndexName(conglomId);
                if (indexName != null) {
                    attributes.put("INDEXNAME", indexName);
                } else if (attributes.get("TYPE").equals("LATCH")) {
                    attributes.put("INDEXNAME", attributes.get("MODE"));
                } else {
                    attributes.put("INDEXNAME", "NULL");
                }
            }
            catch (Exception e) {
                if ("CONTAINERID" != null) {
                    attributes.put("INDEXNAME", "CONTAINERID");
                }
                attributes.put("INDEXNAME", "NULL");
            }
            String tableType = this.tabInfo.getTableType(conglomId);
            attributes.put("TABLETYPE", tableType);
        } else {
            if (conglomId != null) {
                attributes.put("TABLENAME", "CONGLOMID");
            } else {
                attributes.put("TABLENAME", "NULL");
            }
            if ("CONTAINERID" != null) {
                attributes.put("INDEXNAME", "CONTAINERID");
            } else {
                attributes.put("INDEXNAME", "NULL");
            }
            attributes.put("TABLETYPE", this.currentLock.toString());
        }
        this.currentRow = attributes;
    }

    private void cpArray(String toCp, int start, int end) {
        int i;
        int totalAllowWrite = end - start;
        if (toCp != null) {
            for (i = 0; i < toCp.length() && totalAllowWrite - i != 0; ++i) {
                this.outputRow[i + start] = toCp.charAt(i);
            }
        }
        while (i + start != end) {
            this.outputRow[i + start] = 32;
            ++i;
        }
        this.outputRow[end] = 124;
    }

    private boolean timeoutInfoHash() {
        if (this.currentRow == null) {
            return false;
        }
        String[] myData = new String[]{"XID", "TYPE", "MODE", "LOCKCOUNT", "LOCKNAME", "STATE", "TABLETYPE", "INDEXNAME", "TABLENAME"};
        int currentLength = 0;
        for (int i = 0; i < myData.length; ++i) {
            this.cpArray(this.currentRow.get(myData[i]).toString(), currentLength, currentLength + column[i].length());
            currentLength = currentLength + column[i].length() + 1;
        }
        return true;
    }

    static {
        Timeout.column[0] = "XID       ";
        Timeout.column[1] = "TYPE         ";
        Timeout.column[2] = "MODE";
        Timeout.column[3] = "LOCKCOUNT";
        Timeout.column[4] = "LOCKNAME                                                                        ";
        Timeout.column[5] = "STATE";
        Timeout.column[6] = "TABLETYPE / LOCKOBJ                   ";
        Timeout.column[7] = "INDEXNAME / CONTAINER_ID / (MODE for LATCH only)  ";
        Timeout.column[8] = "TABLENAME / CONGLOM_ID                ";
        int length = 0;
        for (int i = 0; i < column.length; ++i) {
            length += column[i].length();
        }
        SanityManager.ASSERT((length += column.length) == 256, "TIMEOUT_MONITOR: length of the row is not 256");
        LENGTHOFTABLE = length;
    }
}

