/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.stream;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.services.stream.InfoStreams;
import org.apache.derby.iapi.services.stream.PrintWriterGetHeader;
import org.apache.derby.impl.services.stream.BasicGetLogHeader;
import org.apache.derby.impl.services.stream.BasicHeaderPrintWriter;

public final class SingleStream
implements InfoStreams,
ModuleControl,
PrivilegedAction<HeaderPrintWriter> {
    private HeaderPrintWriter theStream;
    private String PBfileName;
    private PrintWriterGetHeader PBheader;

    @Override
    public void boot(boolean create, Properties properties) {
        this.theStream = this.makeStream();
    }

    @Override
    public void stop() {
        ((BasicHeaderPrintWriter)this.theStream).complete();
    }

    @Override
    public HeaderPrintWriter stream() {
        return this.theStream;
    }

    private HeaderPrintWriter makeStream() {
        PrintWriterGetHeader header = this.makeHeader();
        HeaderPrintWriter hpw = this.makeHPW(header);
        if (hpw == null) {
            hpw = this.createDefaultStream(header);
        }
        return hpw;
    }

    private PrintWriterGetHeader makeHeader() {
        return new BasicGetLogHeader(true, true, null);
    }

    private HeaderPrintWriter makeHPW(PrintWriterGetHeader header) {
        String target = PropertyUtil.getSystemProperty("derby.stream.error.style");
        if (target != null) {
            return this.makeStyleHPW(target, header);
        }
        target = PropertyUtil.getSystemProperty("derby.stream.error.file");
        if (target != null) {
            return this.makeFileHPW(target, header);
        }
        target = PropertyUtil.getSystemProperty("derby.stream.error.method");
        if (target != null) {
            return this.makeMethodHPW(target, header, false);
        }
        target = PropertyUtil.getSystemProperty("derby.stream.error.field");
        if (target != null) {
            return this.makeFieldHPW(target, header);
        }
        return null;
    }

    private HeaderPrintWriter PBmakeFileHPW(String fileName, PrintWriterGetHeader header) {
        FileOutputStream fos;
        Object monitorEnv;
        boolean appendInfoLog = PropertyUtil.getSystemBoolean("derby.infolog.append");
        File streamFile = new File(fileName);
        if (!streamFile.isAbsolute() && (monitorEnv = Monitor.getMonitor().getEnvironment()) instanceof File) {
            streamFile = new File((File)monitorEnv, fileName);
        }
        try {
            fos = streamFile.exists() && appendInfoLog ? new FileOutputStream(streamFile.getPath(), true) : new FileOutputStream(streamFile);
            FileUtil.limitAccessToOwner(streamFile);
        }
        catch (IOException ioe) {
            return this.useDefaultStream(header, ioe);
        }
        catch (SecurityException se) {
            return this.useDefaultStream(header, se);
        }
        return new BasicHeaderPrintWriter(new BufferedOutputStream(fos), header, true, streamFile.getPath());
    }

    private HeaderPrintWriter makeMethodHPW(String methodInvocation, PrintWriterGetHeader header, boolean canClose) {
        Throwable t;
        int lastDot = methodInvocation.lastIndexOf(46);
        String className = methodInvocation.substring(0, lastDot);
        String methodName = methodInvocation.substring(lastDot + 1);
        try {
            Class<?> theClass = Class.forName(className);
            try {
                Method theMethod = theClass.getMethod(methodName, new Class[0]);
                if (!Modifier.isStatic(theMethod.getModifiers())) {
                    HeaderPrintWriter hpw = this.useDefaultStream(header);
                    hpw.printlnWithHeader(theMethod.toString() + " is not static");
                    return hpw;
                }
                try {
                    return this.makeValueHPW(theMethod, theMethod.invoke((Object)null, new Object[0]), header, methodInvocation, canClose);
                }
                catch (IllegalAccessException iae) {
                    t = iae;
                }
                catch (IllegalArgumentException iarge) {
                    t = iarge;
                }
                catch (InvocationTargetException ite) {
                    t = ite.getTargetException();
                }
            }
            catch (NoSuchMethodException nsme) {
                t = nsme;
            }
        }
        catch (ClassNotFoundException cnfe) {
            t = cnfe;
        }
        catch (SecurityException se) {
            t = se;
        }
        return this.useDefaultStream(header, t);
    }

    private HeaderPrintWriter makeStyleHPW(String style, PrintWriterGetHeader header) {
        HeaderPrintWriter res = null;
        if ("rollingFile".equals(style)) {
            String className = "org.apache.derby.impl.services.stream.RollingFileStreamProvider.getOutputStream";
            res = this.makeMethodHPW(className, header, true);
        } else {
            try {
                IllegalArgumentException ex = new IllegalArgumentException("unknown derby.stream.error.style: " + style);
                throw ex;
            }
            catch (IllegalArgumentException t) {
                res = this.useDefaultStream(header, t);
            }
            catch (Exception t) {
                res = this.useDefaultStream(header, t);
            }
        }
        return res;
    }

    private HeaderPrintWriter makeFieldHPW(String fieldAccess, PrintWriterGetHeader header) {
        Exception t;
        int lastDot = fieldAccess.lastIndexOf(46);
        String className = fieldAccess.substring(0, lastDot);
        String fieldName = fieldAccess.substring(lastDot + 1, fieldAccess.length());
        try {
            Class<?> theClass = Class.forName(className);
            try {
                Field theField = theClass.getField(fieldName);
                if (!Modifier.isStatic(theField.getModifiers())) {
                    HeaderPrintWriter hpw = this.useDefaultStream(header);
                    hpw.printlnWithHeader(theField.toString() + " is not static");
                    return hpw;
                }
                try {
                    return this.makeValueHPW(theField, theField.get(null), header, fieldAccess, false);
                }
                catch (IllegalAccessException iae) {
                    t = iae;
                }
                catch (IllegalArgumentException iarge) {
                    t = iarge;
                }
            }
            catch (NoSuchFieldException nsfe) {
                t = nsfe;
            }
        }
        catch (ClassNotFoundException cnfe) {
            t = cnfe;
        }
        catch (SecurityException se) {
            t = se;
        }
        return this.useDefaultStream(header, t);
    }

    private HeaderPrintWriter makeValueHPW(Member whereFrom, Object value, PrintWriterGetHeader header, String name, boolean canClose) {
        if (value instanceof OutputStream) {
            return new BasicHeaderPrintWriter((OutputStream)value, header, canClose, name);
        }
        if (value instanceof Writer) {
            return new BasicHeaderPrintWriter((Writer)value, header, canClose, name);
        }
        HeaderPrintWriter hpw = this.useDefaultStream(header);
        if (value == null) {
            hpw.printlnWithHeader(whereFrom.toString() + "=null");
        } else {
            hpw.printlnWithHeader(whereFrom.toString() + " instanceof " + value.getClass().getName());
        }
        return hpw;
    }

    private HeaderPrintWriter createDefaultStream(PrintWriterGetHeader header) {
        return this.makeFileHPW("derby.log", header);
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader header) {
        return new BasicHeaderPrintWriter(System.err, header, false, "System.err");
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader header, Throwable t) {
        HeaderPrintWriter hpw = this.useDefaultStream(header);
        while (t != null) {
            Throwable causedBy = t.getCause();
            String causedByStr = MessageService.getTextMessage("N001", new Object[0]);
            hpw.printlnWithHeader(t.toString() + (causedBy != null ? " " + causedByStr : ""));
            t = causedBy;
        }
        return hpw;
    }

    private HeaderPrintWriter makeFileHPW(String fileName, PrintWriterGetHeader header) {
        this.PBfileName = fileName;
        this.PBheader = header;
        return AccessController.doPrivileged(this);
    }

    @Override
    public final HeaderPrintWriter run() {
        return this.PBmakeFileHPW(this.PBfileName, this.PBheader);
    }
}

