/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.shared.common.sanity.SanityManager;

class AlterTableNode
extends DDLStatementNode {
    public TableElementList tableElementList = null;
    char lockGranularity;
    private boolean updateStatistics = false;
    private boolean updateStatisticsAll = false;
    private boolean dropStatistics;
    private boolean dropStatisticsAll;
    private String indexNameForStatistics;
    public boolean compressTable = false;
    public boolean sequential = false;
    public boolean purge = false;
    public boolean defragment = false;
    public boolean truncateEndOfTable = false;
    public int behavior;
    public TableDescriptor baseTable;
    protected int numConstraints;
    private int changeType = 0;
    private boolean truncateTable = false;
    protected SchemaDescriptor schemaDescriptor = null;
    protected ColumnInfo[] colInfos = null;
    protected ConstraintConstantAction[] conActions = null;

    AlterTableNode(TableName tableName, ContextManager cm) throws StandardException {
        super(tableName, cm);
        this.truncateTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    AlterTableNode(TableName tableName, boolean sequential, ContextManager cm) throws StandardException {
        super(tableName, cm);
        this.sequential = sequential;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    AlterTableNode(TableName tableName, boolean purge, boolean defragment, boolean truncateEndOfTable, ContextManager cm) throws StandardException {
        super(tableName, cm);
        this.purge = purge;
        this.defragment = defragment;
        this.truncateEndOfTable = truncateEndOfTable;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor(true, false);
    }

    AlterTableNode(TableName tableName, int changeType, boolean statsAll, String indexName, ContextManager cm) throws StandardException {
        super(tableName, cm);
        this.changeType = changeType;
        this.indexNameForStatistics = indexName;
        switch (changeType) {
            case 5: {
                this.updateStatisticsAll = statsAll;
                this.updateStatistics = true;
                break;
            }
            case 6: {
                this.dropStatisticsAll = statsAll;
                this.dropStatistics = true;
                break;
            }
            default: {
                SanityManager.NOTREACHED();
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    AlterTableNode(TableName tableName, int changeType, TableElementList impactedElements, char lockGranularity, int behavior, ContextManager cm) throws StandardException {
        super(tableName, cm);
        this.changeType = changeType;
        switch (changeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.tableElementList = impactedElements;
                this.lockGranularity = lockGranularity;
                this.behavior = behavior;
                break;
            }
            default: {
                SanityManager.NOTREACHED();
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    @Override
    public String toString() {
        return super.toString() + "objectName: " + this.getObjectName() + "\n" + "lockGranularity: " + this.lockGranularity + "\n" + "compressTable: " + this.compressTable + "\n" + "sequential: " + this.sequential + "\n" + "truncateTable: " + this.truncateTable + "\n" + "purge: " + this.purge + "\n" + "defragment: " + this.defragment + "\n" + "truncateEndOfTable: " + this.truncateEndOfTable + "\n" + "updateStatistics: " + this.updateStatistics + "\n" + "updateStatisticsAll: " + this.updateStatisticsAll + "\n" + "dropStatistics: " + this.dropStatistics + "\n" + "dropStatisticsAll: " + this.dropStatisticsAll + "\n" + "indexNameForStatistics: " + this.indexNameForStatistics + "\n";
    }

    @Override
    void printSubNodes(int depth) {
        if (this.tableElementList != null) {
            this.printLabel(depth, "tableElementList: ");
            this.tableElementList.treePrint(depth + 1);
        }
    }

    @Override
    public String statementToString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE";
        }
        return "ALTER TABLE";
    }

    public int getChangeType() {
        return this.changeType;
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        int numCheckConstraints = 0;
        int numReferenceConstraints = 0;
        int numGenerationClauses = 0;
        int numBackingIndexes = 0;
        this.baseTable = this.compressTable && (this.purge || this.defragment || this.truncateEndOfTable) ? this.getTableDescriptor(false) : this.getTableDescriptor();
        if (this.baseTable.getTableType() == 3) {
            throw StandardException.newException("42995", new Object[0]);
        }
        this.getCompilerContext().createDependency(this.baseTable);
        if (this.changeType == 1 && this.tableElementList != null) {
            for (int i = 0; i < this.tableElementList.size(); ++i) {
                ColumnDefinitionNode cdn;
                if (!(this.tableElementList.elementAt(i) instanceof ColumnDefinitionNode) || (cdn = (ColumnDefinitionNode)this.tableElementList.elementAt(i)).hasGenerationClause() && cdn.getType() == null) continue;
                if (cdn.getType() == null) {
                    throw StandardException.newException("42XA9", cdn.getColumnName());
                }
                if (!cdn.getType().getTypeId().isStringTypeId()) continue;
                cdn.setCollationType(this.schemaDescriptor.getCollationType());
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validate(this, dd, this.baseTable);
            if (this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns() > 1012) {
                throw StandardException.newException("54011", String.valueOf(this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns()), this.getRelativeName(), String.valueOf(1012));
            }
            numBackingIndexes = this.tableElementList.countConstraints(2) + this.tableElementList.countConstraints(6) + this.tableElementList.countConstraints(3);
            numCheckConstraints = this.tableElementList.countConstraints(4);
            numReferenceConstraints = this.tableElementList.countConstraints(6);
            numGenerationClauses = this.tableElementList.countGenerationClauses();
        }
        if (numBackingIndexes + this.baseTable.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", String.valueOf(numBackingIndexes + this.baseTable.getTotalNumberOfIndexes()), this.getRelativeName(), String.valueOf(Short.MAX_VALUE));
        }
        if (numCheckConstraints > 0 || numGenerationClauses > 0 || numReferenceConstraints > 0) {
            FromList fromList = this.makeFromList(dd, this.tableElementList, false);
            FormatableBitSet generatedColumns = this.baseTable.makeColumnMap(this.baseTable.getGeneratedColumns());
            if (numGenerationClauses > 0) {
                this.tableElementList.bindAndValidateGenerationClauses(this.schemaDescriptor, fromList, generatedColumns, this.baseTable);
            }
            if (numCheckConstraints > 0) {
                this.tableElementList.bindAndValidateCheckConstraints(fromList);
            }
            if (numReferenceConstraints > 0) {
                this.tableElementList.validateForeignKeysOnGenerationClauses(fromList, generatedColumns);
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validatePrimaryKeyNullability();
        }
        if (this.updateStatistics && !this.updateStatisticsAll || this.dropStatistics && !this.dropStatisticsAll) {
            ConglomerateDescriptor cd = null;
            if (this.schemaDescriptor.getUUID() != null) {
                cd = dd.getConglomerateDescriptor(this.indexNameForStatistics, this.schemaDescriptor, false);
            }
            if (cd == null) {
                throw StandardException.newException("42X65", this.schemaDescriptor.getSchemaName() + "." + this.indexNameForStatistics);
            }
        }
        this.getCompilerContext().createDependency(this.baseTable);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return AlterTableNode.isSessionSchema(this.baseTable.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        this.prepConstantAction();
        return this.getGenericConstantActionFactory().getAlterTableConstantAction(this.schemaDescriptor, this.getRelativeName(), this.baseTable.getUUID(), this.baseTable.getHeapConglomerateId(), 0, this.colInfos, this.conActions, this.lockGranularity, this.compressTable, this.behavior, this.sequential, this.truncateTable, this.purge, this.defragment, this.truncateEndOfTable, this.updateStatistics, this.updateStatisticsAll, this.dropStatistics, this.dropStatisticsAll, this.indexNameForStatistics);
    }

    private void prepConstantAction() throws StandardException {
        if (this.tableElementList != null) {
            this.genColumnInfo();
        }
        if (this.numConstraints > 0) {
            this.conActions = new ConstraintConstantAction[this.numConstraints];
            this.tableElementList.genConstraintActions(false, this.conActions, this.getRelativeName(), this.schemaDescriptor, this.getDataDictionary());
            for (int conIndex = 0; conIndex < this.conActions.length; ++conIndex) {
                DataDictionary dd;
                ConstraintDescriptorList cdl;
                int constraintType;
                ConstraintConstantAction cca = this.conActions[conIndex];
                if (!(cca instanceof CreateConstraintConstantAction) || (constraintType = cca.getConstraintType()) != 2 || (cdl = (dd = this.getDataDictionary()).getConstraintDescriptors(this.baseTable)).getPrimaryKey() == null) continue;
                throw StandardException.newException("X0Y58.S", this.baseTable.getQualifiedName());
            }
        }
    }

    public void genColumnInfo() throws StandardException {
        this.colInfos = new ColumnInfo[this.tableElementList.countNumberOfColumns()];
        this.numConstraints = this.tableElementList.genColumnInfos(this.colInfos);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.tableElementList != null) {
            this.tableElementList.accept(v);
        }
    }
}

