/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public abstract class BinaryListOperatorNode
extends ValueNode {
    String methodName;
    String operator;
    ValueNode leftOperand;
    ValueNodeList rightOperandList;

    BinaryListOperatorNode(ValueNode leftOperand, ValueNodeList rightOperandList, String operator, String methodName, ContextManager cm) throws SecurityException {
        super(cm);
        this.leftOperand = leftOperand;
        this.rightOperandList = rightOperandList;
        this.operator = operator;
        this.methodName = methodName;
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperandList != null) {
            this.printLabel(depth, "rightOperandList: ");
            this.rightOperandList.treePrint(depth + 1);
        }
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregates);
        this.rightOperandList.bindExpression(fromList, subqueryList, aggregates);
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.rightOperandList.containsAllParameterNodes()) {
                throw StandardException.newException("42X35", this.operator);
            }
            this.leftOperand.setType(this.rightOperandList.getTypeServices());
        }
        if (this.rightOperandList.containsParameterNode()) {
            this.rightOperandList.setParameterDescriptor(this.leftOperand.getTypeServices());
        }
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        this.rightOperandList.genSQLJavaSQLTrees();
        this.bindComparisonOperator();
        return this;
    }

    void bindComparisonOperator() throws StandardException {
        this.rightOperandList.comparable(this.leftOperand);
        boolean nullableResult = this.leftOperand.getTypeServices().isNullable() || this.rightOperandList.isNullable();
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.rightOperandList.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    void setRightOperandList(ValueNodeList newRightOperandList) {
        this.rightOperandList = newRightOperandList;
    }

    ValueNodeList getRightOperandList() {
        return this.rightOperandList;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        boolean pushable = this.leftOperand.categorize(referencedTabs, simplePredsOnly);
        pushable = this.rightOperandList.categorize(referencedTabs, simplePredsOnly) && pushable;
        return pushable;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperandList.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperandList.isConstantExpression();
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return this.leftOperand.constantExpression(whereClause) && this.rightOperandList.constantExpression(whereClause);
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int leftType = this.leftOperand.getOrderableVariantType();
        int rightType = this.rightOperandList.getOrderableVariantType();
        return Math.min(leftType, rightType);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperandList != null) {
            this.rightOperandList = (ValueNodeList)this.rightOperandList.accept(v);
        }
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeKind(o)) {
            return false;
        }
        BinaryListOperatorNode other = (BinaryListOperatorNode)o;
        if (!this.operator.equals(other.operator) || !this.leftOperand.isEquivalent(other.getLeftOperand())) {
            return false;
        }
        return this.rightOperandList.isEquivalent(other.rightOperandList);
    }
}

