/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

class DropRoleNode
extends DDLStatementNode {
    private String roleName;

    DropRoleNode(String roleName, ContextManager cm) throws StandardException {
        super(null, cm);
        this.roleName = roleName;
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if (this.isPrivilegeCollectionRequired()) {
            cc.addRequiredRolePriv(this.roleName, 20);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "roleName: " + this.roleName + "\n";
    }

    @Override
    public String statementToString() {
        return "DROP ROLE";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropRoleConstantAction(this.roleName);
    }
}

