/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.sql.ResultSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class MethodCallNode
extends JavaValueNode {
    String methodName;
    String javaClassName;
    RoutineAliasInfo routineInfo;
    boolean internalCall;
    private String[] procedurePrimitiveArrayType;
    protected JSQLType[] signature;
    protected JavaValueNode[] methodParms;
    protected Member method;
    protected String actualMethodReturnType;
    String[] methodParameterTypes;

    MethodCallNode(String methodName, ContextManager cm) {
        super(cm);
        this.methodName = methodName;
    }

    String getMethodName() {
        return this.methodName;
    }

    TableName getFullName() {
        return null;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public Member getResolvedMethod() {
        return this.method;
    }

    public RoutineAliasInfo getRoutineInfo() {
        return this.routineInfo;
    }

    void addParms(List<ValueNode> parameterList) throws StandardException {
        this.methodParms = new JavaValueNode[parameterList.size()];
        int plSize = parameterList.size();
        for (int index = 0; index < plSize; ++index) {
            ValueNode qt = parameterList.get(index);
            SQLToJavaValueNode jqt = new SQLToJavaValueNode(qt, this.getContextManager());
            this.methodParms[index] = jqt;
        }
    }

    Class<?>[] getMethodParameterClasses() {
        ClassInspector ci = this.getClassFactory().getClassInspector();
        Class[] parmTypeClasses = new Class[this.methodParms.length];
        for (int i = 0; i < this.methodParms.length; ++i) {
            String className = this.methodParameterTypes[i];
            try {
                parmTypeClasses[i] = ci.getClass(className);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                SanityManager.THROWASSERT("Unexpected exception", cnfe);
                return null;
            }
        }
        return parmTypeClasses;
    }

    void getCorrelationTables(JBitSet correlationMap) throws StandardException {
        CollectNodesVisitor<ColumnReference> getCRs = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this.accept(getCRs);
        for (ColumnReference ref : getCRs.getList()) {
            if (!ref.getCorrelated()) continue;
            correlationMap.set(ref.getTableNumber());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.methodParms != null) {
            int parm = 0;
            while (parm < this.methodParms.length) {
                void var2_2;
                if (this.methodParms[var2_2] != null) {
                    this.printLabel(depth, "methodParms[" + (int)var2_2 + "] :");
                    this.methodParms[var2_2].treePrint(depth + 1);
                }
                ++var2_2;
            }
        }
    }

    @Override
    public String toString() {
        return "methodName: " + (this.methodName != null ? this.methodName : "null") + "\n" + super.toString();
    }

    final void bindParameters(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        if (this.methodParms != null) {
            int count = this.methodParms.length;
            if (this.signature == null) {
                this.signature = new JSQLType[count];
            }
            for (int parm = 0; parm < count; ++parm) {
                if (this.methodParms[parm] == null) continue;
                this.methodParms[parm] = this.methodParms[parm].bindExpression(fromList, subqueryList, aggregates);
                if (this.routineInfo == null) {
                    this.signature[parm] = this.methodParms[parm].getJSQLType();
                }
                SelectNode.checkNoWindowFunctions(this.methodParms[parm], "method argument");
            }
        }
    }

    protected boolean areParametersQueryInvariant() throws StandardException {
        return this.getVariantTypeOfParams() == 2;
    }

    void throwNoMethodFound(String receiverTypeName, String[] parmTypeNames, String[] primParmTypeNames) throws StandardException {
        StringBuilder parmTypes = new StringBuilder();
        int paramCount = this.signature.length;
        for (int i = 0; i < paramCount; ++i) {
            if (i != 0) {
                parmTypes.append(", ");
            }
            boolean isVararg = this.isVararg(i);
            String parmType = parmTypeNames[i];
            if (parmTypeNames[i].length() == 0) {
                parmType = "UNTYPED";
            } else if (isVararg) {
                parmType = this.getVarargTypeName(parmType);
            }
            parmTypes.append(parmType);
            if (primParmTypeNames == null || primParmTypeNames[i].equals(parmTypeNames[i])) continue;
            String primTypeName = primParmTypeNames[i];
            if (isVararg) {
                primTypeName = this.getVarargTypeName(primTypeName);
            }
            parmTypes.append("(" + primTypeName + ")");
        }
        throw StandardException.newException("42X50", receiverTypeName, this.methodName, parmTypes);
    }

    private String getVarargTypeName(String arrayTypeName) {
        return this.stripOneArrayLevel(arrayTypeName) + "...";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.methodParms != null) {
            int parm = 0;
            while (parm < this.methodParms.length) {
                void var5_5;
                if (this.methodParms[var5_5] != null) {
                    this.methodParms[var5_5].preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
                }
                ++var5_5;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        boolean pushable = true;
        if (this.methodParms != null) {
            int param = 0;
            while (param < this.methodParms.length) {
                void var4_4;
                if (this.methodParms[var4_4] != null) {
                    pushable = this.methodParms[var4_4].categorize(referencedTabs, simplePredsOnly) && pushable;
                }
                ++var4_4;
            }
        }
        return pushable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.methodParms != null) {
            int param = 0;
            while (param < this.methodParms.length) {
                void var1_1;
                if (this.methodParms[var1_1] != null) {
                    this.methodParms[var1_1] = this.methodParms[var1_1].remapColumnReferencesToExpressions();
                }
                ++var1_1;
            }
        }
        return this;
    }

    public boolean hasVarargs() {
        return this.routineInfo == null ? false : this.routineInfo.hasVarargs();
    }

    public int getFirstVarargIdx() {
        return this.signature.length - 1;
    }

    public boolean isVararg(int parameterNumber) {
        if (!this.hasVarargs()) {
            return false;
        }
        return parameterNumber >= this.getFirstVarargIdx();
    }

    public int generateParameters(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int nonVarargCount = this.hasVarargs() ? this.routineInfo.getParameterCount() - 1 : this.methodParms.length;
        int totalArgCount = this.hasVarargs() ? nonVarargCount + 1 : nonVarargCount;
        for (int param = 0; param < nonVarargCount; ++param) {
            this.generateAndCastOneParameter(acb, mb, param, this.methodParameterTypes[param]);
        }
        if (this.hasVarargs()) {
            this.generateVarargs(acb, mb);
        }
        return totalArgCount;
    }

    private void generateAndCastOneParameter(ExpressionClassBuilder acb, MethodBuilder mb, int param, String parameterType) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        this.generateOneParameter(acb, mb, param);
        String argumentType = MethodCallNode.getParameterTypeName(this.methodParms[param]);
        if (!parameterType.equals(argumentType)) {
            if (ClassInspector.primitiveType(argumentType) && parameterType.equals(JSQLType.getWrapperClassName(JSQLType.getPrimitiveID(argumentType)))) {
                if ("short".equals(argumentType)) {
                    mb.cast("int");
                }
                mb.callMethod((short)184, parameterType, "valueOf", parameterType, 1);
            } else if (ClassInspector.primitiveType(parameterType)) {
                mb.cast(parameterType);
            } else {
                if (this.routineInfo != null) {
                    return;
                }
                SanityManager.ASSERT(classInspector.assignableTo(argumentType, parameterType), "Argument type " + argumentType + " is not assignable to parameter " + parameterType);
                mb.upCast(parameterType);
            }
        }
    }

    private void generateVarargs(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int varargCount;
        String cellType;
        int firstVarargIdx = this.getFirstVarargIdx();
        String arrayType = this.methodParameterTypes[firstVarargIdx];
        String varargType = cellType = this.stripOneArrayLevel(arrayType);
        if (this.routineInfo != null && this.routineInfo.getParameterModes()[firstVarargIdx] != 1) {
            varargType = this.stripOneArrayLevel(varargType);
        }
        if ((varargCount = this.methodParms.length - firstVarargIdx) < 0) {
            varargCount = 0;
        }
        LocalField arrayField = acb.newFieldDeclaration(2, arrayType);
        MethodBuilder cb = acb.getConstructor();
        cb.pushNewArray(cellType, varargCount);
        cb.setField(arrayField);
        for (int i = 0; i < varargCount; ++i) {
            mb.getField(arrayField);
            this.generateAndCastOneParameter(acb, mb, i + firstVarargIdx, cellType);
            mb.setArrayElement(i);
        }
        mb.getField(arrayField);
    }

    protected int getRoutineArgIdx(int invocationArgIdx) {
        if (this.routineInfo == null) {
            return invocationArgIdx;
        }
        return this.getRoutineArgIdx(this.routineInfo, invocationArgIdx);
    }

    protected int getRoutineArgIdx(RoutineAliasInfo rai, int invocationArgIdx) {
        if (!rai.hasVarargs()) {
            return invocationArgIdx;
        }
        int firstVarargIdx = rai.getParameterCount() - 1;
        return firstVarargIdx < invocationArgIdx ? firstVarargIdx : invocationArgIdx;
    }

    public static String getParameterTypeName(JavaValueNode param) throws StandardException {
        String argumentType = param.isPrimitiveType() ? param.getPrimitiveTypeName() : param.getJavaTypeName();
        return argumentType;
    }

    void generateOneParameter(ExpressionClassBuilder acb, MethodBuilder mb, int parameterNumber) throws StandardException {
        this.methodParms[parameterNumber].generateExpression(acb, mb);
    }

    void setNullParameterInfo(String[] parmTypeNames) throws StandardException {
        for (int i = 0; i < this.methodParms.length; ++i) {
            if (!this.methodParms[i].getJavaTypeName().equals("")) continue;
            DataTypeDescriptor dts = DataTypeDescriptor.getSQLDataTypeDescriptor(parmTypeNames[i]);
            ((SQLToJavaValueNode)this.methodParms[i]).value.setType(dts);
            this.methodParms[i].setJavaTypeName(parmTypeNames[i]);
            this.signature[i] = this.methodParms[i].getJSQLType();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resolveMethodCall(String javaClassName, boolean staticMethod) throws StandardException {
        String typeName;
        String[] parmTypeNames;
        if (this.routineInfo == null && !this.internalCall && (this.getCompilerContext().getReliability() & 0x400) != 0) {
            throw StandardException.newException("42X01", javaClassName + (staticMethod ? "::" : ".") + this.methodName);
        }
        int count = this.signature.length;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String[] primParmTypeNames = null;
        boolean[] isParam = this.getIsParam();
        boolean hasDynamicResultSets = this.hasVarargs() ? false : this.routineInfo != null && count != 0 && count != this.methodParms.length;
        int signatureOffset = this.methodName.indexOf(40);
        if (signatureOffset != -1) {
            parmTypeNames = this.parseValidateSignature(this.methodName, signatureOffset, hasDynamicResultSets);
            this.methodName = this.methodName.substring(0, signatureOffset);
            hasDynamicResultSets = false;
        } else {
            parmTypeNames = this.getObjectSignature();
        }
        if (this.hasVarargs()) {
            parmTypeNames[count - 1] = parmTypeNames[count - 1] + "[]";
        }
        try {
            this.method = classInspector.findPublicMethod(javaClassName, this.methodName, parmTypeNames, null, isParam, staticMethod, hasDynamicResultSets, this.hasVarargs());
            if (signatureOffset == -1 && this.routineInfo == null && this.method == null) {
                primParmTypeNames = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicMethod(javaClassName, this.methodName, parmTypeNames, primParmTypeNames, isParam, staticMethod, hasDynamicResultSets, this.hasVarargs());
            }
        }
        catch (ClassNotFoundException e) {
            this.method = null;
        }
        if (this.method == null) {
            this.throwNoMethodFound(javaClassName, parmTypeNames, primParmTypeNames);
        }
        this.actualMethodReturnType = typeName = classInspector.getType(this.method);
        if (this.routineInfo == null) {
            if (typeName.equals("void") && !this.forCallStatement) {
                throw StandardException.newException("42Y09", new Object[0]);
            }
        } else {
            boolean foundCorrectType;
            String requiredType;
            String promoteName = null;
            TypeDescriptorImpl returnType = (TypeDescriptorImpl)this.routineInfo.getReturnType();
            if (returnType == null) {
                requiredType = "void";
            } else {
                TypeId returnTypeId = TypeId.getBuiltInTypeId(returnType.getJDBCTypeId());
                if (returnType.isRowMultiSet() && this.routineInfo.getParameterStyle() == 1) {
                    requiredType = ResultSet.class.getName();
                } else if (returnType.getTypeId().userType()) {
                    requiredType = ((UserDefinedTypeIdImpl)returnType.getTypeId()).getClassName();
                } else {
                    requiredType = returnTypeId.getCorrespondingJavaTypeName();
                    if (!requiredType.equals(typeName)) {
                        switch (returnType.getJDBCTypeId()) {
                            case -5: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 16: {
                                TypeCompiler tc = this.getTypeCompiler(returnTypeId);
                                requiredType = tc.getCorrespondingPrimitiveTypeName();
                                if (this.routineInfo.calledOnNullInput() || this.routineInfo.getParameterCount() == 0) break;
                                promoteName = returnTypeId.getCorrespondingJavaTypeName();
                                break;
                            }
                        }
                    }
                }
            }
            if (ResultSet.class.getName().equals(requiredType)) {
                try {
                    Class<?> actualType = classInspector.getClass(typeName);
                    foundCorrectType = ResultSet.class.isAssignableFrom(actualType);
                }
                catch (ClassNotFoundException cnfe) {
                    foundCorrectType = false;
                }
            } else {
                foundCorrectType = requiredType.equals(typeName);
            }
            if (!foundCorrectType) {
                this.throwNoMethodFound(requiredType + " " + javaClassName, parmTypeNames, primParmTypeNames);
            }
            if (promoteName != null) {
                typeName = promoteName;
            }
            if (this.routineInfo.getReturnType() != null) {
                this.setCollationType(this.routineInfo.getReturnType().getCollationType());
            }
        }
        this.setJavaTypeName(typeName);
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        String methodParameter = null;
        block12: for (int i = 0; i < this.methodParameterTypes.length; ++i) {
            methodParameter = this.methodParameterTypes[i];
            if (this.routineInfo != null && i < this.routineInfo.getParameterCount()) {
                int parameterMode = this.routineInfo.getParameterModes()[this.getRoutineArgIdx(i)];
                switch (parameterMode) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        methodParameter = this.stripOneArrayLevel(methodParameter);
                        break;
                    }
                    case 4: {
                        continue block12;
                    }
                }
            }
            if (this.hasVarargs() && i >= this.getFirstVarargIdx()) {
                methodParameter = this.stripOneArrayLevel(methodParameter);
            }
            if (!ClassInspector.primitiveType(methodParameter) || i >= this.methodParms.length) continue;
            this.methodParms[i].castToPrimitive(true);
        }
        if (this.hasVarargs()) {
            int firstVarargIdx = this.getFirstVarargIdx();
            int trailingVarargCount = this.methodParms.length - firstVarargIdx;
            for (int i = 1; i < trailingVarargCount; ++i) {
                if (!ClassInspector.primitiveType(methodParameter)) continue;
                this.methodParms[i + firstVarargIdx].castToPrimitive(true);
            }
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        DataTypeDescriptor dts = DataTypeDescriptor.getSQLDataTypeDescriptor(typeName);
        if (this.getCompilerContext().getReturnParameterFlag()) {
            this.getParameterTypes()[0] = dts;
        }
    }

    protected String stripOneArrayLevel(String typeName) {
        return typeName.substring(0, typeName.length() - 2);
    }

    private String[] parseValidateSignature(String externalName, int offset, boolean hasDynamicResultSets) throws StandardException {
        int siglen = externalName.length();
        if (offset + 1 == siglen || externalName.charAt(siglen - 1) != ')') {
            throw StandardException.newException("46J01", new Object[0]);
        }
        StringTokenizer st = new StringTokenizer(externalName.substring(offset + 1, siglen - 1), ",", true);
        String[] signatureTypes = new String[this.signature.length];
        boolean seenClass = false;
        int count = 0;
        while (st.hasMoreTokens()) {
            TypeCompiler tc;
            String type = st.nextToken().trim();
            if (",".equals(type)) {
                if (!seenClass) {
                    throw StandardException.newException("46J01", new Object[0]);
                }
                seenClass = false;
                continue;
            }
            if (type.length() == 0) {
                throw StandardException.newException("46J01", new Object[0]);
            }
            seenClass = true;
            if (++count > this.signature.length) {
                if (hasDynamicResultSets) {
                    String rsType = this.signature[this.signature.length - 1].getSQLType().getTypeId().getCorrespondingJavaTypeName();
                    if (!type.equals(rsType)) {
                        throw StandardException.newException("22005", type, rsType);
                    }
                    if (signatureTypes.length == this.signature.length) {
                        String[] sigs = new String[st.countTokens()];
                        System.arraycopy(signatureTypes, 0, sigs, 0, signatureTypes.length);
                        signatureTypes = sigs;
                    }
                    signatureTypes[count - 1] = type;
                    continue;
                }
                throw StandardException.newException("46J02", Integer.toString(count), Integer.toString(this.signature.length));
            }
            TypeId paramTypeId = this.signature[count - 1].getSQLType().getTypeId();
            if (type.equals(paramTypeId.getCorrespondingJavaTypeName())) {
                signatureTypes[count - 1] = type;
                continue;
            }
            if ((paramTypeId.isNumericTypeId() && !paramTypeId.isDecimalTypeId() || paramTypeId.isBooleanTypeId()) && type.equals((tc = this.getTypeCompiler(paramTypeId)).getCorrespondingPrimitiveTypeName())) {
                signatureTypes[count - 1] = type;
                continue;
            }
            throw StandardException.newException("22005", type, paramTypeId.getSQLTypeName());
        }
        if (count != 0 && !seenClass) {
            throw StandardException.newException("46J01", new Object[0]);
        }
        if (count < signatureTypes.length) {
            if (hasDynamicResultSets && count == this.signature.length - 1) {
                String[] sigs = new String[count];
                System.arraycopy(signatureTypes, 0, sigs, 0, count);
                return sigs;
            }
            throw StandardException.newException("46J02", Integer.toString(count), Integer.toString(this.signature.length));
        }
        return signatureTypes;
    }

    protected boolean someParametersAreNull() {
        int count = this.signature.length;
        for (int ictr = 0; ictr < count; ++ictr) {
            if (this.signature[ictr] != null) continue;
            return true;
        }
        return false;
    }

    protected String[] getObjectSignature() throws StandardException {
        int count = this.signature.length;
        String[] parmTypeNames = new String[count];
        TypeCompilerFactory tcf = this.routineInfo == null ? null : this.getCompilerContext().getTypeCompilerFactory();
        for (int i = 0; i < count; ++i) {
            parmTypeNames[i] = MethodCallNode.getObjectTypeName(this.signature[i], tcf);
        }
        return parmTypeNames;
    }

    protected boolean[] getIsParam() {
        if (this.methodParms == null) {
            return new boolean[0];
        }
        boolean[] isParam = new boolean[this.methodParms.length];
        for (int index = 0; index < this.methodParms.length; ++index) {
            if (!(this.methodParms[index] instanceof SQLToJavaValueNode)) continue;
            SQLToJavaValueNode stjvn = (SQLToJavaValueNode)this.methodParms[index];
            if (!stjvn.value.requiresTypeFromContext()) continue;
            isParam[index] = true;
        }
        return isParam;
    }

    static String getObjectTypeName(JSQLType jsqlType, TypeCompilerFactory tcf) throws StandardException {
        if (jsqlType != null) {
            switch (jsqlType.getCategory()) {
                case 0: {
                    TypeId ctid = MethodCallNode.mapToTypeID(jsqlType);
                    if (ctid == null) {
                        return null;
                    }
                    switch (ctid.getJDBCTypeId()) {
                        case -5: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 16: {
                            if (tcf == null) break;
                            return tcf.getTypeCompiler(ctid).getCorrespondingPrimitiveTypeName();
                        }
                    }
                    return ctid.getCorrespondingJavaTypeName();
                }
                case 1: {
                    return jsqlType.getJavaClassName();
                }
                case 2: {
                    return JSQLType.getPrimitiveName(jsqlType.getPrimitiveKind());
                }
            }
            SanityManager.THROWASSERT("Unknown JSQLType: " + jsqlType);
        }
        return "";
    }

    String[] getPrimitiveSignature(boolean castToPrimitiveAsNecessary) throws StandardException {
        int count = this.signature.length;
        String[] primParmTypeNames = new String[count];
        block5: for (int i = 0; i < count; ++i) {
            JSQLType jsqlTyp = this.signature[i];
            if (jsqlTyp == null) {
                primParmTypeNames[i] = "";
                continue;
            }
            switch (jsqlTyp.getCategory()) {
                case 0: {
                    if (this.procedurePrimitiveArrayType != null && i < this.procedurePrimitiveArrayType.length && this.procedurePrimitiveArrayType[i] != null) {
                        primParmTypeNames[i] = this.procedurePrimitiveArrayType[i];
                        continue block5;
                    }
                    TypeId ctid = MethodCallNode.mapToTypeID(jsqlTyp);
                    if (ctid.isNumericTypeId() && !ctid.isDecimalTypeId() || ctid.isBooleanTypeId()) {
                        TypeCompiler tc = this.getTypeCompiler(ctid);
                        primParmTypeNames[i] = tc.getCorrespondingPrimitiveTypeName();
                        if (!castToPrimitiveAsNecessary) continue block5;
                        this.methodParms[i].castToPrimitive(true);
                        continue block5;
                    }
                    primParmTypeNames[i] = ctid.getCorrespondingJavaTypeName();
                    continue block5;
                }
                case 1: {
                    primParmTypeNames[i] = jsqlTyp.getJavaClassName();
                    continue block5;
                }
                case 2: {
                    primParmTypeNames[i] = JSQLType.getPrimitiveName(jsqlTyp.getPrimitiveKind());
                    if (!castToPrimitiveAsNecessary) continue block5;
                    this.methodParms[i].castToPrimitive(true);
                    continue block5;
                }
                default: {
                    SanityManager.THROWASSERT("Unknown JSQLType: " + jsqlTyp);
                }
            }
        }
        return primParmTypeNames;
    }

    @Override
    int getOrderableVariantType() throws StandardException {
        return this.getVariantTypeOfParams();
    }

    private int getVariantTypeOfParams() throws StandardException {
        int variance = 2;
        if (this.methodParms != null) {
            for (int parm = 0; parm < this.methodParms.length; ++parm) {
                if (this.methodParms[parm] != null) {
                    int paramVariantType = this.methodParms[parm].getOrderableVariantType();
                    if (paramVariantType >= variance) continue;
                    variance = paramVariantType;
                    continue;
                }
                variance = 0;
            }
        }
        return variance;
    }

    @Override
    DataTypeDescriptor getDataType() throws StandardException {
        TypeDescriptor td;
        if (this.routineInfo != null && (td = this.routineInfo.getReturnType()) != null) {
            return DataTypeDescriptor.getType(td);
        }
        return super.getDataType();
    }

    JavaValueNode[] getMethodParms() {
        return this.methodParms;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        for (int parm = 0; !v.stopTraversal() && parm < this.methodParms.length; ++parm) {
            if (this.methodParms[parm] == null) continue;
            this.methodParms[parm] = (JavaValueNode)this.methodParms[parm].accept(v);
        }
    }
}

