/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

class RevokeRoleNode
extends DDLStatementNode {
    private List<String> roles;
    private List<String> grantees;

    RevokeRoleNode(List<String> roles, List<String> grantees, ContextManager cm) throws StandardException {
        super(cm);
        this.roles = roles;
        this.grantees = grantees;
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getRevokeRoleConstantAction(this.roles, this.grantees);
    }

    @Override
    public String toString() {
        StringBuilder sb1 = new StringBuilder();
        Iterator<String> it = this.roles.iterator();
        while (it.hasNext()) {
            if (sb1.length() > 0) {
                sb1.append(", ");
            }
            sb1.append(it.next().toString());
        }
        StringBuilder sb2 = new StringBuilder();
        Iterator<String> it2 = this.grantees.iterator();
        while (it2.hasNext()) {
            if (sb2.length() > 0) {
                sb2.append(", ");
            }
            sb2.append(it2.next().toString());
        }
        return super.toString() + sb1.toString() + " FROM: " + sb2.toString() + "\n";
    }

    @Override
    String statementToString() {
        return "REVOKE role";
    }
}

