/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.shared.common.sanity.SanityManager;

class SumAvgAggregateDefinition
implements AggregateDefinition {
    private boolean isSum;

    SumAvgAggregateDefinition() {
    }

    @Override
    public final DataTypeDescriptor getAggregator(DataTypeDescriptor inputType, StringBuffer aggregatorClass) {
        try {
            TypeId compType = inputType.getTypeId();
            CompilerContext cc = (CompilerContext)ContextService.getContext("CompilerContext");
            TypeCompilerFactory tcf = cc.getTypeCompilerFactory();
            TypeCompiler tc = tcf.getTypeCompiler(compType);
            if (compType.isNumericTypeId()) {
                aggregatorClass.append(this.getAggregatorClassName());
                DataTypeDescriptor outDts = tc.resolveArithmeticOperation(inputType, inputType, this.getOperator());
                return outDts.getNullabilityType(true);
            }
        }
        catch (StandardException e) {
            SanityManager.THROWASSERT("Unexpected exception", e);
        }
        return null;
    }

    private String getAggregatorClassName() {
        if (this.isSum) {
            return "org.apache.derby.impl.sql.execute.SumAggregator";
        }
        return "org.apache.derby.impl.sql.execute.AvgAggregator";
    }

    protected String getOperator() {
        if (this.isSum) {
            return "sum";
        }
        return "avg";
    }

    final void setSumOrAvg(boolean isSum) {
        this.isSum = isSum;
    }
}

