/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.compile.ParserImpl;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionContext;
import org.apache.derby.shared.common.sanity.SanityManager;

public class GenericLanguageConnectionFactory
implements LanguageConnectionFactory,
CacheableFactory,
PropertySetCallback,
ModuleControl,
ModuleSupportable {
    private ExecutionFactory ef;
    private OptimizerFactory of;
    private TypeCompilerFactory tcf;
    private DataValueFactory dvf;
    private UUIDFactory uuidFactory;
    private JavaFactory javaFactory;
    private ClassFactory classFactory;
    private PropertyFactory pf;
    private int nextLCCInstanceNumber;
    private int cacheSize = 100;
    private CacheManager singleStatementCache;

    @Override
    public Statement getStatement(SchemaDescriptor compilationSchema, String statementText, boolean forReadOnly) {
        return new GenericStatement(compilationSchema, statementText, forReadOnly);
    }

    @Override
    public LanguageConnectionContext newLanguageConnectionContext(ContextManager cm, TransactionController tc, LanguageFactory lf, Database db, String userName, String drdaID, String dbname) throws StandardException {
        return new GenericLanguageConnectionContext(cm, tc, lf, this, db, userName, this.getNextLCCInstanceNumber(), drdaID, dbname);
    }

    @Override
    public Cacheable newCacheable(CacheManager cm) {
        return new CachedStatement();
    }

    @Override
    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    @Override
    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    @Override
    public JavaFactory getJavaFactory() {
        return this.javaFactory;
    }

    @Override
    public ExecutionFactory getExecutionFactory() {
        return this.ef;
    }

    @Override
    public PropertyFactory getPropertyFactory() {
        return this.pf;
    }

    @Override
    public OptimizerFactory getOptimizerFactory() {
        return this.of;
    }

    @Override
    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.tcf;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    @Override
    public boolean canSupport(Properties startParams) {
        return Monitor.isDesiredType(startParams, 130);
    }

    private int statementCacheSize(Properties startParams) {
        String wantCacheProperty = null;
        wantCacheProperty = PropertyUtil.getPropertyFromSet(startParams, "derby.language.statementCacheSize");
        SanityManager.DEBUG("StatementCacheInfo", "Cacheing implementation chosen if null or 0<" + wantCacheProperty);
        if (wantCacheProperty != null) {
            try {
                this.cacheSize = Integer.parseInt(wantCacheProperty);
            }
            catch (NumberFormatException nfe) {
                this.cacheSize = 100;
            }
        }
        return this.cacheSize;
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        this.dvf = (DataValueFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.types.DataValueFactory", startParams);
        this.javaFactory = (JavaFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.compiler.JavaFactory");
        this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.classFactory = (ClassFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.services.loader.ClassFactory");
        if (this.classFactory == null) {
            this.classFactory = (ClassFactory)Monitor.findSystemModule("org.apache.derby.iapi.services.loader.ClassFactory");
        }
        this.setValidation();
        this.ef = (ExecutionFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.sql.execute.ExecutionFactory", startParams);
        this.of = (OptimizerFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.sql.compile.OptimizerFactory", startParams);
        this.tcf = (TypeCompilerFactory)Monitor.startSystemModule("org.apache.derby.iapi.sql.compile.TypeCompilerFactory");
        int cacheSize = this.statementCacheSize(startParams);
        if (cacheSize > 0) {
            CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
            this.singleStatementCache = cacheFactory.newCacheManager(this, "StatementCache", cacheSize / 4, cacheSize);
        }
    }

    @Override
    public CacheManager getStatementCache() {
        return this.singleStatementCache;
    }

    @Override
    public void stop() {
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (value == null) {
            return true;
        }
        if (key.equals("derby.database.defaultConnectionMode")) {
            String value_s = (String)((Object)value);
            if (!(value_s == null || StringUtil.SQLEqualsIgnoreCase(value_s, "NOACCESS") || StringUtil.SQLEqualsIgnoreCase(value_s, "READONLYACCESS") || StringUtil.SQLEqualsIgnoreCase(value_s, "FULLACCESS"))) {
                throw StandardException.newException("4250B", key, value_s);
            }
            return true;
        }
        if (key.equals("derby.database.readOnlyAccessUsers") || key.equals("derby.database.fullAccessUsers")) {
            String[] newList_a;
            String value_s = (String)((Object)value);
            try {
                newList_a = IdUtil.parseIdList(value_s);
            }
            catch (StandardException se) {
                throw StandardException.newException("4250B", se, key, value_s);
            }
            String dups = IdUtil.dups(newList_a);
            if (dups != null) {
                throw StandardException.newException("4250D", key, dups);
            }
            String otherList = key.equals("derby.database.readOnlyAccessUsers") ? (String)p.get("derby.database.fullAccessUsers") : (String)p.get("derby.database.readOnlyAccessUsers");
            String[] otherList_a = IdUtil.parseIdList(otherList);
            String both = IdUtil.intersect(newList_a, otherList_a);
            if (both != null) {
                throw StandardException.newException("4250C", both);
            }
            return true;
        }
        return false;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) {
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) {
        return null;
    }

    protected void setValidation() throws StandardException {
        this.pf = (PropertyFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        this.pf.addPropertySetNotification(this);
    }

    @Override
    public Parser newParser(CompilerContext cc) {
        return new ParserImpl(cc);
    }

    protected synchronized int getNextLCCInstanceNumber() {
        return this.nextLCCInstanceNumber++;
    }
}

