/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

public class AlterConstraintConstantAction
extends ConstraintConstantAction {
    private String constraintSchemaName;
    boolean[] characteristics;

    AlterConstraintConstantAction(String constraintName, String constraintSchemaName, boolean[] characteristics, String tableName, UUID tableId, String tableSchemaName, IndexConstantAction indexAction) {
        super(constraintName, 5, tableName, tableId, tableSchemaName, indexAction);
        this.constraintSchemaName = constraintSchemaName;
        this.characteristics = (boolean[])characteristics.clone();
    }

    public String toString() {
        String ss = this.constraintSchemaName == null ? this.schemaName : this.constraintSchemaName;
        return "ALTER CONSTRAINT " + ss + "." + this.constraintName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        TableDescriptor td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        SchemaDescriptor tdSd = td.getSchemaDescriptor();
        SchemaDescriptor constraintSd = this.constraintSchemaName == null ? tdSd : dd.getSchemaDescriptor(this.constraintSchemaName, tc, true);
        ConstraintDescriptor conDesc = dd.getConstraintDescriptorByName(td, constraintSd, this.constraintName, true);
        if (conDesc == null) {
            throw StandardException.newException("42X86", constraintSd.getSchemaName() + "." + this.constraintName, td.getQualifiedName());
        }
        if (!this.characteristics[2]) {
            dd.checkVersion(230, "DEFERRED CONSTRAINTS");
            if (!(this.constraintType != 6 && this.constraintType != 1 && this.characteristics[2] || PropertyUtil.getSystemProperty("derby.constraintsTesting", "false").equals("true"))) {
                throw StandardException.newException("0A000.S", "non-default enforcement");
            }
        }
        conDesc.setEnforced(this.characteristics[2]);
        int[] colsToSet = new int[]{6};
        dd.updateConstraintDescriptor(conDesc, conDesc.getUUID(), colsToSet, tc);
    }
}

