/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.xplain;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementTimingsDescriptor;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class XPLAINSystemTableVisitor
implements XPLAINVisitor {
    private boolean no_call_stmts = true;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private Activation activation;
    private boolean considerTimingInformation = false;
    private XPLAINStatementDescriptor stmt;
    private XPLAINStatementTimingsDescriptor stmtTimings = null;
    private UUID stmtUUID;
    private List<XPLAINResultSetDescriptor> rsets = new ArrayList<XPLAINResultSetDescriptor>();
    private List<Object> rsetsTimings = new ArrayList<Object>();
    private List<XPLAINSortPropsDescriptor> sortrsets = new ArrayList<XPLAINSortPropsDescriptor>();
    private List<XPLAINScanPropsDescriptor> scanrsets = new ArrayList<XPLAINScanPropsDescriptor>();
    private int noChildren;
    private Stack<UUID> UUIDStack = new Stack();

    private void pushUUIDnoChildren(UUID uuid) {
        for (int i = 0; i < this.noChildren; ++i) {
            this.UUIDStack.push(uuid);
        }
    }

    @Override
    public void setNumberOfChildren(int noChildren) {
        this.noChildren = noChildren;
    }

    @Override
    public void visit(ResultSetStatistics statistics) {
        UUID sortID;
        XPLAINSortPropsDescriptor sortRSDescriptor;
        UUID timingID = null;
        if (this.considerTimingInformation) {
            timingID = this.dd.getUUIDFactory().createUUID();
            this.rsetsTimings.add(statistics.getResultSetTimingsDescriptor(timingID));
        }
        if ((sortRSDescriptor = (XPLAINSortPropsDescriptor)statistics.getSortPropsDescriptor(sortID = this.dd.getUUIDFactory().createUUID())) != null) {
            this.sortrsets.add(sortRSDescriptor);
        } else {
            sortID = null;
        }
        UUID scanID = this.dd.getUUIDFactory().createUUID();
        XPLAINScanPropsDescriptor scanRSDescriptor = (XPLAINScanPropsDescriptor)statistics.getScanPropsDescriptor(scanID);
        if (scanRSDescriptor != null) {
            this.scanrsets.add(scanRSDescriptor);
        } else {
            scanID = null;
        }
        UUID rsID = this.dd.getUUIDFactory().createUUID();
        this.rsets.add((XPLAINResultSetDescriptor)statistics.getResultSetDescriptor(rsID, this.UUIDStack.empty() ? (UUID)null : this.UUIDStack.pop(), scanID, sortID, this.stmtUUID, timingID));
        this.pushUUIDnoChildren(rsID);
    }

    @Override
    public void reset() {
        this.lcc = this.activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
    }

    @Override
    public void doXPLAIN(RunTimeStatistics rss, Activation activation) throws StandardException {
        this.activation = activation;
        this.reset();
        this.considerTimingInformation = this.lcc.getStatisticsTiming();
        UUID stmtTimingsUUID = null;
        if (this.considerTimingInformation) {
            stmtTimingsUUID = this.dd.getUUIDFactory().createUUID();
            Timestamp endExeTS = rss.getEndExecutionTimestamp();
            Timestamp beginExeTS = rss.getBeginExecutionTimestamp();
            long exeTime = endExeTS != null && beginExeTS != null ? endExeTS.getTime() - beginExeTS.getTime() : 0L;
            this.stmtTimings = new XPLAINStatementTimingsDescriptor(stmtTimingsUUID, new Long(rss.getParseTimeInMillis()), new Long(rss.getBindTimeInMillis()), new Long(rss.getOptimizeTimeInMillis()), new Long(rss.getGenerateTimeInMillis()), new Long(rss.getCompileTimeInMillis()), new Long(exeTime), rss.getBeginCompilationTimestamp(), rss.getEndCompilationTimestamp(), rss.getBeginExecutionTimestamp(), rss.getEndExecutionTimestamp());
        }
        this.stmtUUID = this.dd.getUUIDFactory().createUUID();
        String type = XPLAINUtil.getStatementType(rss.getStatementText());
        if (type.equalsIgnoreCase("C") && this.no_call_stmts) {
            return;
        }
        String xaID = this.lcc.getTransactionExecute().getTransactionIdString();
        String sessionID = Integer.toString(this.lcc.getInstanceNumber());
        String jvmID = Integer.toString(JVMInfo.JDK_ID);
        String osID = System.getProperty("os.name");
        long current = System.currentTimeMillis();
        String XPLAINtype = this.lcc.getXplainOnlyMode() ? "O" : "F";
        Timestamp time = new Timestamp(current);
        String threadID = Thread.currentThread().toString();
        this.stmt = new XPLAINStatementDescriptor(this.stmtUUID, rss.getStatementName(), type, rss.getStatementText(), jvmID, osID, XPLAINtype, time, threadID, xaID, sessionID, this.lcc.getDbname(), this.lcc.getDrdaID(), stmtTimingsUUID);
        try {
            this.addStmtDescriptorsToSystemCatalog();
            rss.acceptFromTopResultSet(this);
            this.addArraysToSystemCatalogs();
        }
        catch (SQLException e) {
            throw StandardException.plainWrapException(e);
        }
        this.clean();
    }

    private void clean() {
        this.activation = null;
        this.lcc = null;
        this.dd = null;
        this.stmtUUID = null;
        this.stmt = null;
        this.stmtTimings = null;
        this.rsets.clear();
        this.rsetsTimings.clear();
        this.sortrsets.clear();
        this.scanrsets.clear();
        this.UUIDStack.clear();
    }

    private Connection getDefaultConn() throws SQLException {
        ConnectionContext cc = (ConnectionContext)((Object)this.lcc.getContextManager().getContext("JDBC_ConnectionContext"));
        return cc.getNestedConnection(true);
    }

    private void addStmtDescriptorsToSystemCatalog() throws StandardException, SQLException {
        boolean statsSave = this.lcc.getRunTimeStatisticsMode();
        this.lcc.setRunTimeStatisticsMode(false);
        Connection conn = this.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_STATEMENTS"));
        this.stmt.setStatementParameters(ps);
        ps.executeUpdate();
        ps.close();
        if (this.considerTimingInformation) {
            ps = conn.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_STATEMENT_TIMINGS"));
            this.stmtTimings.setStatementParameters(ps);
            ps.executeUpdate();
            ps.close();
        }
        conn.close();
        this.lcc.setRunTimeStatisticsMode(statsSave);
    }

    private void addArraysToSystemCatalogs() throws StandardException, SQLException {
        boolean statsSave = this.lcc.getRunTimeStatisticsMode();
        this.lcc.setRunTimeStatisticsMode(false);
        Connection conn = this.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_RESULTSETS"));
        for (XPLAINResultSetDescriptor rset : this.rsets) {
            rset.setStatementParameters(ps);
            ps.executeUpdate();
        }
        ps.close();
        if (this.considerTimingInformation) {
            ps = conn.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_RESULTSET_TIMINGS"));
            for (XPLAINResultSetTimingsDescriptor xPLAINResultSetTimingsDescriptor : this.rsetsTimings) {
                xPLAINResultSetTimingsDescriptor.setStatementParameters(ps);
                ps.executeUpdate();
            }
            ps.close();
        }
        ps = conn.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_SCAN_PROPS"));
        for (XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor : this.scanrsets) {
            xPLAINScanPropsDescriptor.setStatementParameters(ps);
            ps.executeUpdate();
        }
        ps.close();
        ps = conn.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_SORT_PROPS"));
        for (XPLAINSortPropsDescriptor sortProps : this.sortrsets) {
            sortProps.setStatementParameters(ps);
            ps.executeUpdate();
        }
        ps.close();
        conn.close();
        this.lcc.setRunTimeStatisticsMode(statsSave);
    }
}

