/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;
import org.apache.derby.impl.store.access.conglomerate.GenericConglomerate;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerateScratchSpace;
import org.apache.derby.impl.store.access.conglomerate.TemplateRow;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class BTree
extends GenericConglomerate {
    public static final long ROOTPAGEID = 1L;
    public static final String PROPERTY_MAX_ROWS_PER_PAGE_PARAMETER = "derby.access.btreeMaxRowPerPage";
    public static final String PROPERTY_ALLOWDUPLICATES = "allowDuplicates";
    public static final String PROPERTY_NKEYFIELDS = "nKeyFields";
    public static final String PROPERTY_NUNIQUECOLUMNS = "nUniqueColumns";
    public static final String PROPERTY_PARENTLINKS = "maintainParentLinks";
    public static final String PROPERTY_UNIQUE_WITH_DUPLICATE_NULLS = "uniqueWithDuplicateNulls";
    protected ContainerKey id;
    protected int nKeyFields;
    int nUniqueColumns;
    boolean allowDuplicates;
    boolean maintainParentLinks;
    boolean uniqueWithDuplicateNulls = false;
    static int maxRowsPerPage = Integer.MAX_VALUE;
    protected int conglom_format_id;
    protected int[] format_ids;
    protected boolean[] ascDescInfo;
    protected int[] collation_ids;
    protected boolean hasCollatedTypes;

    protected abstract BTreeLockingPolicy getBtreeLockingPolicy(Transaction var1, int var2, int var3, int var4, ConglomerateController var5, OpenBTree var6) throws StandardException;

    public abstract ConglomerateController lockTable(TransactionManager var1, int var2, int var3, int var4) throws StandardException;

    final DataValueDescriptor[] createBranchTemplate(Transaction rawtran, DataValueDescriptor page_ptr) throws StandardException {
        return TemplateRow.newBranchRow(rawtran, this.format_ids, this.collation_ids, page_ptr);
    }

    public final DataValueDescriptor[] createTemplate(Transaction rawtran) throws StandardException {
        SanityManager.ASSERT(this.format_ids != null);
        return TemplateRow.newRow(rawtran, null, this.format_ids, this.collation_ids);
    }

    public final boolean isUnique() {
        return this.nKeyFields != this.nUniqueColumns;
    }

    public void setUniqueWithDuplicateNulls(boolean uniqueWithDuplicateNulls) {
        this.uniqueWithDuplicateNulls = uniqueWithDuplicateNulls;
    }

    public boolean isUniqueWithDuplicateNulls() {
        return this.uniqueWithDuplicateNulls;
    }

    @Override
    public void addColumn(TransactionManager xact_manager, int column_id, Storable template_column, int collation_id) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public final ContainerKey getId() {
        return this.id;
    }

    public void create(Transaction rawtran, int segmentId, long input_containerid, DataValueDescriptor[] template, Properties properties, int conglom_format_id, int tmpFlag) throws StandardException {
        if (properties == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_NKEYFIELDS);
        }
        this.allowDuplicates = Boolean.valueOf(properties.getProperty(PROPERTY_ALLOWDUPLICATES, "false"));
        String result_string = properties.getProperty(PROPERTY_NKEYFIELDS);
        if (result_string == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_NKEYFIELDS);
        }
        this.nKeyFields = Integer.parseInt(result_string);
        result_string = properties.getProperty(PROPERTY_NUNIQUECOLUMNS);
        if (result_string == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_NUNIQUECOLUMNS);
        }
        this.nUniqueColumns = Integer.parseInt(result_string);
        result_string = properties.getProperty(PROPERTY_UNIQUE_WITH_DUPLICATE_NULLS, "false");
        this.uniqueWithDuplicateNulls = new Boolean(result_string);
        result_string = properties.getProperty(PROPERTY_MAX_ROWS_PER_PAGE_PARAMETER);
        if (result_string != null) {
            maxRowsPerPage = Integer.parseInt(result_string);
        }
        this.maintainParentLinks = Boolean.valueOf(properties.getProperty(PROPERTY_PARENTLINKS, "true"));
        if (template.length != this.nKeyFields) {
            SanityManager.THROWASSERT("template.length (" + template.length + ") expected to equal nKeyFields (" + this.nKeyFields + ")");
        }
        SanityManager.ASSERT(this.nUniqueColumns == this.nKeyFields || this.nUniqueColumns == this.nKeyFields - 1);
        this.format_ids = ConglomerateUtil.createFormatIds(template);
        this.conglom_format_id = conglom_format_id;
        properties.put("derby.storage.pageReservedSpace", "0");
        properties.put("derby.storage.minimumRecordSize", "1");
        properties.put("derby.storage.reusableRecordId", "true");
        long containerid = rawtran.addContainer(segmentId, input_containerid, 0, properties, tmpFlag);
        if (containerid <= 0L) {
            throw StandardException.newException("XSCB0.S", new Object[0]);
        }
        if (input_containerid != 0L) {
            SanityManager.ASSERT(containerid == input_containerid);
        }
        this.id = new ContainerKey(segmentId, containerid);
    }

    @Override
    public abstract void drop(TransactionManager var1) throws StandardException;

    @Override
    public abstract long load(TransactionManager var1, boolean var2, RowLocationRetRowSource var3) throws StandardException;

    @Override
    public long getContainerid() {
        return this.id.getContainerId();
    }

    @Override
    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo() throws StandardException {
        return new OpenConglomerateScratchSpace(this.format_ids, this.collation_ids, this.hasCollatedTypes);
    }

    @Override
    public boolean isTemporary() {
        return this.id.getSegmentId() == -1L;
    }

    @Override
    public abstract ConglomerateController open(TransactionManager var1, Transaction var2, boolean var3, int var4, int var5, LockingPolicy var6, StaticCompiledOpenConglomInfo var7, DynamicCompiledOpenConglomInfo var8) throws StandardException;

    @Override
    public boolean isNull() {
        return this.id == null;
    }

    @Override
    public void restoreToNull() {
        this.id = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.conglom_format_id = FormatIdUtil.readFormatIdInteger(in);
        long containerid = in.readLong();
        int segmentid = in.readInt();
        this.nKeyFields = in.readInt();
        this.nUniqueColumns = in.readInt();
        this.allowDuplicates = in.readBoolean();
        this.maintainParentLinks = in.readBoolean();
        this.format_ids = ConglomerateUtil.readFormatIdArray(this.nKeyFields, in);
        this.id = new ContainerKey(segmentid, containerid);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FormatIdUtil.writeFormatIdInteger(out, this.conglom_format_id);
        out.writeLong(this.id.getContainerId());
        out.writeInt((int)this.id.getSegmentId());
        out.writeInt(this.nKeyFields);
        out.writeInt(this.nUniqueColumns);
        out.writeBoolean(this.allowDuplicates);
        out.writeBoolean(this.maintainParentLinks);
        ConglomerateUtil.writeFormatIdArray(this.format_ids, out);
    }

    public String toString() {
        return "BTREE: containerid = " + (this.id == null ? "null" : this.id.toString()) + ";nKeyFields = " + this.nKeyFields + ";nUniqueColumns = " + this.nUniqueColumns + ";allowDuplicates = " + this.allowDuplicates;
    }
}

