/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.InterruptDetectedException;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.shared.common.sanity.SanityManager;

class RAFContainer
extends FileContainer
implements PrivilegedExceptionAction<Object> {
    protected StorageRandomAccessFile fileData;
    protected boolean needsSync;
    private int actionCode;
    private static final int GET_FILE_NAME_ACTION = 1;
    private static final int CREATE_CONTAINER_ACTION = 2;
    private static final int REMOVE_FILE_ACTION = 3;
    private static final int OPEN_CONTAINER_ACTION = 4;
    private static final int STUBBIFY_ACTION = 5;
    private static final int GET_RANDOM_ACCESS_FILE_ACTION = 7;
    private static final int REOPEN_CONTAINER_ACTION = 8;
    private ContainerKey actionIdentity;
    private boolean actionStub;
    private boolean actionErrorOK;
    private boolean actionTryAlternatePath;
    private StorageFile actionFile;
    private LogInstant actionInstant;
    private boolean inBackup = false;
    private boolean inRemove = false;
    private String fileName;

    RAFContainer(BaseDataFileFactory factory) {
        super(factory);
    }

    @Override
    public synchronized boolean isDirty() {
        return super.isDirty() || this.needsSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeContainer(LogInstant instant, boolean leaveStub) throws StandardException {
        RAFContainer rAFContainer;
        try {
            rAFContainer = this;
            synchronized (rAFContainer) {
                this.inRemove = true;
                while (this.inBackup) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        InterruptStatus.setInterrupted();
                    }
                }
            }
            this.pageCache.discard(this.identity);
            this.stubbify(instant);
        }
        finally {
            rAFContainer = this;
            synchronized (rAFContainer) {
                this.inRemove = false;
                this.notifyAll();
            }
        }
    }

    @Override
    void closeContainer() {
        if (this.fileData != null) {
            try {
                this.fileData.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.fileData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readPage(long pageNumber, byte[] pageData) throws IOException, StandardException {
        SanityManager.ASSERT(!this.getCommittedDropState());
        long pageOffset = pageNumber * (long)this.pageSize;
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            this.fileData.seek(pageOffset);
            this.fileData.readFully(pageData, 0, this.pageSize);
        }
        if (this.dataFactory.databaseEncrypted() && pageNumber != 0L) {
            this.decryptPage(pageData, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void writePage(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            if (this.getCommittedDropState()) {
                return;
            }
            long pageOffset = pageNumber * (long)this.pageSize;
            byte[] encryptionBuf = null;
            if (this.dataFactory.databaseEncrypted() && pageNumber != 0L) {
                encryptionBuf = this.getEncryptionBuffer();
            }
            byte[] dataToWrite = this.updatePageArray(pageNumber, pageData, encryptionBuf, false);
            try {
                this.fileData.seek(pageOffset);
                if (this.fileData.getFilePointer() != pageOffset) {
                    this.padFile(this.fileData, pageOffset);
                }
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(dataToWrite, 0, this.pageSize);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            }
            catch (IOException ioe) {
                if (!this.padFile(this.fileData, pageOffset)) {
                    throw ioe;
                }
                SanityManager.ASSERT(this.fileData.length() >= pageOffset, "failed to blank filled missing pages");
                this.fileData.seek(pageOffset);
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(dataToWrite, 0, this.pageSize);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            }
            if (syncPage) {
                this.dataFactory.writeInProgress();
                try {
                    if (this.dataFactory.dataNotSyncedAtAllocation) return;
                    this.fileData.sync();
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            } else {
                this.needsSync = true;
            }
            return;
        }
    }

    protected byte[] updatePageArray(long pageNumber, byte[] pageData, byte[] encryptionBuf, boolean encryptWithNewEngine) throws StandardException, IOException {
        if (pageNumber == 0L) {
            this.writeHeader(this.getIdentity(), pageData);
            if (FormatIdUtil.readFormatIdInteger(pageData) != 118) {
                SanityManager.THROWASSERT("expect 118got " + FormatIdUtil.readFormatIdInteger(pageData));
            }
            return pageData;
        }
        if (encryptionBuf != null && (this.dataFactory.databaseEncrypted() || encryptWithNewEngine)) {
            return this.encryptPage(pageData, this.pageSize, encryptionBuf, encryptWithNewEngine);
        }
        return pageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean padFile(StorageRandomAccessFile file, long pageOffset) throws IOException, StandardException {
        long currentEOF = file.length();
        if (currentEOF >= pageOffset) {
            return false;
        }
        byte[] zero = new byte[this.pageSize];
        file.seek(currentEOF);
        while (currentEOF < pageOffset) {
            this.dataFactory.writeInProgress();
            try {
                long len = pageOffset - currentEOF;
                if (len > (long)this.pageSize) {
                    len = this.pageSize;
                }
                file.write(zero, 0, (int)len);
            }
            finally {
                this.dataFactory.writeFinished();
            }
            currentEOF += (long)this.pageSize;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean(boolean forRemove) throws StandardException {
        boolean waited = false;
        boolean success = false;
        int maxTries = 120;
        while (!success) {
            success = true;
            RAFContainer rAFContainer = this;
            synchronized (rAFContainer) {
                if (this.getCommittedDropState()) {
                    this.clearDirty();
                    return;
                }
                while (this.preDirty) {
                    waited = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        InterruptStatus.setInterrupted();
                    }
                }
                if (waited && this.getCommittedDropState()) {
                    this.clearDirty();
                    return;
                }
                if (!forRemove && this.isDirty()) {
                    try {
                        this.writeRAFHeader(this.getIdentity(), this.fileData, false, true);
                        this.clearDirty();
                    }
                    catch (InterruptDetectedException e) {
                        if (--maxTries > 0) {
                            success = false;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ee) {
                                InterruptStatus.setInterrupted();
                            }
                            continue;
                        }
                        throw StandardException.newException("XSDG9.D", e, new Object[0]);
                    }
                    catch (IOException ioe) {
                        throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", ioe, this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "clean", this.fileName));
                    }
                }
            }
        }
    }

    private void clearDirty() {
        this.isDirty = false;
        this.needsSync = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int preAllocate(long lastPreallocPagenum, int preAllocSize) {
        int n = this.doPreAllocatePages(lastPreallocPagenum, preAllocSize);
        if (n > 0) {
            RAFContainer rAFContainer = this;
            synchronized (rAFContainer) {
                boolean inwrite = false;
                try {
                    this.dataFactory.writeInProgress();
                    inwrite = true;
                    if (!this.dataFactory.dataNotSyncedAtAllocation) {
                        this.fileData.sync();
                    }
                }
                catch (IOException ioe) {
                    n = 0;
                }
                catch (StandardException se) {
                    n = 0;
                }
                finally {
                    if (inwrite) {
                        this.dataFactory.writeFinished();
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void truncatePages(long lastValidPagenum) throws StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            boolean inwrite = false;
            try {
                this.dataFactory.writeInProgress();
                inwrite = true;
                this.fileData.setLength((lastValidPagenum + 1L) * (long)this.pageSize);
            }
            catch (IOException ioe) {
            }
            catch (StandardException se) {
            }
            finally {
                if (inwrite) {
                    this.dataFactory.writeFinished();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRAFHeader(Object identity, StorageRandomAccessFile file, boolean create, boolean syncFile) throws IOException, StandardException {
        byte[] epage = create ? new byte[this.pageSize] : this.getEmbryonicPage(file, 0L);
        this.writeHeader(identity, file, create, epage);
        if (syncFile) {
            this.dataFactory.writeInProgress();
            try {
                if (!this.dataFactory.dataNotSyncedAtCheckpoint) {
                    file.sync();
                }
            }
            finally {
                this.dataFactory.writeFinished();
            }
        }
    }

    @Override
    protected void flushAll() throws StandardException {
        this.pageCache.clean(this.identity);
        this.clean(false);
    }

    synchronized StorageFile getFileName(ContainerKey identity, boolean stub, boolean errorOK, boolean tryAlternatePath) throws StandardException {
        this.actionCode = 1;
        this.actionIdentity = identity;
        this.actionStub = stub;
        this.actionErrorOK = errorOK;
        this.actionTryAlternatePath = tryAlternatePath;
        try {
            StorageFile storageFile = (StorageFile)AccessController.doPrivileged(this);
            return storageFile;
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionIdentity = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageFile privGetFileName(ContainerKey identity, boolean stub, boolean errorOK, boolean tryAlternatePath) throws StandardException {
        StorageFile directory;
        StorageFile container = this.dataFactory.getContainerPath(identity, stub);
        if (!container.exists() && tryAlternatePath) {
            container = this.dataFactory.getAlternateContainerPath(identity, stub);
        }
        if (!container.exists() && !(directory = container.getParentDir()).exists()) {
            BaseDataFileFactory baseDataFileFactory = this.dataFactory;
            synchronized (baseDataFileFactory) {
                if (!directory.exists()) {
                    if (!directory.mkdirs()) {
                        if (errorOK) {
                            return null;
                        }
                        throw StandardException.newException("XSDF3.S", directory);
                    }
                    try {
                        directory.limitAccessToOwner();
                    }
                    catch (IOException ioe) {
                        if (errorOK) {
                            return null;
                        }
                        throw StandardException.newException("XSDF3.S", ioe, directory);
                    }
                }
            }
        }
        return container;
    }

    @Override
    synchronized void createContainer(ContainerKey newIdentity) throws StandardException {
        if (this.spareSpace < 0 || this.spareSpace > 100) {
            SanityManager.THROWASSERT("invalid spare space " + this.spareSpace);
        }
        this.actionCode = 2;
        this.actionIdentity = newIdentity;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionIdentity = null;
        }
    }

    private void copyFile(final StorageFile from, final File to) throws StandardException {
        Boolean success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ReuseFactory.getBoolean(FileUtil.copyFile(RAFContainer.this.dataFactory.getStorageFactory(), from, to));
            }
        });
        if (!success.booleanValue()) {
            throw StandardException.newException("XSRS5.S", from, to);
        }
    }

    private void removeFile(final File file) throws StandardException {
        Boolean success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ReuseFactory.getBoolean(!file.exists() || file.delete());
            }
        });
        if (!success.booleanValue()) {
            throw StandardException.newException("XBM0R.D", file);
        }
    }

    synchronized boolean removeFile(StorageFile file) throws SecurityException, StandardException {
        this.actionCode = 3;
        this.actionFile = file;
        try {
            boolean bl = AccessController.doPrivileged(this) != null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionFile = null;
        }
    }

    private boolean privRemoveFile(StorageFile file) throws StandardException {
        this.closeContainer();
        this.dataFactory.writeInProgress();
        try {
            if (file.exists()) {
                boolean bl = file.delete();
                return bl;
            }
        }
        finally {
            this.dataFactory.writeFinished();
        }
        return true;
    }

    @Override
    synchronized boolean openContainer(ContainerKey newIdentity) throws StandardException {
        this.actionCode = 4;
        this.actionIdentity = newIdentity;
        try {
            boolean bl = AccessController.doPrivileged(this) != null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            this.closeContainer();
            throw (StandardException)pae.getException();
        }
        catch (RuntimeException e) {
            this.closeContainer();
            throw e;
        }
        finally {
            this.actionIdentity = null;
        }
    }

    protected synchronized void reopenContainer(ContainerKey currentIdentity) throws StandardException {
        this.actionCode = 8;
        this.actionIdentity = currentIdentity;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            this.closeContainer();
            throw (StandardException)pae.getException();
        }
        catch (RuntimeException e) {
            this.closeContainer();
            throw e;
        }
        finally {
            this.actionIdentity = null;
        }
    }

    private synchronized void stubbify(LogInstant instant) throws StandardException {
        this.setDroppedState(true);
        this.setCommittedDropState(true);
        this.actionIdentity = (ContainerKey)this.getIdentity();
        this.actionInstant = instant;
        this.actionCode = 5;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionIdentity = null;
            this.actionInstant = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void backupContainer(BaseContainerHandle handle, String backupLocation) throws StandardException {
        backupCompleted = false;
        backupFile = null;
        backupRaf = null;
        isStub = false;
        page = null;
        while (!backupCompleted) {
            block43: {
                block44: {
                    var8_8 = this;
                    synchronized (var8_8) {
                        while (this.inRemove) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                InterruptStatus.setInterrupted();
                            }
                        }
                        if (this.getCommittedDropState()) {
                            isStub = true;
                        }
                        this.inBackup = true;
                    }
                    if (!isStub) break block44;
                    file = this.getFileName((ContainerKey)this.getIdentity(), true, false, true);
                    backupFile = new File(backupLocation, file.getName());
                    this.copyFile(file, backupFile);
                    ** GOTO lbl75
                }
                lastPageNumber = this.getLastPageNumber(handle);
                if (lastPageNumber != -1L) break block43;
                var10_14 = this;
                synchronized (var10_14) {
                    this.inBackup = false;
                    this.notifyAll();
                }
                if (page != null) {
                    page.unlatch();
                    page = null;
                }
                if (!backupCompleted && backupFile != null) {
                    if (backupRaf != null) {
                        try {
                            backupRaf.close();
                            backupRaf = null;
                        }
                        catch (IOException ioe) {
                            throw StandardException.newException("XSDFH.S", ioe, new Object[]{backupFile});
                        }
                    }
                    this.removeFile(backupFile);
                }
                return;
            }
            try {
                file = this.getFileName((ContainerKey)this.getIdentity(), false, false, true);
                backupFile = new File(backupLocation, file.getName());
                backupRaf = this.getRandomAccessFile(backupFile);
                encryptionBuf = null;
                if (this.dataFactory.databaseEncrypted()) {
                    encryptionBuf = new byte[this.pageSize];
                }
                for (pageNumber = 0L; pageNumber <= lastPageNumber; ++pageNumber) {
                    page = this.getLatchedPage(handle, pageNumber);
                    dataToWrite = this.updatePageArray(pageNumber, page.getPageArray(), encryptionBuf, false);
                    backupRaf.write(dataToWrite, 0, this.pageSize);
                    page.unlatch();
                    page = null;
                    var15_21 = this;
                    synchronized (var15_21) {
                        if (this.inRemove) {
                            break;
                        }
                        continue;
                    }
                }
lbl75:
                // 3 sources

                if (!isStub) {
                    backupRaf.getFD().sync();
                    backupRaf.close();
                    backupRaf = null;
                }
                backupCompleted = true;
                lastPageNumber = this;
            }
            catch (IOException ioe) {
                try {
                    throw StandardException.newException("XSDFH.S", ioe, new Object[]{backupFile});
                }
                catch (Throwable var18_24) {
                    var19_25 = this;
                    synchronized (var19_25) {
                        this.inBackup = false;
                        this.notifyAll();
                    }
                    if (page != null) {
                        page.unlatch();
                        page = null;
                    }
                    if (!backupCompleted && backupFile != null) {
                        if (backupRaf != null) {
                            try {
                                backupRaf.close();
                                backupRaf = null;
                            }
                            catch (IOException ioe) {
                                throw StandardException.newException("XSDFH.S", ioe, new Object[]{backupFile});
                            }
                        }
                        this.removeFile(backupFile);
                    }
                    throw var18_24;
                }
            }
            synchronized (lastPageNumber) {
                this.inBackup = false;
                this.notifyAll();
            }
            if (page != null) {
                page.unlatch();
                page = null;
            }
            if (backupCompleted || backupFile == null) continue;
            if (backupRaf != null) {
                try {
                    backupRaf.close();
                    backupRaf = null;
                }
                catch (IOException ioe) {
                    throw StandardException.newException("XSDFH.S", ioe, new Object[]{backupFile});
                }
            }
            this.removeFile(backupFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void encryptOrDecryptContainer(BaseContainerHandle handle, String newFilePath, boolean doEncrypt) throws StandardException {
        BasePage page = null;
        StorageFile newFile = this.dataFactory.getStorageFactory().newStorageFile(newFilePath);
        StorageRandomAccessFile newRaf = null;
        try {
            long lastPageNumber = this.getLastPageNumber(handle);
            newRaf = this.getRandomAccessFile(newFile);
            byte[] encryptionBuf = null;
            if (doEncrypt) {
                encryptionBuf = new byte[this.pageSize];
            }
            for (long pageNumber = 0L; pageNumber <= lastPageNumber; ++pageNumber) {
                page = this.getLatchedPage(handle, pageNumber);
                byte[] dataToWrite = this.updatePageArray(pageNumber, page.getPageArray(), encryptionBuf, true);
                newRaf.write(dataToWrite, 0, this.pageSize);
                page.unlatch();
                page = null;
            }
            newRaf.sync();
            newRaf.close();
            newRaf = null;
            if (page != null) {
                page.unlatch();
                page = null;
            }
            if (newRaf == null) return;
        }
        catch (IOException ioe) {
            try {
                throw StandardException.newException("XSDG3.D", ioe, this.getIdentity() != null ? this.getIdentity().toString() : "unknown", doEncrypt ? "encrypt" : "decrypt", newFilePath);
            }
            catch (Throwable throwable) {
                if (page != null) {
                    page.unlatch();
                    page = null;
                }
                if (newRaf == null) throw throwable;
                try {
                    newRaf.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    newRaf = null;
                    throw StandardException.newException("XSDG3.D", ioe2, this.getIdentity() != null ? this.getIdentity().toString() : "unknown", doEncrypt ? "encrypt-close" : "decrypt-close", newFilePath);
                }
            }
        }
        try {
            newRaf.close();
            return;
        }
        catch (IOException ioe) {
            newRaf = null;
            throw StandardException.newException("XSDG3.D", ioe, this.getIdentity() != null ? this.getIdentity().toString() : "unknown", doEncrypt ? "encrypt-close" : "decrypt-close", newFilePath);
        }
    }

    private RandomAccessFile getRandomAccessFile(final File file) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<RandomAccessFile>(){

                @Override
                public RandomAccessFile run() throws IOException {
                    boolean preExisting = file.exists();
                    RandomAccessFile raf = new RandomAccessFile(file, "rw");
                    if (!preExisting) {
                        FileUtil.limitAccessToOwner(file);
                    }
                    return raf;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    synchronized StorageRandomAccessFile getRandomAccessFile(StorageFile file) throws SecurityException, StandardException {
        this.actionCode = 7;
        this.actionFile = file;
        try {
            StorageRandomAccessFile storageRandomAccessFile = (StorageRandomAccessFile)AccessController.doPrivileged(this);
            return storageRandomAccessFile;
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run() throws StandardException {
        switch (this.actionCode) {
            case 1: {
                return this.privGetFileName(this.actionIdentity, this.actionStub, this.actionErrorOK, this.actionTryAlternatePath);
            }
            case 2: {
                StorageFile file = this.privGetFileName(this.actionIdentity, false, false, false);
                try {
                    if (file.exists()) {
                        throw StandardException.newException("XSDF0.S", file);
                    }
                }
                catch (SecurityException se) {
                    throw StandardException.newException("XSDF1.S", se, file);
                }
                try {
                    this.dataFactory.writeInProgress();
                    try {
                        this.fileData = file.getRandomAccessFile("rw");
                        file.limitAccessToOwner();
                    }
                    finally {
                        this.dataFactory.writeFinished();
                    }
                    this.canUpdate = true;
                    this.writeRAFHeader(this.actionIdentity, this.fileData, true, this.actionIdentity.getSegmentId() != -1L);
                }
                catch (IOException ioe) {
                    boolean fileDeleted;
                    this.canUpdate = false;
                    try {
                        fileDeleted = this.privRemoveFile(file);
                    }
                    catch (SecurityException se) {
                        throw StandardException.newException("XSDF2.S", ioe, file, se.toString());
                    }
                    if (!fileDeleted) {
                        throw StandardException.newException("XSDF2.S", ioe, file, ioe.toString());
                    }
                    throw StandardException.newException("XSDF1.S", ioe, file);
                }
                return null;
            }
            case 3: {
                return this.privRemoveFile(this.actionFile) ? this : null;
            }
            case 4: {
                boolean isStub = false;
                StorageFile file2 = this.privGetFileName(this.actionIdentity, false, true, true);
                if (file2 == null) {
                    return null;
                }
                try {
                    if (!file2.exists()) {
                        file2 = this.privGetFileName(this.actionIdentity, true, true, true);
                        if (!file2.exists()) {
                            return null;
                        }
                        isStub = true;
                    }
                }
                catch (SecurityException se) {
                    throw StandardException.newException("XSDA4.S", se, new Object[0]);
                }
                this.canUpdate = false;
                try {
                    if (!this.dataFactory.isReadOnly() && file2.canWrite()) {
                        this.canUpdate = true;
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                this.fileName = file2.toString();
                try {
                    this.fileData = file2.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                    this.readHeader(this.getEmbryonicPage(this.fileData, 0L));
                    if (isStub) {
                        SanityManager.ASSERT(this.getDroppedState() && this.getCommittedDropState(), "a stub failed to set drop state");
                    }
                }
                catch (IOException ioe) {
                    if (isStub) {
                        throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", ioe, this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "read", this.fileName));
                    }
                    StorageFile stub = this.privGetFileName(this.actionIdentity, true, true, true);
                    if (stub.exists()) {
                        try {
                            boolean delete_status = this.privRemoveFile(file2);
                            if (!delete_status) {
                                SanityManager.THROWASSERT("delete of file (" + file2 + ") failed.");
                            }
                            this.fileData = stub.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                            this.readHeader(this.getEmbryonicPage(this.fileData, 0L));
                        }
                        catch (IOException ioe2) {
                            throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", ioe2, this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "delete-stub", this.fileName));
                        }
                    }
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", ioe, this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "read", this.fileName));
                }
                return this;
            }
            case 8: {
                StorageFile file = this.privGetFileName(this.actionIdentity, false, true, true);
                RAFContainer file2 = this;
                synchronized (file2) {
                    try {
                        this.fileData = file.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                    }
                    catch (FileNotFoundException ioe) {
                        throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", ioe, this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "read", this.fileName));
                    }
                }
                return this;
            }
            case 5: {
                StorageFile file = this.privGetFileName(this.actionIdentity, false, false, true);
                StorageFile stub = this.privGetFileName(this.actionIdentity, true, false, false);
                StorageRandomAccessFile stubData = null;
                try {
                    if (!stub.exists()) {
                        stubData = stub.getRandomAccessFile("rw");
                        stub.limitAccessToOwner();
                        this.writeRAFHeader(this.actionIdentity, stubData, true, true);
                        stubData.close();
                        stubData = null;
                    }
                    this.dataFactory.flush(this.actionInstant);
                    this.privRemoveFile(file);
                }
                catch (SecurityException se) {
                    throw StandardException.newException("XSDF4.S", se, file, se.toString());
                }
                catch (IOException ioe) {
                    try {
                        if (stubData != null) {
                            stubData.close();
                            stub.delete();
                            stubData = null;
                        }
                        if (this.fileData != null) {
                            this.fileData.close();
                            this.fileData = null;
                        }
                    }
                    catch (IOException ioe2) {
                        throw StandardException.newException("XSDF4.S", ioe2, file, ioe.toString());
                    }
                    catch (SecurityException se) {
                        throw StandardException.newException("XSDF4.S", se, file, se.toString());
                    }
                }
                this.dataFactory.stubFileToRemoveAfterCheckPoint(stub, this.actionInstant, this.getIdentity());
                return null;
            }
            case 7: {
                try {
                    boolean exists = this.actionFile.exists();
                    StorageRandomAccessFile result = this.actionFile.getRandomAccessFile("rw");
                    if (!exists) {
                        this.actionFile.limitAccessToOwner();
                    }
                    return result;
                }
                catch (IOException ioe) {
                    throw StandardException.newException("XSDF1.S", ioe, this.actionFile.getPath());
                }
            }
        }
        return null;
    }
}

