/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.AutoloadedDriver;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.derby.jdbc.EmbeddedDataSourceInterface;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.EmbeddedXADataSourceInterface;
import org.apache.derby.jdbc.InternalDriver;

public class BasicEmbeddedDataSource40
implements DataSource,
Serializable,
EmbeddedDataSourceInterface {
    private static final long serialVersionUID = -4945135214995641182L;
    protected String description;
    protected String dataSourceName;
    protected String databaseName;
    protected String connectionAttributes;
    protected String createDatabase;
    protected String shutdownDatabase;
    protected boolean attributesAsPassword;
    private String shortDatabaseName;
    private String password;
    private String user;
    protected int loginTimeout;
    private transient PrintWriter printer;
    protected transient String jdbcurl;
    protected transient InternalDriver driver;

    public BasicEmbeddedDataSource40() {
        this.update();
    }

    @Override
    public synchronized void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        if (databaseName != null && databaseName.contains(";")) {
            String[] dbShort = databaseName.split(";");
            this.shortDatabaseName = dbShort[0];
        } else {
            this.shortDatabaseName = databaseName;
        }
        this.update();
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    private String getShortDatabaseName() {
        return this.shortDatabaseName;
    }

    @Override
    public void setDataSourceName(String dsn) {
        this.dataSourceName = dsn;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printer = out;
    }

    protected void update() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("jdbc:derby:");
        String dbName = this.getDatabaseName();
        if (dbName != null) {
            dbName = dbName.trim();
        }
        if (dbName == null || dbName.length() == 0) {
            dbName = " ";
        }
        sb.append(dbName);
        String connAttrs = this.getConnectionAttributes();
        if (connAttrs != null && (connAttrs = connAttrs.trim()).length() != 0) {
            sb.append(';');
            sb.append(this.connectionAttributes);
        }
        this.jdbcurl = sb.toString();
    }

    @Override
    public void setCreateDatabase(String create) {
        this.createDatabase = create != null && create.toLowerCase(Locale.ENGLISH).equals("create") ? create : null;
    }

    @Override
    public String getCreateDatabase() {
        return this.createDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalDriver findDriver() throws SQLException {
        String url = this.jdbcurl;
        BasicEmbeddedDataSource40 basicEmbeddedDataSource40 = this;
        synchronized (basicEmbeddedDataSource40) {
            if (this.driver == null || !this.driver.acceptsURL(url)) {
                new EmbeddedDriver();
                Driver registerDriver = DriverManager.getDriver(url);
                this.driver = registerDriver instanceof AutoloadedDriver ? (InternalDriver)AutoloadedDriver.getDriverModule() : (InternalDriver)registerDriver;
            }
        }
        return this.driver;
    }

    @Override
    public void setConnectionAttributes(String prop) {
        this.connectionAttributes = prop;
        this.update();
    }

    @Override
    public String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    @Override
    public void setShutdownDatabase(String shutdown) {
        this.shutdownDatabase = shutdown != null && shutdown.equalsIgnoreCase("shutdown") ? shutdown : null;
    }

    @Override
    public String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    @Override
    public void setAttributesAsPassword(boolean attributesAsPassword) {
        this.attributesAsPassword = attributesAsPassword;
        this.update();
    }

    @Override
    public boolean getAttributesAsPassword() {
        return this.attributesAsPassword;
    }

    public boolean equals(Object other) {
        if (other instanceof EmbeddedDataSource) {
            EmbeddedDataSource ds = (EmbeddedDataSource)other;
            boolean match = true;
            if (this.databaseName != null) {
                if (!this.databaseName.equals(ds.databaseName)) {
                    match = false;
                }
            } else if (ds.databaseName != null) {
                match = false;
            }
            if (this.dataSourceName != null) {
                if (!this.dataSourceName.equals(ds.dataSourceName)) {
                    match = false;
                }
            } else if (ds.dataSourceName != null) {
                match = false;
            }
            if (this.description != null) {
                if (!this.description.equals(ds.description)) {
                    match = false;
                }
            } else if (ds.description != null) {
                match = false;
            }
            if (this.createDatabase != null) {
                if (!this.createDatabase.equals(ds.createDatabase)) {
                    match = false;
                }
            } else if (ds.createDatabase != null) {
                match = false;
            }
            if (this.shutdownDatabase != null) {
                if (!this.shutdownDatabase.equals(ds.shutdownDatabase)) {
                    match = false;
                }
            } else if (ds.shutdownDatabase != null) {
                match = false;
            }
            if (this.connectionAttributes != null) {
                if (!this.connectionAttributes.equals(ds.connectionAttributes)) {
                    match = false;
                }
            } else if (ds.connectionAttributes != null) {
                match = false;
            }
            if (this.loginTimeout != ds.loginTimeout) {
                match = false;
            }
            return match;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 29 * hash + (this.dataSourceName != null ? this.dataSourceName.hashCode() : 0);
        hash = 29 * hash + (this.databaseName != null ? this.databaseName.hashCode() : 0);
        hash = 29 * hash + (this.connectionAttributes != null ? this.connectionAttributes.hashCode() : 0);
        hash = 29 * hash + (this.createDatabase != null ? this.createDatabase.hashCode() : 0);
        hash = 29 * hash + (this.shutdownDatabase != null ? this.shutdownDatabase.hashCode() : 0);
        hash = 29 * hash + this.loginTimeout;
        return hash;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword(), false);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection(username, password, true);
    }

    final Connection getConnection(String username, String password, boolean requestPassword) throws SQLException {
        Connection conn;
        Properties info = new Properties();
        if (username != null) {
            info.put("user", username);
        }
        if (!(requestPassword && this.attributesAsPassword || password == null)) {
            info.put("password", password);
        }
        if (this.createDatabase != null) {
            info.put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            info.put("shutdown", "true");
        }
        String url = this.jdbcurl;
        if (this.attributesAsPassword && requestPassword && password != null) {
            StringBuilder sb = new StringBuilder(url.length() + password.length() + 1);
            sb.append(url);
            sb.append(';');
            sb.append(password);
            url = sb.toString();
        }
        if ((conn = this.findDriver().connect(url, info, this.loginTimeout)) == null) {
            throw Util.generateCsSQLException("XCY00.S", "databaseName", this.getDatabaseName());
        }
        return conn;
    }

    @Override
    public boolean isWrapperFor(Class<?> interFace) throws SQLException {
        return interFace.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw Util.generateCsSQLException("XJ128.S", iface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ResourceAdapter setupResourceAdapter(EmbeddedXADataSourceInterface ds, ResourceAdapter ra, String user, String password, boolean requestPassword) throws SQLException {
        EmbeddedXADataSourceInterface embeddedXADataSourceInterface = ds;
        synchronized (embeddedXADataSourceInterface) {
            if (ra == null || !ra.isActive()) {
                ra = null;
                String dbName = ((BasicEmbeddedDataSource40)((Object)ds)).getShortDatabaseName();
                if (dbName != null) {
                    Database database = null;
                    if (Monitor.getMonitor() != null) {
                        database = (Database)Monitor.findService("org.apache.derby.database.Database", dbName);
                    }
                    if (database == null) {
                        if (requestPassword) {
                            ds.getConnection(user, password).close();
                        } else {
                            ds.getConnection().close();
                        }
                        database = (Database)Monitor.findService("org.apache.derby.database.Database", dbName);
                    }
                    if (database != null) {
                        ra = (ResourceAdapter)database.getResourceAdapter();
                    }
                }
                if (ra == null) {
                    throw new SQLException(MessageService.getTextMessage("I024", new Object[0]), "08006", 45000);
                }
                InternalDriver driver = ((BasicEmbeddedDataSource40)((Object)ds)).findDriver();
                if (driver == null) {
                    throw new SQLException(MessageService.getTextMessage("I025", new Object[0]), "08006", 45000);
                }
            }
        }
        return ra;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)Util.generateCsSQLException("0A000.S", "getParentLogger");
    }
}

