/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.impl.jdbc.EmbedCallableStatement;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.BasicEmbeddedDataSource40;
import org.apache.derby.shared.common.sanity.SanityManager;

class EmbedPooledConnection
implements PooledConnection,
BrokeredConnectionControl {
    private String connString;
    private ArrayList<ConnectionEventListener> eventListener;
    private final CopyOnWriteArrayList<StatementEventListener> statementEventListeners = new CopyOnWriteArrayList();
    private int eventIterators;
    EmbedConnection realConnection;
    int defaultIsolationLevel;
    private boolean defaultReadOnly;
    BrokeredConnection currentConnectionHandle;
    final BasicEmbeddedDataSource40 dataSource;
    private final String username;
    private final String password;
    private final boolean requestPassword;
    protected boolean isActive;

    public boolean isActive() {
        return this.isActive;
    }

    EmbedPooledConnection(BasicEmbeddedDataSource40 ds, String u, String p, boolean requestPassword) throws SQLException {
        this.dataSource = ds;
        this.username = u;
        this.password = p;
        this.requestPassword = requestPassword;
        this.isActive = true;
        this.openRealConnection();
    }

    String getUsername() {
        if (this.username == null || this.username.equals("")) {
            return "APP";
        }
        return this.username;
    }

    String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkActive();
        if (this.realConnection == null) {
            this.openRealConnection();
        } else {
            this.resetRealConnection();
        }
        this.closeCurrentConnectionHandle();
        Connection c = this.getNewCurrentConnectionHandle();
        return c;
    }

    final void openRealConnection() throws SQLException {
        Connection rc = this.dataSource.getConnection(this.username, this.password, this.requestPassword);
        this.realConnection = (EmbedConnection)rc;
        this.defaultIsolationLevel = rc.getTransactionIsolation();
        this.defaultReadOnly = rc.isReadOnly();
        if (this.currentConnectionHandle != null) {
            this.realConnection.setApplicationConnection(this.currentConnectionHandle);
        }
    }

    final Connection getNewCurrentConnectionHandle() throws SQLException {
        BrokeredConnection applicationConnection = this.currentConnectionHandle = this.realConnection.getLocalDriver().newBrokeredConnection(this);
        this.realConnection.setApplicationConnection(applicationConnection);
        return applicationConnection;
    }

    private void closeCurrentConnectionHandle() throws SQLException {
        if (this.currentConnectionHandle != null) {
            ArrayList<ConnectionEventListener> tmpEventListener = this.eventListener;
            this.eventListener = null;
            try {
                this.currentConnectionHandle.close();
            }
            finally {
                this.eventListener = tmpEventListener;
            }
            this.currentConnectionHandle = null;
        }
    }

    void resetRealConnection() throws SQLException {
        this.realConnection.rollback();
        this.realConnection.clearWarnings();
        if (this.realConnection.getTransactionIsolation() != this.defaultIsolationLevel) {
            this.realConnection.setTransactionIsolation(this.defaultIsolationLevel);
        }
        if (!this.realConnection.getAutoCommit()) {
            this.realConnection.setAutoCommit(true);
        }
        if (this.realConnection.isReadOnly() != this.defaultReadOnly) {
            this.realConnection.setReadOnly(this.defaultReadOnly);
        }
        if (this.realConnection.getHoldability() != 1) {
            this.realConnection.setHoldability(1);
        }
        this.realConnection.resetFromPool();
        SanityManager.ASSERT(this.realConnection.transactionIsIdle(), "real connection should have been idle at this point");
    }

    @Override
    public synchronized void close() throws SQLException {
        if (!this.isActive) {
            return;
        }
        this.closeCurrentConnectionHandle();
        try {
            if (this.realConnection != null && !this.realConnection.isClosed()) {
                this.realConnection.close();
            }
        }
        finally {
            this.realConnection = null;
            this.isActive = false;
            this.eventListener = null;
        }
    }

    @Override
    public final synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this.isActive) {
            return;
        }
        if (listener == null) {
            return;
        }
        if (this.eventListener == null) {
            this.eventListener = new ArrayList();
        } else if (this.eventIterators > 0) {
            this.eventListener = new ArrayList<ConnectionEventListener>(this.eventListener);
        }
        this.eventListener.add(listener);
    }

    @Override
    public final synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null || this.eventListener == null) {
            return;
        }
        if (this.eventIterators > 0) {
            this.eventListener = new ArrayList<ConnectionEventListener>(this.eventListener);
        }
        this.eventListener.remove(listener);
    }

    @Override
    public synchronized EngineConnection getRealConnection() throws SQLException {
        this.checkActive();
        return this.realConnection;
    }

    public synchronized LanguageConnectionContext getLanguageConnection() throws SQLException {
        this.checkActive();
        return this.realConnection.getLanguageConnection();
    }

    public synchronized void notifyError(SQLException exception) {
        if (exception.getErrorCode() < 40000) {
            return;
        }
        this.fireConnectionEventListeners(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEventListeners(SQLException exception) {
        if (this.eventListener != null && !this.eventListener.isEmpty()) {
            ConnectionEvent event = new ConnectionEvent(this, exception);
            ++this.eventIterators;
            try {
                for (ConnectionEventListener l : this.eventListener) {
                    if (exception == null) {
                        l.connectionClosed(event);
                        continue;
                    }
                    l.connectionErrorOccurred(event);
                }
            }
            finally {
                --this.eventIterators;
            }
        }
    }

    final void checkActive() throws SQLException {
        if (!this.isActive) {
            throw Util.noCurrentConnection();
        }
    }

    @Override
    public boolean isIsolationLevelSetUsingSQLorJDBC() throws SQLException {
        if (this.realConnection != null) {
            return this.realConnection.getLanguageConnection().isIsolationLevelSetUsingSQLorJDBC();
        }
        return false;
    }

    @Override
    public void resetIsolationLevelFlag() throws SQLException {
        this.realConnection.getLanguageConnection().resetIsolationLevelFlagUsedForSQLandJDBC();
    }

    @Override
    public boolean isInGlobalTransaction() {
        return false;
    }

    @Override
    public void notifyException(SQLException sqle) {
        this.notifyError(sqle);
    }

    @Override
    public void checkAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public int checkHoldCursors(int holdability, boolean downgrade) throws SQLException {
        return holdability;
    }

    @Override
    public void checkSavepoint() throws SQLException {
    }

    @Override
    public void checkRollback() throws SQLException {
    }

    @Override
    public void checkCommit() throws SQLException {
    }

    @Override
    public void checkClose() throws SQLException {
        if (this.realConnection != null) {
            this.realConnection.checkForTransactionInProgress();
        }
    }

    @Override
    public synchronized boolean closingConnection() throws SQLException {
        this.currentConnectionHandle = null;
        this.fireConnectionEventListeners(null);
        return false;
    }

    @Override
    public Statement wrapStatement(Statement s) throws SQLException {
        return s;
    }

    @Override
    public PreparedStatement wrapStatement(PreparedStatement ps, String sql, Object generatedKeys) throws SQLException {
        EmbedPreparedStatement ps_ = (EmbedPreparedStatement)ps;
        ps_.setBrokeredConnectionControl(this);
        return ps_;
    }

    @Override
    public CallableStatement wrapStatement(CallableStatement cs, String sql) throws SQLException {
        EmbedCallableStatement cs_ = (EmbedCallableStatement)cs;
        cs_.setBrokeredConnectionControl(this);
        return cs_;
    }

    public String toString() {
        if (this.connString == null) {
            String physicalConnString = this.isActive ? this.realConnection.toString() : "<none>";
            this.connString = this.getClass().getName() + "@" + this.hashCode() + " " + "Physical Connection = " + physicalConnString;
        }
        return this.connString;
    }

    @Override
    public void onStatementClose(PreparedStatement statement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement);
            for (StatementEventListener l : this.statementEventListeners) {
                l.statementClosed(event);
            }
        }
    }

    @Override
    public void onStatementErrorOccurred(PreparedStatement statement, SQLException sqle) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement, sqle);
            for (StatementEventListener l : this.statementEventListeners) {
                l.statementErrorOccurred(event);
            }
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (listener != null) {
            this.statementEventListeners.remove(listener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (this.isActive && listener != null) {
            this.statementEventListeners.add(listener);
        }
    }
}

