/*******************************************************************************
 * Copyright (c) 2019, 2020 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.wsat.fat;

import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

import componenttest.custom.junit.runner.AlwaysPassesTest;
import componenttest.rules.repeater.FeatureReplacementAction;
import componenttest.rules.repeater.RepeatTests;

@RunWith(Suite.class)
@SuiteClasses({
	AlwaysPassesTest.class,
	AssertionTest.class,
	DBTest.class,
	DBOptionalTest.class,
	DBOptionalTestDisabled.class,
	DBServiceTest.class,
	DBServiceTestDisabled.class,
	DBServiceOptionalTestDisabled.class,
	DBServiceOptionalTest.class,
	DBTestDisabled.class,
	DBWithoutAssertionTest.class,
	EJBCDITest.class,
	MultiServerTest.class,
	SSLTest.class,
	
	/**
	 * tWAS migration FAT
	 */
	SimpleTest.class,
	ComplexTest.class,
	SleepTest.class,
	LPSTest.class,
	LPSDisabledTest.class,
	MultiThreadedTest.class
})
public class FATSuite {

    @ClassRule
    public static RepeatTests r = RepeatTests.withoutModification()
                    .andWith(FeatureReplacementAction.EE8_FEATURES().fullFATOnly());
}
