/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import com.ibm.ws.kernel.boot.cmdline.LaunchManifest;
import com.ibm.ws.kernel.boot.cmdline.PackageDelegateClassLoader;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class UtilityMain {
    private static final String DEFAULT_BUNDLE_VERSION = "0.0.0";

    public static void main(String[] args) {
        try {
            UtilityMain.internal_main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(32);
        }
    }

    public static void internal_main(String[] args) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String jarName = System.getProperty("java.class.path");
        JarFile jarFile = new JarFile(new File(jarName));
        Attributes a = jarFile.getManifest().getMainAttributes();
        jarFile.close();
        String commandClass = a.getValue("Command-Class");
        String requiredBundles = a.getValue("Require-Bundle");
        String parentCL = a.getValue("Parent-ClassLoader");
        String parentLastPackages = a.getValue("Parent-Last-Package");
        String requireCompiler = a.getValue("Require-Compiler");
        boolean bootstrapCLParent = false;
        boolean compilerTools = false;
        if ("bootstrap".equals(parentCL)) {
            bootstrapCLParent = true;
        }
        if ("true".equals(requireCompiler)) {
            compilerTools = true;
        }
        List rbs = LaunchManifest.parseRequireBundle((String)requiredBundles);
        BundleRepositoryRegistry.initializeDefaults(null, false);
        ContentBasedLocalBundleRepository repo = BundleRepositoryRegistry.getInstallBundleRepository();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (LaunchManifest.RequiredBundle rb : rbs) {
            String bundleVersion = rb.getAttribute("version");
            bundleVersion = bundleVersion != null ? bundleVersion : DEFAULT_BUNDLE_VERSION;
            File f = repo.selectBundle(rb.getAttribute("location"), rb.getSymbolicName(), VersionUtility.stringToVersionRange(bundleVersion));
            if (f == null) continue;
            urls.add(f.toURI().toURL());
        }
        if (compilerTools) {
            File toolsFile = Utils.getJavaTools();
            if (toolsFile != null) {
                urls.add(toolsFile.toURI().toURL());
            } else if (!Utils.hasToolsByDefault()) {
                UtilityMain.error("error.sdkRequired", System.getProperty("java.home"));
                System.exit(30);
                return;
            }
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextLoader = currentThread.getContextClassLoader();
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        List parentLastPackageList = LaunchManifest.parseHeaderList((String)parentLastPackages);
        ClassLoader parentLoader = bootstrapCLParent ? null : UtilityMain.class.getClassLoader();
        PackageDelegateClassLoader cl = new PackageDelegateClassLoader(urlArray, parentLoader, parentLastPackageList);
        currentThread.setContextClassLoader((ClassLoader)cl);
        try {
            Class<?> clazz = cl.loadClass(commandClass);
            Method m = clazz.getMethod("main", args.getClass());
            m.invoke(null, new Object[]{args});
        }
        finally {
            currentThread.setContextClassLoader(originalContextLoader);
        }
    }

    private static String format(String key, Object ... args) {
        String string = Utils.getResourceBundleString(key);
        return args == null || args.length == 0 ? string : MessageFormat.format(string, args);
    }

    private static void error(String key, Object ... args) {
        System.err.println(UtilityMain.format(key, args));
    }
}

