#!/bin/bash
#
# Installs a PostgreSQL.
#
# Usage:
#   install-pgsql.sh <dest-dir> <port>
#
# Example:
#   mkdir /usr/local/pgsql
#   ./install-pgsql.sh /usr/local/pgsql
#   cd /usr/local/pgsql
#   ./bin/pg_ctl start -o -i -D `pwd`/data -l postgresql.log
#   ... do stuff ...
#   ./bin/pg_ctl stop -D `pwd`/data
#

PLATFORM=`uname -s`
DEST=${1}
if [ "x${DEST}" = "x" ] ; then
  echo "Usage: $0 <dest-dir> <port>"
  exit 1
fi
PGPORT=${2}
if [ "x${PGPORT}" = "x" ] ; then
  echo "Usage: $0 <dest-dir> <port>"
  exit 1
fi

if [ "x${PLATFORM}" = "xLinux" ] ; then
  PLATFORM=x86-linux
elif [ "x${PLATFORM}" = "xSunOS" ] ; then
  PLATFORM=sparc-solaris
else
  echo "Unsupported platform: ${PLATFORM}"
  exit 1
fi

cd `dirname $0`
cp -R ${PLATFORM}/* ${DEST}
cd ${DEST}
tar xzf pgsql.tar.gz
cp conf/* ./data/
rm -rf conf pgsql.tar.gz
cd ./data
cat postgresql.conf | sed "s/@@@PGPORT@@@/${PGPORT}/g" > pgconf
mv pgconf postgresql.conf

echo "PostgreSQL (port=${PGPORT}) successfully installed to: ${DEST}"
