/*
 * RHQ Management Platform
 * Copyright (C) 2005-2008 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.rhq.enterprise.gui.authentication;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.Constants;
import org.rhq.enterprise.gui.legacy.RetCodeConstants;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferencesCache;
import org.rhq.enterprise.server.util.LookupUtil;

public class LogoutAction extends Action {
    // ---------------------------------------------------- Public Methods

    /**
     * log a user out of the system.
     */
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog(LogoutAction.class.getName());

        ServletContext ctx = getServlet().getServletContext();
        SubjectManagerLocal authBoss = LookupUtil.getSubjectManager();
        Integer sessionId = RequestUtils.getSessionId(request);
        authBoss.logout(sessionId.intValue());

        HttpSession session = request.getSession();

        clearSubjectPreferences(session);

        session.removeAttribute(Constants.USER_PARAM);
        SessionUtils.setWebUser(session, null);
        session.invalidate();

        return mapping.findForward(RetCodeConstants.SUCCESS_URL);
    }

    private void clearSubjectPreferences(HttpSession session) {
        WebUser webUser = SessionUtils.getWebUser(session);
        if (webUser != null) {
            Subject subject = webUser.getSubject();
            if (subject != null) {
                SubjectPreferencesCache.getInstance().clearConfiguration(subject.getId());
            }
        }
    }
}