/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.cts.ejb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.ObjectNotFoundException;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.jboss.test.cts.jms.MsgSender;
import org.jboss.test.cts.keys.AccountPK;

public class CtsBmpBean
implements EntityBean {
    Logger log = Logger.getLogger(this.getClass());
    private static final String TABLE_NAME = "BMP_BEAN_TBL";
    EntityContext ctx = null;
    DataSource ds = null;
    private MsgSender ms = null;
    String accountNumber;
    String personsName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountPK ejbCreate(AccountPK pk, String personsName) throws CreateException, DuplicateKeyException {
        this.log.debug((Object)("entry ejbCreate(\"" + pk.getKey() + "\", " + "\"" + personsName + "\")"));
        this.sendMsg("EJB_CREATE_MSG");
        try {
            Connection con = this.ds.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement("SELECT accountNumber FROM BMP_BEAN_TBL WHERE accountNumber=?");
                try {
                    ps.setString(1, pk.getKey());
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        throw new DuplicateKeyException("Bean with accountNumber=" + pk.getKey() + " already exists.");
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    ps.close();
                    throw throwable;
                }
                ps.close();
                ps = con.prepareStatement("INSERT INTO BMP_BEAN_TBL VALUES (?,?)");
                try {
                    ps.setString(1, pk.getKey());
                    ps.setString(2, personsName);
                    ps.execute();
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    ps.close();
                    throw throwable;
                }
                ps.close();
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            this.log.debug((Object)"failed", (Throwable)e);
            throw new CreateException("Entity bean creation failure: " + e.getMessage());
        }
        this.accountNumber = pk.getKey();
        this.personsName = personsName;
        this.log.debug((Object)("Created \"" + this.accountNumber + "\"."));
        return pk;
    }

    public void ejbPostCreate(AccountPK pk, String personsName) {
        this.log.debug((Object)"ejbPostCreate(AccountPK, String) called");
        this.sendMsg("EJB_POST_CREATE_MSG");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccountPK ejbFindByPrimaryKey(AccountPK pk) throws FinderException {
        this.log.debug((Object)"entry ejbFindByPrimaryKey");
        try {
            AccountPK accountPK;
            Connection con = this.ds.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement("SELECT accountNumber FROM BMP_BEAN_TBL WHERE accountNumber=?");
                try {
                    ps.setString(1, pk.getKey());
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) {
                        throw new ObjectNotFoundException("No bean with accountNumber=" + pk.getKey() + " found.");
                    }
                    accountPK = pk;
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    ps.close();
                    throw throwable;
                }
                ps.close();
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                con.close();
                throw throwable;
            }
            con.close();
            return accountPK;
        }
        catch (SQLException e) {
            this.log.debug((Object)"failed", (Throwable)e);
            throw new FinderException("Could not find: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection ejbFindAll() throws FinderException {
        this.log.debug((Object)"entry ejbFindAll");
        this.ensureTableExists();
        LinkedList<AccountPK> result = new LinkedList<AccountPK>();
        try {
            LinkedList<AccountPK> linkedList;
            Connection con = this.ds.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement("SELECT accountNumber FROM BMP_BEAN_TBL");
                try {
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(new AccountPK(rs.getString(1)));
                    }
                    linkedList = result;
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    ps.close();
                    throw throwable;
                }
                ps.close();
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                con.close();
                throw throwable;
            }
            con.close();
            return linkedList;
        }
        catch (SQLException e) {
            this.log.debug((Object)"failed", (Throwable)e);
            throw new FinderException("Could not find: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection ejbFindByPersonsName(String guysName) throws FinderException {
        this.log.debug((Object)("entry ejbFindByPersonsName(\"" + guysName + "\")."));
        LinkedList<AccountPK> result = new LinkedList<AccountPK>();
        try {
            LinkedList<AccountPK> linkedList;
            Connection con = this.ds.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement("SELECT accountNumber FROM BMP_BEAN_TBL WHERE name=?");
                try {
                    ps.setString(1, guysName);
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(new AccountPK(rs.getString(1)));
                    }
                    linkedList = result;
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    ps.close();
                    throw throwable;
                }
                ps.close();
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                con.close();
                throw throwable;
            }
            con.close();
            return linkedList;
        }
        catch (SQLException e) {
            this.log.debug((Object)"failed", (Throwable)e);
            throw new FinderException("Could not find: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbLoad() {
        this.log.debug((Object)("ejbLoad(\"" + ((AccountPK)this.ctx.getPrimaryKey()).getKey() + "\") called"));
        this.sendMsg("EJB_LOAD_MSG");
        try {
            Connection con = this.ds.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement("SELECT accountNumber,name FROM BMP_BEAN_TBL WHERE accountNumber=?");
                try {
                    AccountPK pk = (AccountPK)this.ctx.getPrimaryKey();
                    ps.setString(1, pk.getKey());
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) {
                        throw new NoSuchEntityException("Instance " + pk.getKey() + " not found in database.");
                    }
                    this.accountNumber = rs.getString(1);
                    this.personsName = rs.getString(2);
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    ps.close();
                    throw throwable;
                }
                ps.close();
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            this.log.debug((Object)"failed", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        this.log.debug((Object)("ejbLoad(\"" + ((AccountPK)this.ctx.getPrimaryKey()).getKey() + "\") returning"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbStore() {
        this.log.debug((Object)("ejbStore(\"" + this.accountNumber + "\") called"));
        this.sendMsg("EJB_STORE_MSG");
        try {
            Connection con = this.ds.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement("UPDATE BMP_BEAN_TBL SET name=? WHERE accountNumber=?");
                try {
                    ps.setString(1, this.personsName);
                    ps.setString(2, this.accountNumber);
                    ps.executeUpdate();
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    ps.close();
                    throw throwable;
                }
                ps.close();
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            this.log.debug((Object)"failed", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        this.log.debug((Object)("ejbStore(\"" + this.accountNumber + "\") returning"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbRemove() {
        this.log.debug((Object)("ejbRemove(\"" + this.accountNumber + "\") called"));
        this.sendMsg("EJB_REMOVE_MSG");
        try {
            Connection con = this.ds.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement("DELETE FROM BMP_BEAN_TBL WHERE accountNumber=?");
                try {
                    ps.setString(1, this.accountNumber);
                    ps.executeUpdate();
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    ps.close();
                    throw throwable;
                }
                ps.close();
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            this.log.debug((Object)"failed", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        this.log.debug((Object)("Removed \"" + this.accountNumber + "\"."));
    }

    public void ejbActivate() {
        this.log.debug((Object)"ejbActivate() called");
        this.sendMsg("EJB_ACTIVATE_MSG");
    }

    public void ejbPassivate() {
        this.log.debug((Object)"ejbPassivate() called");
        this.sendMsg("EJB_PASSIVATE_MSG");
        if (this.ms != null) {
            try {
                this.ms.close();
            }
            catch (JMSException e) {
                this.log.debug((Object)"failed", (Throwable)e);
            }
            this.ms = null;
        }
    }

    public void setEntityContext(EntityContext ctx) {
        this.log.debug((Object)"setEntityContext() called");
        this.sendMsg("SET_ENTITY_CONTEXT_MSG");
        this.ctx = ctx;
        try {
            InitialContext context = new InitialContext();
            this.ds = (DataSource)context.lookup("java:comp/env/datasource");
        }
        catch (NamingException nex) {
            this.log.debug((Object)"failed", (Throwable)nex);
            throw new EJBException("Datasource not found: " + nex.getMessage());
        }
    }

    public void unsetEntityContext() {
        this.log.debug((Object)"unsetEntityContext() called");
        this.sendMsg("UNSET_ENTITY_CONTEXT_MSG");
        this.ctx = null;
        this.ds = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureTableExists() {
        boolean exists = true;
        try {
            Connection con = this.ds.getConnection();
            try {
                Statement s = con.createStatement();
                try {
                    ResultSet rs = s.executeQuery("SELECT * FROM BMP_BEAN_TBL");
                    ResultSetMetaData md = rs.getMetaData();
                    if (md.getColumnCount() != 2) {
                        throw new SQLException("Not two columns");
                    }
                    if (!"ACCOUNTNUMBER".equals(md.getColumnName(1).toUpperCase())) {
                        throw new SQLException("First column name not \"accountNumber\"");
                    }
                    if (!"NAME".equals(md.getColumnName(2).toUpperCase())) {
                        throw new SQLException("Second column name not \"name\"");
                    }
                    if (md.getColumnType(1) != 12) {
                        throw new SQLException("First column type not VARCHAR");
                    }
                    if (md.getColumnType(2) != 12) {
                        throw new SQLException("Second column type not VARCHAR");
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    s.close();
                    throw throwable;
                }
                s.close();
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            exists = false;
        }
        if (!exists) {
            this.initializeDatabaseTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeDatabaseTable() {
        this.log.debug((Object)"Initializing DATABASE tables for BMP test...");
        try {
            Connection con = this.ds.getConnection();
            try {
                Statement s = con.createStatement();
                try {
                    try {
                        s.executeUpdate("DROP TABLE BMP_BEAN_TBL");
                        this.log.debug((Object)"Dropped old table.");
                    }
                    catch (SQLException sQLException) {
                        Object var5_5 = null;
                        s.close();
                    }
                    Object var5_4 = null;
                    s.close();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    s.close();
                    throw throwable;
                }
                s = con.createStatement();
                try {
                    s.executeUpdate("CREATE TABLE BMP_BEAN_TBL (accountNumber VARCHAR(25), name VARCHAR(200))");
                    this.log.debug((Object)"Created new table.");
                    Object var7_9 = null;
                    s.close();
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    s.close();
                    throw throwable;
                }
                Object var9_12 = null;
                con.close();
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                con.close();
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.log.debug((Object)"failed", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        this.log.debug((Object)"Initialized DATABASE tables for BMP test.");
    }

    private void sendMsg(String msg) {
        if (this.ms == null) {
            this.ms = new MsgSender();
        }
        this.ms.sendMsg(msg);
    }

    public void setPersonsName(String personsName) {
        this.personsName = personsName;
    }

    public String getPersonsName() {
        return this.personsName;
    }
}

