package org.rhq.jon.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Replace;

public class ProcessCveListTask extends Task {
    //Define properties to be used
    //##Include CVE details as fixes to current release.
    //  Ex. (JON Repo Root)/patches/cve-list.txt
    private String cvelist = "";
    //##Include destination of expanded JON Server where file change
    //  will happen.
    private String jonserver = "";
    //##Include destination of expanded [JON Root] on file system.
    private String reporoot = "";
    //##Whether to include extrs debug logging while CVE processing.
    private String enabledebug = "";
    //## store off values for each entry of cve list.
    private String oldFilePath = null;//Ex. relative to 'jonserver'
    private String newFile = null;//Ex. http or path relative to 'reporoot' that includes updated content
    private String newFileIdentifier = null; //Ex. resteasy-jaxb-provider-2.3.8.SP1-redhat-1.jar Regex hell. Just require full here.
    private String moduleFile = null; //Ex. most times module.xml

    //Parse properties passed into the ant task

    // The method executing the task
    @Override
    public void execute() throws BuildException {
        boolean debug = false;
        String debugSelection = getEnabledebug();
        if ((debugSelection != null) && (!debugSelection.trim().isEmpty())) {
            debug = Boolean.valueOf(getEnabledebug().trim());
        }

        //Load the cve-list file
        String cveListFile = reporoot + File.separator + getCvelist();
        if (debug) {
            System.out.println("[PROC-CVE-DEBUG] repoRoot [" + reporoot + "]");
            System.out.println("[PROC-CVE-DEBUG] jonserver [" + getJonserver() + "]");
            System.out.println("[PROC-CVE-DEBUG] cveList[" + getCvelist() + "]");
            System.out.println("[PROC-CVE-DEBUG] cveListFile [" + cveListFile + "]");
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(cveListFile));
            //iterate through the file, ignoring comments. Ex. # starts line
            String line = null;
            while (((line = br.readLine()) != null) && (line.trim().length()>0)) {
                //exclude lines that start with '#' as are comment lines.
                if (!line.trim().startsWith("#")) {
                    StringTokenizer arguments = new StringTokenizer(line);
                    //For each line, determine which of supported CVE type passed in.
                    oldFilePath = arguments.nextToken(); //argument 1
                    newFile = arguments.nextToken(); //argument 2
                    newFileIdentifier = arguments.nextToken(); //argument 3
                    if (arguments.hasMoreTokens()) {
                        moduleFile = arguments.nextToken(); //argument 4
                    }
                    if (debug) {
                        System.out.println("\t[PROC-CVE-DEBUG] oldFilePath [" + oldFilePath + "]");
                        System.out.println("\t[PROC-CVE-DEBUG] newFile [" + newFile + "]");
                        System.out.println("\t[PROC-CVE-DEBUG] newFileIdentifier [" + newFileIdentifier + "]");
                        System.out.println("\t[PROC-CVE-DEBUG] moduleFile [" + moduleFile + "]");
                    }
                    //## detect directory structure of old file
                    File oldFileLocation = new File(jonserver + File.separator + oldFilePath);
                    String OLD_FILE_DIR = oldFileLocation.getParent();
                    String OLD_FILE_NAME = oldFileLocation.getName();
                    if (debug) {
                        System.out.println("\t[PROC-CVE-DEBUG] OLD_FILE_DIR [" + OLD_FILE_DIR + "]");
                        System.out.println("\t[PROC-CVE-DEBUG] OLD_FILE_NAME [" + OLD_FILE_NAME + "]");
                        System.out.println("[PROC-CVE-DEBUG] Removing [" + jonserver + File.separator + oldFilePath
                            + "]");
                    }
                    //for each: i)remove old file ii)wget to pull down new file
                    //## Remove old file.
                    Delete clean = new Delete();
                    clean.setFile(new File(jonserver + File.separator + oldFilePath));
                    clean.execute();

                    //## Download OR copy new file.
                    if (newFile.startsWith("http")) {
                        if (debug) {
                            System.out.println("[PROC-CVE-DEBUG] Retrieving [" + newFile + "]");
                        }
                        String dest = OLD_FILE_DIR + File.separator + newFileIdentifier;
                        FileOutputStream fos;
                        InputStream is = null;
                        URL url = null;
                        File localDestination = new File(dest);
                        if (!localDestination.getParentFile().exists()) {//create file hierarchy if it doesn't already exist
                            //creating parent directories.
                            File parent = localDestination.getParentFile();
                            parent.mkdirs();
                            if (debug) {
                                System.out.println("[PROC-CVE-DEBUG] creating parent dirs:[" + parent.getAbsolutePath()
                                    + "].");
                            }
                        }
                        if (!localDestination.exists()) {
                            boolean newlyCreated = localDestination.createNewFile();
                            if (newlyCreated) {
                                if (debug) {
                                    System.out.println("### Created new file....[" + localDestination.getAbsolutePath()
                                        + "].");
                                }
                            }
                        }
                        try {
                            url = new URL(newFile);
                            fos = new FileOutputStream(localDestination);

                            is = url.openStream();
                            byte[] byteChunk = new byte[4096]; // 
                            int n;

                            while ((n = is.read(byteChunk)) > 0) {
                                fos.write(byteChunk, 0, n);
                            }
                            fos.flush();
                            fos.close();
                        } catch (IOException e) {
                            System.err.printf("Failed while reading bytes from %s: %s", url.toExternalForm(),
                                e.getMessage());
                            e.printStackTrace();
                        } finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    } else {
                        if (debug) {
                            System.out
                                .println("[PROC-CVE-DEBUG] Copying [" + reporoot + File.separator + newFile + "]");
                        }
                        Copy copy = new Copy();
                        copy.setFile(new File(reporoot + File.separator + newFile));
                        copy.setTofile(new File(OLD_FILE_DIR + File.separator + moduleFile));
                        copy.execute();
                    }
                    if (moduleFile != null) {
                        if (debug) {
                            System.out.println("[PROC-CVE-DEBUG] Updating [" + OLD_FILE_DIR + File.separator
                                + moduleFile + "]");
                            System.out.println("[PROC-CVE-DEBUG]  ### Updating file in place JAVA.");
                        }
                        Replace update = new Replace();
                        String file = OLD_FILE_DIR + File.separator + moduleFile;
                        String token = OLD_FILE_NAME;
                        String value = newFileIdentifier;
                        update.setFile(new File(file));
                        update.setToken(token);
                        update.setValue(value);
                        update.execute();
                    }
                }
            }
            //close reader
            br.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new BuildException("Unable to locate [" + cveListFile + "]. Correct and re-run.");
        } catch (IOException e) {
            e.printStackTrace();
            throw new BuildException("Unexpected error parsing [" + cveListFile + "]. Correct and re-run.");
        }
    }

    //###############       
    /**
     * @param args
     */
    public static void main(String[] args) {
        //use this method to populate the values like ant will.
        ProcessCveListTask pcl = new ProcessCveListTask();
        // Populate with local values to test.                
        //        pcl.setReporoot("(jon.git root)/jon_BUILD");
        //        pcl.setJonserver("(test location that is JON server dest)");
        //        pcl.setCvelist("patches/cve-list.txt");
        pcl.execute();
    }

    public String getCvelist() {
        return cvelist;
    }

    public void setCvelist(String cvelist) {
        this.cvelist = cvelist;
    }

    public String getJonserver() {
        return jonserver;
    }

    public void setJonserver(String jonserver) {
        this.jonserver = jonserver;
    }

    public String getReporoot() {
        return reporoot;
    }

    public void setReporoot(String reporoot) {
        this.reporoot = reporoot;
    }

    public String getEnabledebug() {
        return enabledebug;
    }

    public void setEnabledebug(String enabledebug) {
        this.enabledebug = enabledebug;
    }
}
