/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.OrganizationConfigManagerImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class OrganizationConfigManager {
    private SSOToken token;
    private String orgName;
    private String orgDN;
    private OrgConfigViaAMSDK amsdk;
    private OrganizationConfigManagerImpl orgConfigImpl;
    static String orgNamingAttrInLegacyMode;
    static Pattern baseDNpattern;
    protected static final String SERVICES_NODE;
    static String specialCharsString;
    private static String SEPERATOR;
    private String CONF_ENABLED = "sun-idrepo-amSDK-config-copyconfig-enabled";
    private boolean copyOrgInitialized;
    private boolean copyOrgEnabled;
    private String amSDKOrgDN;
    public static final String SUNORG_ALIAS = "sunOrganizationAliases";
    private String SUNDNS_ALIAS = "sunDNSAliases";
    private String SUNPREF_DOMAIN = "sunPreferredDomain";
    private String SUNORG_STATUS = "sunOrganizationStatus";
    private static boolean registeredForConfigNotifications;
    private static boolean realmEnabled;
    private static boolean coexistMode;
    private static boolean migratedTo70;

    public OrganizationConfigManager(SSOToken token, String orgName) throws SMSException {
        this.token = token;
        this.orgName = orgName;
        this.validateConfigImpl();
        this.orgDN = this.orgConfigImpl.getOrgDN();
        try {
            if (migratedTo70 && !registeredForConfigNotifications) {
                ServiceConfigManager scmr = new ServiceConfigManager("sunidentityrepositoryservice", token);
                scmr.addListener(new OrganizationConfigManagerListener());
                registeredForConfigNotifications = true;
            }
        }
        catch (SMSException s) {
            String installTime = SystemProperties.get("installTime", "false");
            if (!installTime.equals("true")) {
                SMSEntry.debug.warning("OrganizationConfigManager: constructor. Unable to construct ServiceConfigManager for idRepoService ", (Throwable)s);
            }
            throw s;
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("OrganizationConfigManager:Constructor", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        if (coexistMode) {
            this.amsdk = new OrgConfigViaAMSDK(token, DNMapper.realmNameToAMSDKName(this.orgDN), this.orgDN);
            if (orgNamingAttrInLegacyMode == null) {
                orgNamingAttrInLegacyMode = this.getNamingAttrForOrg();
            }
        }
    }

    public String getOrganizationName() {
        return this.orgName;
    }

    public Set getConfiguredServices() throws SMSException {
        return this.getAssignedServices();
    }

    public Set getServiceSchemas() throws SMSException {
        HashSet<ServiceSchema> serviceSchemaSet = null;
        try {
            Set serviceNames = OrganizationConfigManager.getServiceNames(this.token);
            serviceSchemaSet = new HashSet<ServiceSchema>(serviceNames.size() * 2);
            Iterator names = serviceNames.iterator();
            while (names.hasNext()) {
                ServiceSchemaManager ssm = new ServiceSchemaManager((String)names.next(), this.token);
                ServiceSchema ss = ssm.getOrganizationCreationSchema();
                if (ss == null) continue;
                serviceSchemaSet.add(ss);
            }
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("OrganizationConfigManager:getServiceSchemas unable to get service schema", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), (Throwable)((Object)ssoe), "sms-INVALID_SSO_TOKEN");
        }
        return serviceSchemaSet;
    }

    public OrganizationConfigManager createSubOrganization(String subOrgName, Map attributes) throws SMSException {
        String subOrgDN;
        boolean orgExists;
        block14: {
            this.validateConfigImpl();
            orgExists = false;
            subOrgDN = OrganizationConfigManager.normalizeDN(subOrgName, this.orgDN);
            try {
                new OrganizationConfigManager(this.token, subOrgDN);
                SMSEntry.debug.error("OrganizationConfigManager::createSubOrganization() Realm Already Exists.. " + subOrgDN);
                orgExists = true;
            }
            catch (SMSException smse) {
                if (!SMSEntry.debug.messageEnabled()) break block14;
                SMSEntry.debug.message("OrganizationConfigManager::createSubOrganization() New Realm, creating realm: " + subOrgName + "-" + smse);
            }
        }
        Object[] args = new Object[]{subOrgName};
        if (orgExists) {
            throw new SMSException("amSDK", "sms-organization_already_exists1", args);
        }
        StringTokenizer st = new StringTokenizer(specialCharsString, SEPERATOR);
        while (st.hasMoreTokens()) {
            String obj = st.nextToken();
            if (subOrgName.indexOf(obj) <= -1) continue;
            SMSEntry.debug.error("OrganizationConfigManager::createSubOrganization() : Invalid realm name: " + subOrgName);
            SMSEntry.debug.error("OrganizationConfigManager::createSubOrganization() : Detected invalid chars: " + obj);
            Object[] args1 = new Object[]{subOrgName};
            throw new SMSException("amSDK", SMSEntry.bundle.getString("sms-invalid-org-name"), args1);
        }
        if (coexistMode || realmEnabled && this.isCopyOrgEnabled()) {
            this.amsdk.createSubOrganization(subOrgName);
        }
        if ((realmEnabled || subOrgDN.toLowerCase().startsWith("o=sunamhiddenrealm")) && this.getSubOrganizationNames(subOrgName, false).isEmpty()) {
            CreateServiceConfig.createOrganization(this.token, subOrgDN);
        }
        OrganizationConfigManager ocm = this.getSubOrgConfigManager(subOrgName);
        if (attributes != null && !attributes.isEmpty()) {
            for (String serviceName : attributes.keySet()) {
                Map svcAttributes = (Map)attributes.get(serviceName);
                if (svcAttributes == null || svcAttributes.isEmpty()) continue;
                ocm.setAttributes(serviceName, svcAttributes);
            }
        }
        if (realmEnabled && !coexistMode) {
            OrganizationConfigManager.loadDefaultServices(this.token, ocm);
        }
        if (realmEnabled && this.isCopyOrgEnabled()) {
            this.registerSvcsForOrg(subOrgName, subOrgDN);
            OrganizationConfigManager subOrg = this.getSubOrgConfigManager(subOrgName);
            ServiceConfig s = subOrg.getServiceConfig("sunidentityrepositoryservice");
            if (s != null) {
                try {
                    ServiceConfig subConfig;
                    Iterator items = s.getSubConfigNames().iterator();
                    if (items.hasNext() && (subConfig = s.getSubConfig((String)items.next())).getSchemaID().equalsIgnoreCase("amSDK")) {
                        HashMap amsdkConfig = new HashMap();
                        HashSet<String> vals = new HashSet<String>();
                        vals.add(orgNamingAttrInLegacyMode + "=" + subOrgName + "," + this.amSDKOrgDN);
                        amsdkConfig.put("amSDKOrgName", vals);
                        subConfig.setAttributes(amsdkConfig);
                    }
                }
                catch (SSOException ssoe) {
                    SMSEntry.debug.error("OrganizationConfigManager::createSubOrganization:", (Throwable)((Object)ssoe));
                    throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
                }
            }
        }
        return ocm;
    }

    public Set getSubOrganizationNames() throws SMSException {
        try {
            return this.getSubOrganizationNames("*", false);
        }
        catch (SMSException s) {
            SMSEntry.debug.error("OrganizationConfigManager: getSubOrganizationNames() Unable to get sub organization names ", (Throwable)s);
            throw s;
        }
    }

    public Set getPeerOrganizationNames() throws SMSException {
        Set getPeerSet = Collections.EMPTY_SET;
        if (realmEnabled) {
            try {
                OrganizationConfigManager ocmParent = this.getParentOrgConfigManager();
                getPeerSet = ocmParent.getSubOrganizationNames();
            }
            catch (SMSException s) {
                if (SMSEntry.debug.warningEnabled()) {
                    SMSEntry.debug.warning("OrganizationConfigManager: getPeerOrganizationNames() Unable to get Peer organization names ", (Throwable)s);
                }
                throw s;
            }
        }
        return getPeerSet;
    }

    public Set getSubOrganizationNames(String pattern, boolean recursive) throws SMSException {
        this.validateConfigImpl();
        try {
            if (realmEnabled) {
                return this.orgConfigImpl.getSubOrganizationNames(this.token, pattern, recursive);
            }
            return this.amsdk.getSubOrganizationNames(pattern, recursive);
        }
        catch (SMSException s) {
            SMSEntry.debug.error("OrganizationConfigManager: getSubOrganizationNames(String pattern, boolean recursive) Unable to get sub organization names for filter: " + pattern, (Throwable)s);
            throw s;
        }
    }

    public void deleteSubOrganization(String subOrgName, boolean recursive) throws SMSException {
        this.validateConfigImpl();
        String subOrgDN = OrganizationConfigManager.normalizeDN(subOrgName, this.orgDN);
        if (subOrgDN.equals("/") || subOrgDN.equalsIgnoreCase(SMSEntry.getRootSuffix()) || subOrgDN.equalsIgnoreCase(SERVICES_NODE)) {
            Object[] parms = new Object[]{this.orgName};
            SMSEntry.debug.error("OrganizationConfigManager: deleteSubOrganization(Root realm " + this.orgName + " cannot be deleted. ");
            throw new SMSException("amSDK", "sms-cannot_delete_rootsuffix", parms);
        }
        OrganizationConfigManager subRlmConfigMgr = this.getSubOrgConfigManager(subOrgName);
        Set subRlmSet = subRlmConfigMgr.getSubOrganizationNames("*", true);
        if (realmEnabled) {
            try {
                CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, subOrgDN);
                if (cEntry.isDirty()) {
                    cEntry.refresh();
                }
                SMSEntry entry = cEntry.getClonedSMSEntry();
                if (!recursive && subRlmSet != null && !subRlmSet.isEmpty()) {
                    throw new SMSException(SMSEntry.bundle.getString("sms-entries-exists"), "sms-entries-exists");
                }
                entry.delete(this.token);
                cEntry.refresh(entry);
            }
            catch (SSOException ssoe) {
                SMSEntry.debug.error("OrganizationConfigManager: deleteSubOrganization(String subOrgName, boolean recursive) Unable to delete sub organization ", (Throwable)((Object)ssoe));
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if (coexistMode || realmEnabled && this.isCopyOrgEnabled()) {
            String amsdkName = DNMapper.realmNameToAMSDKName(subOrgDN);
            if (!SMSEntry.getRootSuffix().equalsIgnoreCase(SMSEntry.getAMSdkBaseDN())) {
                String convOrg = subOrgName;
                if (subOrgName.startsWith("/")) {
                    convOrg = DNMapper.convertToDN(subOrgName).toString();
                }
                amsdkName = convOrg + "," + this.amSDKOrgDN;
            }
            this.amsdk.deleteSubOrganization(amsdkName);
        }
    }

    public OrganizationConfigManager getSubOrgConfigManager(String subOrgName) throws SMSException {
        this.validateConfigImpl();
        return new OrganizationConfigManager(this.token, OrganizationConfigManager.normalizeDN(subOrgName, this.orgDN));
    }

    public Map getAttributes(String serviceName) throws SMSException {
        this.validateConfigImpl();
        if (serviceName == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Set> attrValues = null;
        if (migratedTo70) {
            serviceName = serviceName.toLowerCase();
            try {
                SMSEntry entry;
                Map map;
                CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, this.orgDN);
                if (cEntry.isDirty() || coexistMode || realmEnabled && this.isCopyOrgEnabled()) {
                    cEntry.refresh();
                }
                if ((map = SMSUtils.getAttrsFromEntry(entry = cEntry.getSMSEntry())) != null && !map.isEmpty()) {
                    for (String name : map.keySet()) {
                        if (!name.toLowerCase().startsWith(serviceName)) continue;
                        Set values = (Set)map.get(name);
                        String key = name.substring(serviceName.length() + 1);
                        if (attrValues == null) {
                            attrValues = new HashMap();
                        }
                        attrValues.put(key, values);
                    }
                }
            }
            catch (SSOException ssoe) {
                SMSEntry.debug.error("OrganizationConfigManager: getAttributes(String serviceName) Unable to get Attributes", (Throwable)((Object)ssoe));
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if ((coexistMode || realmEnabled && this.isCopyOrgEnabled()) && serviceName.equalsIgnoreCase("sunidentityrepositoryservice")) {
            Map amsdkMap = this.amsdk.getAttributes();
            HashMap<String, Set> mergesdkMap = new HashMap<String, Set>(2);
            if (amsdkMap != null && !amsdkMap.isEmpty()) {
                HashSet mergeValues = new HashSet(2);
                for (String key : amsdkMap.keySet()) {
                    if (!key.equalsIgnoreCase(this.SUNDNS_ALIAS) && !key.equalsIgnoreCase(this.SUNPREF_DOMAIN) && !key.equalsIgnoreCase(SUNORG_ALIAS)) continue;
                    this.buildSet(key, amsdkMap, mergeValues);
                }
                mergesdkMap.put(SUNORG_ALIAS, mergeValues);
                mergesdkMap.put(this.SUNORG_STATUS, (Set)amsdkMap.get(this.SUNORG_STATUS));
            }
            if (attrValues == null) {
                attrValues = mergesdkMap;
            } else {
                attrValues.putAll(mergesdkMap);
            }
        }
        return attrValues == null ? Collections.EMPTY_MAP : attrValues;
    }

    private Set buildSet(String attrName, Map attributes, Set resultSet) {
        Set vals = (Set)attributes.get(attrName);
        if (vals != null && !vals.isEmpty()) {
            resultSet.addAll(vals);
        }
        return resultSet;
    }

    public void addAttributeValues(String serviceName, String attrName, Set values) throws SMSException {
        this.validateConfigImpl();
        if (serviceName == null || attrName == null) {
            return;
        }
        if (migratedTo70) {
            serviceName = serviceName.toLowerCase();
            try {
                CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, this.orgDN);
                if (cEntry.isDirty()) {
                    cEntry.refresh();
                }
                SMSEntry e = cEntry.getClonedSMSEntry();
                ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
                ServiceSchema ss = ssm.getOrganizationCreationSchema();
                if (ss == null) {
                    throw new SMSException(SMSEntry.bundle.getString("sms-SMSSchema_service_notfound"), "sms-SMSSchema_service_notfound");
                }
                HashMap map = new HashMap(2);
                HashSet newValues = new HashSet(values);
                Map allAttributes = ss.getAttributeDefaults();
                Set existingValues = (Set)allAttributes.get(attrName);
                if (existingValues != null && !existingValues.isEmpty()) {
                    newValues.addAll(existingValues);
                }
                map.put(attrName, newValues);
                ss.validateAttributes(map);
                SMSUtils.addAttribute(e, serviceName + "-" + attrName, values, ss.getSearchableAttributeNames());
                e.save(this.token);
                cEntry.refresh(e);
            }
            catch (SSOException ssoe) {
                SMSEntry.debug.error("OrganizationConfigManager: Unable to add Attribute Values", (Throwable)((Object)ssoe));
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if (coexistMode && serviceName.equalsIgnoreCase("sunidentityrepositoryservice")) {
            this.amsdk.addAttributeValues(attrName, values);
        }
    }

    public void setAttributes(String serviceName, Map attributes) throws SMSException {
        this.validateConfigImpl();
        if (serviceName == null) {
            return;
        }
        if (migratedTo70) {
            serviceName = serviceName.toLowerCase();
            try {
                CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, this.orgDN);
                if (cEntry.isDirty()) {
                    cEntry.refresh();
                }
                SMSEntry e = cEntry.getClonedSMSEntry();
                if (attributes != null && !attributes.isEmpty()) {
                    ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
                    ServiceSchema ss = ssm.getOrganizationCreationSchema();
                    ss.validateAttributes(attributes);
                    HashMap<String, Set<Object>> attrsMap = new HashMap<String, Set<Object>>();
                    for (String name : attributes.keySet()) {
                        Set values = (Set)attributes.get(name);
                        attrsMap.put(serviceName + "-" + name, values);
                    }
                    Map oldAttrs = this.getAttributes(serviceName);
                    for (String skey : oldAttrs.keySet()) {
                        if (attributes.containsKey(skey)) continue;
                        attrsMap.put(serviceName + "-" + skey, (Set<Object>)oldAttrs.get(skey));
                    }
                    SMSUtils.setAttributeValuePairs(e, attrsMap, ss.getSearchableAttributeNames());
                    String dataStore = SMSEntry.getDataStore(this.token);
                    if (dataStore != null && !dataStore.equals(SMSEntry.DATASTORE_ACTIVE_DIR)) {
                        if (e.getDN().equalsIgnoreCase(SERVICES_NODE)) {
                            String[] ocVals = e.getAttributeValues("objectclass");
                            boolean exists = false;
                            for (int ic = 0; ocVals != null && ic < ocVals.length; ++ic) {
                                if (!ocVals[ic].startsWith("sunServiceComponent")) continue;
                                exists = true;
                                break;
                            }
                            if (!exists) {
                                e.addAttribute("objectclass", "sunServiceComponent");
                            }
                        } else if (e.getDN().startsWith("o=")) {
                            String[] vals = e.getAttributeValues("objectclass");
                            boolean rsvcExists = false;
                            for (int n = 0; vals != null && n < vals.length; ++n) {
                                if (!vals[n].equalsIgnoreCase("sunRealmService")) continue;
                                rsvcExists = true;
                                break;
                            }
                            if (!rsvcExists) {
                                e.addAttribute("objectclass", "sunRealmService");
                            }
                        }
                    }
                    e.save(this.token);
                    cEntry.refresh(e);
                }
            }
            catch (SSOException ssoe) {
                SMSEntry.debug.error("OrganizationConfigManager: Unable to set Attributes", (Throwable)((Object)ssoe));
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if ((coexistMode || realmEnabled && this.isCopyOrgEnabled()) && serviceName.equalsIgnoreCase("sunidentityrepositoryservice")) {
            this.amsdk.setAttributes(attributes);
        }
    }

    public void removeAttribute(String serviceName, String attrName) throws SMSException {
        this.validateConfigImpl();
        if (serviceName == null || attrName == null) {
            return;
        }
        if (migratedTo70) {
            try {
                CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, this.orgDN);
                if (cEntry.isDirty()) {
                    cEntry.refresh();
                }
                SMSEntry e = cEntry.getClonedSMSEntry();
                SMSUtils.removeAttribute(e, serviceName.toLowerCase() + "-" + attrName);
                e.save(this.token);
                cEntry.refresh(e);
            }
            catch (SSOException ssoe) {
                SMSEntry.debug.error("OrganizationConfigManager: Unable to remove Attribute", (Throwable)((Object)ssoe));
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if (coexistMode && serviceName.equalsIgnoreCase("sunidentityrepositoryservice")) {
            this.amsdk.removeAttribute(attrName);
        }
    }

    public void removeAttributeValues(String serviceName, String attrName, Set values) throws SMSException {
        this.validateConfigImpl();
        if (serviceName == null || attrName == null) {
            return;
        }
        if (migratedTo70) {
            try {
                CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, this.orgDN);
                if (cEntry.isDirty()) {
                    cEntry.refresh();
                }
                SMSEntry e = cEntry.getClonedSMSEntry();
                ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
                ServiceSchema ss = ssm.getOrganizationCreationSchema();
                HashMap<String, Set> map = new HashMap<String, Set>(2);
                map.put(attrName, values);
                ss.validateAttributes(map);
                SMSUtils.removeAttributeValues(e, serviceName.toLowerCase() + "-" + attrName, values, ss.getSearchableAttributeNames());
                e.save(this.token);
                cEntry.refresh(e);
            }
            catch (SSOException ssoe) {
                SMSEntry.debug.error("OrganizationConfigManager: Unable to remove Attribute Values", (Throwable)((Object)ssoe));
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
        if (coexistMode && serviceName.equalsIgnoreCase("sunidentityrepositoryservice")) {
            this.amsdk.removeAttributeValues(attrName, values);
        }
    }

    public ServiceConfig getServiceConfig(String serviceName) throws SMSException {
        try {
            ServiceConfigManager scmgr = new ServiceConfigManager(serviceName, this.token);
            ServiceConfig scg = scmgr.getOrganizationConfig(this.orgName, null);
            return scg;
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("OrganizationConfigManager: Unable to get Service Config", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public ServiceConfig addServiceConfig(String serviceName, Map attributes) throws SMSException {
        try {
            ServiceConfigManagerImpl scmi = ServiceConfigManagerImpl.getInstance(this.token, serviceName, ServiceManager.getVersion(serviceName));
            ServiceConfigImpl sci = scmi.getOrganizationConfig(this.token, this.orgName, null);
            if (sci == null || sci.isNewEntry()) {
                ServiceConfigManager scm = new ServiceConfigManager(serviceName, this.token);
                return scm.createOrganizationConfig(this.orgName, attributes);
            }
            SMSEntry.debug.error("OrganizationConfigManager: ServiceConfig already exists: " + sci.getDN());
            throw new SMSException(SMSEntry.bundle.getString("sms-service_already_exists1"));
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("OrganizationConfigManager: Unable to add Service Config", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public void removeServiceConfig(String serviceName) throws SMSException {
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, this.token);
            scm.deleteOrganizationConfig(this.orgName);
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("OrganizationConfigManager: Unable to delete Service Config", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public String addListener(ServiceListener listener) {
        return this.orgConfigImpl.addListener(listener);
    }

    public void removeListener(String listenerID) {
        this.orgConfigImpl.removeListener(listenerID);
    }

    private static String normalizeDN(String subOrgName, String orgDN) {
        if (subOrgName == null || subOrgName.length() == 0) {
            return orgDN;
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("OrganizationConfigManager.normalizeDN()-subOrgName " + subOrgName);
        }
        String subOrgDN = null;
        if (DN.isDN((String)subOrgName) && !subOrgName.startsWith("///")) {
            int ndx = subOrgName.lastIndexOf(DNMapper.serviceDN);
            if (ndx == -1) {
                ndx = subOrgName.lastIndexOf(SMSEntry.getRootSuffix());
            }
            if (ndx > 0) {
                subOrgName = subOrgName.substring(0, ndx - 1);
            }
            subOrgDN = DNMapper.normalizeDN(subOrgName) + orgDN;
        } else if (subOrgName.indexOf(47) != -1) {
            int dx;
            String tmp = DNMapper.convertToDN(subOrgName).toString();
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("OrganizationConfigManager.normalizeDN()-slashConvertedString: " + tmp);
            }
            subOrgDN = tmp != null && tmp.length() > 0 ? (tmp.charAt(tmp.length() - 1) == ',' ? tmp + DNMapper.serviceDN : ((dx = tmp.indexOf(",")) >= 0 ? tmp + "," + DNMapper.serviceDN : tmp + "," + orgDN)) : orgDN;
        } else {
            subOrgDN = subOrgName.startsWith("sunamhiddenrealm") ? "o=" + subOrgName + "," + DNMapper.serviceDN : (coexistMode ? orgNamingAttrInLegacyMode + "=" + subOrgName + "," + DNMapper.realmNameToAMSDKName(orgDN) : "o=" + subOrgName + "," + orgDN);
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("OrganizationConfigManager::normalizeDN() suborgdn " + subOrgDN);
        }
        return subOrgDN;
    }

    static Set getServiceNames(SSOToken token) throws SMSException, SSOException {
        CachedSubEntries cse = CachedSubEntries.getInstance(token, DNMapper.serviceDN);
        return cse.getSubEntries(token);
    }

    /*
     * Exception decompiling
     */
    public Set getAssignableServices() throws SMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Set getAssignedServices() throws SMSException {
        return this.getAssignedServices(true);
    }

    public Set getAssignedServices(boolean includeMandatory) throws SMSException {
        this.validateConfigImpl();
        Set assignedServices = Collections.EMPTY_SET;
        assignedServices = coexistMode ? this.amsdk.getAssignedServices() : this.orgConfigImpl.getAssignedServices(this.token);
        if (!includeMandatory) {
            Set ds = ServiceManager.requiredServices();
            assignedServices.removeAll(ds);
        }
        return assignedServices;
    }

    public void assignService(String serviceName, Map attributes) throws SMSException {
        this.addServiceConfig(serviceName, attributes);
    }

    public Map getServiceAttributes(String serviceName) throws SMSException {
        ServiceConfig scg = this.getServiceConfig(serviceName);
        if (scg == null) {
            Object[] args = new Object[]{serviceName};
            SMSEntry.debug.error("OrganizationConfigManager.getServiceAttributes() Unable to get service attributes. ");
            throw new SMSException("amSDK", "sms-no-organization-schema", args);
        }
        return scg.getAttributes();
    }

    public void unassignService(String serviceName) throws SMSException {
        this.removeServiceConfig(serviceName);
    }

    public void modifyService(String serviceName, Map attributes) throws SMSException {
        try {
            this.getServiceConfig(serviceName).setAttributes(attributes);
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("OrganizationConfigManager.modifyService SSOException in modify service ", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public String getNamingAttrForOrg() {
        return OrgConfigViaAMSDK.getNamingAttrForOrg();
    }

    public OrganizationConfigManager getParentOrgConfigManager() throws SMSException {
        OrganizationConfigManager ocm = null;
        String parentDN = null;
        if (DN.isDN((String)this.orgDN)) {
            if (this.orgDN.equalsIgnoreCase(DNMapper.serviceDN)) {
                return this;
            }
            parentDN = new DN(this.orgDN).getParent().toString();
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("OrganizationConfigManager.getParentOrgConfigManager() parentDN : " + parentDN);
            }
            if (parentDN != null && parentDN.length() > 0) {
                ocm = new OrganizationConfigManager(this.token, parentDN);
            }
        }
        return ocm;
    }

    public static void loadDefaultServices(SSOToken token, OrganizationConfigManager ocm) throws SMSException {
        if (!migratedTo70) {
            return;
        }
        Set defaultServices = ServiceManager.servicesAssignedByDefault();
        OrganizationConfigManager parentOrg = ocm.getParentOrgConfigManager();
        if (defaultServices == null) {
            return;
        }
        CaseInsensitiveHashSet assignedServices = new CaseInsensitiveHashSet((Collection)parentOrg.getAssignedServices());
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("OrganizationConfigManager::loadDefaultServices assignedServices : " + assignedServices);
        }
        boolean doAuthServiceLater = false;
        String serviceName = null;
        Iterator items = defaultServices.iterator();
        while (items.hasNext() || doAuthServiceLater) {
            if (items.hasNext()) {
                serviceName = (String)items.next();
                if (serviceName.equals("iPlanetAMAuthService")) {
                    doAuthServiceLater = true;
                    continue;
                }
            } else if (doAuthServiceLater) {
                serviceName = "iPlanetAMAuthService";
                doAuthServiceLater = false;
            }
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("OrganizationConfigManager::loadDefaultServices:ServiceName " + serviceName);
            }
            try {
                ServiceConfig sc = parentOrg.getServiceConfig(serviceName);
                Map attrs = null;
                if (sc == null || !assignedServices.contains(serviceName)) continue;
                attrs = sc.getAttributesWithoutDefaults();
                if (SMSEntry.debug.messageEnabled()) {
                    SMSEntry.debug.message("OrganizationConfigManager::loadDefaultServices Copying service from parent: " + serviceName);
                }
                ServiceConfig scn = ocm.addServiceConfig(serviceName, attrs);
                OrganizationConfigManager.copySubConfig(sc, scn);
            }
            catch (SSOException ssoe) {
                if (SMSEntry.debug.messageEnabled()) {
                    SMSEntry.debug.message("OrganizationConfigManager.loadDefaultServices SSOException in loading default services ", (Throwable)((Object)ssoe));
                }
                throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
            }
        }
    }

    private void registerSvcsForOrg(String subOrgName, String subOrgDN) {
        block7: {
            try {
                Set defaultServices = ServiceManager.servicesAssignedByDefault();
                if (SMSEntry.debug.messageEnabled()) {
                    SMSEntry.debug.message("OrganizationConfigManager::registerSvcsForOrg. defaultServices : " + defaultServices);
                }
                if (defaultServices != null) {
                    Set assignedServices = this.amsdk.getAssignedServices();
                    if (SMSEntry.debug.messageEnabled()) {
                        SMSEntry.debug.message("OrganizationConfigManager::registerSvcsForOrg:assignedServices: " + assignedServices);
                    }
                    Iterator items = defaultServices.iterator();
                    String serviceName = null;
                    this.amsdk = SMSEntry.getRootSuffix().equalsIgnoreCase(SMSEntry.getAMSdkBaseDN()) ? new OrgConfigViaAMSDK(this.token, orgNamingAttrInLegacyMode + "=" + subOrgName + "," + DNMapper.realmNameToAMSDKName(this.orgDN), subOrgDN) : new OrgConfigViaAMSDK(this.token, orgNamingAttrInLegacyMode + "=" + subOrgName + "," + this.amSDKOrgDN, subOrgDN);
                    while (items.hasNext()) {
                        serviceName = (String)items.next();
                        if (!assignedServices.contains(serviceName)) continue;
                        if (SMSEntry.debug.messageEnabled()) {
                            SMSEntry.debug.message("OrganizationConfigManager::registerSvcsForOrg:ServiceName : " + serviceName);
                        }
                        this.amsdk.assignService(serviceName);
                    }
                }
            }
            catch (SMSException smse) {
                if (!SMSEntry.debug.warningEnabled()) break block7;
                SMSEntry.debug.warning("OrganizationConfigManager::registerSvcsForOrg. SMSException in registering services: ", (Throwable)smse);
            }
        }
    }

    static void copySubConfig(ServiceConfig from, ServiceConfig to) throws SMSException, SSOException {
        Set subConfigNames = from.getSubConfigNames();
        for (String subConfigName : subConfigNames) {
            ServiceConfig scf = from.getSubConfig(subConfigName);
            to.addSubConfig(subConfigName, scf.getSchemaID(), scf.getPriority(), scf.getAttributesWithoutDefaults());
            ServiceConfig sct = to.getSubConfig(subConfigName);
            OrganizationConfigManager.copySubConfig(scf, sct);
        }
    }

    protected boolean isCopyOrgEnabled() {
        block11: {
            if (this.copyOrgInitialized) {
                return this.copyOrgEnabled;
            }
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("OrganizationConfigManager: in isCopyOrgEnabled() ");
            }
            try {
                ServiceConfig s = this.getServiceConfig("sunidentityrepositoryservice");
                if (s == null) break block11;
                Iterator items = s.getSubConfigNames().iterator();
                while (items.hasNext()) {
                    Set orgs;
                    Map configMap;
                    String name = items.next().toString();
                    ServiceConfig subConfig = s.getSubConfig(name);
                    if (subConfig == null) {
                        SMSEntry.debug.error("OrganizationConfigManager.isCopyOrgEnabled. SubConfig is NULL: SC Name: " + name + " For org: " + this.orgDN);
                        return false;
                    }
                    if (!subConfig.getSchemaID().equalsIgnoreCase("amSDK") || (configMap = subConfig.getAttributes()) == null || configMap.isEmpty() || (orgs = (Set)configMap.get("amSDKOrgName")) == null || orgs.isEmpty()) continue;
                    this.amSDKOrgDN = (String)orgs.iterator().next();
                    Set cfgs = (Set)configMap.get(this.CONF_ENABLED);
                    if (cfgs != null && !cfgs.isEmpty() && cfgs.contains("true") && this.amSDKOrgDN != null) {
                        this.amsdk = new OrgConfigViaAMSDK(this.token, this.amSDKOrgDN, this.orgDN);
                        if (orgNamingAttrInLegacyMode == null) {
                            orgNamingAttrInLegacyMode = this.getNamingAttrForOrg();
                        }
                        this.copyOrgEnabled = true;
                    }
                    break;
                }
            }
            catch (SSOException sse) {
                if (SMSEntry.debug.messageEnabled()) {
                    SMSEntry.debug.message("OrganizationConfigManager:isCopyOrgEnabled() Unable to get service: sunidentityrepositoryservice", (Throwable)((Object)sse));
                }
            }
            catch (SMSException e) {
                if (!SMSEntry.debug.messageEnabled()) break block11;
                SMSEntry.debug.message("OrganizationConfigManager:isCopyOrgEnabled() Unable to get service: sunidentityrepositoryservice", (Throwable)e);
            }
        }
        this.copyOrgInitialized = true;
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("OrganizationConfigManager: copyOrgEnabled == " + this.copyOrgEnabled);
        }
        return this.copyOrgEnabled;
    }

    static void initializeFlags() {
        realmEnabled = ServiceManager.isRealmEnabled();
        coexistMode = ServiceManager.isCoexistenceMode();
        migratedTo70 = ServiceManager.isConfigMigratedTo70();
    }

    void validateConfigImpl() throws SMSException {
        if (this.orgConfigImpl == null || !this.orgConfigImpl.isValid()) {
            try {
                this.orgConfigImpl = OrganizationConfigManagerImpl.getInstance(this.token, this.orgName);
            }
            catch (SSOException ssoe) {
                throw new SMSException((Throwable)((Object)ssoe), "sms-INVALID_SSO_TOKEN");
            }
        }
    }

    static {
        baseDNpattern = Pattern.compile(SMSEntry.getRootSuffix());
        SERVICES_NODE = "ou=services," + SMSEntry.getRootSuffix();
        specialCharsString = "*|(|)|!|/|=";
        SEPERATOR = "|";
        OrganizationConfigManager.initializeFlags();
    }

    class OrganizationConfigManagerListener
    implements ServiceListener {
        OrganizationConfigManagerListener() {
        }

        public void schemaChanged(String serviceName, String version) {
            ServiceManager.schemaChanged();
            if (serviceName.equalsIgnoreCase("iPlanetAMPlatformService")) {
                ServiceManager.accessManagerServers = null;
            }
        }

        public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
            if (serviceName.equalsIgnoreCase("sunidentityrepositoryservice")) {
                try {
                    ServiceManager.checkFlags(OrganizationConfigManager.this.token);
                }
                catch (SSOException ssoe) {
                    SMSEntry.debug.error("OrganizationConfigManager: globalConfigChanged ", (Throwable)((Object)ssoe));
                }
                catch (SMSException smse) {
                    SMSEntry.debug.error("OrganizationConfigManager: globalConfigChanged ", (Throwable)smse);
                }
                realmEnabled = ServiceManager.isRealmEnabled();
                coexistMode = ServiceManager.isCoexistenceMode();
                migratedTo70 = ServiceManager.isConfigMigratedTo70();
            }
        }

        public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
            if (serviceName.equalsIgnoreCase("sunidentityrepositoryservice")) {
                OrgConfigViaAMSDK.attributeMappings = new HashMap();
                OrgConfigViaAMSDK.reverseAttributeMappings = new HashMap();
            }
        }
    }
}

