/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.ConfigurationProperties;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.ArtifactResolver;
import org.sonatype.aether.impl.LocalRepositoryEvent;
import org.sonatype.aether.impl.LocalRepositoryMaintainer;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.impl.RepositoryEventDispatcher;
import org.sonatype.aether.impl.UpdateCheck;
import org.sonatype.aether.impl.UpdateCheckManager;
import org.sonatype.aether.impl.VersionResolver;
import org.sonatype.aether.impl.internal.DefaultLocalRepositoryEvent;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.LocalArtifactRegistration;
import org.sonatype.aether.repository.LocalArtifactRequest;
import org.sonatype.aether.repository.LocalArtifactResult;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.VersionRequest;
import org.sonatype.aether.resolution.VersionResolutionException;
import org.sonatype.aether.resolution.VersionResult;
import org.sonatype.aether.spi.connector.ArtifactDownload;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.transfer.ArtifactNotFoundException;
import org.sonatype.aether.transfer.ArtifactTransferException;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;
import org.sonatype.aether.util.listener.DefaultRepositoryEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArtifactResolver.class)
public class DefaultArtifactResolver
implements ArtifactResolver,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private FileProcessor fileProcessor;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement
    private VersionResolver versionResolver;
    @Requirement
    private UpdateCheckManager updateCheckManager;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement(role=LocalRepositoryMaintainer.class)
    private List<LocalRepositoryMaintainer> localRepositoryMaintainers = new ArrayList<LocalRepositoryMaintainer>();

    public DefaultArtifactResolver() {
    }

    public DefaultArtifactResolver(Logger logger, FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RemoteRepositoryManager remoteRepositoryManager) {
        this(logger, fileProcessor, repositoryEventDispatcher, versionResolver, updateCheckManager, remoteRepositoryManager, null);
    }

    public DefaultArtifactResolver(Logger logger, FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RemoteRepositoryManager remoteRepositoryManager, List<LocalRepositoryMaintainer> localRepositoryMaintainers) {
        this.setLogger(logger);
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setVersionResolver(versionResolver);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setLocalRepositoryMaintainers(localRepositoryMaintainers);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
        this.setFileProcessor((FileProcessor)locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher((RepositoryEventDispatcher)locator.getService(RepositoryEventDispatcher.class));
        this.setVersionResolver((VersionResolver)locator.getService(VersionResolver.class));
        this.setUpdateCheckManager((UpdateCheckManager)locator.getService(UpdateCheckManager.class));
        this.setRemoteRepositoryManager((RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class));
        this.setLocalRepositoryMaintainers(locator.getServices(LocalRepositoryMaintainer.class));
    }

    public DefaultArtifactResolver setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultArtifactResolver setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public DefaultArtifactResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultArtifactResolver setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultArtifactResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        if (updateCheckManager == null) {
            throw new IllegalArgumentException("update check manager has not been specified");
        }
        this.updateCheckManager = updateCheckManager;
        return this;
    }

    public DefaultArtifactResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public DefaultArtifactResolver addLocalRepositoryMaintainer(LocalRepositoryMaintainer maintainer) {
        if (maintainer == null) {
            throw new IllegalArgumentException("local repository maintainer has not been specified");
        }
        this.localRepositoryMaintainers.add(maintainer);
        return this;
    }

    public DefaultArtifactResolver setLocalRepositoryMaintainers(List<LocalRepositoryMaintainer> maintainers) {
        this.localRepositoryMaintainers = maintainers == null ? new ArrayList<LocalRepositoryMaintainer>() : maintainers;
        return this;
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.resolveArtifacts(session, Collections.singleton(request)).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>(requests.size());
        boolean failures = false;
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        WorkspaceReader workspace = session.getWorkspaceReader();
        ArrayList<ResolutionGroup> groups = new ArrayList<ResolutionGroup>();
        for (ArtifactRequest artifactRequest : requests) {
            File file;
            VersionResult versionResult;
            ArtifactResult result = new ArtifactResult(artifactRequest);
            results.add(result);
            Artifact artifact = artifactRequest.getArtifact();
            List<Object> repos = artifactRequest.getRepositories();
            this.artifactResolving(session, artifact);
            String localPath = artifact.getProperty("localPath", null);
            if (localPath != null) {
                File file2 = new File(localPath);
                if (!file2.isFile()) {
                    failures = true;
                    result.addException((Exception)new ArtifactNotFoundException(artifact, null));
                    continue;
                }
                artifact = artifact.setFile(file2);
                result.setArtifact(artifact);
                this.artifactResolved(session, artifact, null, result.getExceptions());
                continue;
            }
            try {
                VersionRequest versionRequest = new VersionRequest(artifact, (List)repos, artifactRequest.getRequestContext());
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
            }
            catch (VersionResolutionException e) {
                result.addException((Exception)((Object)e));
                continue;
            }
            artifact = artifact.setVersion(versionResult.getVersion());
            if (versionResult.getRepository() != null) {
                repos = versionResult.getRepository() instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)versionResult.getRepository()) : Collections.emptyList();
            }
            if (workspace != null && (file = workspace.findArtifact(artifact)) != null) {
                artifact = artifact.setFile(file);
                result.setArtifact(artifact);
                result.setRepository((ArtifactRepository)workspace.getRepository());
                this.artifactResolved(session, artifact, (ArtifactRepository)workspace.getRepository(), null);
                continue;
            }
            LocalArtifactResult local = lrm.find(session, new LocalArtifactRequest(artifact, repos, artifactRequest.getRequestContext()));
            if (local.isAvailable() || local.getFile() != null && versionResult.getRepository() instanceof LocalRepository) {
                result.setRepository((ArtifactRepository)lrm.getRepository());
                try {
                    artifact = artifact.setFile(this.getFile(session, artifact, local.getFile()));
                    result.setArtifact(artifact);
                    this.artifactResolved(session, artifact, (ArtifactRepository)lrm.getRepository(), null);
                }
                catch (ArtifactTransferException e) {
                    result.addException((Exception)((Object)e));
                }
                if (local.isAvailable()) continue;
                lrm.add(session, new LocalArtifactRegistration(artifact));
                continue;
            }
            if (local.getFile() != null) {
                this.logger.debug("Verifying availability of " + local.getFile() + " from " + repos);
            }
            if (session.isOffline()) {
                ArtifactNotFoundException exception = new ArtifactNotFoundException(artifact, null, "The repository system is offline but the artifact " + artifact + " is not available in the local repository.");
                result.addException((Exception)exception);
                this.artifactResolved(session, artifact, null, result.getExceptions());
                continue;
            }
            AtomicBoolean resolved = new AtomicBoolean(false);
            Iterator<Object> groupIt = groups.iterator();
            for (RemoteRepository remoteRepository : repos) {
                if (!remoteRepository.getPolicy(artifact.isSnapshot()).isEnabled()) continue;
                ResolutionGroup group = null;
                while (groupIt.hasNext()) {
                    ResolutionGroup t = (ResolutionGroup)groupIt.next();
                    if (!t.matches(remoteRepository)) continue;
                    group = t;
                    break;
                }
                if (group == null) {
                    group = new ResolutionGroup(remoteRepository);
                    groups.add(group);
                    groupIt = Collections.emptyList().iterator();
                }
                group.items.add(new ResolutionItem(artifact, resolved, result, local, remoteRepository));
            }
        }
        for (ResolutionGroup resolutionGroup : groups) {
            ArrayList<ArtifactDownload> downloads = new ArrayList<ArtifactDownload>();
            for (ResolutionItem item : resolutionGroup.items) {
                Artifact artifact = item.artifact;
                if (item.resolved.get()) continue;
                ArtifactDownload download = new ArtifactDownload();
                download.setArtifact(artifact);
                download.setRequestContext(item.request.getRequestContext());
                if (item.local.getFile() != null) {
                    download.setFile(item.local.getFile());
                    download.setExistenceCheck(true);
                } else {
                    String path = lrm.getPathForRemoteArtifact(artifact, resolutionGroup.repository, item.request.getRequestContext());
                    download.setFile(new File(lrm.getRepository().getBasedir(), path));
                }
                boolean snapshot = artifact.isSnapshot();
                RepositoryPolicy policy = this.remoteRepositoryManager.getPolicy(session, resolutionGroup.repository, !snapshot, snapshot);
                if (session.isNotFoundCachingEnabled() || session.isTransferErrorCachingEnabled()) {
                    UpdateCheck<Artifact, ArtifactTransferException> check = new UpdateCheck<Artifact, ArtifactTransferException>();
                    check.setItem(artifact);
                    check.setFile(download.getFile());
                    check.setRepository(resolutionGroup.repository);
                    check.setPolicy(policy.getUpdatePolicy());
                    item.updateCheck = check;
                    this.updateCheckManager.checkArtifact(session, check);
                    if (!check.isRequired() && check.getException() != null) {
                        item.result.addException((Exception)((Object)check.getException()));
                        continue;
                    }
                }
                download.setChecksumPolicy(policy.getChecksumPolicy());
                download.setRepositories(item.repository.getMirroredRepositories());
                downloads.add(download);
                item.download = download;
            }
            if (downloads.isEmpty()) continue;
            for (ArtifactDownload download : downloads) {
                this.artifactDownloading(session, download.getArtifact(), resolutionGroup.repository);
            }
            try {
                RepositoryConnector connector = this.remoteRepositoryManager.getRepositoryConnector(session, resolutionGroup.repository);
                try {
                    connector.get(downloads, null);
                }
                finally {
                    connector.close();
                }
            }
            catch (NoRepositoryConnectorException e) {
                for (ArtifactDownload download : downloads) {
                    download.setException(new ArtifactTransferException(download.getArtifact(), resolutionGroup.repository, (Throwable)e));
                }
            }
            for (ResolutionItem item : resolutionGroup.items) {
                ArtifactDownload download;
                download = item.download;
                if (download == null) continue;
                if (item.updateCheck != null) {
                    item.updateCheck.setException(download.getException());
                    this.updateCheckManager.touchArtifact(session, item.updateCheck);
                }
                if (download.getException() == null) {
                    item.resolved.set(true);
                    item.result.setRepository((ArtifactRepository)resolutionGroup.repository);
                    Artifact artifact = download.getArtifact();
                    try {
                        artifact = artifact.setFile(this.getFile(session, artifact, download.getFile()));
                        item.result.setArtifact(artifact);
                    }
                    catch (ArtifactTransferException e) {
                        item.result.addException((Exception)((Object)e));
                        continue;
                    }
                    lrm.add(session, new LocalArtifactRegistration(artifact, resolutionGroup.repository, download.getSupportedContexts()));
                    if (!this.localRepositoryMaintainers.isEmpty()) {
                        DefaultLocalRepositoryEvent event = new DefaultLocalRepositoryEvent(LocalRepositoryEvent.EventType.ARTIFACT_DOWNLOADED, session, artifact, artifact.getFile());
                        for (LocalRepositoryMaintainer maintainer : this.localRepositoryMaintainers) {
                            maintainer.artifactDownloaded(event);
                        }
                    }
                    this.artifactDownloaded(session, artifact, resolutionGroup.repository, null);
                    this.artifactResolved(session, artifact, (ArtifactRepository)resolutionGroup.repository, null);
                    continue;
                }
                item.result.addException((Exception)((Object)download.getException()));
                this.artifactDownloaded(session, download.getArtifact(), resolutionGroup.repository, (Exception)((Object)download.getException()));
            }
        }
        for (ArtifactResult artifactResult : results) {
            Artifact artifact = artifactResult.getArtifact();
            if (artifact != null && artifact.getFile() != null) continue;
            failures = true;
            if (artifactResult.getExceptions().isEmpty()) {
                ArtifactNotFoundException exception = new ArtifactNotFoundException(artifactResult.getRequest().getArtifact(), null);
                artifactResult.addException((Exception)exception);
            }
            this.artifactResolved(session, artifactResult.getRequest().getArtifact(), null, artifactResult.getExceptions());
        }
        if (failures) {
            throw new ArtifactResolutionException(results);
        }
        return results;
    }

    private File getFile(RepositorySystemSession session, Artifact artifact, File file) throws ArtifactTransferException {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion()) && ConfigurationProperties.get((RepositorySystemSession)session, (String)"aether.artifactResolver.snapshotNormalization", (boolean)true)) {
            boolean copy;
            String name = file.getName().replace(artifact.getVersion(), artifact.getBaseVersion());
            File dst = new File(file.getParent(), name);
            boolean bl = copy = dst.length() != file.length() || dst.lastModified() != file.lastModified();
            if (copy) {
                try {
                    this.fileProcessor.copy(file, dst, null);
                    dst.setLastModified(file.lastModified());
                }
                catch (IOException e) {
                    throw new ArtifactTransferException(artifact, null, (Throwable)e);
                }
            }
            file = dst;
        }
        return file;
    }

    private void artifactResolving(RepositorySystemSession session, Artifact artifact) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_RESOLVING, session);
        event.setArtifact(artifact);
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }

    private void artifactResolved(RepositorySystemSession session, Artifact artifact, ArtifactRepository repository, List<Exception> exceptions) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_RESOLVED, session);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setExceptions(exceptions);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }

    private void artifactDownloading(RepositorySystemSession session, Artifact artifact, RemoteRepository repository) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_DOWNLOADING, session);
        event.setArtifact(artifact);
        event.setRepository((ArtifactRepository)repository);
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }

    private void artifactDownloaded(RepositorySystemSession session, Artifact artifact, RemoteRepository repository, Exception exception) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_DOWNLOADED, session);
        event.setArtifact(artifact);
        event.setRepository((ArtifactRepository)repository);
        event.setException(exception);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }

    static class ResolutionItem {
        final ArtifactRequest request;
        final ArtifactResult result;
        final LocalArtifactResult local;
        final RemoteRepository repository;
        final Artifact artifact;
        final AtomicBoolean resolved;
        ArtifactDownload download;
        UpdateCheck<Artifact, ArtifactTransferException> updateCheck;

        ResolutionItem(Artifact artifact, AtomicBoolean resolved, ArtifactResult result, LocalArtifactResult local, RemoteRepository repository) {
            this.artifact = artifact;
            this.resolved = resolved;
            this.result = result;
            this.request = result.getRequest();
            this.local = local;
            this.repository = repository;
        }
    }

    static class ResolutionGroup {
        final RemoteRepository repository;
        final List<ResolutionItem> items = new ArrayList<ResolutionItem>();

        ResolutionGroup(RemoteRepository repository) {
            this.repository = repository;
        }

        boolean matches(RemoteRepository repo) {
            return this.repository.getUrl().equals(repo.getUrl()) && this.repository.getContentType().equals(repo.getContentType()) && this.repository.isRepositoryManager() == repo.isRepositoryManager();
        }
    }
}

