/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaSecurityUtils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import java.util.List;
import java.util.Map;

public class CreateSAML2HostedProviderTemplate {
    private CreateSAML2HostedProviderTemplate() {
    }

    private static String getHostURL() {
        String protocol = SystemPropertiesManager.get((String)"com.iplanet.am.server.protocol");
        String host = SystemPropertiesManager.get((String)"com.iplanet.am.server.host");
        String port = SystemPropertiesManager.get((String)"com.iplanet.am.server.port");
        String deploymentURI = SystemPropertiesManager.get((String)"com.iplanet.am.services.deploymentDescriptor");
        return protocol + "://" + host + ":" + port + deploymentURI;
    }

    public static String createExtendedDataTemplate(String entityID, Map mapParams, String url) {
        return CreateSAML2HostedProviderTemplate.createExtendedDataTemplate(entityID, mapParams, url, true);
    }

    public static String createExtendedDataTemplate(String entityID, Map mapParams, String url, boolean hosted) {
        String pepAlias;
        String pdpAlias;
        String affiAlias;
        String authnaAlias;
        String attrqAlias;
        String attraAlias;
        String spAlias;
        if (url == null) {
            url = CreateSAML2HostedProviderTemplate.getHostURL();
        }
        StringBuffer buff = new StringBuffer();
        String strHosted = hosted ? "1" : "0";
        buff.append("<EntityConfig xmlns=\"urn:sun:fm:SAML:2.0:entityconfig\"\n    xmlns:fm=\"urn:sun:fm:SAML:2.0:entityconfig\"\n    hosted=\"" + strHosted + "\"\n" + "    entityID=\"" + entityID + "\">\n\n");
        String idpAlias = (String)mapParams.get("idp");
        if (idpAlias != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)idpAlias);
            CreateSAML2HostedProviderTemplate.buildIDPConfigTemplate(buff, idpAlias, url, mapParams);
        }
        if ((spAlias = (String)mapParams.get("sp")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)spAlias);
            CreateSAML2HostedProviderTemplate.buildSPConfigTemplate(buff, spAlias, url, mapParams);
        }
        if ((attraAlias = (String)mapParams.get("attra")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)attraAlias);
            CreateSAML2HostedProviderTemplate.buildAttributeAuthorityConfigTemplate(buff, attraAlias, url, mapParams);
        }
        if ((attrqAlias = (String)mapParams.get("attrq")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)attrqAlias);
            CreateSAML2HostedProviderTemplate.buildAttributeQueryConfigTemplate(buff, attrqAlias, url, mapParams);
        }
        if ((authnaAlias = (String)mapParams.get("authna")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)authnaAlias);
            CreateSAML2HostedProviderTemplate.buildAuthnAuthorityConfigTemplate(buff, authnaAlias, url, mapParams);
        }
        if ((affiAlias = (String)mapParams.get("affiliation")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)affiAlias);
            CreateSAML2HostedProviderTemplate.buildAffiliationConfigTemplate(buff, affiAlias, url, mapParams);
        }
        if ((pdpAlias = (String)mapParams.get("pdp")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)pdpAlias);
            CreateSAML2HostedProviderTemplate.buildPDPConfigTemplate(buff, pdpAlias, mapParams);
        }
        if ((pepAlias = (String)mapParams.get("pep")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)pepAlias);
            CreateSAML2HostedProviderTemplate.buildPEPConfigTemplate(buff, pepAlias, mapParams);
        }
        buff.append("</EntityConfig>\n");
        return buff.toString();
    }

    private static void buildIDPConfigTemplate(StringBuffer buff, String idpAlias, String url, Map mapParams) {
        String idpSCertAlias = (String)mapParams.get("idpscert");
        String idpECertAlias = (String)mapParams.get("idpecert");
        if (idpSCertAlias == null) {
            idpSCertAlias = "";
        }
        if (idpECertAlias == null) {
            idpECertAlias = "";
        }
        buff.append("    <IDPSSOConfig metaAlias=\"" + idpAlias + "\">\n" + "        <Attribute name=\"" + "description" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "signingCertAlias" + "\">\n" + "            <Value>" + idpSCertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "encryptionCertAlias" + "\">\n" + "            <Value>" + idpECertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthOn" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthUser" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthPassword" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "autofedEnabled" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "autofedAttribute" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "assertionEffectiveTime" + "\">\n" + "            <Value>600</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "idpAuthncontextMapper" + "\">\n" + "            <Value>com.sun.identity.saml2.plugins.DefaultIDPAuthnContextMapper" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "idpAuthncontextClassrefMapping" + "\">\n" + "            <Value>" + "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport" + "|0||default</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "idpAccountMapper" + "\">\n" + "            <Value>com.sun.identity.saml2.plugins.DefaultIDPAccountMapper" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "idpAttributeMapper" + "\">\n" + "            <Value>com.sun.identity.saml2.plugins.DefaultIDPAttributeMapper" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "assertionIDRequestMapper" + "\">\n" + "            <Value>com.sun.identity.saml2.plugins.DefaultAssertionIDRequestMapper" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "nameIDFormatMap" + "\">\n" + "           <Value>" + "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress" + "=mail" + "</Value>\n" + "           <Value>" + "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName" + "=" + "</Value>\n" + "           <Value>" + "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName" + "=" + "</Value>\n" + "           <Value>" + "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos" + "=" + "</Value>\n" + "           <Value>" + "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified" + "=" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "idpECPSessionMapper" + "\">\n" + "            <Value>" + "com.sun.identity.saml2.plugins.DefaultIDPECPSessionMapper" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "attributeMap" + "\">\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "wantNameIDEncrypted" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "wantArtifactResolveSigned" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "wantLogoutRequestSigned" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "wantLogoutResponseSigned" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "wantMNIRequestSigned" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "wantMNIResponseSigned" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "cotlist" + "\">\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "discoveryBootstrappingEnabled" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "assertionCacheEnabled" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "assertionNotBeforeTimeSkew" + "\">\n" + "            <Value>600</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "saeAppSecretList" + "\">\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "saeIDPUrl" + "\">\n" + "            <Value>" + url + "/idpsaehandler/metaAlias" + idpAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "AuthUrl" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "       <Attribute name=\"" + "appLogoutUrl" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "idpSessionSyncEnabled" + "\">\n" + "           <Value>false</Value>\n" + "       </Attribute>\n" + "    </IDPSSOConfig>\n");
    }

    private static void buildSPConfigTemplate(StringBuffer buff, String spAlias, String url, Map mapParams) {
        String spSCertAlias = (String)mapParams.get("spscert");
        String spECertAlias = (String)mapParams.get("specert");
        if (spSCertAlias == null) {
            spSCertAlias = "";
        }
        if (spECertAlias == null) {
            spECertAlias = "";
        }
        buff.append("    <SPSSOConfig metaAlias=\"" + spAlias + "\">\n" + "        <Attribute name=\"" + "description" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "signingCertAlias" + "\">\n" + "            <Value>" + spSCertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "encryptionCertAlias" + "\">\n" + "            <Value>" + spECertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthOn" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthUser" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthPassword" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "autofedEnabled" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "autofedAttribute" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "transientUser" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "spAdapter" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "spAdapterEnv" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "spAccountMapper" + "\">\n" + "            <Value>com.sun.identity.saml2.plugins.DefaultSPAccountMapper" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "useNameIDAsSPUserID" + "\">\n" + "            <Value>false" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "spAttributeMapper" + "\">\n" + "            <Value>com.sun.identity.saml2.plugins.DefaultSPAttributeMapper" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "spAuthncontextMapper" + "\">\n" + "            <Value>" + "com.sun.identity.saml2.plugins.DefaultSPAuthnContextMapper" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "spAuthncontextClassrefMapping" + "\">\n" + "            <Value>" + "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport|0|default" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "spAuthncontextComparisonType" + "\">\n" + "           <Value>" + "exact" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "attributeMap" + "\">\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "saml2AuthModuleName" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "localAuthURL" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "intermediateUrl" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "defaultRelayState" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "appLogoutUrl" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "assertionTimeSkew" + "\">\n" + "           <Value>300</Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "wantAttributeEncrypted" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "wantAssertionEncrypted" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "wantNameIDEncrypted" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "wantPOSTResponseSigned" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "wantArtifactResponseSigned" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "wantLogoutRequestSigned" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "wantLogoutResponseSigned" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "wantMNIRequestSigned" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "wantMNIResponseSigned" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "responseArtifactMessageEncoding" + "\">\n" + "           <Value>" + "URI" + "</Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "cotlist" + "\">\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "saeAppSecretList" + "\">\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "saeSPUrl" + "\">\n" + "           <Value>" + url + "/spsaehandler/metaAlias" + spAlias + "</Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "saeSPLogoutUrl" + "\">\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "ECPRequestIDPListFinderImpl" + "\">\n" + "           <Value>com.sun.identity.saml2.plugins.ECPIDPFinder</Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "ECPRequestIDPList" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "ECPRequestIDPListGetComplete" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "enableIDPProxy" + "\">\n" + "           <Value>false</Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "idpProxyList" + "\">\n" + "           <Value></Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "idpProxyCount" + "\">\n" + "           <Value>0</Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "useIntroductionForIDPProxy" + "\">\n" + "           <Value>false</Value>\n" + "       </Attribute>\n" + "       <Attribute name=\"" + "spSessionSyncEnabled" + "\">\n" + "           <Value>false</Value>\n" + "       </Attribute>\n" + "    </SPSSOConfig>\n");
    }

    private static void buildAttributeAuthorityConfigTemplate(StringBuffer buff, String attraAlias, String url, Map mapParams) {
        String attraECertAlias = (String)mapParams.get("attraecert");
        String attraSCertAlias = (String)mapParams.get("attrascert");
        if (attraECertAlias == null) {
            attraECertAlias = "";
        }
        if (attraSCertAlias == null) {
            attraSCertAlias = "";
        }
        buff.append("    <AttributeAuthorityConfig metaAlias=\"" + attraAlias + "\">\n" + "        <Attribute name=\"" + "signingCertAlias" + "\">\n" + "            <Value>" + attraSCertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "encryptionCertAlias" + "\">\n" + "            <Value>" + attraECertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "default" + "_" + "attributeAuthorityMapper" + "\">\n" + "            <Value>" + "com.sun.identity.saml2.plugins.DefaultAttributeAuthorityMapper" + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "x509Subject" + "_" + "attributeAuthorityMapper" + "\">\n" + "            <Value>com.sun.identity.saml2.plugins.X509SubjectAttributeAuthorityMapper</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "x509SubjectDataStoreAttrName" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "assertionIDRequestMapper" + "\">\n" + "            <Value>com.sun.identity.saml2.plugins.DefaultAssertionIDRequestMapper" + "</Value>\n" + "        </Attribute>\n" + "    </AttributeAuthorityConfig>\n");
    }

    private static void buildAttributeQueryConfigTemplate(StringBuffer buff, String attrqAlias, String url, Map mapParams) {
        String attrqSCertAlias = (String)mapParams.get("attrqscert");
        String attrqECertAlias = (String)mapParams.get("attrqecert");
        if (attrqSCertAlias == null) {
            attrqSCertAlias = "";
        }
        if (attrqECertAlias == null) {
            attrqECertAlias = "";
        }
        buff.append("    <AttributeQueryConfig metaAlias=\"" + attrqAlias + "\">\n" + "        <Attribute name=\"" + "signingCertAlias" + "\">\n" + "            <Value>" + attrqSCertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "encryptionCertAlias" + "\">\n" + "            <Value>" + attrqECertAlias + "</Value>\n" + "        </Attribute>\n" + "    </AttributeQueryConfig>\n");
    }

    private static void buildAuthnAuthorityConfigTemplate(StringBuffer buff, String authnaAlias, String url, Map mapParams) {
        String authnaECertAlias = (String)mapParams.get("authnaecert");
        String authnaSCertAlias = (String)mapParams.get("authnascert");
        if (authnaECertAlias == null) {
            authnaECertAlias = "";
        }
        if (authnaSCertAlias == null) {
            authnaSCertAlias = "";
        }
        buff.append("    <AuthnAuthorityConfig metaAlias=\"" + authnaAlias + "\">\n" + "        <Attribute name=\"" + "signingCertAlias" + "\">\n" + "            <Value>" + authnaSCertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "encryptionCertAlias" + "\">\n" + "            <Value>" + authnaECertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "assertionIDRequestMapper" + "\">\n" + "            <Value>com.sun.identity.saml2.plugins.DefaultAssertionIDRequestMapper" + "</Value>\n" + "        </Attribute>\n" + "    </AuthnAuthorityConfig>\n");
    }

    private static void buildAffiliationConfigTemplate(StringBuffer buff, String affiAlias, String url, Map mapParams) {
        String affiECertAlias = (String)mapParams.get("affiecert");
        String affiSCertAlias = (String)mapParams.get("affiscert");
        if (affiECertAlias == null) {
            affiECertAlias = "";
        }
        if (affiSCertAlias == null) {
            affiSCertAlias = "";
        }
        buff.append("    <AffiliationConfig metaAlias=\"" + affiAlias + "\">\n" + "        <Attribute name=\"" + "signingCertAlias" + "\">\n" + "            <Value>" + affiSCertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "encryptionCertAlias" + "\">\n" + "            <Value>" + affiECertAlias + "</Value>\n" + "        </Attribute>\n" + "    </AffiliationConfig>\n");
    }

    private static void buildPDPConfigTemplate(StringBuffer buff, String pdpAlias, Map mapParams) {
        String pdpECertAlias = (String)mapParams.get("pdpecert");
        String pdpSCertAlias = (String)mapParams.get("pdpscert");
        if (pdpECertAlias == null) {
            pdpECertAlias = "";
        }
        if (pdpSCertAlias == null) {
            pdpSCertAlias = "";
        }
        buff.append("    <XACMLPDPConfig metaAlias=\"" + pdpAlias + "\">\n" + "        <Attribute name=\"" + "signingCertAlias" + "\">\n" + "            <Value>" + pdpSCertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "encryptionCertAlias" + "\">\n" + "            <Value>" + pdpECertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthOn" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthUser" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthPassword" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "wantXACMLAuthzDecisionQuerySigned" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "cotlist" + "\">\n" + "        </Attribute>\n" + "   </XACMLPDPConfig>\n");
    }

    private static void buildPEPConfigTemplate(StringBuffer buff, String pepAlias, Map mapParams) {
        String pepECertAlias = (String)mapParams.get("pepecert");
        String pepSCertAlias = (String)mapParams.get("pepscert");
        if (pepECertAlias == null) {
            pepECertAlias = "";
        }
        if (pepSCertAlias == null) {
            pepSCertAlias = "";
        }
        buff.append("   <XACMLAuthzDecisionQueryConfig metaAlias=\"" + pepAlias + "\">\n" + "        <Attribute name=\"" + "signingCertAlias" + "\">\n" + "            <Value>" + pepSCertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "encryptionCertAlias" + "\">\n" + "            <Value>" + pepECertAlias + "</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthOn" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthUser" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "basicAuthPassword" + "\">\n" + "            <Value></Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "wantXACMLAuthzDecisionResponseSigned" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "wantAssertionEncrypted" + "\">\n" + "            <Value>false</Value>\n" + "        </Attribute>\n" + "        <Attribute name=\"" + "cotlist" + "\">\n" + "        </Attribute>\n" + "  </XACMLAuthzDecisionQueryConfig>\n");
    }

    public static String buildMetaDataTemplate(String entityID, Map mapParams, String url) throws SAML2MetaException {
        String pepAlias;
        String pdpAlias;
        String affiAlias;
        String authnaAlias;
        String attrqAlias;
        String attraAlias;
        String spAlias;
        StringBuffer buff = new StringBuffer();
        if (url == null) {
            url = CreateSAML2HostedProviderTemplate.getHostURL();
        }
        buff.append("<EntityDescriptor\n    xmlns=\"urn:oasis:names:tc:SAML:2.0:metadata\"\n    entityID=\"" + entityID + "\">\n");
        String idpAlias = (String)mapParams.get("idp");
        if (idpAlias != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)idpAlias);
            CreateSAML2HostedProviderTemplate.addIdentityProviderTemplate(buff, idpAlias, url, mapParams);
        }
        if ((spAlias = (String)mapParams.get("sp")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)spAlias);
            CreateSAML2HostedProviderTemplate.addServiceProviderTemplate(buff, spAlias, url, mapParams);
        }
        if ((attraAlias = (String)mapParams.get("attra")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)attraAlias);
            CreateSAML2HostedProviderTemplate.addAttributeAuthorityTemplate(buff, attraAlias, url, mapParams);
        }
        if ((attrqAlias = (String)mapParams.get("attrq")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)attrqAlias);
            CreateSAML2HostedProviderTemplate.addAttributeQueryTemplate(buff, attrqAlias, url, mapParams);
        }
        if ((authnaAlias = (String)mapParams.get("authna")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)authnaAlias);
            CreateSAML2HostedProviderTemplate.addAuthnAuthorityTemplate(buff, authnaAlias, url, mapParams);
        }
        if ((affiAlias = (String)mapParams.get("affiliation")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)affiAlias);
            String affiOwnerID = (String)mapParams.get("affiOwnerID");
            CreateSAML2HostedProviderTemplate.addAffiliationTemplate(buff, affiOwnerID, affiAlias, url, mapParams);
        }
        if ((pdpAlias = (String)mapParams.get("pdp")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)pdpAlias);
            CreateSAML2HostedProviderTemplate.addPDPTemplate(buff, pdpAlias, url, mapParams);
        }
        if ((pepAlias = (String)mapParams.get("pep")) != null) {
            String realm = SAML2MetaUtils.getRealmByMetaAlias((String)pepAlias);
            CreateSAML2HostedProviderTemplate.addPEPTemplate(buff, url, mapParams);
        }
        buff.append("</EntityDescriptor>\n");
        return buff.toString();
    }

    private static void addIdentityProviderTemplate(StringBuffer buff, String idpAlias, String url, Map mapParams) throws SAML2MetaException {
        String idpEX509Cert;
        String maStr = CreateSAML2HostedProviderTemplate.buildMetaAliasInURI(idpAlias);
        buff.append("    <IDPSSODescriptor\n        WantAuthnRequestsSigned=\"false\"\n        protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">\n");
        String idpSCertAlias = (String)mapParams.get("idpscert");
        String idpECertAlias = (String)mapParams.get("idpecert");
        String idpSX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)idpSCertAlias);
        if (idpSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + idpSX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "        </KeyDescriptor>\n");
        }
        if ((idpEX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)idpECertAlias)) != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + idpEX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "            <EncryptionMethod Algorithm=" + "\"http://www.w3.org/2001/04/xmlenc#aes128-cbc\">\n" + "                <KeySize xmlns=\"" + "http://www.w3.org/2001/04/xmlenc#" + "\">" + "128</KeySize>\n" + "            </EncryptionMethod>\n" + "        </KeyDescriptor>\n");
        }
        buff.append("        <ArtifactResolutionService\n            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n            Location=\"" + url + "/ArtifactResolver" + maStr + "\"\n" + "            index=\"0\"\n" + "            isDefault=\"1\"/>\n" + "        <SingleLogoutService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\"\n" + "            Location=\"" + url + "/IDPSloRedirect" + maStr + "\"\n" + "            ResponseLocation=\"" + url + "/IDPSloRedirect" + maStr + "\"/>\n" + "        <SingleLogoutService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n" + "            Location=\"" + url + "/IDPSloPOST" + maStr + "\"\n" + "            ResponseLocation=\"" + url + "/IDPSloPOST" + maStr + "\"/>\n" + "        <SingleLogoutService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/IDPSloSoap" + maStr + "\"/>\n" + "        <ManageNameIDService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\"\n" + "            Location=\"" + url + "/IDPMniRedirect" + maStr + "\"\n" + "            ResponseLocation=\"" + url + "/IDPMniRedirect" + maStr + "\"/>\n" + "        <ManageNameIDService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n" + "            Location=\"" + url + "/IDPMniPOST" + maStr + "\"\n" + "            ResponseLocation=\"" + url + "/IDPMniPOST" + maStr + "\"/>\n" + "        <ManageNameIDService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/IDPMniSoap" + maStr + "\"/>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:2.0:nameid-format:transient" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "          " + "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName" + "\n" + "        </NameIDFormat>\n" + "        <SingleSignOnService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\"\n" + "            Location=\"" + url + "/SSORedirect" + maStr + "\"/>\n" + "        <SingleSignOnService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n" + "            Location=\"" + url + "/SSOPOST" + maStr + "\"/>\n" + "        <SingleSignOnService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/SSOSoap" + maStr + "\"/>\n" + "        <NameIDMappingService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/NIMSoap" + maStr + "\"/>\n" + "        <AssertionIDRequestService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/AIDReqSoap/" + "IDPRole" + maStr + "\"/>\n" + "        <AssertionIDRequestService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:URI\"\n" + "            Location=\"" + url + "/AIDReqUri/" + "IDPRole" + maStr + "\"/>\n" + "    </IDPSSODescriptor>\n");
    }

    private static void addServiceProviderTemplate(StringBuffer buff, String spAlias, String url, Map mapParams) throws SAML2MetaException {
        String maStr = CreateSAML2HostedProviderTemplate.buildMetaAliasInURI(spAlias);
        buff.append("    <SPSSODescriptor\n        AuthnRequestsSigned=\"false\"\n        WantAssertionsSigned=\"false\"\n        protocolSupportEnumeration=\n            \"urn:oasis:names:tc:SAML:2.0:protocol\">\n");
        String spSCertAlias = (String)mapParams.get("spscert");
        String spECertAlias = (String)mapParams.get("specert");
        String spSX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)spSCertAlias);
        String spEX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)spECertAlias);
        if (spSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + spSX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "        </KeyDescriptor>\n");
        }
        if (spEX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + spEX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "            <EncryptionMethod Algorithm=" + "\"http://www.w3.org/2001/04/xmlenc#aes128-cbc\">\n" + "                <KeySize xmlns=\"" + "http://www.w3.org/2001/04/xmlenc#" + "\">" + "128</KeySize>\n" + "            </EncryptionMethod>\n" + "        </KeyDescriptor>\n");
        }
        buff.append("        <SingleLogoutService\n            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\"\n            Location=\"" + url + "/SPSloRedirect" + maStr + "\"\n" + "            ResponseLocation=\"" + url + "/SPSloRedirect" + maStr + "\"/>\n" + "        <SingleLogoutService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n" + "            Location=\"" + url + "/SPSloPOST" + maStr + "\"\n" + "            ResponseLocation=\"" + url + "/SPSloPOST" + maStr + "\"/>\n" + "        <SingleLogoutService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/SPSloSoap" + maStr + "\"/>\n" + "        <ManageNameIDService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\"\n" + "            Location=\"" + url + "/SPMniRedirect" + maStr + "\"\n" + "            ResponseLocation=\"" + url + "/SPMniRedirect" + maStr + "\"/>\n" + "        <ManageNameIDService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n" + "            Location=\"" + url + "/SPMniPOST" + maStr + "\"\n" + "            ResponseLocation=\"" + url + "/SPMniPOST" + maStr + "\"/>\n" + "        <ManageNameIDService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/SPMniSoap" + maStr + "\"\n" + "            ResponseLocation=\"" + url + "/SPMniSoap" + maStr + "\"/>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:2.0:nameid-format:transient" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "          " + "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos" + "\n" + "        </NameIDFormat>\n" + "        <NameIDFormat>\n" + "            " + "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName" + "\n" + "        </NameIDFormat>\n" + "        <AssertionConsumerService\n" + "            isDefault=\"true\"\n" + "            index=\"0\"\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact\"\n" + "            Location=\"" + url + "/Consumer" + maStr + "\"/>\n" + "        <AssertionConsumerService\n" + "            index=\"1\"\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n" + "            Location=\"" + url + "/Consumer" + maStr + "\"/>\n" + "        <AssertionConsumerService\n" + "            index=\"2\"\n" + "            Binding=\"" + "urn:oasis:names:tc:SAML:2.0:bindings:PAOS" + "\"\n" + "            Location=\"" + url + "/Consumer/ECP" + maStr + "\"/>\n" + "    </SPSSODescriptor>\n");
    }

    private static void addAttributeAuthorityTemplate(StringBuffer buff, String attraAlias, String url, Map mapParams) throws SAML2MetaException {
        String attraEX509Cert;
        String maStr = CreateSAML2HostedProviderTemplate.buildMetaAliasInURI(attraAlias);
        buff.append("    <AttributeAuthorityDescriptor\n        protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">\n");
        String attraECertAlias = (String)mapParams.get("attraecert");
        String attraSCertAlias = (String)mapParams.get("attrascert");
        String attraSX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)attraSCertAlias);
        if (attraSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + attraSX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "        </KeyDescriptor>\n");
        }
        if ((attraEX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)attraECertAlias)) != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + attraEX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "            <EncryptionMethod Algorithm=" + "\"http://www.w3.org/2001/04/xmlenc#aes128-cbc\">\n" + "                <KeySize xmlns=\"" + "http://www.w3.org/2001/04/xmlenc#" + "\">" + "128</KeySize>\n" + "            </EncryptionMethod>\n" + "        </KeyDescriptor>\n");
        }
        buff.append("        <AttributeService\n            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n            Location=\"" + url + "/AttributeServiceSoap/" + "default" + maStr + "\"/>\n" + "        <AttributeService\n" + "            xmlns:x509qry=\"urn:oasis:names:tc:SAML:metadata:X509:query\"\n" + "            x509qry:supportsX509Query=\"true\"\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/AttributeServiceSoap/" + "x509Subject" + maStr + "\"/>\n" + "        <AssertionIDRequestService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/AIDReqSoap/" + "AttrAuthRole" + maStr + "\"/>\n" + "        <AssertionIDRequestService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:URI\"\n" + "            Location=\"" + url + "/AIDReqUri/" + "AttrAuthRole" + maStr + "\"/>\n" + "        <AttributeProfile>" + "urn:oasis:names:tc:SAML:2.0:profiles:attribute:basic" + "</AttributeProfile>\n" + "    </AttributeAuthorityDescriptor>\n");
    }

    private static void addAttributeQueryTemplate(StringBuffer buff, String attrqAlias, String url, Map mapParams) throws SAML2MetaException {
        String maStr = CreateSAML2HostedProviderTemplate.buildMetaAliasInURI(attrqAlias);
        buff.append("    <RoleDescriptor\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xmlns:query=\"urn:oasis:names:tc:SAML:metadata:ext:query\"\n        xsi:type=\"query:AttributeQueryDescriptorType\"\n        protocolSupportEnumeration=\n            \"urn:oasis:names:tc:SAML:2.0:protocol\">\n");
        String attrqSCertAlias = (String)mapParams.get("attrqscert");
        String attrqECertAlias = (String)mapParams.get("attrqecert");
        String attrqSX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)attrqSCertAlias);
        String attrqEX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)attrqECertAlias);
        if (attrqSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + attrqSX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "        </KeyDescriptor>\n");
        }
        if (attrqEX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + attrqEX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "            <EncryptionMethod Algorithm=" + "\"http://www.w3.org/2001/04/xmlenc#aes128-cbc\">\n" + "                <KeySize xmlns=\"" + "http://www.w3.org/2001/04/xmlenc#" + "\">" + "128</KeySize>\n" + "            </EncryptionMethod>\n" + "        </KeyDescriptor>\n");
        }
        buff.append("        <NameIDFormat>\n            urn:oasis:names:tc:SAML:2.0:nameid-format:persistent\n        </NameIDFormat>\n        <NameIDFormat>\n            urn:oasis:names:tc:SAML:2.0:nameid-format:transient\n        </NameIDFormat>\n        <NameIDFormat>\n            urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName\n        </NameIDFormat>\n    </RoleDescriptor>\n");
    }

    private static void addAuthnAuthorityTemplate(StringBuffer buff, String authnaAlias, String url, Map mapParams) throws SAML2MetaException {
        String authnaEX509Cert;
        String maStr = CreateSAML2HostedProviderTemplate.buildMetaAliasInURI(authnaAlias);
        buff.append("    <AuthnAuthorityDescriptor\n        protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">\n");
        String authnaECertAlias = (String)mapParams.get("authnaecert");
        String authnaSCertAlias = (String)mapParams.get("authnascert");
        String authnaSX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)authnaSCertAlias);
        if (authnaSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + authnaSX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "        </KeyDescriptor>\n");
        }
        if ((authnaEX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)authnaECertAlias)) != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + authnaEX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "            <EncryptionMethod Algorithm=" + "\"http://www.w3.org/2001/04/xmlenc#aes128-cbc\">\n" + "                <KeySize xmlns=\"" + "http://www.w3.org/2001/04/xmlenc#" + "\">" + "128</KeySize>\n" + "            </EncryptionMethod>\n" + "        </KeyDescriptor>\n");
        }
        buff.append("        <AuthnQueryService\n            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n            Location=\"" + url + "/AuthnQueryServiceSoap" + maStr + "\"/>\n" + "        <AssertionIDRequestService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\"\n" + "            Location=\"" + url + "/AIDReqSoap/" + "AuthnAuthRole" + maStr + "\"/>\n" + "        <AssertionIDRequestService\n" + "            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:URI\"\n" + "            Location=\"" + url + "/AIDReqUri/" + "AuthnAuthRole" + maStr + "\"/>\n" + "    </AuthnAuthorityDescriptor>\n");
    }

    private static void addAffiliationTemplate(StringBuffer buff, String affiOwnerID, String affiAlias, String url, Map mapParams) throws SAML2MetaException {
        String affiEX509Cert;
        String maStr = CreateSAML2HostedProviderTemplate.buildMetaAliasInURI(affiAlias);
        buff.append("    <AffiliationDescriptor\n        affiliationOwnerID=\"" + affiOwnerID + "\">\n");
        List affiMembers = (List)mapParams.get("affimembers");
        for (String affiMember : affiMembers) {
            buff.append("        <AffiliateMember>" + affiMember + "</AffiliateMember>\n");
        }
        String affiECertAlias = (String)mapParams.get("affiecert");
        String affiSCertAlias = (String)mapParams.get("affiscert");
        String affiSX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)affiSCertAlias);
        if (affiSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + affiSX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "        </KeyDescriptor>\n");
        }
        if ((affiEX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)affiECertAlias)) != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + affiEX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "            <EncryptionMethod Algorithm=" + "\"http://www.w3.org/2001/04/xmlenc#aes128-cbc\">\n" + "                <KeySize xmlns=\"" + "http://www.w3.org/2001/04/xmlenc#" + "\">" + "128</KeySize>\n" + "            </EncryptionMethod>\n" + "        </KeyDescriptor>\n");
        }
        buff.append("    </AffiliationDescriptor>\n");
    }

    private static void addPDPTemplate(StringBuffer buff, String pdpAlias, String url, Map mapParams) throws SAML2MetaException {
        String maStr = CreateSAML2HostedProviderTemplate.buildMetaAliasInURI(pdpAlias);
        buff.append("    <XACMLPDPDescriptor protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">\n");
        String pdpECertAlias = (String)mapParams.get("pdpecert");
        String pdpSCertAlias = (String)mapParams.get("pdpscert");
        String pdpSX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)pdpSCertAlias);
        String pdpEX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)pdpECertAlias);
        if (pdpSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + pdpSX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "        </KeyDescriptor>\n");
        }
        if (pdpEX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + pdpEX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "            <EncryptionMethod Algorithm=" + "\"http://www.w3.org/2001/04/xmlenc#aes128-cbc\">\n" + "                <KeySize xmlns=\"" + "http://www.w3.org/2001/04/xmlenc#" + "\">" + "128</KeySize>\n" + "            </EncryptionMethod>\n" + "        </KeyDescriptor>\n");
        }
        buff.append("         <XACMLAuthzService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:SOAP\" Location=\"" + url + "/saml2query" + maStr + "\"/>\n" + "    </XACMLPDPDescriptor>\n");
    }

    private static void addPEPTemplate(StringBuffer buff, String url, Map mapParams) throws SAML2MetaException {
        buff.append("    <XACMLAuthzDecisionQueryDescriptor WantAssertionsSigned=\"false\" protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">\n");
        String pepECertAlias = (String)mapParams.get("pepecert");
        String pepSCertAlias = (String)mapParams.get("pepscert");
        String pepSX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)pepSCertAlias);
        String pepEX509Cert = SAML2MetaSecurityUtils.buildX509Certificate((String)pepECertAlias);
        if (pepSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + pepSX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "        </KeyDescriptor>\n");
        }
        if (pepEX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n            <KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n                <X509Data>\n                    <X509Certificate>\n" + pepEX509Cert + "                    </X509Certificate>\n" + "                </X509Data>\n" + "            </KeyInfo>\n" + "            <EncryptionMethod Algorithm=" + "\"http://www.w3.org/2001/04/xmlenc#aes128-cbc\">\n" + "                <KeySize xmlns=\"" + "http://www.w3.org/2001/04/xmlenc#" + "\">" + "128</KeySize>\n" + "            </EncryptionMethod>\n" + "        </KeyDescriptor>\n");
        }
        buff.append("    </XACMLAuthzDecisionQueryDescriptor>\n");
    }

    private static String buildMetaAliasInURI(String alias) {
        return "/metaAlias" + alias;
    }
}

