
/*
 * JBoss, a division of Red Hat
 * Copyright 2010, Red Hat Middleware, LLC, and individual
 * contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of
 * individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.oasis.wsrp.v1;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.0
 * 
 */
@WebService(name = "WSRP_v1_PortletManagement_PortType", targetNamespace = "urn:oasis:names:tc:wsrp:v1:intf")
public interface WSRPV1PortletManagementPortType {


    /**
     * 
     * @param portletDescription
     * @param resourceList
     * @param registrationContext
     * @param portletContext
     * @param userContext
     * @param desiredLocales
     * @param extensions
     * @throws V1OperationFailed
     * @throws V1InvalidRegistration
     * @throws V1AccessDenied
     * @throws V1InvalidHandle
     * @throws V1InconsistentParameters
     * @throws V1MissingParameters
     * @throws V1InvalidUserCategory
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:getPortletDescription")
    @RequestWrapper(localName = "getPortletDescription", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1GetPortletDescription")
    @ResponseWrapper(localName = "getPortletDescriptionResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1PortletDescriptionResponse")
    public void getPortletDescription(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "portletContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1PortletContext portletContext,
        @WebParam(name = "userContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1UserContext userContext,
        @WebParam(name = "desiredLocales", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        List<String> desiredLocales,
        @WebParam(name = "portletDescription", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1PortletDescription> portletDescription,
        @WebParam(name = "resourceList", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1ResourceList> resourceList,
        @WebParam(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Extension>> extensions)
        throws V1AccessDenied, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1MissingParameters, V1OperationFailed
    ;

    /**
     * 
     * @param portletHandle
     * @param registrationContext
     * @param portletContext
     * @param portletState
     * @param userContext
     * @param extensions
     * @throws V1OperationFailed
     * @throws V1InvalidRegistration
     * @throws V1AccessDenied
     * @throws V1InvalidHandle
     * @throws V1InconsistentParameters
     * @throws V1MissingParameters
     * @throws V1InvalidUserCategory
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:clonePortlet")
    @RequestWrapper(localName = "clonePortlet", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1ClonePortlet")
    @ResponseWrapper(localName = "clonePortletResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1PortletContext")
    public void clonePortlet(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "portletContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1PortletContext portletContext,
        @WebParam(name = "userContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1UserContext userContext,
        @WebParam(name = "portletHandle", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<String> portletHandle,
        @WebParam(name = "portletState", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<byte[]> portletState,
        @WebParam(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Extension>> extensions)
        throws V1AccessDenied, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1MissingParameters, V1OperationFailed
    ;

    /**
     * 
     * @param destroyFailed
     * @param portletHandles
     * @param registrationContext
     * @param extensions
     * @throws V1OperationFailed
     * @throws V1InvalidRegistration
     * @throws V1InconsistentParameters
     * @throws V1MissingParameters
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:destroyPortlets")
    @RequestWrapper(localName = "destroyPortlets", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1DestroyPortlets")
    @ResponseWrapper(localName = "destroyPortletsResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1DestroyPortletsResponse")
    public void destroyPortlets(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "portletHandles", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        List<String> portletHandles,
        @WebParam(name = "destroyFailed", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1DestroyFailed>> destroyFailed,
        @WebParam(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Extension>> extensions)
        throws V1InconsistentParameters, V1InvalidRegistration, V1MissingParameters, V1OperationFailed
    ;

    /**
     * 
     * @param portletHandle
     * @param registrationContext
     * @param portletContext
     * @param portletState
     * @param propertyList
     * @param userContext
     * @param extensions
     * @throws V1OperationFailed
     * @throws V1InvalidRegistration
     * @throws V1AccessDenied
     * @throws V1InvalidHandle
     * @throws V1InconsistentParameters
     * @throws V1MissingParameters
     * @throws V1InvalidUserCategory
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:setPortletProperties")
    @RequestWrapper(localName = "setPortletProperties", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1SetPortletProperties")
    @ResponseWrapper(localName = "setPortletPropertiesResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1PortletContext")
    public void setPortletProperties(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "portletContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1PortletContext portletContext,
        @WebParam(name = "userContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1UserContext userContext,
        @WebParam(name = "propertyList", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1PropertyList propertyList,
        @WebParam(name = "portletHandle", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<String> portletHandle,
        @WebParam(name = "portletState", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<byte[]> portletState,
        @WebParam(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Extension>> extensions)
        throws V1AccessDenied, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1MissingParameters, V1OperationFailed
    ;

    /**
     * 
     * @param resetProperties
     * @param registrationContext
     * @param names
     * @param portletContext
     * @param userContext
     * @param properties
     * @param extensions
     * @throws V1OperationFailed
     * @throws V1InvalidRegistration
     * @throws V1AccessDenied
     * @throws V1InvalidHandle
     * @throws V1InconsistentParameters
     * @throws V1MissingParameters
     * @throws V1InvalidUserCategory
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:getPortletProperties")
    @RequestWrapper(localName = "getPortletProperties", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1GetPortletProperties")
    @ResponseWrapper(localName = "getPortletPropertiesResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1PropertyList")
    public void getPortletProperties(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "portletContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1PortletContext portletContext,
        @WebParam(name = "userContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1UserContext userContext,
        @WebParam(name = "names", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        List<String> names,
        @WebParam(name = "properties", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Property>> properties,
        @WebParam(name = "resetProperties", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1ResetProperty>> resetProperties,
        @WebParam(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Extension>> extensions)
        throws V1AccessDenied, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1MissingParameters, V1OperationFailed
    ;

    /**
     * 
     * @param modelDescription
     * @param resourceList
     * @param registrationContext
     * @param portletContext
     * @param userContext
     * @param desiredLocales
     * @param extensions
     * @throws V1OperationFailed
     * @throws V1InvalidRegistration
     * @throws V1AccessDenied
     * @throws V1InvalidHandle
     * @throws V1InconsistentParameters
     * @throws V1MissingParameters
     * @throws V1InvalidUserCategory
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:getPortletPropertyDescription")
    @RequestWrapper(localName = "getPortletPropertyDescription", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1GetPortletPropertyDescription")
    @ResponseWrapper(localName = "getPortletPropertyDescriptionResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1PortletPropertyDescriptionResponse")
    public void getPortletPropertyDescription(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "portletContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1PortletContext portletContext,
        @WebParam(name = "userContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1UserContext userContext,
        @WebParam(name = "desiredLocales", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        List<String> desiredLocales,
        @WebParam(name = "modelDescription", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1ModelDescription> modelDescription,
        @WebParam(name = "resourceList", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1ResourceList> resourceList,
        @WebParam(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Extension>> extensions)
        throws V1AccessDenied, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1MissingParameters, V1OperationFailed
    ;

}
