/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;

public class ListEntities
extends AuthenticatedCommand {
    private String realm;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.superAdminUserValidation();
        this.realm = this.getStringOptionValue("realm", "/");
        String spec = FederationManager.getIDFFSubCommandSpecification(rc);
        String[] params = new String[]{this.realm, spec};
        this.writeLog(0, Level.INFO, "ATTEMPT_LIST_ENTITIES", params);
        if (spec.equals("saml2")) {
            this.handleSAML2Request(rc);
            this.writeLog(0, Level.INFO, "SUCCEEDED_LIST_ENTITIES", params);
        } else if (spec.equals("idff")) {
            this.handleIDFFRequest(rc);
            this.writeLog(0, Level.INFO, "SUCCEEDED_LIST_ENTITIES", params);
        } else if (spec.equals("wsfed")) {
            this.handleWSFedRequest(rc);
            this.writeLog(0, Level.INFO, "SUCCEEDED_LIST_ENTITIES", params);
        } else {
            String[] args = new String[]{this.realm, this.getResourceString("unsupported-specification")};
            this.writeLog(1, Level.INFO, "FAILED_LIST_ENTITIES", args);
            throw new CLIException(this.getResourceString("unsupported-specification"), 127);
        }
    }

    private void handleSAML2Request(RequestContext rc) throws CLIException {
        IOutput outputWriter = this.getOutputWriter();
        Object[] objs = new Object[]{this.realm};
        try {
            SAML2MetaManager metaManager = new SAML2MetaManager();
            Set entities = metaManager.getAllEntities(this.realm);
            if (entities == null || entities.isEmpty()) {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-no-entities"), objs));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-entity-listing"), objs));
                for (String name : entities) {
                    outputWriter.printlnMessage("  " + name);
                }
            }
        }
        catch (SAML2MetaException e) {
            this.debugWarning("ListEntities.handleRequest", e);
            String[] args = new String[]{this.realm, e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_LIST_ENTITIES", args);
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleIDFFRequest(RequestContext rc) throws CLIException {
        IOutput outputWriter = this.getOutputWriter();
        Object[] objs = new Object[]{this.realm};
        try {
            IDFFMetaManager metaManager = new IDFFMetaManager((Object)this.getAdminSSOToken());
            Set entities = metaManager.getAllEntities(this.realm);
            if (entities == null || entities.isEmpty()) {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-no-entities"), objs));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-entity-listing"), objs));
                for (String name : entities) {
                    outputWriter.printlnMessage("  " + name);
                }
            }
        }
        catch (IDFFMetaException e) {
            this.debugWarning("ListEntities.handleIDFFRequest", e);
            String[] args = new String[]{this.realm, e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_LIST_ENTITIES", args);
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleWSFedRequest(RequestContext rc) throws CLIException {
        IOutput outputWriter = this.getOutputWriter();
        Object[] objs = new Object[]{this.realm};
        try {
            Set entities = WSFederationMetaManager.getAllEntities((String)this.realm);
            if (entities == null || entities.isEmpty()) {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-no-entities"), objs));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-entity-listing"), objs));
                for (String name : entities) {
                    outputWriter.printlnMessage("  " + name);
                }
            }
        }
        catch (WSFederationMetaException e) {
            this.debugWarning("ListEntities.handleRequest", e);
            String[] args = new String[]{this.realm, e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_LIST_ENTITIES", args);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

