/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts;

import com.iplanet.sso.SSOToken;
import com.sun.identity.classloader.FAMClassLoader;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.logging.LogUtil;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.provider.STSConfig;
import com.sun.identity.wss.provider.TrustAuthorityConfig;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.FAMSecurityToken;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.UserNameToken;
import com.sun.identity.wss.security.handler.SOAPRequestHandler;
import com.sun.identity.wss.sts.ClientUserToken;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.STSConstants;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.identity.wss.trust.RequestSecurityToken;
import com.sun.identity.wss.trust.RequestSecurityTokenResponse;
import com.sun.identity.wss.trust.RequestSecurityTokenResponseCollection;
import com.sun.identity.wss.trust.WSTException;
import com.sun.identity.wss.trust.WSTrustFactory;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TrustAuthorityClient {
    private static Debug debug = STSUtils.debug;
    private static Class clientTokenClass;
    public static String[] jars;

    public SecurityToken getSecurityToken(ProviderConfig pc, Object credential) throws FAMSTSException {
        return this.getSecurityToken(pc, null, null, null, credential, null, null, null);
    }

    public SecurityToken getSecurityToken(ProviderConfig pc, Object credential, ServletContext context) throws FAMSTSException {
        return this.getSecurityToken(pc, null, null, null, credential, null, null, context);
    }

    public SecurityToken getSecurityToken(String wspEndPoint, String stsEndPoint, String stsMexEndPoint, Object credential, String securityMech, ServletContext context) throws FAMSTSException {
        return this.getSecurityToken(null, wspEndPoint, stsEndPoint, stsMexEndPoint, credential, securityMech, null, context);
    }

    public SecurityToken getSecurityToken(String wspEndPoint, String stsEndPoint, String stsMexEndPoint, Object credential, String securityMech, String tokenType, ServletContext context) throws FAMSTSException {
        return this.getSecurityToken(null, wspEndPoint, stsEndPoint, stsMexEndPoint, credential, securityMech, tokenType, context);
    }

    private SecurityToken getSecurityToken(ProviderConfig pc, String wspEndPoint, String stsEndPoint, String stsMexEndPoint, Object credential, String securityMech, String tokenType, ServletContext context) throws FAMSTSException {
        String keyType = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey";
        String stsAgentName = null;
        String wstVersion = "1.3";
        if (pc != null) {
            String stsSecMech;
            List securityMechanisms = pc.getSecurityMechanisms();
            if (securityMechanisms == null || securityMechanisms.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("TrustAuthorityClient.getSecurityToken::Security Mechanisms are not configured");
                }
                return null;
            }
            securityMech = (String)securityMechanisms.get(0);
            STSConfig stsConfig = null;
            TrustAuthorityConfig taconfig = pc.getTrustAuthorityConfig();
            if (!(taconfig instanceof STSConfig)) {
                throw new FAMSTSException(STSUtils.bundle.getString("invalidtaconfig"));
            }
            stsConfig = (STSConfig)taconfig;
            stsAgentName = stsConfig.getName();
            stsEndPoint = stsConfig.getEndpoint();
            stsMexEndPoint = stsConfig.getMexEndpoint();
            wstVersion = stsConfig.getProtocolVersion();
            if ("1.0".equals(wstVersion)) {
                keyType = "http://schemas.xmlsoap.org/ws/2005/02/trust/PublicKey";
            }
            if ((stsSecMech = (String)stsConfig.getSecurityMech().get(0)).equals("urn:sun:wss:security:null:KerberosToken") || stsSecMech.equals("urn:sun:wss:security:null:UserNameToken-Plain") || stsSecMech.equals("urn:sun:wss:security:null:UserNameToken") || stsSecMech.equals("urn:sun:wss:security:null:SAML2Token-SV") || stsSecMech.equals("urn:sun:wss:security:null:SAMLToken-SV") || stsSecMech.equals("urn:sun:wss:sts:security")) {
                keyType = "1.0".equals(wstVersion) ? "http://schemas.xmlsoap.org/ws/2005/05/identity/NoProofKey" : "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";
            }
            wspEndPoint = pc.getWSPEndpoint();
        } else {
            String stsSecMechTemp;
            Set values;
            Map attrMap = STSUtils.getAgentAttributes(stsEndPoint, "STSEndpoint", null, "STSAgent");
            stsAgentName = (String)attrMap.get("Name");
            Set versionSet = (Set)attrMap.get("WSTrustVersion");
            wstVersion = (String)versionSet.iterator().next();
            if (wstVersion == null || wstVersion.length() == 0) {
                wstVersion = "1.3";
            }
            if ("1.0".equals(wstVersion)) {
                keyType = "http://schemas.xmlsoap.org/ws/2005/02/trust/PublicKey";
            }
            if ((values = (Set)attrMap.get("SecurityMech")) != null && !values.isEmpty() && ((stsSecMechTemp = (String)values.iterator().next()).equals("urn:sun:wss:security:null:KerberosToken") || stsSecMechTemp.equals("urn:sun:wss:security:null:UserNameToken-Plain") || stsSecMechTemp.equals("urn:sun:wss:security:null:UserNameToken") || stsSecMechTemp.equals("urn:sun:wss:security:null:SAML2Token-SV") || stsSecMechTemp.equals("urn:sun:wss:security:null:SAMLToken-SV") || stsSecMechTemp.equals("urn:sun:wss:sts:security"))) {
                keyType = wstVersion.equals("1.0") ? "http://schemas.xmlsoap.org/ws/2005/05/identity/NoProofKey" : "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";
            }
        }
        if (securityMech.equals("urn:sun:wss:sts:security")) {
            String useMetro = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.trustclient.enablemetro", (String)"true");
            if (!Boolean.valueOf(useMetro).booleanValue()) {
                return this.getSTSToken(wspEndPoint, stsEndPoint, stsMexEndPoint, credential, keyType, tokenType, wstVersion, stsAgentName);
            }
            return this.getSTSToken(wspEndPoint, stsEndPoint, stsMexEndPoint, credential, keyType, tokenType, wstVersion, context);
        }
        if (securityMech.equals("urn:sun:liberty:discovery:security")) {
            return this.getLibertyToken(pc, credential);
        }
        debug.error("TrustAuthorityClient.getSecurityTokenInvalid security mechanism to get token from TA");
        return null;
    }

    public SecurityToken renewIssuedToken(SecurityToken securityToken, ProviderConfig pc, Object credential) throws FAMSTSException {
        throw new FAMSTSException("unsupported");
    }

    public boolean cancelIssuedToken(SecurityToken securityToken, ProviderConfig pc) throws FAMSTSException {
        throw new FAMSTSException("unsupported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityToken getSTSToken(String wspEndPoint, String stsEndpoint, String stsMexAddress, Object credential, String keyType, String tokenType, String wstVersion, ServletContext context) throws FAMSTSException {
        if (debug.messageEnabled()) {
            debug.message("TrustAuthorityClient.getSTSToken:: stsEndpoint : " + stsEndpoint);
            debug.message("TrustAuthorityClient.getSTSToken:: stsMexAddress : " + stsMexAddress);
            debug.message("TrustAuthorityClient.getSTSToken:: wsp end point : " + wspEndPoint);
            debug.message("TrustAuthorityClient.getSTSToken:: keyType : " + keyType);
        }
        ClassLoader oldcc = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cls = FAMClassLoader.getFAMClassLoader(context, jars);
            Thread.currentThread().setContextClassLoader(cls);
            Class<?> _handlerTrustAuthorityClient = cls.loadClass("com.sun.identity.wss.sts.TrustAuthorityClientImpl");
            Constructor<?> taClientCon = _handlerTrustAuthorityClient.getConstructor(new Class[0]);
            Object stsClient = taClientCon.newInstance(new Object[0]);
            Class[] clsa = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.Object"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
            Method getSTSTokenElement = stsClient.getClass().getDeclaredMethod("getSTSTokenElement", clsa);
            Object[] args = new Object[]{wspEndPoint, stsEndpoint, stsMexAddress, credential, keyType, tokenType, wstVersion};
            Element element = (Element)getSTSTokenElement.invoke(stsClient, args);
            String type = this.getTokenType(element);
            if (debug.messageEnabled()) {
                debug.message("TrustAuthorityClient.getSTSToken:: Token type : " + type);
                debug.message("TrustAuthorityClient.getSTSToken:: Token obtained from STS : " + XMLUtils.print((Node)element));
            }
            if (LogUtil.isLogEnabled()) {
                if (credential != null && credential instanceof SSOToken) {
                    String[] stringArray = new String[]{wspEndPoint, stsEndpoint, stsMexAddress, credential.toString(), keyType, tokenType};
                    LogUtil.access(Level.INFO, "SUCCESS_RETRIEVING_TOKEN_FROM_STS", stringArray, credential);
                } else {
                    String[] stringArray = new String[]{wspEndPoint, stsEndpoint, stsMexAddress, null, keyType, tokenType};
                    LogUtil.access(Level.INFO, "SUCCESS_RETRIEVING_TOKEN_FROM_STS", stringArray, null);
                }
            }
            if (type == null) throw new FAMSTSException(STSUtils.bundle.getString("nulltokentype"));
            if (type.equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                SAML2Token sAML2Token = new SAML2Token(element);
                return sAML2Token;
            }
            if (type.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1")) {
                AssertionToken assertionToken = new AssertionToken(element);
                return assertionToken;
            }
            if (type.equals("urn:sun:wss:ssotoken")) {
                FAMSecurityToken fAMSecurityToken = new FAMSecurityToken(element);
                return fAMSecurityToken;
            }
            if (type.equals("urn:sun:wss:usernametoken")) {
                UserNameToken userNameToken = new UserNameToken(element);
                return userNameToken;
            }
            try {
                throw new FAMSTSException(STSUtils.bundle.getString("unsupportedtokentype"));
            }
            catch (Exception ex) {
                debug.error("TrustAuthorityClient.getSTSToken:: Failed inobtainining STS Token : ", (Throwable)ex);
                String[] data = new String[]{ex.getLocalizedMessage()};
                LogUtil.error(Level.INFO, "ERROR_RETRIEVING_TOKEN_FROM_STS", data, null);
                LogUtil.error(Level.SEVERE, "ERROR_RETRIEVING_TOKEN_FROM_STS", data, null);
                throw new FAMSTSException(STSUtils.bundle.getString("wstrustexception"));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcc);
        }
    }

    private SecurityToken getLibertyToken(ProviderConfig pc, Object ssoToken) throws FAMSTSException {
        throw new FAMSTSException(STSUtils.bundle.getString("unsupportedoperation"));
    }

    private String getTokenType(Element element) throws FAMSTSException {
        String elemName = element.getLocalName();
        if (elemName == null) {
            throw new FAMSTSException(STSUtils.bundle.getString("invalidelementname"));
        }
        if (elemName.equals(STSConstants.ASSERTION_ELEMENT)) {
            String attrValue = element.getNamespaceURI();
            if (attrValue != null && attrValue.length() != 0 && attrValue.equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                return "urn:oasis:names:tc:SAML:2.0:assertion";
            }
            attrValue = element.getNamespaceURI();
            if (attrValue != null && attrValue.length() != 0 && attrValue.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
            }
        } else {
            if (elemName.equals("UsernameToken")) {
                return "urn:sun:wss:usernametoken";
            }
            if (elemName.equals("FAMToken")) {
                return "urn:sun:wss:ssotoken";
            }
            return "getTokenType:NOT IMPLEMENTED TOKEN TYPE";
        }
        return null;
    }

    private SecurityToken getSTSToken(String wspEndPoint, String stsEndPoint, String stsMexEndPoint, Object credential, String keyType, String tokenType, String wstVersion, String stsAgentName) throws FAMSTSException {
        try {
            if (debug.messageEnabled()) {
                debug.message("TrustAuthorityClient.getSTSToken: WS-Trust Parameters: STSEndpoint = " + stsEndPoint + " keyType = " + keyType + " tokenType = " + tokenType + " wstVersion = " + wstVersion + " STSAgentName = " + stsAgentName);
            }
            WSTrustFactory trustFactory = WSTrustFactory.newInstance(wstVersion);
            RequestSecurityToken rst = trustFactory.createRequestSecurityToken();
            rst.setAppliesTo(wspEndPoint);
            rst.setKeyType(keyType);
            String requestType = "http://schemas.xmlsoap.org/ws/2005/02/trust/Issue";
            if ("1.3".equals(wstVersion)) {
                requestType = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue";
            }
            rst.setRequestType(requestType);
            if (credential != null) {
                rst.setOnBehalfOf(this.getClientUserToken(credential));
            }
            rst.setTokenType(tokenType);
            RequestSecurityTokenResponse rstR = this.getTrustResponse(rst, stsEndPoint, stsAgentName, wstVersion, credential);
            Element secTokenE = (Element)rstR.getRequestedSecurityToken().getFirstChild();
            return this.parseSecurityToken(secTokenE);
        }
        catch (WSTException wse) {
            debug.error("TrustAuthorityClient.getSTSToken: Failed in  retrieving Token from STS", (Throwable)wse);
            throw new FAMSTSException(wse.getMessage());
        }
    }

    private RequestSecurityTokenResponse getTrustResponse(RequestSecurityToken rst, String url, String stsAgentName, String wstVersion, Object credential) throws FAMSTSException {
        SOAPMessage soapMsg = STSUtils.prepareSOAPMessage(url, wstVersion);
        if (soapMsg == null) {
            throw new FAMSTSException("nullElement");
        }
        try {
            Node rstE = soapMsg.getSOAPPart().importNode((Node)rst.toDOMElement(), true);
            soapMsg.getSOAPBody().appendChild(rstE);
            SOAPRequestHandler handler = new SOAPRequestHandler();
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("providername", stsAgentName);
            QName serviceQName = new QName(stsAgentName);
            config.put("javax.xml.ws.wsdl.service", serviceQName);
            handler.init(config);
            Subject subject = new Subject();
            if (credential != null) {
                subject.getPrivateCredentials().add(credential);
            }
            SOAPMessage secureMsg = handler.secureRequest(soapMsg, subject, config);
            SOAPMessage response = this.getSOAPResponse(secureMsg, url);
            handler.validateResponse(response, config);
            return this.getRequestSecurityTokenResponse(response, wstVersion);
        }
        catch (SOAPException se) {
            debug.error("TrustAuthorityClient.getTrustResponse:  SOAP Exception", (Throwable)se);
            throw new FAMSTSException(se.getMessage());
        }
        catch (WSTException we) {
            debug.error("TrustAuthorityClient.getTrustResponse:  WST Exception", (Throwable)we);
            throw new FAMSTSException(we.getMessage());
        }
        catch (SecurityException sse) {
            debug.error("TrustAuthorityClient.getTrustResponse:  SecurityException", (Throwable)sse);
            throw new FAMSTSException(sse.getMessage());
        }
    }

    private SOAPMessage getSOAPResponse(SOAPMessage soapMsg, String url) throws FAMSTSException {
        try {
            SOAPClient soapClient = new SOAPClient();
            soapClient.setURL(url);
            String msg = XMLUtils.print((Node)soapMsg.getSOAPPart(), (String)"UTF-8");
            InputStream is = soapClient.call(msg, null, null);
            return STSUtils.createSOAPMessage(is);
        }
        catch (SOAPException se) {
            debug.error("TrustAutorityClient.getSOAPResponse:  soap exception", (Throwable)se);
            throw new FAMSTSException(se.getMessage());
        }
        catch (Exception ex) {
            debug.error("TrustAutorityClient.getSOAPResponse:   exception", (Throwable)ex);
            throw new FAMSTSException(ex.getMessage());
        }
    }

    private RequestSecurityTokenResponse getRequestSecurityTokenResponse(SOAPMessage soapMsg, String wstVersion) throws FAMSTSException {
        try {
            Element rstRC = (Element)soapMsg.getSOAPBody().getFirstChild();
            WSTrustFactory wstFactory = WSTrustFactory.newInstance(wstVersion);
            if ("RequestSecurityTokenResponse".equals(rstRC.getLocalName())) {
                return wstFactory.createRequestSecurityTokenResponse(rstRC);
            }
            RequestSecurityTokenResponseCollection rstRCollection = wstFactory.createRequestSecurityTokenResponseCollection(rstRC);
            List rstResponses = rstRCollection.getRequestSecurityTokenResponses();
            if (rstResponses.size() == 0) {
                throw new FAMSTSException("nullElements");
            }
            return (RequestSecurityTokenResponse)rstResponses.get(0);
        }
        catch (SOAPException se) {
            debug.error("TrustAuthorityClient.getRequestSecurityTokenResponse: soap exception", (Throwable)se);
            throw new FAMSTSException(se.getMessage());
        }
        catch (WSTException we) {
            debug.error("TrustAuthorityClient.getRequestSecurityTokenResponse: wst exception", (Throwable)we);
            throw new FAMSTSException(we.getMessage());
        }
    }

    private SecurityToken parseSecurityToken(Element element) throws FAMSTSException {
        String type = this.getTokenType(element);
        try {
            if (type != null) {
                if (type.equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                    return new SAML2Token(element);
                }
                if (type.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1")) {
                    return new AssertionToken(element);
                }
                if (type.equals("urn:sun:wss:ssotoken")) {
                    return new FAMSecurityToken(element);
                }
                if (type.equals("urn:sun:wss:usernametoken")) {
                    return new UserNameToken(element);
                }
                throw new FAMSTSException(STSUtils.bundle.getString("unsupportedtokentype"));
            }
            throw new FAMSTSException(STSUtils.bundle.getString("nulltokentype"));
        }
        catch (Exception se) {
            debug.error("TrustAuthorityClient.parseSecurityToken: Exception :", (Throwable)se);
            throw new FAMSTSException(se.getMessage());
        }
    }

    private Element getClientUserToken(Object credential) throws FAMSTSException {
        if (clientTokenClass == null) {
            String className = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.sts.clientusertoken", (String)"com.sun.identity.wss.sts.STSClientUserToken");
            try {
                clientTokenClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (Exception ex) {
                debug.error("TrustAuthorityClientImpl.getClientUserToken:Failed in obtaining class", (Throwable)ex);
                throw new FAMSTSException(STSUtils.bundle.getString("initializationFailed"));
            }
        }
        try {
            ClientUserToken userToken = (ClientUserToken)clientTokenClass.newInstance();
            userToken.init(credential);
            if (debug.messageEnabled()) {
                debug.message("TrustAuthorityClientImpl:getClientUserToken: Client User Token : " + userToken);
            }
            return (Element)userToken.getTokenValue();
        }
        catch (Exception ex) {
            debug.error("TrustAuthorityClientImpl.getClientUserToken: Failed in initialization", (Throwable)ex);
            throw new FAMSTSException(STSUtils.bundle.getString("usertokeninitfailed"));
        }
    }

    static {
        jars = new String[]{"webservices-api.jar", "webservices-rt.jar", "webservices-tools.jar", "webservices-extra-api.jar", "webservices-extra.jar", "openssoclientsdk.jar", "openssowssproviders.jar", "xalan.jar", "xercesImpl.jar"};
    }
}

