/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.cli.CLIException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class HttpClient {
    private static final String PROPERTIES = "CLIClient";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_HOST = "host";
    private static final String PROP_PORT = "port";
    private static final String PROP_URI = "deployment-uri";
    private static boolean useCache = Boolean.getBoolean(SystemProperties.get("com.sun.identity.urlconnection.useCache", "false"));

    public static void main(String[] args) {
        try {
            String inputLine;
            URL url = new URL(HttpClient.getServerURL());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setUseCaches(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            PrintWriter out = new PrintWriter(connection.getOutputStream());
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    out.print("&");
                }
                out.print("arg" + i + "=");
                out.print(URLEncoder.encode(args[i], "UTF-8"));
            }
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                System.out.println(inputLine);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CLIException e) {
            System.err.println(e.getMessage());
        }
    }

    private static String getServerURL() throws CLIException {
        ResourceBundle bdl = null;
        try {
            bdl = ResourceBundle.getBundle(PROPERTIES);
        }
        catch (MissingResourceException e) {
            throw new CLIException("CLIClient.properties file not found.", 1);
        }
        try {
            return bdl.getString(PROP_PROTOCOL) + "://" + bdl.getString(PROP_HOST) + ":" + bdl.getString(PROP_PORT) + "/" + bdl.getString(PROP_URI) + "/webcli";
        }
        catch (MissingResourceException e) {
            throw new CLIException("Missing properties in CLIClient.properties.", 1);
        }
    }
}

