/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class AddSubSchema
extends SchemaCommand {
    static final String ARGUMENT_FILENAME = "filename";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String schemaType = this.getStringOptionValue("schematype");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String fileName = this.getStringOptionValue(ARGUMENT_FILENAME);
        if (subSchemaName == null) {
            subSchemaName = "/";
        }
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{serviceName, schemaType, subSchemaName};
        ServiceSchema ss = this.getServiceSchema();
        CommandManager mgr = this.getCommandManager();
        String url = mgr.getWebEnabledURL();
        this.writeLog(0, Level.INFO, "ATTEMPT_ADD_SUB_SCHEMA", params);
        try {
            if (url != null && url.length() > 0) {
                ss.addSubSchema(new ByteArrayInputStream(fileName.getBytes()));
            } else {
                ss.addSubSchema(new FileInputStream(fileName));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_ADD_SUB_SCHEMA", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("add-subschema-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, e.getMessage()};
            this.debugError("AddSubSchema.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_ADD_SUB_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, e.getMessage()};
            this.debugError("AddSubSchema.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_SUB_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        catch (IOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, e.getMessage()};
            this.debugError("AddSubSchema.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_SUB_SCHEMA", args);
            throw new CLIException(e, 127);
        }
    }
}

