/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.util.AMSendMail;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.spi.AMAuthCallBackException;
import com.sun.identity.authentication.spi.AMAuthCallBackImpl;
import com.sun.identity.common.AccountLockoutInfo;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.MessagingException;

public class ISAccountLockout {
    private static final String USER_STATUS_ATTR = "inetuserstatus";
    private static final String USER_ACTIVE = "Active";
    private static final String USER_INACTIVE = "Inactive";
    private static final String SPACE_DELIM = " ";
    private static final String PIPE_DELIM = "|";
    private static final String FROM_ADDRESS = "lockOutEmailFrom";
    private static final String EMAIL_SUBJECT = "lockOutEmailSub";
    private static final String EMAIL_MESSAGE = "lockOutEmailMsg";
    private static final String INVALID_ATTEMPTS_XML_OBJECT_CLASS = "sunAMAuthAccountLockout";
    private static final String DEFAULT_INVALID_ATTEMPTS_XML_ATTR = "sunAMAuthInvalidAttemptsData";
    private static final String BEGIN_XML = "<InvalidPassword>";
    private static final String INVALID_PASS_COUNT_BEGIN = "<InvalidCount>";
    private static final String INVALID_PASS_COUNT_END = "</InvalidCount>";
    private static final String LAST_FAILED_BEGIN = "<LastInvalidAt>";
    private static final String LAST_FAILED_END = "</LastInvalidAt>";
    private static final String LOCKEDOUT_AT_BEGIN = "<LockedoutAt>";
    private static final String LOCKEDOUT_AT_END = "</LockedoutAt>";
    private static final String ACTUAL_LOCKOUT_DURATION_BEGIN = "<ActualLockoutDuration>";
    private static final String ACTUAL_LOCKOUT_DURATION_END = "</ActualLockoutDuration>";
    private static final String END_XML = "</InvalidPassword>";
    private boolean failureLockoutMode = false;
    private boolean memoryLocking = false;
    private boolean storeInvalidAttemptsInDS = true;
    private long failureLockoutTime = 300L;
    private int failureLockoutCount = 5;
    private String lockoutNotification = null;
    private int lockoutUserWarning = 3;
    private int userWarningCount = 0;
    private long failureLockoutDuration = 0L;
    private int failureLockoutMultiplier = 1;
    private String lockoutAttrValue = null;
    private String lockoutAttrName = null;
    private String bundleName = null;
    private String invalidAttemptsDataAttrName = "sunAMAuthInvalidAttemptsData";
    private boolean needToSetInvalidAttemptsObjectClass = true;
    static Debug debug = Debug.getInstance((String)"amAccountLockout");
    private AMAuthCallBackImpl callbackImpl = null;
    static Map loginFailHash = Collections.synchronizedMap(new HashMap());

    public ISAccountLockout(boolean failureLockoutMode, long failureLockoutTime, int failureLockoutCount, String lockoutNotification, int lockoutUserWarning, String lockoutAttrName, String lockoutAttrValue, long lockoutFailureDuration, int lockoutFailureMultiplier, String invalidAttemptsDataAttrName, String bundleName) {
        this.failureLockoutMode = failureLockoutMode;
        this.failureLockoutTime = failureLockoutTime;
        this.failureLockoutCount = failureLockoutCount;
        this.lockoutNotification = lockoutNotification;
        this.lockoutUserWarning = lockoutUserWarning;
        this.lockoutAttrName = lockoutAttrName;
        this.lockoutAttrValue = lockoutAttrValue;
        this.failureLockoutDuration = lockoutFailureDuration;
        this.failureLockoutMultiplier = lockoutFailureMultiplier;
        if (lockoutFailureDuration > 0L) {
            this.memoryLocking = true;
        }
        if (invalidAttemptsDataAttrName == null || invalidAttemptsDataAttrName.length() == 0) {
            this.invalidAttemptsDataAttrName = DEFAULT_INVALID_ATTEMPTS_XML_ATTR;
            this.needToSetInvalidAttemptsObjectClass = true;
        } else {
            this.invalidAttemptsDataAttrName = invalidAttemptsDataAttrName;
            this.needToSetInvalidAttemptsObjectClass = false;
        }
        this.bundleName = bundleName;
    }

    public boolean isLockoutEnabled() {
        return this.failureLockoutMode && this.failureLockoutCount > 0 && this.failureLockoutTime > 0L;
    }

    public boolean getStoreInvalidAttemptsInDS() {
        return this.storeInvalidAttemptsInDS;
    }

    public void setStoreInvalidAttemptsInDS(boolean aStoreInvalidAttemptsInDS) {
        this.storeInvalidAttemptsInDS = aStoreInvalidAttemptsInDS;
    }

    public boolean isMemoryLocking() {
        return this.memoryLocking;
    }

    public int invalidPasswd(String userDN, String userName, AMIdentity amIdentity, AccountLockoutInfo acInfo) {
        if (acInfo == null) {
            acInfo = new AccountLockoutInfo();
            acInfo.setActualLockoutDuration(this.failureLockoutDuration);
            loginFailHash.put(userDN, acInfo);
        }
        if (debug.messageEnabled()) {
            debug.message("ISAccountLockout.invalidPasswd with userDN, AMIdentity");
            debug.message("userDN : " + userDN);
        }
        long now = System.currentTimeMillis();
        int fail_count = acInfo.getFailCount();
        long lastFailTime = acInfo.getLastFailTime();
        long lockedAt = acInfo.getLockoutAt();
        fail_count = lastFailTime + this.failureLockoutTime > now ? ++fail_count : 1;
        if (lastFailTime + this.failureLockoutTime > now && fail_count == this.failureLockoutCount) {
            lockedAt = now;
        }
        if (debug.messageEnabled()) {
            debug.message("ISAccountLockout.invalidPasswd:fail_count:" + fail_count);
        }
        if (this.storeInvalidAttemptsInDS) {
            HashMap attrMap = new HashMap();
            HashSet<String> invalidAttempts = new HashSet<String>();
            String invalidXML = ISAccountLockout.createInvalidAttemptsXML(fail_count, now, lockedAt, acInfo.getActualLockoutDuration());
            invalidAttempts.add(invalidXML);
            if (debug.messageEnabled()) {
                debug.message("ISAccountLockout.invalidPasswd: Invalid Attempt XML being inserted= " + invalidXML);
            }
            attrMap.put(this.invalidAttemptsDataAttrName, invalidAttempts);
            try {
                this.setLockoutObjectClass(amIdentity);
                amIdentity.setAttributes(attrMap);
                amIdentity.store();
                debug.message("ISAccountLockout.invalidPasswd: Stored Invalid Attempt XML");
            }
            catch (Exception e) {
                debug.error("ISAccountLockout.invalidPasswd", (Throwable)e);
                return -1;
            }
        }
        acInfo.setLastFailTime(now);
        acInfo.setFailCount(fail_count);
        acInfo.setLockoutAt(lockedAt);
        if (lockedAt > 0L) {
            acInfo.setLockout(true);
        }
        acInfo.setUserToken(userName);
        if (fail_count == this.failureLockoutCount) {
            if (!this.memoryLocking) {
                this.inactivateUserAccount(amIdentity);
            }
            try {
                this.sendLockOutNotice(userName);
                this.callbackImpl = AMAuthCallBackImpl.getInstance(amIdentity.getRealm());
                this.callbackImpl.processedAccounttLockout(new Long(now), userName);
            }
            catch (AMAuthCallBackException e) {
                if (debug.getState() >= 1) {
                    debug.error("ISAccountLockout invalidPasswd : error getting callback implementation instance or error from callback module", (Throwable)((Object)e));
                }
            }
            catch (Exception ex) {
                debug.message("Error activating account/sendingnotification ", (Throwable)ex);
            }
        }
        this.setWarningCount(fail_count, this.failureLockoutCount);
        return this.userWarningCount;
    }

    public AccountLockoutInfo getAcInfo(String userDN, AMIdentity amIdentity) {
        AccountLockoutInfo acInfo = null;
        if (this.storeInvalidAttemptsInDS) {
            acInfo = new AccountLockoutInfo();
            Set attrValueSet = Collections.EMPTY_SET;
            try {
                attrValueSet = amIdentity.getAttribute(this.invalidAttemptsDataAttrName);
            }
            catch (Exception e) {
                debug.error("ISAccoutLockout.getAcInfo", (Throwable)e);
                return null;
            }
            String xmlFromDS = null;
            if (attrValueSet != null && !attrValueSet.isEmpty()) {
                Iterator i = attrValueSet.iterator();
                xmlFromDS = (String)i.next();
            }
            int invalid_attempts = 0;
            long last_failed = 0L;
            long locked_out_at = 0L;
            long actual_lockout_duration = this.failureLockoutDuration;
            if (xmlFromDS != null && xmlFromDS.length() != 0 && xmlFromDS.indexOf(BEGIN_XML) != -1) {
                String invalid_attempts_str = ISAccountLockout.getElement(xmlFromDS, INVALID_PASS_COUNT_BEGIN, INVALID_PASS_COUNT_END);
                invalid_attempts = Integer.parseInt(invalid_attempts_str);
                String last_failed_str = ISAccountLockout.getElement(xmlFromDS, LAST_FAILED_BEGIN, LAST_FAILED_END);
                last_failed = Long.parseLong(last_failed_str);
                String locked_out_at_str = ISAccountLockout.getElement(xmlFromDS, LOCKEDOUT_AT_BEGIN, LOCKEDOUT_AT_END);
                locked_out_at = Long.parseLong(locked_out_at_str);
                String actualLockoutDuration = ISAccountLockout.getElement(xmlFromDS, ACTUAL_LOCKOUT_DURATION_BEGIN, ACTUAL_LOCKOUT_DURATION_END);
                actual_lockout_duration = actualLockoutDuration != null && actualLockoutDuration.length() != 0 ? Long.parseLong(actualLockoutDuration) : this.failureLockoutDuration;
            }
            acInfo.setLastFailTime(last_failed);
            acInfo.setFailCount(invalid_attempts);
            acInfo.setLockoutAt(locked_out_at);
            acInfo.setActualLockoutDuration(actual_lockout_duration);
            if (locked_out_at > 0L) {
                acInfo.setLockout(true);
            }
            this.setWarningCount(invalid_attempts, this.failureLockoutCount);
            acInfo.setWarningCount(this.userWarningCount);
        } else {
            acInfo = (AccountLockoutInfo)loginFailHash.get(userDN);
        }
        return acInfo;
    }

    private void setLockoutObjectClass(AMIdentity amIdentity) {
        if (!this.needToSetInvalidAttemptsObjectClass) {
            return;
        }
        try {
            Set attrValueSetObjectClass = amIdentity.getAttribute("objectClass");
            if (attrValueSetObjectClass != null && !attrValueSetObjectClass.contains(INVALID_ATTEMPTS_XML_OBJECT_CLASS)) {
                attrValueSetObjectClass.add(INVALID_ATTEMPTS_XML_OBJECT_CLASS);
                HashMap<String, Set> map = new HashMap<String, Set>(2);
                map.put("ObjectClass", attrValueSetObjectClass);
                amIdentity.setAttributes(map);
            }
        }
        catch (IdRepoException e) {
            debug.message("ISAccountLockout.setLockoutObjectClass", (Throwable)e);
        }
        catch (SSOException e) {
            debug.message("ISAccountLockout.setLockoutObjectClass", (Throwable)((Object)e));
        }
    }

    public AccountLockoutInfo invalidPasswd(AMIdentity amIdentity, AccountLockoutInfo acInfo) {
        return this.invalidPasswdEx(amIdentity, acInfo);
    }

    private AccountLockoutInfo invalidPasswdEx(Object subject, AccountLockoutInfo acInfo) {
        long now = System.currentTimeMillis();
        if (acInfo == null) {
            debug.message("ISAccountLockout.invalidPasswdEx: First failure.");
            acInfo = new AccountLockoutInfo();
            acInfo.setActualLockoutDuration(this.failureLockoutDuration);
            acInfo.setLastFailTime(now);
        }
        int failCount = 0;
        if (acInfo != null) {
            long lastFailTime = acInfo.getLastFailTime();
            failCount = acInfo.getFailCount();
            long failureLockoutInterval = this.failureLockoutTime;
            if (lastFailTime + failureLockoutInterval > now) {
                acInfo.setFailCount(++failCount);
                if (failCount >= this.failureLockoutCount) {
                    acInfo.setLockoutAt(now);
                    acInfo.setLockout(this.failureLockoutDuration > 0L);
                    if (subject != null && failCount == this.failureLockoutCount) {
                        String notifyUser = null;
                        if (!this.memoryLocking) {
                            this.inactivateUserAccount((AMIdentity)subject);
                        }
                        if ((notifyUser = acInfo.getUserToken()) == null) {
                            notifyUser = ((AMIdentity)subject).getUniversalId();
                        }
                        this.sendLockOutNotice(notifyUser);
                    }
                }
            } else {
                debug.message("restart time and count");
                acInfo.setFailCount(1);
                acInfo.setLastFailTime(now);
                failCount = 1;
            }
        }
        this.setWarningCount(failCount, this.failureLockoutCount);
        acInfo.setWarningCount(this.userWarningCount);
        return acInfo;
    }

    public void sendLockOutNotice(String userDN) {
        if (this.lockoutNotification != null) {
            AMSendMail sm = new AMSendMail();
            StringTokenizer emailTokens = new StringTokenizer(this.lockoutNotification, SPACE_DELIM);
            StringBuffer sb = new StringBuffer();
            while (emailTokens.hasMoreTokens()) {
                StringTokenizer stz2 = new StringTokenizer(emailTokens.nextToken(), PIPE_DELIM);
                String[] toAddress = new String[]{stz2.nextToken()};
                String locale = null;
                String charset = null;
                if (stz2.hasMoreTokens()) {
                    locale = stz2.nextToken();
                    if (stz2.hasMoreTokens()) {
                        charset = stz2.nextToken();
                    }
                }
                ResourceBundle rb = Locale.getResourceBundle((String)this.bundleName, (String)locale);
                String fromAddress = rb.getString(FROM_ADDRESS);
                String emailSubject = rb.getString(EMAIL_SUBJECT);
                String[] obj = new String[]{userDN};
                String emailMsg = MessageFormat.format(rb.getString(EMAIL_MESSAGE), obj);
                if (debug.messageEnabled()) {
                    debug.message("ISAccountLockout.sendLockOutNotice: lockoutNotification = " + this.lockoutNotification + " toAddress = " + toAddress);
                }
                try {
                    sm.postMail(toAddress, emailSubject, emailMsg, fromAddress, charset);
                }
                catch (MessagingException ex) {
                    debug.error("cannot email lockout notification:token ", (Throwable)ex);
                }
            }
        }
    }

    public boolean isLockedOut(AccountLockoutInfo acInfo) {
        boolean isLockedOut = acInfo.isLockout();
        if (debug.messageEnabled()) {
            debug.message("ISAccoutLockout.isLockedOut : " + isLockedOut);
        }
        if (acInfo != null && isLockedOut) {
            long now = System.currentTimeMillis();
            long lockOutTime = acInfo.getLockoutAt();
            if (lockOutTime + acInfo.getActualLockoutDuration() < now) {
                if (debug.messageEnabled()) {
                    debug.message("isLockedOut returns false. loginFailureLockoutDuration=" + acInfo.getActualLockoutDuration() + " lockOutTime=" + lockOutTime + " now=" + now);
                }
                isLockedOut = false;
            }
        }
        return isLockedOut;
    }

    private void inactivateUserAccount(AMIdentity amIdentity) {
        debug.message("entering ISAccountLockout.inactivateUserAccount");
        try {
            HashMap attrMap = new HashMap();
            HashSet<String> attrValSet1 = new HashSet<String>();
            if (this.lockoutAttrName != null && this.lockoutAttrValue != null) {
                attrValSet1.add(this.lockoutAttrValue);
                attrMap.put(this.lockoutAttrName, attrValSet1);
            }
            HashSet<String> attrValSet2 = new HashSet<String>();
            attrValSet2.add(USER_INACTIVE);
            attrMap.put(USER_STATUS_ATTR, attrValSet2);
            amIdentity.setAttributes(attrMap);
            amIdentity.store();
        }
        catch (Exception e) {
            debug.error("ISAccountLockout.inactivateUserAccount", (Throwable)e);
        }
    }

    private void setWarningCount(int failCount, int failureLockoutCount) {
        int upperLimit;
        this.userWarningCount = 0;
        if (failCount >= failureLockoutCount) {
            this.userWarningCount = -1;
        } else if (this.lockoutUserWarning > 0 && this.lockoutUserWarning < failureLockoutCount && failCount >= (upperLimit = this.lockoutUserWarning)) {
            this.userWarningCount = failureLockoutCount - failCount;
        }
    }

    public boolean isAccountLocked(AMIdentity amIdentity) {
        boolean isLocked = false;
        if (!this.memoryLocking) {
            try {
                String attrValue;
                Iterator i;
                Set attrValueSet;
                if (this.lockoutAttrName != null && this.lockoutAttrValue != null && (attrValueSet = amIdentity.getAttribute(this.lockoutAttrName)) != null && !attrValueSet.isEmpty()) {
                    i = attrValueSet.iterator();
                    attrValue = (String)i.next();
                    isLocked = attrValue.equals(this.lockoutAttrValue);
                }
                if (!isLocked && (attrValueSet = amIdentity.getAttribute(USER_STATUS_ATTR)) != null && !attrValueSet.isEmpty()) {
                    i = attrValueSet.iterator();
                    attrValue = (String)i.next();
                    isLocked = attrValue.equals(USER_INACTIVE);
                }
            }
            catch (Exception e) {
                debug.error("Error inactivating user account", (Throwable)e);
            }
        }
        if (debug.messageEnabled()) {
            if (isLocked) {
                debug.message("Account is locked");
            } else {
                debug.message("Account is unlocked");
            }
        }
        return isLocked;
    }

    public void resetLockoutAttempts(String userDN, AMIdentity amIdentity, AccountLockoutInfo acInfo, boolean resetDuration) {
        debug.message("entering ISAccountLockout.resetLockoutAttempts");
        if (debug.messageEnabled()) {
            debug.message("ISAccountLockout.resetLockoutAttempts:: resetDuration =" + resetDuration);
        }
        int fail_count = 0;
        long lastFailTime = 0L;
        long locked_out_at = 0L;
        long actualLockoutDuration = this.failureLockoutDuration;
        long currentLockoutDuration = acInfo.getActualLockoutDuration();
        if (acInfo != null) {
            fail_count = acInfo.getFailCount();
            lastFailTime = acInfo.getLastFailTime();
            locked_out_at = acInfo.getLockoutAt();
            long now = System.currentTimeMillis();
            if (!resetDuration) {
                actualLockoutDuration = currentLockoutDuration;
                if (debug.messageEnabled()) {
                    debug.message("ISAccountLockout.resetLockoutAttempts::Locked out At =" + locked_out_at);
                }
                if (locked_out_at > 0L) {
                    if (debug.messageEnabled()) {
                        debug.message("ISAccountLockout.resetLockoutAttempts:: Using the multiplier");
                    }
                    actualLockoutDuration = (long)this.failureLockoutMultiplier * currentLockoutDuration;
                }
            }
        }
        if (this.storeInvalidAttemptsInDS) {
            try {
                if (fail_count != 0 || lastFailTime != 0L || locked_out_at != 0L || actualLockoutDuration != currentLockoutDuration) {
                    HashMap attrMap = new HashMap();
                    HashSet<String> invalidAttempts = new HashSet<String>();
                    String invalidXML = ISAccountLockout.createInvalidAttemptsXML(0, 0L, 0L, actualLockoutDuration);
                    invalidAttempts.add(invalidXML);
                    attrMap.put(this.invalidAttemptsDataAttrName, invalidAttempts);
                    this.setLockoutObjectClass(amIdentity);
                    amIdentity.setAttributes(attrMap);
                    debug.message("Saving XML = " + invalidXML);
                    amIdentity.store();
                }
                debug.message("ISAccountLockout::resetLockoutAttempts done");
            }
            catch (Exception exp) {
                debug.message("error reseting Lockout Attempts");
            }
        }
        acInfo.setFailCount(0);
        acInfo.setLastFailTime(0L);
        acInfo.setLockoutAt(0L);
        acInfo.setLockout(false);
        acInfo.setActualLockoutDuration(actualLockoutDuration);
    }

    private static String createInvalidAttemptsXML(int invalidCount, long lastFailed, long lockedOutAt, long actualLockoutDuration) {
        StringBuffer xmlBuffer = new StringBuffer(150);
        xmlBuffer.append(BEGIN_XML).append(INVALID_PASS_COUNT_BEGIN).append(String.valueOf(invalidCount)).append(INVALID_PASS_COUNT_END).append(LAST_FAILED_BEGIN).append(String.valueOf(lastFailed)).append(LAST_FAILED_END).append(LOCKEDOUT_AT_BEGIN).append(String.valueOf(lockedOutAt)).append(LOCKEDOUT_AT_END).append(ACTUAL_LOCKOUT_DURATION_BEGIN).append(String.valueOf(actualLockoutDuration)).append(ACTUAL_LOCKOUT_DURATION_END).append(END_XML);
        return xmlBuffer.toString();
    }

    private static String getElement(String content, String start, String end) {
        String answer = null;
        if (content != null) {
            int startIndex = content.indexOf(start);
            int endIndex = content.indexOf(end);
            if (startIndex != -1 && endIndex != -1 && startIndex + start.length() < endIndex) {
                answer = content.substring(startIndex + start.length(), endIndex);
            }
        }
        return answer;
    }
}

