/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm.model;

import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMResBundleCacher;
import com.sun.identity.console.base.model.AMSystemConfig;
import com.sun.identity.console.dm.model.DMModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.ldap.util.RDN;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.RequiredValueValidator;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class DMModelBase
extends AMModelBase
implements DMModel {
    private static RequiredValueValidator reqValidator = new RequiredValueValidator();
    protected String errorMessage = null;
    protected String searchErrorMsg = null;
    protected Set values = null;
    protected List searchReturnAttrs = null;
    private Set searchResults = null;
    protected Map resultsMap = null;
    protected Map mandatoryAttributes = new HashMap();
    private AMStoreConnection dpStoreConn = null;
    private int groupConfiguration = 10;
    public int errorCode = 0;
    private String filterAttributeXML = null;
    private Set filterAttributes = null;
    private Set filterAttributeNames = null;
    protected int locationType = -1;
    private boolean userMgmtEnabled;
    private boolean peopleContainerDisplay;
    private boolean groupContainerDisplay;
    private boolean orgUnitDisplay;
    private boolean adminGroupsEnabled;
    private String DEFAULT_NAME_COLUMN = "table.dm.name.column.name";
    private String DEFAULT_SEARCH_PATTERN = "*";
    private String EMPTY_DISPLAY_STRING = "-";

    public DMModelBase(HttpServletRequest req, Map map) {
        super(req, map);
    }

    protected void initialize(HttpServletRequest req, String rbName) {
        super.initialize(req, rbName);
        this.readConsoleProfile();
    }

    private boolean isAttributeSet(ServiceSchema schema, String attrName) {
        String value = this.getDefaultAttrValue(schema, attrName);
        return value != null && value.equals("true");
    }

    private void readConsoleProfile() {
        try {
            ServiceSchemaManager svcSchemaMgr = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            ServiceSchema schema = svcSchemaMgr.getSchema(SchemaType.GLOBAL);
            this.peopleContainerDisplay = this.isAttributeSet(schema, "iplanet-am-admin-console-pc-display");
            this.groupContainerDisplay = this.isAttributeSet(schema, "iplanet-am-admin-console-gc-display");
            this.adminGroupsEnabled = this.isAttributeSet(schema, "iplanet-am-admin-console-compliance-admin-groups");
            this.userMgmtEnabled = this.isAttributeSet(schema, "iplanet-am-admin-console-um-enabled");
            if (!AMSystemConfig.iPlanetCompliantDIT) {
                this.orgUnitDisplay = this.isAttributeSet(schema, "iplanet-am-admin-console-ou-display");
                this.getGroupConfigurationType(schema);
            }
        }
        catch (SMSException smse) {
            debug.error("DMModelBase.readConsoleProfile", (Throwable)smse);
        }
        catch (SSOException ssoe) {
            debug.error("DMModelBase.readConsoleProfile", (Throwable)((Object)ssoe));
        }
    }

    private void getGroupConfigurationType(ServiceSchema schema) {
        String value = this.getDefaultAttrValue(schema, "iplanet-am-admin-console-group-type");
        this.groupConfiguration = value.equalsIgnoreCase("dynamic") ? 12 : 10;
    }

    private String getDefaultAttrValue(ServiceSchema schema, String attrName) {
        String value = null;
        AttributeSchema as = schema.getAttributeSchema(attrName);
        Set defaultValue = as.getDefaultValues();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            value = (String)defaultValue.iterator().next();
        }
        return value;
    }

    protected int getGroupConfiguration() {
        return this.groupConfiguration;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String msgStr) {
        this.errorMessage = msgStr;
    }

    public Set getAttrList() {
        return this.values;
    }

    public void setAttrList(Set set) {
        this.values = set;
    }

    Set setSearchResults(AMSearchResults results) {
        this.searchResults = Collections.EMPTY_SET;
        if (results != null) {
            this.searchResults = results.getSearchResults();
            this.resultsMap = results.getResultAttributes();
            if (this.searchErrorMsg != null) {
                this.errorCode = results.getErrorCode();
            }
        }
        return this.searchResults;
    }

    Set getSearchResults() {
        return this.searchResults;
    }

    public String getAttributeLocalizedName(String name, String schemaName) {
        String localizedStr = name;
        try {
            ServiceSchemaManager mgr = this.getServiceSchemaManager("iPlanetAMEntrySpecificService");
            String key = this.getSubSchemaI18NKey(mgr, SchemaType.GLOBAL, schemaName, name);
            if (key == null) {
                key = name;
            }
            localizedStr = this.getL10NAttributeName(mgr, key);
        }
        catch (SMSException se) {
            debug.error("DMModelBase.getAttributeLocalizedName", (Throwable)se);
        }
        catch (SSOException se) {
            debug.error("DMModelBase.getAttributeLocalizedName", (Throwable)((Object)se));
        }
        return localizedStr;
    }

    private String getSubSchemaI18NKey(ServiceSchemaManager svcSchemaMgr, SchemaType type, String name, String attribute) throws SMSException {
        AttributeSchema as;
        ServiceSchema subSchema;
        String i18nKey = null;
        ServiceSchema schema = svcSchemaMgr.getSchema(type);
        if (schema != null && (subSchema = schema.getSubSchema(name)) != null && (as = subSchema.getAttributeSchema(attribute)) != null) {
            i18nKey = as.getI18NKey();
        }
        return i18nKey;
    }

    protected String getL10NAttributeName(ServiceSchemaManager mgr, String key) {
        String i18nName = key;
        try {
            String name = mgr.getI18NFileName();
            if (name != null) {
                ResourceBundle rb = AMResBundleCacher.getBundle(name, this.locale);
                i18nName = Locale.getString((ResourceBundle)rb, (String)key, (Debug)debug);
            }
        }
        catch (MissingResourceException mre) {
            debug.warning("DMModelBase.getL10NAttributeName", (Throwable)mre);
        }
        return i18nName;
    }

    protected Set getObjectAttributeNames(String schemaName, int objectType) {
        ServiceSchemaManager mgr;
        block7: {
            mgr = null;
            try {
                this.getServiceSchemaManager("iPlanetAMEntrySpecificService");
            }
            catch (SSOException s) {
                if (debug.warningEnabled()) {
                    debug.warning("DMModel.getObjectAttributeNames", (Throwable)((Object)s));
                }
                return Collections.EMPTY_SET;
            }
            catch (SMSException se) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("DMModel.getObjectAttributeNames", (Throwable)se);
            }
        }
        Set attrSchemaSet = this.getAttributesToDisplay(mgr, SchemaType.GLOBAL, schemaName);
        HashSet<String> set = Collections.EMPTY_SET;
        if (attrSchemaSet != null && !attrSchemaSet.isEmpty()) {
            Iterator iter = attrSchemaSet.iterator();
            set = new HashSet(attrSchemaSet.size() + 1);
            while (iter.hasNext()) {
                AttributeSchema attrSchema = (AttributeSchema)iter.next();
                String name = attrSchema.getName();
                set.add(name);
            }
        } else {
            set = new HashSet<String>(1);
        }
        set.add(AdminInterfaceUtils.getNamingAttribute(objectType, debug));
        return set;
    }

    protected void setSearchControlAttributes(AMSearchControl searchControl, String returnAttributes) {
        StringTokenizer tok = new StringTokenizer(returnAttributes);
        ArrayList<String> searchAttrs = new ArrayList<String>(tok.countTokens() * 2);
        while (tok.hasMoreTokens()) {
            searchAttrs.add(tok.nextToken());
        }
        String[] sortKeys = new String[]{(String)searchAttrs.get(0)};
        searchControl.setSortKeys(sortKeys);
        searchControl.setReturnAttributes(new HashSet(searchAttrs));
    }

    protected void setSearchControlAttributes(String orgDN, String schemaName, int objectType, AMSearchControl searchControl, String type) {
        this.setLocationDN(orgDN);
        if (this.searchReturnAttrs == null) {
            String returnAttr = this.getSearchReturnValue();
            if (returnAttr == null) {
                this.searchReturnAttrs = new ArrayList(1);
                this.searchReturnAttrs.add(AdminInterfaceUtils.getNamingAttribute(objectType, debug));
            } else {
                this.searchReturnAttrs = this.getValidatedAttributes(returnAttr, schemaName, objectType, type);
            }
        }
        String sortKey = (String)this.searchReturnAttrs.get(0);
        String[] sortKeys = new String[]{sortKey};
        searchControl.setSortKeys(sortKeys);
        searchControl.setReturnAttributes(new HashSet(this.searchReturnAttrs));
    }

    public List getSearchReturnAttributes(String schemaName, int objectType, String type) {
        if (this.searchReturnAttrs == null) {
            String returnAttr = this.getSearchReturnValue();
            if (returnAttr == null) {
                this.searchReturnAttrs = new ArrayList(1);
                this.searchReturnAttrs.add(AdminInterfaceUtils.getNamingAttribute(objectType, debug));
            } else {
                this.searchReturnAttrs = this.getValidatedAttributes(returnAttr, schemaName, objectType, type);
            }
        }
        return this.searchReturnAttrs;
    }

    protected List getValidatedAttributes(String returnAttr, String schemaName, int objectType, String type) {
        List list;
        ArrayList<String> searchAttrs = Collections.EMPTY_LIST;
        if (returnAttr != null && returnAttr.length() > 0 && (list = this.getObjectDisplayList(returnAttr, type)) != null && !list.isEmpty()) {
            searchAttrs = new ArrayList(list.size());
            Set objAttrs = this.getObjectAttributeNames(schemaName, objectType);
            if (objAttrs != null && !objAttrs.isEmpty()) {
                for (String str : list) {
                    if (!objAttrs.contains(str) || searchAttrs.contains(str)) continue;
                    searchAttrs.add(str);
                }
            }
        }
        if (searchAttrs == null || searchAttrs.isEmpty()) {
            searchAttrs = new ArrayList<String>(1);
            searchAttrs.add(AdminInterfaceUtils.getNamingAttribute(objectType, debug));
        }
        return searchAttrs;
    }

    public String getAttributeValue(String objectDN, String attrName) {
        Set attrValues;
        Map values;
        String value = "";
        if (!(this.resultsMap == null || this.resultsMap.isEmpty() || (values = (Map)this.resultsMap.get(objectDN)) == null || values.isEmpty() || (attrValues = (Set)values.get(attrName)) == null || attrValues.isEmpty())) {
            value = this.getMultiValue(attrValues);
        }
        return value;
    }

    public String getAttributeName(String schemaName, int objectType, String type) {
        this.getSearchReturnAttributes(schemaName, objectType, type);
        if (this.searchReturnAttrs.isEmpty()) {
            return AdminInterfaceUtils.getNamingAttribute(objectType, debug);
        }
        int size = this.searchReturnAttrs.size();
        return (String)this.searchReturnAttrs.get(size - 1);
    }

    public List getAttrSearchList() {
        return this.searchReturnAttrs;
    }

    public void setAttrSearchList(List list) {
        this.searchReturnAttrs = list;
    }

    public Map getAttrMap() {
        return this.resultsMap;
    }

    public void setAttrMap(Map map) {
        this.resultsMap = map;
    }

    protected Set getAttrValues(String attrName, String serviceName, String dn) {
        return this.getAttrValues(attrName, serviceName, dn, 302);
    }

    protected Set getAttrValues(String attrName, String serviceName, String dn, int templateType) {
        Set values = Collections.EMPTY_SET;
        try {
            String orgDN = this.getOrganizationDN(dn);
            AMTemplate template = this.getServiceTemplate(orgDN, serviceName, templateType);
            if (template != null && template.isExists()) {
                values = template.getAttribute(attrName);
            } else {
                AttributeSchema attrSchema;
                SchemaType schemaType = SchemaType.ORGANIZATION;
                if (templateType == 300) {
                    schemaType = SchemaType.POLICY;
                } else if (templateType == 301) {
                    schemaType = SchemaType.DYNAMIC;
                }
                ServiceSchemaManager mgr = this.getServiceSchemaManager(serviceName);
                ServiceSchema schema = mgr.getSchema(schemaType);
                if (schema != null && (attrSchema = schema.getAttributeSchema(attrName)) != null) {
                    values = attrSchema.getDefaultValues();
                }
            }
        }
        catch (SSOException ssoe) {
            if (debug.warningEnabled()) {
                debug.warning("DMModelBase.getAttrValues: attrName=" + attrName + ", serviceName=" + serviceName, (Throwable)((Object)ssoe));
            }
        }
        catch (AMException ame) {
            debug.error("DMModelBase.getAttrValues: attrName=" + attrName + ", serviceName=" + serviceName, (Throwable)ame);
        }
        catch (SMSException smse) {
            debug.error("DMModelBase.getAttrValues: attrName=" + attrName + ", serviceName=" + serviceName, (Throwable)smse);
        }
        return values;
    }

    private String getOrganizationDN(String dn) throws AMException, SSOException {
        String orgDN = null;
        AMObject obj = this.getAMObject(dn);
        if (obj != null) {
            orgDN = obj.getOrganizationDN();
        } else {
            AMEntity entity = this.getAMStoreConnection().getEntity(dn);
            if (entity != null) {
                orgDN = entity.getOrganizationDN();
            }
        }
        return orgDN != null ? orgDN : "";
    }

    protected AMTemplate getServiceTemplate(String orgDN, String service, int templateType) {
        AMObject template = null;
        boolean bOrganization = false;
        try {
            int type = this.getObjectType(orgDN);
            String[] params = new String[]{orgDN, service, Integer.toString(templateType)};
            switch (type) {
                case 2: {
                    bOrganization = true;
                    this.logEvent("ATTEMPT_DIR_MGR_GET_SERVICE_TEMPLATE_UNDER_ORGANIZATION", params);
                    AMOrganization org = (AMOrganization)this.getAMObject(orgDN);
                    if (org != null && (templateType != 302 || org.orgTemplateExists(service))) {
                        template = org.getTemplate(service, templateType);
                    }
                    this.logEvent("SUCCEED_DIR_MGR_GET_SERVICE_TEMPLATE_UNDER_ORGANIZATION", params);
                    break;
                }
                case 3: {
                    this.logEvent("ATTEMPT_DIR_MGR_GET_SERVICE_TEMPLATE_UNDER_CONTAINER", params);
                    AMOrganizationalUnit orgUnit = (AMOrganizationalUnit)this.getAMObject(orgDN);
                    if (orgUnit != null && (templateType != 302 || orgUnit.orgTemplateExists(service))) {
                        template = orgUnit.getTemplate(service, templateType);
                    }
                    this.logEvent("SUCCEED_DIR_MGR_GET_SERVICE_TEMPLATE_UNDER_CONTAINER", params);
                }
            }
            if (template != null && !template.isExists()) {
                template = null;
            }
        }
        catch (AMException e) {
            String msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_GET_SERVICE_TEMPLATE_UNDER_ORGANIZATION" : "AM_EXCEPTION_DIR_MGR_GET_SERVICE_TEMPLATE_UNDER_CONTAINER";
            String[] paramsEx = new String[]{orgDN, service, Integer.toString(templateType), this.getErrorString(e)};
            this.logEvent(msgId, paramsEx);
            debug.error("couldn't get " + service + " template for " + orgDN, (Throwable)e);
        }
        catch (SSOException e) {
            String msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_GET_SERVICE_TEMPLATE_UNDER_ORGANIZATION" : "SSO_EXCEPTION_DIR_MGR_GET_SERVICE_TEMPLATE_UNDER_CONTAINER";
            String[] paramsEx = new String[]{orgDN, service, Integer.toString(templateType), this.getErrorString((Throwable)((Object)e))};
            this.logEvent(msgId, paramsEx);
            debug.error("couldn't get " + service + " template for " + orgDN, (Throwable)((Object)e));
        }
        return template;
    }

    protected AMTemplate getServiceTemplate(String serviceName, SchemaType schemaType) throws AMException, SSOException {
        AMTemplate template = null;
        switch (this.locationType) {
            case 2: {
                template = this.getServiceTemplateInOrg(serviceName, this.locationDN, schemaType);
                break;
            }
            case 3: {
                template = this.getServiceTemplateInOrgUnit(serviceName, this.locationDN, schemaType);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                AMRole role = this.getAMStoreConnection().getRole(this.locationDN);
                template = role.getTemplate(serviceName, 301);
            }
        }
        return template;
    }

    private AMTemplate getServiceTemplateInOrg(String serviceName, String orgDN, SchemaType schemaType) throws AMException, SSOException {
        AMTemplate template = null;
        AMOrganization org = this.getAMStoreConnection().getOrganization(orgDN);
        if (schemaType.equals(SchemaType.ORGANIZATION)) {
            if (org.orgTemplateExists(serviceName)) {
                template = org.getTemplate(serviceName, 302);
            }
        } else {
            template = org.getTemplate(serviceName, 301);
        }
        return template;
    }

    private AMTemplate getServiceTemplateInOrgUnit(String serviceName, String orgUnitDN, SchemaType schemaType) throws AMException, SSOException {
        AMTemplate template = null;
        AMOrganizationalUnit orgUnit = this.getAMStoreConnection().getOrganizationalUnit(orgUnitDN);
        if (schemaType.equals(SchemaType.ORGANIZATION)) {
            if (orgUnit.orgTemplateExists(serviceName)) {
                template = orgUnit.getTemplate(serviceName, 302);
            }
        } else {
            template = orgUnit.getTemplate(serviceName, 301);
        }
        return template;
    }

    protected String getMultiValue(Set attrValues) {
        StringBuffer sb = new StringBuffer(25);
        if (attrValues != null && !attrValues.isEmpty()) {
            Iterator iter = attrValues.iterator();
            while (iter.hasNext()) {
                if (sb.length() != 0) {
                    sb.append(this.getLocalizedString("multiValuedAttrSeparator") + " ");
                }
                sb.append((String)iter.next());
            }
        }
        return sb.toString();
    }

    protected void setSearchControlLimits(AMSearchControl searchControl) {
        searchControl.setMaxResults(this.getSearchResultLimit());
        searchControl.setTimeOut(this.getSearchTimeOutLimit());
    }

    protected AMTemplate getOrgTemplate(AMObject obj) {
        AMTemplate amTemplate = null;
        if (obj instanceof AMOrganization) {
            amTemplate = this.getOrgTemplate((AMOrganization)obj);
        } else if (obj instanceof AMOrganizationalUnit) {
            amTemplate = this.getOrgTemplate((AMOrganizationalUnit)obj);
        } else if (debug.warningEnabled()) {
            debug.warning("DMModelBase.getOrgTemplate, invalid object type " + obj.getDN());
        }
        return amTemplate;
    }

    protected AMTemplate getOrgTemplate(String orgDN) {
        AMTemplate template = null;
        try {
            int type = this.getObjectType(orgDN);
            if (type == 2) {
                template = this.getOrgTemplate(this.getAMStoreConnection().getOrganization(orgDN));
            } else if (type == 3) {
                template = this.getOrgTemplate(this.getAMStoreConnection().getOrganizationalUnit(orgDN));
            }
        }
        catch (SSOException ssoe) {
            debug.warning("DMModelBase.getOrgTemplate", (Throwable)((Object)ssoe));
        }
        return template;
    }

    protected AMTemplate getOrgTemplate(AMOrganization org) {
        AMTemplate template = null;
        if (org != null) {
            try {
                if (org.orgTemplateExists("iPlanetAMAdminConsoleService")) {
                    template = org.getTemplate("iPlanetAMAdminConsoleService", 302);
                }
            }
            catch (AMException ame) {
                debug.warning("DMModel.getOrgTemplate", (Throwable)ame);
            }
            catch (SSOException ssoe) {
                debug.warning("DMModel.getOrgTemplate", (Throwable)((Object)ssoe));
            }
        }
        return template;
    }

    protected AMTemplate getOrgTemplate(AMOrganizationalUnit ou) {
        AMTemplate template = null;
        if (ou != null) {
            try {
                if (ou.orgTemplateExists("iPlanetAMAdminConsoleService")) {
                    template = ou.getTemplate("iPlanetAMAdminConsoleService", 302);
                }
            }
            catch (AMException ame) {
                debug.warning("DMModelBase.getOrgTemplate", (Throwable)ame);
            }
            catch (SSOException ssoe) {
                debug.warning("DMModelBase.getOrgTemplate", (Throwable)((Object)ssoe));
            }
        }
        return template;
    }

    protected List getObjectDisplayList(String returnAttr, String type) {
        StringTokenizer st = new StringTokenizer(returnAttr, "|");
        List list = Collections.EMPTY_LIST;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            int index = str.indexOf("=");
            if (index != -1) {
                String name = str.substring(0, index).trim();
                if (!name.equals(type)) continue;
                str = str.substring(index + 1, str.length());
                list = this.getReturnAttrList(str);
                break;
            }
            if (index != -1 || !type.equals("users")) continue;
            list = this.getReturnAttrList(str);
            break;
        }
        return list;
    }

    public boolean isAdminGroupsEnabled() {
        return this.adminGroupsEnabled;
    }

    private List getReturnAttrList(String str) {
        ArrayList<String> list = Collections.EMPTY_LIST;
        StringTokenizer subSt = new StringTokenizer(str);
        int n = subSt.countTokens();
        if (n > 0) {
            list = new ArrayList<String>(n);
        }
        while (subSt.hasMoreTokens()) {
            String value = subSt.nextToken().trim();
            if (value.length() <= 0) continue;
            list.add(value);
        }
        return list;
    }

    public Map deleteObject(Set dnSet) throws AMConsoleException {
        if (dnSet == null || dnSet.isEmpty()) {
            throw new AMConsoleException(this.getLocalizedString("no.entries.selected"));
        }
        int size = dnSet.size();
        HashMap<String, String> failedObjectMap = new HashMap<String, String>(size);
        HashSet<String> deleted = new HashSet<String>(size);
        Iterator iter = dnSet.iterator();
        while (iter.hasNext()) {
            String[] paramsEx;
            String deleteObj;
            AMObject dpObj;
            block11: {
                dpObj = null;
                deleteObj = (String)iter.next();
                if (deleteObj.equals(this.getStartDSDN())) {
                    debug.warning("DModelBase.deleteUMObject - skipping entry tried to remove the users starting location");
                    continue;
                }
                try {
                    dpObj = this.getAMObject(deleteObj);
                    if (dpObj == null) {
                        if (!debug.warningEnabled()) continue;
                        debug.warning("skipping " + deleteObj + ", no object found for it.");
                    }
                    break block11;
                }
                catch (AMException ame) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("skipping " + deleteObj + ", no object found for it.");
                }
                catch (SSOException ssoe) {
                    debug.error("token exception", (Throwable)((Object)ssoe));
                }
                continue;
            }
            try {
                if (dpObj.isExists()) {
                    String[] param = new String[]{deleteObj};
                    this.logEvent("ATTEMPT_DIR_MGR_DELETE_DIR_OBJECT", param);
                    dpObj.delete(true);
                    this.logEvent("SUCCEED_DIR_MGR_DELETE_DIR_OBJECT", param);
                    deleted.add(deleteObj);
                    continue;
                }
                if (!debug.warningEnabled()) continue;
                debug.warning("skipping " + deleteObj + ", doesn't exist in directory");
            }
            catch (AMException dpe) {
                this.errorMessage = this.getErrorString(dpe);
                paramsEx = new String[]{deleteObj, this.errorMessage};
                this.logEvent("AM_EXCEPTION_DIR_MGR_DELETE_DIR_OBJECT", paramsEx);
                failedObjectMap.put(deleteObj, this.errorMessage);
                if (!debug.warningEnabled()) continue;
                debug.warning("Failed to delete AMObject: " + deleteObj);
                debug.warning("DModelBase.deleteOrgs:", (Throwable)dpe);
            }
            catch (SSOException ssoe) {
                paramsEx = new String[]{deleteObj, this.getErrorString((Throwable)((Object)ssoe))};
                this.logEvent("SSO_EXCEPTION_DIR_MGR_DELETE_DIR_OBJECT", paramsEx);
                if (!debug.warningEnabled()) continue;
                debug.warning("Failed to delete AMObject: " + deleteObj);
                debug.warning("DModelBase.deleteOrgs", (Throwable)((Object)ssoe));
            }
        }
        return failedObjectMap;
    }

    private void addEntry(String type, List entries) {
        HashMap<String, String> tab = new HashMap<String, String>(10);
        tab.put("label", "dm." + type + ".label");
        tab.put("status", "dm." + type + ".status");
        tab.put("tooltip", "dm." + type + ".tooltip");
        tab.put("url", "../dm/" + type);
        tab.put("viewbean", "com.sun.identity.console.dm." + type + "ViewBean");
        tab.put("permissions", "sunAMRealmService");
        entries.add(tab);
    }

    public List getTabMenu() {
        ArrayList entries = new ArrayList(15);
        HashMap tab = new HashMap(10);
        if (this.showOrganizations()) {
            this.addEntry("Organization", entries);
        }
        if (this.showOrgUnits()) {
            this.addEntry("Container", entries);
        }
        if (this.showGroupContainers()) {
            this.addEntry("GroupContainer", entries);
        }
        if (this.showGroups()) {
            this.addEntry("Group", entries);
        }
        if (this.showPeopleContainers()) {
            this.addEntry("PeopleContainer", entries);
        }
        if (this.userMgmtEnabled) {
            this.addEntry("User", entries);
        }
        if (this.showRoles()) {
            this.addEntry("Role", entries);
        }
        return entries;
    }

    public void writeProfile(AMObject amObj, Map data) throws AMConsoleException, SSOException {
        this.writeProfile(amObj, data, false);
    }

    public void writeProfile(AMObject amObj, Map data, boolean overwrite) throws AMConsoleException, SSOException {
        Map storedValues;
        ArrayList<String> errors;
        block12: {
            errors = new ArrayList<String>(data.size());
            HashSet<String> keys = new HashSet<String>();
            for (String key : data.keySet()) {
                if (key.startsWith("iPlanetEncryptedPassword")) {
                    key = key.substring("iPlanetEncryptedPassword".length());
                } else if (key.startsWith("iPlanetPlainTextPassword")) {
                    key = key.substring("iPlanetPlainTextPassword".length());
                }
                keys.add(key);
            }
            storedValues = null;
            try {
                storedValues = amObj.getAttributes(keys);
            }
            catch (AMException ame) {
                if (!debug.warningEnabled()) break block12;
                debug.warning("DMModelBase.writeProfile, ", (Throwable)ame);
            }
        }
        if (storedValues == null) {
            storedValues = Collections.EMPTY_MAP;
        }
        for (String key : data.keySet()) {
            String error;
            Set oldValue;
            Set newValue = (Set)data.get(key);
            boolean encrypted = false;
            boolean plainpassword = false;
            if (key.startsWith("iPlanetEncryptedPassword")) {
                encrypted = true;
                key = key.substring("iPlanetEncryptedPassword".length());
            } else if (key.startsWith("iPlanetPlainTextPassword")) {
                plainpassword = true;
                key = key.substring("iPlanetPlainTextPassword".length());
            }
            if ((oldValue = (Set)storedValues.get(key)).isEmpty() && newValue.isEmpty() || !overwrite && ((Object)newValue).equals(oldValue) || (error = this.writeAttrValues(amObj, key, newValue, oldValue, encrypted, plainpassword)) == null || error.length() <= 0) continue;
            errors.add(error);
        }
        if (errors.size() > 0) {
            throw new AMConsoleException(errors);
        }
    }

    private String writeAttrValues(AMObject amObj, String name, Set values, Set oldValues, boolean encrypted, boolean plainpassword) throws SSOException {
        String error = null;
        if (encrypted) {
            values = this.encryptString(values);
        }
        try {
            String[] param = new String[]{amObj.getDN()};
            this.logEvent("ATTEMPT_DIR_MGR_MODIFY_DIR_OBJECT", param);
            HashMap<String, Set> mapAttrVal = new HashMap<String, Set>(1);
            mapAttrVal.put(name, values);
            amObj.setAttributes(mapAttrVal);
            amObj.store();
            this.logEvent("SUCCEED_DIR_MGR_MODIFY_DIR_OBJECT", param);
        }
        catch (AMException ame) {
            String[] paramsEx = new String[]{amObj.getDN(), this.getErrorString(ame)};
            this.logEvent("AM_EXCEPTION_DIR_MGR_MODIFY_DIR_OBJECT", paramsEx);
            if (debug.warningEnabled()) {
                debug.warning("error setting attribute " + name, (Throwable)ame);
            }
            error = name + "-" + this.getErrorString(ame);
        }
        return error;
    }

    protected void getPropertyXML(String serviceName, String subSchemaName, SchemaType type, StringBuffer buff) {
        try {
            ServiceSchema sub = this.getSubSchema(serviceName, type, subSchemaName);
            if (sub != null) {
                PropertyXMLBuilder xmlBuilder = new PropertyXMLBuilder(sub, this);
                buff.append(xmlBuilder.getXML(false));
                this.setMandatoryAttributes(xmlBuilder.getAttributeSchemas());
            }
        }
        catch (SSOException e) {
            debug.error("DMModeBase.getPropertyXML-SSO", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("DMModeBase.getPropertyXML-SMS", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.error("DMModeBase.getPropertyXML-AMConsole", (Throwable)e);
        }
    }

    protected ServiceSchema getServiceSchema(String serviceName, SchemaType type) throws SMSException, SSOException {
        ServiceSchemaManager manager = this.getServiceSchemaManager(serviceName);
        ServiceSchema ss = manager.getSchema(type);
        return ss;
    }

    protected ServiceSchema getSubSchema(String serviceName, SchemaType type, String subschema) throws SMSException, SSOException {
        ServiceSchema service = this.getServiceSchema(serviceName, type);
        ServiceSchema tmp = service.getSubSchema(subschema);
        return tmp;
    }

    public void removeServices(String location, Set services) throws AMConsoleException {
        if (services == null || services.isEmpty()) {
            throw new AMConsoleException("empty.service.list");
        }
        if (location == null || location.length() == 0) {
            throw new AMConsoleException("system.error");
        }
        Set currentServices = null;
        AMOrganization org = null;
        AMOrganizationalUnit orgUnit = null;
        int locationType = this.getObjectType(location);
        try {
            if (locationType == 2) {
                org = this.getAMStoreConnection().getOrganization(location);
                currentServices = orgUnit.getRegisteredServiceNames();
            } else {
                orgUnit = this.getAMStoreConnection().getOrganizationalUnit(location);
                currentServices = orgUnit.getRegisteredServiceNames();
            }
        }
        catch (SSOException ssoe) {
            debug.warning("DMModelBase.removeServices", (Throwable)((Object)ssoe));
        }
        catch (AMException ame) {
            debug.warning("DMModelBase.removeServices", (Throwable)ame);
        }
        Iterator i = services.iterator();
        while (i.hasNext()) {
            String[] paramsEx;
            String msgId;
            boolean bOrganization = false;
            String name = (String)i.next();
            try {
                if (!currentServices.contains(name)) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("DMModelBase.removeServies");
                    debug.message("skipping " + name + ", not a registerd service.");
                    continue;
                }
                bOrganization = locationType == 2;
                String[] params = new String[]{location, name};
                if (bOrganization) {
                    this.logEvent("ATTEMPT_DIR_MGR_REMOVE_SERIVCE_FROM_ORGANIZATION", params);
                    org.unregisterService(name);
                    this.logEvent("SUCCEED_DIR_MGR_REMOVE_SERIVCE_FROM_ORGANIZATION", params);
                    continue;
                }
                this.logEvent("ATTEMPT_DIR_MGR_REMOVE_SERIVCE_FROM_CONTAINER", params);
                orgUnit.unregisterService(name);
                this.logEvent("SUCCEED_DIR_MGR_REMOVE_SERIVCE_FROM_CONTAINER", params);
            }
            catch (SSOException ssoe) {
                msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_REMOVE_SERIVCE_FROM_ORGANIZATION" : "SSO_EXCEPTION_DIR_MGR_REMOVE_SERIVCE_FROM_CONTAINER";
                paramsEx = new String[]{location, name, this.getErrorString((Throwable)((Object)ssoe))};
                this.logEvent(msgId, paramsEx);
                debug.warning("DMModelBase.removeServices", (Throwable)((Object)ssoe));
            }
            catch (AMException ame) {
                msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_REMOVE_SERIVCE_FROM_ORGANIZATION" : "AM_EXCEPTION_DIR_MGR_REMOVE_SERIVCE_FROM_CONTAINER";
                paramsEx = new String[]{location, name, this.getErrorString(ame)};
                this.logEvent(msgId, paramsEx);
                debug.warning("DMModelBase.removeServices", (Throwable)ame);
            }
        }
    }

    protected Set getSchemaAttributes(String serviceName, SchemaType type) throws SSOException, SMSException {
        Set attributes = null;
        try {
            ServiceSchemaManager manager = this.getServiceSchemaManager(serviceName);
            ServiceSchema sub = manager.getSchema(type);
            attributes = sub.getAttributeSchemas();
        }
        catch (SSOException e) {
            debug.error("DMModelBase.getSchemaAttributes", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("DMModelBase.getSchemaAttributes", (Throwable)e);
        }
        return attributes != null ? attributes : Collections.EMPTY_SET;
    }

    private String getFilterSectionXML() {
        StringBuffer xml = new StringBuffer(1000);
        xml.append("<property>").append("<label name=\"LogicalOperatorLabel\" ").append("defaultValue=\"search.user.logical.operator\" ").append("labelFor=\"logicalOp\" />").append("<cc name=\"logicalOp\" tagclass=").append("\"com.sun.web.ui.taglib.html.CCDropDownMenuTag\">").append("<option label=\"" + this.getLogicalOrOpLabel() + "\" value=\"").append(this.getLogicalOrOpValue() + "\" /><option label=\"").append(this.getLogicalAndOpLabel() + "\" value=\"" + this.getLogicalAndOpValue()).append("\" /></cc><cc name=\"matchLabel\" tagclass=\"").append("com.sun.web.ui.taglib.html.CCStaticTextFieldTag\">").append("<attribute name=\"defaultValue\" ").append("value=\"search.user.logical.operator.label\" /></cc>").append("</property>");
        return xml.toString();
    }

    private String processFilterSection(StringBuffer xml) {
        String SECTION_NAME = "<section name";
        String REQUIRED_PROPERTY = "<property required=\"true\">";
        int start = xml.toString().indexOf(SECTION_NAME);
        int end = xml.toString().indexOf(62, start);
        xml.replace(start, end + 1, this.getFilterSectionXML());
        start = xml.toString().lastIndexOf("</section>\n");
        int length = "</section>\n".length();
        xml.delete(start, start + length);
        length = REQUIRED_PROPERTY.length();
        int idx = xml.toString().indexOf(REQUIRED_PROPERTY);
        while (idx != -1) {
            xml.replace(idx, idx + length, "<property >\n");
            idx = xml.toString().indexOf(REQUIRED_PROPERTY);
        }
        return xml.toString();
    }

    protected String getFilterAttributesXML() {
        if (this.filterAttributeXML == null) {
            StringBuffer buff = new StringBuffer(500);
            try {
                PropertyXMLBuilder xmlBuilder = new PropertyXMLBuilder("iPlanetAMUserService", (AMModel)this, this.getFilterAttributes());
                buff.append(xmlBuilder.getXML(false));
                this.filterAttributeXML = this.processFilterSection(buff);
            }
            catch (SSOException e) {
                debug.error("DMModelBase.getFilterAttributesXML", (Throwable)((Object)e));
            }
            catch (SMSException e) {
                debug.error("DMModelBase.getFilterAttributesXML", (Throwable)e);
            }
            catch (AMConsoleException e) {
                debug.error("DMModelBase.getFilterAttributesXML", (Throwable)e);
            }
        }
        return this.filterAttributeXML;
    }

    protected Set getFilterAttributes() {
        if (this.filterAttributes == null) {
            this.filterAttributes = new HashSet();
            try {
                this.filterAttributes = this.getSchemaAttributes("iPlanetAMUserService", SchemaType.USER);
                String[] show = new String[]{"filter"};
                PropertyXMLBuilder.filterAttributes(this.filterAttributes, show);
            }
            catch (SSOException e) {
                debug.error("DMModelBase.getFilterAttributes", (Throwable)((Object)e));
            }
            catch (SMSException e) {
                debug.error("DMModelBase.getFilterAttributes", (Throwable)e);
            }
        }
        return this.filterAttributes;
    }

    protected Set getFilterAttributeNames() {
        if (this.filterAttributeNames == null) {
            this.filterAttributeNames = new HashSet();
            for (AttributeSchema as : this.getFilterAttributes()) {
                this.filterAttributeNames.add(as.getName());
            }
            this.filterAttributeNames.add("logicalOp");
        }
        return this.filterAttributeNames;
    }

    protected String generateFilter(Map attributes) {
        StringBuffer filter = new StringBuffer(512);
        for (AttributeSchema as : attributes.keySet()) {
            String key = as.getName();
            Set value = (Set)attributes.remove(key);
            if (value == null || value.isEmpty()) {
                if (!key.equals("uid")) continue;
                filter.append("(" + key + "=*)");
                continue;
            }
            Iterator valIter = value.iterator();
            String val = (String)valIter.next();
            if (key.equalsIgnoreCase("inetuserstatus")) {
                if (val.equalsIgnoreCase("Active")) {
                    filter.append("(|(").append("inetuserstatus").append("=active)(!(").append("inetuserstatus").append("=*)))");
                    continue;
                }
                filter.append("(").append("inetuserstatus").append("=").append(val).append(")");
                continue;
            }
            if (val.length() > 0) {
                filter.append("(").append(key).append("=").append(val).append(")");
                continue;
            }
            if (!key.equals("uid")) continue;
            filter.append("(uid=*)");
        }
        return filter.toString();
    }

    protected String getParentDN(String dn) throws AMException, SSOException {
        AMObject obj = this.getAMObject(dn);
        return obj.getOrganizationDN();
    }

    protected boolean hasDisplayedAttributes(String service, SchemaType type) {
        Set as;
        ServiceSchema schema = null;
        try {
            schema = this.getServiceSchema(service, type);
        }
        catch (SMSException e) {
            debug.warning("DMModelBase.hasDisplayedAttributes", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("DMModelBase.hasDisplayedAttributes", (Throwable)((Object)e));
        }
        boolean display = false;
        if (schema != null && (as = schema.getAttributeSchemas()) != null && !as.isEmpty()) {
            Iterator i = as.iterator();
            while (i.hasNext() && !display) {
                if (!this.isDisplayed((AttributeSchema)i.next())) continue;
                display = true;
            }
        }
        return display;
    }

    public String getUniversalId(String dn) {
        String universalId = "";
        try {
            AMObject obj = this.getAMObject(dn);
            String orgDN = obj.getOrganizationDN();
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), dn, orgDN);
            universalId = IdUtils.getUniversalId(amid);
        }
        catch (AMException e) {
            debug.error("DMModelBase.getUniversalId", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("DMModelBase.getUniversalId", (Throwable)((Object)e));
        }
        catch (IdRepoException e) {
            debug.error("DMModelBase.getUniversalId", (Throwable)e);
        }
        return universalId;
    }

    private String getLogicalOrOpLabel() {
        return this.getLocalizedString("logicalOR.label");
    }

    private String getLogicalOrOpValue() {
        return "OR";
    }

    private String getLogicalAndOpValue() {
        return "AND";
    }

    private String getLogicalAndOpLabel() {
        return this.getLocalizedString("logicalAND.label");
    }

    protected String removeSectionTags(String xml) {
        if (xml.length() > 0) {
            int idx = xml.indexOf(">");
            if ((idx = (xml = xml.substring(idx + 1)).lastIndexOf("</section>\n")) != -1) {
                xml = xml.substring(0, idx);
            }
        }
        return xml;
    }

    protected AMGroup getAMGroup(String dn) {
        AMGroup group = null;
        int locType = this.getObjectType(dn);
        switch (locType) {
            case 11: {
                group = this.getDynamicGroup(dn);
                break;
            }
            case 12: {
                group = this.getAssignableDynamicGroup(dn);
                break;
            }
            case 9: 
            case 10: {
                group = this.getStaticGroup(dn);
            }
        }
        return group;
    }

    protected AMGroup getDynamicGroup(String dn) {
        AMDynamicGroup group = null;
        try {
            group = this.getAMStoreConnection().getDynamicGroup(dn);
        }
        catch (SSOException ssoe) {
            debug.warning("DMModel.getDynamicGroup", (Throwable)((Object)ssoe));
        }
        return group;
    }

    protected AMGroup getAssignableDynamicGroup(String dn) {
        AMAssignableDynamicGroup group = null;
        try {
            group = this.getAMStoreConnection().getAssignableDynamicGroup(dn);
        }
        catch (SSOException ssoe) {
            debug.warning("DMModel.getAssignableDynamicGroup", (Throwable)((Object)ssoe));
        }
        return group;
    }

    protected AMGroup getStaticGroup(String dn) {
        AMStaticGroup group = null;
        try {
            group = this.getAMStoreConnection().getStaticGroup(dn);
        }
        catch (SSOException ssoe) {
            debug.warning("DMModel.getStaticGroup", (Throwable)((Object)ssoe));
        }
        return group;
    }

    protected void setMandatoryAttributes(Set attributeSchemas) {
        for (AttributeSchema as : attributeSchemas) {
            String any = as.getAny();
            if (!PropertyXMLBuilderBase.hasAnyAttribute(as.getAny(), "required")) continue;
            this.mandatoryAttributes.put(as.getName(), as);
        }
    }

    protected void validateRequiredAttributes(Map data) throws AMConsoleException {
        for (String attrName : data.keySet()) {
            AttributeSchema as = (AttributeSchema)this.mandatoryAttributes.get(attrName);
            if (as == null || reqValidator.validate((Set)data.get(attrName))) continue;
            String serviceName = as.getServiceSchema().getServiceName();
            String expMsg = this.getLocalizedString("entity-values-missing");
            ResourceBundle rb = this.getServiceResourceBundle(serviceName);
            Object[] arg = new String[]{Locale.getString((ResourceBundle)rb, (String)as.getI18NKey(), (Debug)debug)};
            throw new AMConsoleException(MessageFormat.format(expMsg, arg));
        }
    }

    protected String getSearchReturnValue() {
        String searchAttr = null;
        try {
            AMOrganization orgObject = (AMOrganization)this.getAMObject(this.getStartDSDN());
            searchAttr = this.getSearchReturnValue(orgObject);
        }
        catch (SSOException ssoe) {
            debug.warning("DMModelBase.getSearchReturnValue", (Throwable)((Object)ssoe));
        }
        catch (AMException dpe) {
            debug.warning("DMModelBase.getSearchReturnValue", (Throwable)dpe);
        }
        if (searchAttr == null || searchAttr.length() == 0) {
            searchAttr = AdminInterfaceUtils.getNamingAttribute(1, debug);
        }
        return searchAttr;
    }

    private String getSearchReturnValue(AMObject obj) {
        String searchAttr = null;
        try {
            AMTemplate amTemplate = this.getOrgTemplate(obj);
            if (amTemplate != null) {
                searchAttr = this.getStringAttribute(amTemplate, "iplanet-am-admin-console-user-return-attribute");
            } else {
                ServiceSchemaManager mgr = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (mgr != null) {
                    searchAttr = DMModelBase.getStringAttribute(mgr, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-return-attribute");
                }
            }
        }
        catch (SMSException smse) {
            debug.warning("DMModelBase.getUserSearchReturnAttribute", (Throwable)smse);
        }
        catch (SSOException ssoe) {
            debug.warning("DMModelBase.getUserSearchReturnAttribute", (Throwable)((Object)ssoe));
        }
        catch (AMException dpe) {
            debug.warning("DMModelBase.getUserSearchReturnAttribute", (Throwable)dpe);
        }
        return searchAttr;
    }

    protected String getValidUserAttributes(String value) {
        StringBuffer userAttributes;
        block6: {
            userAttributes = new StringBuffer(16);
            if (value != null && value.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(value);
                try {
                    ServiceSchemaManager mgr = this.getServiceSchemaManager("iPlanetAMUserService");
                    ServiceSchema schema = mgr.getSchema(SchemaType.USER);
                    Set attributeNames = schema.getAttributeSchemaNames();
                    while (tokenizer.hasMoreTokens()) {
                        String tmp = tokenizer.nextToken();
                        if (!attributeNames.contains(tmp)) continue;
                        userAttributes.append(" ").append(tmp);
                    }
                }
                catch (SSOException s) {
                    if (debug.warningEnabled()) {
                        debug.warning("DMModel.getValidUserAttributes", (Throwable)((Object)s));
                    }
                }
                catch (SMSException se) {
                    if (!debug.warningEnabled()) break block6;
                    debug.warning("DMModel.getValidUserAttributes", (Throwable)se);
                }
            }
        }
        return userAttributes.length() > 0 ? userAttributes.toString() : AdminInterfaceUtils.getNamingAttribute(1, debug);
    }

    public boolean createOrganization(String location) {
        int type = this.getObjectType(location);
        return type == 2 || type == 3;
    }

    public boolean createOrganizationUnit(String location) {
        int type = this.getObjectType(location);
        return type == 2 || type == 3;
    }

    public boolean createGroupContainer(String location) {
        int type = this.getObjectType(location);
        return type == 2 || type == 3 || type == 4;
    }

    public boolean createGroup(String location) {
        boolean create = true;
        int type = this.getObjectType(location);
        if (this.groupContainerDisplay && type != 4 && type != 9 && type != 11 && type != 10 && type != 12 || !this.groupContainerDisplay && type != 2 && type != 3 && type != 9 && type != 11 && type != 10 && type != 12) {
            create = false;
        }
        return create;
    }

    public boolean createRole(String location) {
        int type = this.getObjectType(location);
        return type == 2 || type == 3;
    }

    public boolean createPeopleContainer(String location) {
        int type = this.getObjectType(location);
        return type == 2 || type == 3 || type == 5;
    }

    public boolean createUser(String location) {
        boolean create = true;
        int type = this.getObjectType(location);
        if (this.peopleContainerDisplay && type != 5 || !this.peopleContainerDisplay && type != 2 && type != 3) {
            create = false;
        }
        return create;
    }

    public int getObjectType(String name) {
        int objectType = -1;
        if (name == null || name.length() == 0) {
            debug.warning("DMModelBase.Invalid object type");
        } else {
            AMStoreConnection storeConn = this.getAdminStoreConnection();
            try {
                Set services;
                if (DN.isDN((String)name) || name.indexOf("/") != -1) {
                    objectType = storeConn.getAMObjectType(name);
                } else if (this.locationDN != null && DN.isDN((String)this.locationDN) && (services = this.getServiceList(this.locationDN)).contains(name)) {
                    objectType = 15;
                }
            }
            catch (AMException e) {
                debug.warning("DMModelBase.getObjectType", (Throwable)e);
            }
            catch (SSOException e) {
                debug.warning("DMModelBase.getObjectType", (Throwable)((Object)e));
            }
        }
        return objectType;
    }

    protected Set getServiceList(String dn) throws AMException, SSOException {
        Set list = Collections.EMPTY_SET;
        int type = this.getObjectType(dn);
        AMStoreConnection sc = this.getAMStoreConnection();
        list = type == 2 ? sc.getOrganization(dn).getRegisteredServiceNames() : (type == 3 ? sc.getOrganizationalUnit(dn).getRegisteredServiceNames() : this.getServiceList(AMAdminUtils.getParent(dn)));
        return list;
    }

    protected AMStoreConnection getAMStoreConnection() {
        try {
            if (this.dpStoreConn == null) {
                this.dpStoreConn = new AMStoreConnection(this.getUserSSOToken());
            }
        }
        catch (SSOException ssoe) {
            debug.error("DMModelBase.getAMStoreConnection", (Throwable)((Object)ssoe));
        }
        return this.dpStoreConn;
    }

    public boolean showGroupContainers() {
        int type = this.getObjectType(this.getStartDSDN());
        boolean display = type == 2 || type == 3 || type == 4;
        return this.groupContainerDisplay && display;
    }

    public boolean showPeopleContainers() {
        int type = this.getObjectType(this.getStartDSDN());
        boolean display = type == 2 || type == 3 || type == 5;
        return display && this.peopleContainerDisplay;
    }

    public boolean showOrgUnits() {
        int type = this.getObjectType(this.getStartDSDN());
        boolean display = type == 2 || type == 3;
        return display && this.orgUnitDisplay;
    }

    public boolean showOrganizations() {
        int type = this.getObjectType(this.getStartDSDN());
        return type == 2 || type == 3;
    }

    public boolean showGroups() {
        int type = this.getObjectType(this.getStartDSDN());
        return type == 2 || type == 3 || type == 9 || type == 4;
    }

    public boolean showRoles() {
        int type = this.getObjectType(this.getStartDSDN());
        return type == 2 || type == 3 || type == 6 || type == 7 || type == 8;
    }

    public AMObject getAMObject(String dn) throws AMException, SSOException {
        AMStoreConnection sc = this.getAdminStoreConnection();
        AMObject dpObj = null;
        int objectType = this.getObjectType(dn);
        switch (objectType) {
            case 2: {
                dpObj = sc.getOrganization(dn);
                break;
            }
            case 3: {
                dpObj = sc.getOrganizationalUnit(dn);
                break;
            }
            case 9: 
            case 10: {
                dpObj = sc.getStaticGroup(dn);
                break;
            }
            case 11: {
                dpObj = sc.getDynamicGroup(dn);
                break;
            }
            case 12: {
                dpObj = sc.getAssignableDynamicGroup(dn);
                break;
            }
            case 6: {
                dpObj = sc.getRole(dn);
                break;
            }
            case 8: {
                dpObj = sc.getFilteredRole(dn);
                break;
            }
            case 1: {
                dpObj = sc.getUser(dn);
                break;
            }
            case 5: {
                dpObj = sc.getPeopleContainer(dn);
                break;
            }
            case 4: {
                dpObj = sc.getGroupContainer(dn);
                break;
            }
            default: {
                if (!debug.warningEnabled()) break;
                debug.warning("DMModelBase.getAMObject: Cannot create AMObject for:" + dn);
            }
        }
        return dpObj;
    }

    protected AMStoreConnection getAdminStoreConnection() {
        AMStoreConnection storeConn = null;
        SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (adminSSOToken != null) {
            try {
                storeConn = new AMStoreConnection(adminSSOToken);
            }
            catch (SSOException ssoe) {
                debug.warning("DMModelBase.getAdminStoreConnection", (Throwable)((Object)ssoe));
            }
        }
        return storeConn;
    }

    public String getDisplayPath(String dn) {
        StringBuffer path = new StringBuffer(64);
        List nodes = this.pathToDisplayString(dn);
        int size = nodes.size();
        for (int x = 0; x < size; ++x) {
            String tmp = (String)nodes.get(x);
            path.append(AMFormatUtils.DNToName(this, tmp));
            if (x >= size - 1) continue;
            path.append(" > ");
        }
        return path.toString();
    }

    public List pathToDisplayString(String dn) {
        int locType = this.getObjectType(dn);
        boolean isRole = locType == 6 || locType == 8;
        return this.pathToDisplayString(dn, this.getStartDN(), isRole);
    }

    public List pathToDisplayString(String dn, String startDN, boolean isRole) {
        List<String> pp = null;
        DN dnObj = new DN(dn);
        DN startDNObj = new DN(startDN);
        if (dnObj.equals(startDNObj)) {
            pp = new ArrayList(1);
            if (dn.equalsIgnoreCase(this.getStartDSDN())) {
                pp.add(this.getStartDSDN());
            } else {
                pp.add(this.DNToName(startDN, isRole));
            }
        } else {
            pp = this.pathToDisplayString(LDAPDN.explodeDN((String)dn, (boolean)false), dn, isRole);
        }
        return pp;
    }

    private List pathToDisplayString(String[] RDNs, String locDN, boolean isRole) {
        int size = RDNs.length;
        ArrayList<String> pp = new ArrayList<String>(size);
        DN currentDN = null;
        DN startDNObj = new DN(this.getStartDSDN());
        for (int i = size - 1; i >= 0; --i) {
            String rootSuffix = this.getStartDSDN();
            if (currentDN == null) {
                currentDN = new DN(RDNs[i]);
            } else {
                currentDN.addRDN(new RDN(RDNs[i]));
            }
            if (!startDNObj.equals(currentDN)) continue;
            String dn = currentDN.toString();
            if (rootSuffix.equalsIgnoreCase(dn)) {
                pp.add(rootSuffix);
            } else {
                pp.add(dn);
            }
            for (int j = i - 1; j > 0; --j) {
                currentDN.addRDN(new RDN(RDNs[j]));
                dn = currentDN.toString();
                pp.add(dn);
            }
            break;
        }
        pp.add(this.DNToName(locDN, isRole));
        return pp;
    }

    public String getStringAttribute(AMTemplate template, String attribute) throws AMException, SSOException {
        Set tmp = this.getAttribute(template, attribute);
        return tmp != null && !tmp.isEmpty() ? (String)tmp.iterator().next() : "";
    }

    public static String getStringAttribute(ServiceSchemaManager svcSchemaMgr, SchemaType type, String attribute) throws SMSException {
        Set tmp = AMAdminUtils.getAttribute(svcSchemaMgr, type, attribute);
        return tmp != null && !tmp.isEmpty() ? (String)tmp.iterator().next() : "";
    }

    public Set getAttribute(AMTemplate template, String attribute) throws AMException, SSOException {
        Set value = Collections.EMPTY_SET;
        if (template != null) {
            value = template.getAttribute(attribute);
        }
        return value == null ? Collections.EMPTY_SET : value;
    }

    public String getRoleDisplayName(String roleName) {
        String suffix = this.getLocalizedString("admin_suffix.name");
        String grpNamingAttr = AdminInterfaceUtils.getNamingAttribute(9, debug) + "=";
        String pcNamingAttr = AdminInterfaceUtils.getNamingAttribute(5, debug) + "=";
        if (roleName.startsWith(grpNamingAttr)) {
            int start = 3;
            int end = roleName.indexOf("_" + grpNamingAttr);
            if (end == -1 && (end = roleName.lastIndexOf("_" + AdminInterfaceUtils.getNamingAttribute(4, debug))) == -1) {
                end = roleName.length();
            }
            roleName = roleName.substring(start, end) + " " + suffix;
        } else if (roleName.startsWith(pcNamingAttr)) {
            int start = 3;
            int end = (roleName = roleName.substring(start)).indexOf("_");
            if (end == -1) {
                end = roleName.length();
            }
            roleName = roleName.substring(0, end) + " " + suffix;
        }
        return roleName;
    }

    public String DNToName(String dn, boolean isRoleDN) {
        String ret = dn;
        if (DN.isDN((String)dn)) {
            String[] comps = LDAPDN.explodeDN((String)dn, (boolean)true);
            ret = comps[0];
            if (isRoleDN) {
                String HD_NAME = "help_desk_" + AdminInterfaceUtils.getNamingAttribute(9, debug) + "=";
                String suffix = this.getLocalizedString("admin_suffix.name");
                if (ret.startsWith(HD_NAME)) {
                    ret = ret.substring(HD_NAME.length());
                    suffix = this.getLocalizedString("help_desk_admin_suffix.name");
                    int end = ret.indexOf("_");
                    if (end == -1) {
                        end = ret.length();
                    }
                    ret = ret.substring(0, end) + " " + suffix;
                } else {
                    String grpNamingAttr = AdminInterfaceUtils.getNamingAttribute(9, debug);
                    String pcNamingAttr = AdminInterfaceUtils.getNamingAttribute(5, debug);
                    if (ret.startsWith(grpNamingAttr + "=")) {
                        int start = 3;
                        int end = ret.indexOf("_" + grpNamingAttr + "=");
                        if (end == -1 && (end = ret.lastIndexOf("_" + AdminInterfaceUtils.getNamingAttribute(4, debug))) == -1) {
                            end = ret.length();
                        }
                        ret = ret.substring(start, end) + " " + suffix;
                    } else if (ret.startsWith(pcNamingAttr + "=")) {
                        int start = 3;
                        int end = (ret = ret.substring(start)).indexOf("_");
                        if (end == -1) {
                            end = ret.length();
                        }
                        ret = ret.substring(0, end) + " " + suffix;
                    }
                }
            }
        }
        return ret;
    }

    public String getSearchResultWarningMessage(AMSearchResults results) {
        String message = null;
        if (results != null) {
            int errorCode = results.getErrorCode();
            if (errorCode == 1) {
                message = this.getLocalizedString("sizeLimitExceeded.message");
            } else if (errorCode == 2) {
                message = this.getLocalizedString("timeLimitExceeded.message");
            }
        }
        return message != null ? message : "";
    }

    public String getNameColumnLabel() {
        String name;
        block5: {
            name = null;
            try {
                String attribute = this.getUserDisplayAttribute();
                ServiceSchemaManager mgr = this.getServiceSchemaManager("iPlanetAMUserService");
                ServiceSchema schema = mgr.getSchema(SchemaType.USER);
                AttributeSchema as = schema.getAttributeSchema(attribute);
                if (as != null) {
                    String i18nKey = as.getI18NKey();
                    name = this.getL10NAttributeName(mgr, i18nKey);
                }
            }
            catch (SSOException s) {
                if (debug.warningEnabled()) {
                    debug.warning("DMModel.getNameColumnLabel", (Throwable)((Object)s));
                }
            }
            catch (SMSException se) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("DMModel.getNameColumnLabel", (Throwable)se);
            }
        }
        return name != null ? name : this.getLocalizedString(this.DEFAULT_NAME_COLUMN);
    }

    public String getUserDisplayValue(String dn) {
        String displayValue = null;
        try {
            String displayAttribute = this.getUserDisplayAttribute();
            if (displayAttribute == null) {
                displayAttribute = AdminInterfaceUtils.getNamingAttribute(1, debug);
            }
            Set values = null;
            if (this.resultsMap != null && !this.resultsMap.isEmpty()) {
                Map dnEntry = (Map)this.resultsMap.get(dn);
                values = (Set)dnEntry.get(displayAttribute);
            } else {
                AMObject dnEntry = this.getAMObject(dn);
                values = dnEntry.getAttribute(displayAttribute);
            }
            displayValue = values != null && !values.isEmpty() ? (String)values.iterator().next() : this.EMPTY_DISPLAY_STRING;
        }
        catch (AMException ae) {
            if (debug.warningEnabled()) {
                debug.warning("DMModelBase.getUserDisplayValue " + dn + " is not a user entry. Returning DN");
            }
        }
        catch (SSOException s) {
            debug.warning("DMModelBase.getUserDisplayValue", (Throwable)((Object)s));
        }
        return displayValue != null ? displayValue : this.DNToName(dn, false);
    }

    String createUserSearchFilter(String pattern) throws SSOException {
        String searchAttribute = null;
        if (pattern.equals(this.DEFAULT_SEARCH_PATTERN)) {
            searchAttribute = AdminInterfaceUtils.getNamingAttribute(1, debug);
        } else {
            searchAttribute = this.getUserSearchAttribute();
            if (searchAttribute == null) {
                searchAttribute = AdminInterfaceUtils.getNamingAttribute(1, debug);
            }
        }
        StringBuffer searchFilter = new StringBuffer(20);
        searchFilter.append("(").append(searchAttribute).append("=").append(pattern).append(")");
        return searchFilter.toString();
    }
}

