/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.DNUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.PluginInterface;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSNotificationManager;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchemaImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ServiceSchemaManagerImpl
implements SMSObjectListener {
    private String serviceName;
    private String version;
    private int instanceID;
    private String i18nKey;
    private String i18nFileName;
    private String i18nJarURL;
    private String serviceHierarchy;
    private String viewBeanURL;
    private int revisionNumber;
    private ServiceManager sm;
    private CachedSMSEntry smsEntry;
    private Map listenerObjects;
    private String listenerId;
    private String xmlSchema;
    private Document document;
    private Node schemaRoot;
    private Map subSchemas;
    private Map pluginInterfaces;
    private static Debug debug = SMSEntry.debug;
    private static Map schemaManagers = Collections.synchronizedMap(new HashMap());
    private static final int DEFAULT_REVISION = 10;
    private static final int REVISION_ERROR = -1;

    private ServiceSchemaManagerImpl(SSOToken t, String serviceName, String version) throws SMSException, SSOException {
        this.serviceName = serviceName;
        this.version = version;
        this.instanceID = SMSUtils.getInstanceID();
        this.subSchemas = new HashMap();
        this.pluginInterfaces = new HashMap();
        this.smsEntry = CachedSMSEntry.getInstance(t, this, serviceName, version);
        if (!this.isValid()) {
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        this.update();
    }

    public boolean isValid() throws SMSException {
        if (this.smsEntry.isValid() && this.smsEntry.isDirty()) {
            this.smsEntry.refresh();
        }
        if (this.smsEntry.isNewEntry()) {
            Object[] msgs = new String[]{this.serviceName};
            throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", msgs);
        }
        return this.smsEntry.isValid();
    }

    public String getName() {
        return this.serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    String getI18NKey() {
        return this.i18nKey;
    }

    void setI18NKey(String fn) throws SMSException, SSOException {
        this.i18nKey = fn;
        Node schemaNode = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)schemaNode).setAttribute("i18nKey", fn);
    }

    int getRevisionNumber() {
        return this.revisionNumber;
    }

    void setRevisionNumber(int revisionNumber) throws SMSException, SSOException {
        this.revisionNumber = revisionNumber;
        Node schemaNode = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)schemaNode).setAttribute("revisionNumber", Integer.toString(revisionNumber));
    }

    String getI18NFileName() {
        return this.i18nFileName;
    }

    void setI18NFileName(String fn) throws SMSException, SSOException {
        this.i18nFileName = fn;
        Node schemaNode = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)schemaNode).setAttribute("i18nFileName", fn);
    }

    String getI18NJarURL() {
        return this.i18nJarURL;
    }

    void setI18NJarURL(String url) throws SMSException, SSOException {
        this.i18nJarURL = url;
        Node schemaNode = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)schemaNode).setAttribute("i18nJarURL", url);
    }

    String getServiceHierarchy() {
        return this.serviceHierarchy;
    }

    void setServiceHierarchy(String newhierarchy) throws SMSException, SSOException {
        this.serviceHierarchy = newhierarchy;
        Node schemaNode = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)schemaNode).setAttribute("serviceHierarchy", newhierarchy);
    }

    String getPropertiesViewBeanURL() {
        return this.viewBeanURL;
    }

    void setPropertiesViewBeanURL(String newhierarchy) throws SMSException, SSOException {
        this.viewBeanURL = newhierarchy;
        Node schemaNode = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)schemaNode).setAttribute("propertiesViewBeanURL", newhierarchy);
    }

    Set getSchemaTypes() throws SMSException {
        return new HashSet(this.subSchemas.keySet());
    }

    ServiceSchemaImpl getSchema(SchemaType type) {
        ServiceSchemaImpl answer = (ServiceSchemaImpl)this.subSchemas.get(type);
        return answer;
    }

    InputStream getSchema() {
        return new ByteArrayInputStream(this.xmlSchema.getBytes());
    }

    CachedSMSEntry getCachedSMSEntry() {
        return this.smsEntry;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        hash = 89 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 89 * hash + this.instanceID;
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceSchemaManagerImpl) {
            ServiceSchemaManagerImpl ssm = (ServiceSchemaManagerImpl)o;
            if (this.serviceName.equalsIgnoreCase(ssm.serviceName) && this.version.equalsIgnoreCase(ssm.version) && this.instanceID == ssm.instanceID) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("\nService Schema Manager: ").append(this.serviceName).append("\n\tVersion: ").append(this.version);
        sb.append("\nI18n file name: " + this.getI18NFileName());
        sb.append("\nI18n Jar URL: " + this.getI18NJarURL());
        sb.append("\nService hierarchy: " + this.getServiceHierarchy());
        sb.append("\nProperty View Bean: " + this.getPropertiesViewBeanURL());
        ServiceSchemaImpl ss = this.getSchema(SchemaType.GLOBAL);
        if (ss != null) {
            sb.append("\nGlobal Schema:\n").append(ss.toString());
        }
        if ((ss = this.getSchema(SchemaType.ORGANIZATION)) != null) {
            sb.append("Organization Schema:\n").append(ss.toString());
        }
        if ((ss = this.getSchema(SchemaType.DYNAMIC)) != null) {
            sb.append("Dynamic Schema:\n").append(ss.toString());
        }
        if ((ss = this.getSchema(SchemaType.USER)) != null) {
            sb.append("User Schema:\n").append(ss.toString());
        }
        if ((ss = this.getSchema(SchemaType.POLICY)) != null) {
            sb.append("Policy Schema:\n").append(ss.toString());
        }
        return sb.toString();
    }

    synchronized String addListener(ServiceListener listener) {
        if (this.listenerObjects == null) {
            this.listenerObjects = Collections.synchronizedMap(new HashMap());
        }
        if (this.listenerObjects.isEmpty()) {
            this.listenerId = SMSNotificationManager.getInstance().registerCallbackHandler(this);
        }
        String id = SMSUtils.getUniqueID();
        this.listenerObjects.put(id, listener);
        return id;
    }

    synchronized void removeListener(String listenerID) {
        if (this.listenerObjects != null) {
            this.listenerObjects.remove(listenerID);
            if (this.listenerObjects.isEmpty()) {
                SMSNotificationManager.getInstance().removeCallbackHandler(listenerID);
            }
        }
    }

    public void objectChanged(String name, int type) {
        String dn = ServiceManager.getServiceNameDN(this.serviceName, this.version);
        if (DNUtils.normalizeDN(dn).equals(DNUtils.normalizeDN(name))) {
            if (debug.messageEnabled()) {
                debug.message("ServiceSchemaManagerImpl:objectChanged for " + this.serviceName + "(" + this.version + ")");
            }
            this.allObjectsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allObjectsChanged() {
        if (this.listenerObjects != null && !this.listenerObjects.isEmpty()) {
            HashSet lObjects = new HashSet();
            Map map = this.listenerObjects;
            synchronized (map) {
                lObjects.addAll(this.listenerObjects.values());
            }
            for (ServiceListener listener : lObjects) {
                if (debug.messageEnabled()) {
                    debug.message("ServiceSchemaManagerImpl:Sending change notification to: " + listener.getClass().getName());
                }
                try {
                    listener.schemaChanged(this.serviceName, this.version);
                }
                catch (Throwable t) {
                    debug.error("ServiceSchemaManagerImpl:allObjectsChanged. Listeners Exception sending notification to class: " + listener.getClass().getName(), t);
                }
            }
        }
    }

    Set getPluginInterfaceNames() {
        return new HashSet(this.pluginInterfaces.keySet());
    }

    PluginInterface getPluginInterface(String piName) {
        return (PluginInterface)this.pluginInterfaces.get(piName);
    }

    void setServiceManager(ServiceManager sm) {
        this.sm = sm;
    }

    Document getDocument() {
        return this.document;
    }

    Document getDocumentCopy() throws SMSException {
        String schema = this.xmlSchema;
        if (schema == null || schema.length() == 0) {
            schema = SMSSchema.getDummyXML(this.serviceName, this.version);
        }
        return SMSSchema.getXMLDocument(schema, false);
    }

    protected void finalize() throws Throwable {
        this.smsEntry.removeServiceListener(this);
    }

    synchronized void update() {
        if (!this.smsEntry.isValid()) {
            this.clear();
            return;
        }
        this.xmlSchema = this.smsEntry.getXMLSchema();
        if (this.xmlSchema == null) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceSchemaManagerImpl:: schema is null " + this.serviceName + "(" + this.version + ")");
            }
            return;
        }
        try {
            this.document = SMSSchema.getXMLDocument(SMSSchema.getServiceSchemaInputStream(this.xmlSchema), false);
            this.schemaRoot = XMLUtils.getRootNode((Document)this.document, (String)"Schema");
        }
        catch (Exception e) {
            debug.error("ServiceSchemaManagerImpl: XML parser error: " + this.serviceName + "(" + this.version + ")", (Throwable)e);
            return;
        }
        if (this.schemaRoot == null) {
            debug.warning("ServiceSchemaManagerImpl: " + this.serviceName + "no schema found");
            return;
        }
        this.i18nKey = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"i18nKey");
        this.i18nFileName = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"i18nFileName");
        this.i18nJarURL = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"i18nJarURL");
        this.serviceHierarchy = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"serviceHierarchy");
        this.viewBeanURL = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"propertiesViewBeanURL");
        String revNum = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"revisionNumber");
        try {
            this.revisionNumber = revNum != null ? Integer.parseInt(revNum) : 10;
        }
        catch (Exception e) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceSchemaManagerImpl ==> " + this.serviceName + ": Invalid revision revision number: " + revNum, (Throwable)e);
            }
            this.revisionNumber = -1;
        }
        this.updateSchema(SchemaType.GLOBAL, "Global");
        this.updateSchema(SchemaType.ORGANIZATION, "Organization");
        this.updateSchema(SchemaType.DYNAMIC, "Dynamic");
        this.updateSchema(SchemaType.USER, "User");
        this.updateSchema(SchemaType.POLICY, "Policy");
        this.updateSchema(SchemaType.GROUP, "Group");
        this.updateSchema(SchemaType.DOMAIN, "Domain");
        this.updateGenericSchema("Generic");
        Iterator pins = XMLUtils.getChildNodes((Node)this.schemaRoot, (String)"PluginInterface").iterator();
        while (pins.hasNext()) {
            PluginInterface pi = new PluginInterface((Node)pins.next());
            this.pluginInterfaces.put(pi.getName(), pi);
        }
    }

    void updateGenericSchema(String schemaName) {
        for (Node childNode : XMLUtils.getChildNodes((Node)this.schemaRoot, (String)schemaName)) {
            String stype = XMLUtils.getNodeAttributeValue((Node)childNode, (String)"type");
            if (stype == null) continue;
            SchemaType type = new SchemaType(stype.toUpperCase());
            ServiceSchemaImpl ss = (ServiceSchemaImpl)this.subSchemas.get(type);
            if (ss != null) {
                ss.update(childNode);
                continue;
            }
            this.subSchemas.put(type, new ServiceSchemaImpl(this, childNode));
        }
    }

    void updateSchema(SchemaType type, String schemaName) {
        Node childNode = XMLUtils.getChildNode((Node)this.schemaRoot, (String)schemaName);
        if (childNode == null) {
            this.subSchemas.remove(type);
        } else {
            ServiceSchemaImpl ss = (ServiceSchemaImpl)this.subSchemas.get(type);
            if (ss != null) {
                ss.update(childNode);
            } else {
                this.subSchemas.put(type, new ServiceSchemaImpl(this, childNode));
            }
        }
    }

    private void clear() {
        this.smsEntry.removeServiceListener(this);
        if (this.smsEntry.isValid()) {
            this.smsEntry.clear();
        }
        if (this.listenerObjects == null || this.listenerObjects.isEmpty()) {
            SMSNotificationManager.getInstance().removeCallbackHandler(this.listenerId);
        }
        this.xmlSchema = null;
        this.document = null;
        this.schemaRoot = null;
        this.subSchemas.clear();
        this.pluginInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceSchemaManagerImpl getInstance(SSOToken t, String serviceName, String version) throws SMSException, SSOException {
        String cacheName = ServiceManager.getCacheIndex(serviceName, version);
        ServiceSchemaManagerImpl ssmi = (ServiceSchemaManagerImpl)schemaManagers.get(cacheName);
        if (ssmi != null && !ssmi.isValid()) {
            schemaManagers.remove(cacheName);
            ssmi = null;
        }
        if (ssmi != null) {
            if (!SMSEntry.cacheSMSEntries) {
                ssmi.smsEntry.refresh();
            }
            return ssmi;
        }
        Map map = schemaManagers;
        synchronized (map) {
            ssmi = (ServiceSchemaManagerImpl)schemaManagers.get(cacheName);
            if (ssmi == null || !ssmi.isValid()) {
                ssmi = new ServiceSchemaManagerImpl(t, serviceName, version);
                schemaManagers.put(cacheName, ssmi);
            }
        }
        return ssmi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Map map = schemaManagers;
        synchronized (map) {
            for (ServiceSchemaManagerImpl ssmi : schemaManagers.values()) {
                ssmi.clear();
            }
            schemaManagers.clear();
        }
    }

    public String toXML(AMEncryption encryptObj) throws SMSException {
        Document doc = this.getDocumentCopy();
        ServiceManager.checkAndEncryptPasswordSyntax(doc, false, encryptObj);
        return SMSSchema.nodeToString(XMLUtils.getRootNode((Document)doc, (String)"Service"));
    }
}

