/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.flatfile;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.CaseInsensitiveProperties;
import com.sun.identity.common.CaseInsensitiveTreeSet;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaException;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.flatfile.FileNameDecoder;
import com.sun.identity.sm.flatfile.FileNameEncoder;
import com.sun.identity.sm.flatfile.SMSFlatFileObjectBase;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.naming.directory.ModificationItem;

public class SMSFlatFileObject
extends SMSFlatFileObjectBase {
    private Properties mNameMap = null;
    private File mNameMapHandle = null;
    static final String DEFAULT_NAMEMAP_FILENAME = "NameMap.properties";
    static final String DEFAULT_ATTRIBUTE_FILENAME = "Attributes.properties";

    protected void loadMapper() throws SMSException {
        block15: {
            StringBuffer nameMapFilename = new StringBuffer(this.mRootDir);
            nameMapFilename.append(File.separatorChar);
            nameMapFilename.append(DEFAULT_NAMEMAP_FILENAME);
            this.mNameMapHandle = new File(nameMapFilename.toString());
            if (this.mNameMapHandle.isFile()) {
                if (!this.mNameMapHandle.canRead()) {
                    String errmsg = "SMSFlatFileObject.initialize: cannot read file " + this.mNameMapHandle.getPath();
                    this.mDebug.error(errmsg);
                    throw new SMSException(errmsg);
                }
                this.mNameMap = this.loadProperties(this.mNameMapHandle, null);
            } else {
                block14: {
                    try {
                        this.mNameMapHandle.createNewFile();
                    }
                    catch (IOException e) {
                        String errmsg = "SMSFlatFileObject.initialize: cannot create file, " + nameMapFilename + ". Exception " + e.getMessage();
                        this.mDebug.error(errmsg);
                        throw new SMSException(errmsg);
                    }
                    catch (SecurityException e) {
                        String errmsg = "SMSFlatFileObject.initialize: cannot create file " + nameMapFilename + ". Exception " + e.getMessage();
                        this.mDebug.error(errmsg);
                        throw new SMSException(errmsg);
                    }
                    this.mNameMap = new CaseInsensitiveProperties();
                    try {
                        this.create(null, this.mRootDN, new HashMap());
                        if (this.mDebug.messageEnabled()) {
                            this.mDebug.message("SMSFlatFileObject.initialize: created SMS object for " + this.mRootDN);
                        }
                    }
                    catch (SSOException e) {
                    }
                    catch (ServiceAlreadyExistsException e) {
                        if (!this.mDebug.messageEnabled()) break block14;
                        this.mDebug.message("SMSFlatFileObject.initialize: " + this.mRootDN + " already exists");
                    }
                }
                try {
                    this.create(null, "ou=services," + this.mRootDN, new HashMap());
                    if (this.mDebug.messageEnabled()) {
                        this.mDebug.message("SMSFlatFileObject.initialize: created SMS object for ou=services," + this.mRootDN);
                    }
                }
                catch (SSOException e) {
                }
                catch (ServiceAlreadyExistsException e) {
                    if (!this.mDebug.messageEnabled()) break block15;
                    this.mDebug.message("SMSFlatFileObject.initialize: ou=services," + this.mRootDN + " already exists");
                }
            }
        }
    }

    private String getAttrFile(String objName) {
        int j;
        int i;
        String attrFile = null;
        String objKey = objName.toLowerCase();
        attrFile = this.mNameMap.getProperty(objKey);
        if (attrFile != null) {
            return attrFile;
        }
        int index = objName.indexOf(44);
        if (index != -1 && (attrFile = this.mNameMap.getProperty(objKey = objKey.substring(index + 1))) != null) {
            String dirName = objName.substring(0, index).trim();
            StringBuffer sb = new StringBuffer(attrFile.length() + dirName.length() + 2);
            sb.append(attrFile.substring(0, attrFile.length() - DEFAULT_ATTRIBUTE_FILENAME.length()));
            sb.append(FileNameEncoder.encode(dirName));
            sb.append(File.separatorChar);
            sb.append(DEFAULT_ATTRIBUTE_FILENAME);
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer(this.mRootDir.length() + objName.length() + 20);
        sb.append(this.mRootDir);
        sb.append(File.separatorChar);
        char[] objchars = objName.toCharArray();
        for (i = j = objchars.length - 1; i >= 0; --i) {
            if (objchars[i] != ',') continue;
            if (i == j) {
                --j;
                continue;
            }
            String rdn = new String(objchars, i + 1, j - i).trim();
            String encodedRdn = FileNameEncoder.encode(rdn);
            sb.append(encodedRdn);
            sb.append(File.separatorChar);
            j = i - 1;
        }
        if (i != j) {
            String lastRdn = new String(objchars, 0, j - i);
            String encodedLastRdn = FileNameEncoder.encode(lastRdn);
            sb.append(encodedLastRdn);
            sb.append(File.separatorChar);
        }
        sb.append(DEFAULT_ATTRIBUTE_FILENAME);
        attrFile = sb.toString();
        return attrFile;
    }

    private void createLookupFiles(File dirHandle, String attr, Set sunserviceids) throws SMSException {
        StringBuffer sb = new StringBuffer(dirHandle.getPath());
        sb.append(File.separatorChar);
        sb.append(attr);
        sb.append('=');
        String fileprefix = sb.toString();
        Iterator i = sunserviceids.iterator();
        while (i.hasNext()) {
            String id = ((String)i.next()).toLowerCase();
            File idFile = new File(fileprefix + id);
            try {
                idFile.createNewFile();
            }
            catch (IOException e) {
                String errmsg = "SMSFlatFileObject.createLookupIdFiles:  File, " + idFile.getPath() + ". Exception: " + e.getMessage();
                this.mDebug.error("SMSFlatFileObject.createLookupIdFiles", (Throwable)e);
                throw new SMSException(errmsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getSubEntries(String objName, String filter, String sidFilter, boolean isSubConfig, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException {
        String objKey = objName.toLowerCase();
        AbstractSet subentries = null;
        this.mRWLock.readRequest();
        try {
            String filepath = this.mNameMap.getProperty(objKey);
            if (filepath == null) {
                String errmsg = "SMSFlatFileObjectBase.getSubEntries: " + objName + " : not found in objects map.";
                this.mDebug.warning(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
            File filehandle = new File(filepath);
            File parentDir = filehandle.getParentFile();
            if (!parentDir.isDirectory()) {
                String errmsg = "SMSFlatFileObject.getSubEntries: " + objName + " : " + filehandle.getPath() + " does not exist or is not a directory.";
                this.mDebug.error(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
            FilenameFilter subentFileFilter = new FilenameFilter(filter);
            FilenameFilter sidFileFilter = null;
            if (sidFilter != null && sidFilter.length() > 0) {
                sidFileFilter = isSubConfig ? new FilenameFilter("sunserviceID=" + sidFilter.toLowerCase()) : new FilenameFilter("sunxmlKeyValue=" + sidFilter.toLowerCase());
            }
            subentries = sortResults ? new CaseInsensitiveTreeSet(ascendingOrder) : new CaseInsensitiveHashSet();
            File[] subentriesFound = parentDir.listFiles(subentFileFilter);
            int numEntriesAdded = 0;
            boolean done = false;
            for (int i = 0; i < subentriesFound.length && !done; ++i) {
                File[] sunserviceidFiles = null;
                if (sidFileFilter != null && ((sunserviceidFiles = subentriesFound[i].listFiles(sidFileFilter)) == null || sunserviceidFiles.length <= 0)) continue;
                String filename = subentriesFound[i].getName();
                int equalSign = filename.indexOf(61);
                if (equalSign < 0 || equalSign == filename.length() - 1) {
                    String errmsg = "SMSFlatFileObject.getSubEntries: Invalid sub entry name found: " + filename;
                    this.mDebug.error(errmsg);
                    throw new SchemaException(errmsg);
                }
                String subentryname = FileNameDecoder.decode(filename.substring(equalSign + 1));
                subentries.add(subentryname);
                done = !sortResults && numOfEntries > 0 && ++numEntriesAdded == numOfEntries;
            }
            if (sortResults && numOfEntries > 0) {
                while (numEntriesAdded - numOfEntries > 0) {
                    Object l = ((CaseInsensitiveTreeSet)subentries).last();
                    subentries.remove(l);
                    --numEntriesAdded;
                }
            }
        }
        finally {
            this.mRWLock.readDone();
        }
        return subentries;
    }

    protected void deleteSunXmlKeyValFiles(File dirHandle) throws SMSException {
        StringBuffer sb = new StringBuffer("sunxmlKeyValue");
        sb.append("=*");
        FilenameFilter filter = new FilenameFilter(sb.toString());
        File[] deleteFiles = dirHandle.listFiles(filter);
        for (int i = 0; deleteFiles != null && i < deleteFiles.length; ++i) {
            File deleteFile = deleteFiles[i];
            deleteFile.delete();
        }
    }

    public SMSFlatFileObject() throws SMSException {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map read(SSOToken token, String objName) throws SMSException, SSOException {
        CaseInsensitiveHashMap attrMap;
        block10: {
            if (objName == null || objName.length() == 0) {
                throw new IllegalArgumentException("SMSFlatFileObject.read: object name is null or empty.");
            }
            String objKey = objName.toLowerCase();
            attrMap = null;
            this.mRWLock.readRequest();
            try {
                String filepath = this.mNameMap.getProperty(objKey);
                if (filepath == null) {
                    if (this.mDebug.messageEnabled()) {
                        this.mDebug.message("SMSFlatFileObject.read: object " + objName + " not found.");
                    }
                    break block10;
                }
                File filehandle = new File(filepath);
                Properties props = null;
                try {
                    props = this.loadProperties(filehandle, objName);
                }
                catch (ServiceNotFoundException e) {
                    // empty catch block
                }
                if (props != null) {
                    attrMap = new CaseInsensitiveHashMap();
                    Enumeration<?> keys = props.propertyNames();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String vals = props.getProperty(key);
                        if (vals == null || vals.length() <= 0) continue;
                        attrMap.put(key, this.toValSet(key, vals));
                    }
                }
            }
            finally {
                this.mRWLock.readDone();
            }
        }
        return attrMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(SSOToken token, String objName, Map attrs) throws SMSException, SSOException {
        if (objName == null || objName.length() == 0 || attrs == null) {
            throw new IllegalArgumentException("SMSFlatFileObject.create: One or more arguments is null or empty");
        }
        String objKey = objName.toLowerCase();
        String filepath = null;
        this.mRWLock.readRequest();
        try {
            filepath = this.mNameMap.getProperty(objKey);
            if (filepath != null) {
                String errmsg = "SMSFlatFileObject.create: object " + objName + " already exists in " + filepath;
                this.mDebug.error(errmsg);
                throw new ServiceAlreadyExistsException(errmsg);
            }
        }
        finally {
            this.mRWLock.readDone();
        }
        this.mRWLock.writeRequest();
        try {
            filepath = this.mNameMap.getProperty(objKey);
            if (filepath != null) {
                String errmsg = "SMSFlatFileObject.create: object " + objName + " already exists in " + filepath;
                this.mDebug.error(errmsg);
                throw new ServiceAlreadyExistsException(errmsg);
            }
            filepath = this.getAttrFile(objName);
            File filehandle = new File(filepath);
            File parentDir = filehandle.getParentFile();
            if (parentDir.isDirectory()) {
                String errmsg = "SMSFlatFileObject.create: object " + objName + " directory " + parentDir.getPath() + " exists before create!";
                this.mDebug.error(errmsg);
                throw new ServiceAlreadyExistsException(errmsg);
            }
            Set sunserviceids = null;
            Set sunxmlkeyvals = null;
            Properties props = new Properties();
            Set keys = attrs.keySet();
            if (keys != null) {
                for (String key : keys) {
                    Set vals = (Set)attrs.get(key);
                    if (key.equalsIgnoreCase("sunserviceID")) {
                        sunserviceids = vals;
                    } else if (key.equalsIgnoreCase("sunxmlKeyValue")) {
                        sunxmlkeyvals = vals;
                    }
                    props.put(key, this.toValString(vals));
                }
            }
            try {
                String errmsg;
                if (!parentDir.mkdirs()) {
                    errmsg = "SMSFlatFileObject.create: object " + objName + ": Could not create directory " + parentDir.getPath();
                    this.mDebug.error(errmsg);
                    throw new SMSException(errmsg);
                }
                try {
                    if (!filehandle.createNewFile()) {
                        errmsg = "SMSFlatFileObject.create: object " + objName + ": Could not create file " + filepath;
                        this.mDebug.error(errmsg);
                        throw new SMSException(errmsg);
                    }
                }
                catch (IOException e) {
                    String errmsg2 = "SMSFlatFileObject.create: object " + objName + " IOException encountered when creating file " + filehandle.getPath() + ". Exception: " + e.getMessage();
                    this.mDebug.error("SMSFlatFileObject.create", (Throwable)e);
                    throw new SMSException(errmsg2);
                }
                this.saveProperties(props, filehandle, objName);
                if (sunserviceids != null && !sunserviceids.isEmpty()) {
                    this.createSunServiceIdFiles(parentDir, sunserviceids);
                }
                if (sunxmlkeyvals != null && !sunxmlkeyvals.isEmpty()) {
                    this.createSunXmlKeyValFiles(parentDir, sunxmlkeyvals);
                }
                this.mNameMap.setProperty(objKey, filepath);
                this.saveProperties(this.mNameMap, this.mNameMapHandle, null);
            }
            catch (SMSException e) {
                this.deleteDir(parentDir);
                this.mNameMap.remove(objKey);
                throw e;
            }
        }
        finally {
            this.mRWLock.writeDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(SSOToken token, String objName, ModificationItem[] mods) throws SMSException, SSOException {
        if (objName == null || objName.length() == 0 || mods == null || mods.length == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.modify: One or more arguments is null or empty");
        }
        String objKey = objName.toLowerCase();
        String filepath = null;
        this.mRWLock.readRequest();
        try {
            filepath = this.mNameMap.getProperty(objKey);
            if (filepath == null) {
                String errmsg = "SMSFlatFileObject.modify: object " + objName + " not found.";
                this.mDebug.error(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
        }
        finally {
            this.mRWLock.readDone();
        }
        this.mRWLock.writeRequest();
        try {
            filepath = this.mNameMap.getProperty(objKey);
            if (filepath == null) {
                String errmsg = "SMSFlatFileObject.modify: object " + objName + " not found.";
                this.mDebug.error(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
            File filehandle = new File(filepath);
            if (!filehandle.isFile()) {
                String errmsg = "SMSFlatFileObject.modify: Attributes file for object " + objName + " not found.";
                this.mDebug.error(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
            Properties props = this.loadProperties(filehandle, objName);
            boolean hasSunXmlKeyValue = props.getProperty("sunxmlKeyValue") != null;
            for (int i = 0; i < mods.length; ++i) {
                this.modifyValues(objName, mods[i], props);
            }
            this.saveProperties(props, filehandle, objName);
            if (!hasSunXmlKeyValue) {
                boolean bl = hasSunXmlKeyValue = props.getProperty("sunxmlKeyValue") != null;
            }
            if (hasSunXmlKeyValue) {
                this.deleteSunXmlKeyValFiles(filehandle.getParentFile());
                Set xmlKeyVals = this.toValSet("sunxmlKeyValue", props.getProperty("sunxmlKeyValue"));
                this.createSunXmlKeyValFiles(filehandle.getParentFile(), xmlKeyVals);
            }
        }
        finally {
            this.mRWLock.writeDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SSOToken token, String objName) throws SMSException, SSOException {
        if (objName == null || objName.length() == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.delete: object name is null or empty.");
        }
        String objKey = objName.toLowerCase();
        String filepath = null;
        this.mRWLock.readRequest();
        try {
            filepath = this.mNameMap.getProperty(objKey);
            if (filepath == null && this.mDebug.messageEnabled()) {
                this.mDebug.message("SMSFlatFileObject.delete: " + objName + ": object not found.");
            }
        }
        finally {
            this.mRWLock.readDone();
        }
        if (filepath != null) {
            this.mRWLock.writeRequest();
            try {
                filepath = this.mNameMap.getProperty(objKey);
                if (filepath == null) {
                    if (this.mDebug.messageEnabled()) {
                        this.mDebug.message("SMSFlatFileObject.delete: " + objName + ": object not found.");
                    }
                } else {
                    File filehandle = new File(filepath);
                    File parentDir = filehandle.getParentFile();
                    this.deleteDir(parentDir);
                    objName = objName.toLowerCase();
                    Enumeration<Object> keysEnum = this.mNameMap.keys();
                    while (keysEnum.hasMoreElements()) {
                        String key = (String)keysEnum.nextElement();
                        if (!key.endsWith(objName)) continue;
                        this.mNameMap.remove(key);
                    }
                    this.saveProperties(this.mNameMap, this.mNameMapHandle, null);
                }
            }
            finally {
                this.mRWLock.writeDone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(SSOToken token, String objName) {
        boolean exists = false;
        if (objName == null || objName.length() == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.entryExists: One or more arguments is null or empty.");
        }
        this.mRWLock.readRequest();
        try {
            String filepath = this.mNameMap.getProperty(objName.toLowerCase());
            if (filepath != null) {
                exists = true;
            }
        }
        finally {
            this.mRWLock.readDone();
        }
        return exists;
    }

    public String toString() {
        return "SMSFlatFileObject";
    }

    private void deleteDir(File dirhandle) throws SMSException {
        File[] files = dirhandle.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDir(files[i]);
                    continue;
                }
                if (files[i].delete()) continue;
                String errmsg = "SMSFlatFileObject.delete: File " + files[i].getPath() + " could not be removed!";
                this.mDebug.error(errmsg);
                throw new SMSException(errmsg);
            }
        }
        dirhandle.delete();
    }

    private void createSunXmlKeyValFiles(File dirHandle, Set sunxmlkeyvals) throws SMSException {
        this.createLookupFiles(dirHandle, "sunxmlKeyValue", sunxmlkeyvals);
    }

    private void createSunServiceIdFiles(File dirHandle, Set sunserviceids) throws SMSException {
        this.createLookupFiles(dirHandle, "sunserviceID", sunserviceids);
    }

    private class FilenameFilter
    implements FileFilter {
        Pattern pattern;

        public FilenameFilter(String filter) {
            if (filter != null && filter.length() != 0 && !filter.equals("*")) {
                int idx = filter.indexOf(42);
                while (idx != -1) {
                    filter = filter.substring(0, idx) + ".*" + filter.substring(idx + 1);
                    idx = filter.indexOf(42, idx + 2);
                }
                this.pattern = Pattern.compile(filter.toLowerCase());
            }
        }

        public boolean accept(File file) {
            String filename = file.getName();
            if (this.pattern == null) {
                return true;
            }
            return this.pattern.matcher(filename.toLowerCase()).matches();
        }
    }
}

