/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.log.Logger;
import com.sun.identity.setup.EmbeddedOpenDS;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.logging.Level;

public class EmbeddedStatus
extends ServerConfigBase {
    private static final String SERVER_CONFIG_XML_FILE = "serverconfigxml";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{};
        System.out.println("RYA : EMB: ");
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_EMBEDDED_STATUS", params);
            String port = this.getStringOptionValue("port");
            String passwd = this.getAdminPassword();
            if (passwd == null) {
                passwd = this.getStringOptionValue("password");
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayOutputStream boe = new ByteArrayOutputStream();
            Logger.token.set(adminSSOToken);
            int stat = EmbeddedOpenDS.getReplicationStatus(port, passwd, bos, boe);
            Logger.token.set(null);
            String str = bos.toString();
            String stre = boe.toString();
            String[] params1 = new String[]{Integer.toString(stat)};
            outputWriter.printMessage(MessageFormat.format(this.getResourceString("embedded-status-status"), params1));
            outputWriter.printlnMessage("\n");
            outputWriter.printlnMessage(str);
            outputWriter.printlnMessage("\n");
            outputWriter.printlnMessage(stre);
            outputWriter.printlnMessage("\n");
            this.writeLog(0, Level.INFO, "SUCCEED_EMBEDDED_STATUS", params);
        }
        catch (Exception e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("EmbeddedStatus.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_EMBEDDED_STATUS", args);
            throw new CLIException(e, 127);
        }
    }
}

