/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.admin;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class PossibleLocales
extends ChoiceValues {
    private static SSOToken ssoToken = PossibleLocales.getAdminSSOToken();
    private static final String G11N_SERIVCE_LOCALE_CHARSET_MAPPING = "sun-identity-g11n-settings-locale-charset-mapping";
    private static final String G11N_SERVICE_NAME = "iPlanetG11NSettings";
    private static final String SEPARATOR = "|";
    private static final String LOCALE_ATTR = "locale";
    private static Set DEFAULT_LOCALES;
    private static Debug debug;

    public Map getChoiceValues() {
        AttributeSchema attributeSchema;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", "-");
        ServiceSchemaManager mgr = this.getG11NServiceSchemaManager();
        Set values = DEFAULT_LOCALES;
        if (mgr != null && (attributeSchema = this.getLocaleCharsetMappingAttributeSchema(mgr)) != null) {
            values = attributeSchema.getDefaultValues();
        }
        if (values != null && !values.isEmpty()) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                String locale = PossibleLocales.parseLocaleCharsetValue((String)iter.next());
                if (locale == null || locale.length() <= 0) continue;
                map.put(locale, locale);
            }
        }
        return map;
    }

    private static String parseLocaleCharsetValue(String localeCharset) {
        String locale = null;
        StringTokenizer st = new StringTokenizer(localeCharset, SEPARATOR);
        while (st.hasMoreTokens() && locale == null) {
            locale = PossibleLocales.getLocale(st.nextToken());
        }
        return locale;
    }

    private static String getLocale(String str) {
        String attr;
        String locale = null;
        StringTokenizer st = new StringTokenizer(str, "=");
        if (st.countTokens() == 2 && (attr = st.nextToken()).equals(LOCALE_ATTR)) {
            locale = st.nextToken();
        }
        return locale;
    }

    private AttributeSchema getLocaleCharsetMappingAttributeSchema(ServiceSchemaManager mgr) {
        AttributeSchema attributeSchema = null;
        try {
            ServiceSchema schema = mgr.getSchema(SchemaType.GLOBAL);
            if (schema != null) {
                attributeSchema = schema.getAttributeSchema(G11N_SERIVCE_LOCALE_CHARSET_MAPPING);
            }
        }
        catch (SMSException smse) {
            debug.error("PossibleLocales.getLocaleCharsetMappingAttributeSchema", (Throwable)smse);
        }
        return attributeSchema;
    }

    private ServiceSchemaManager getG11NServiceSchemaManager() {
        ServiceSchemaManager mgr;
        block4: {
            mgr = null;
            if (ssoToken != null) {
                try {
                    mgr = new ServiceSchemaManager(G11N_SERVICE_NAME, ssoToken);
                }
                catch (SSOException ssoe) {
                    debug.error("PossibleLocales.getG11NServiceSchemaManager", (Throwable)((Object)ssoe));
                }
                catch (SMSException smse) {
                    String installTime = SystemProperties.get("installTime", "false");
                    if (!installTime.equals("false")) break block4;
                    debug.error("PossibleLocales.getG11NServiceSchemaManager", (Throwable)smse);
                }
            }
        }
        return mgr;
    }

    private static SSOToken getAdminSSOToken() {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    static {
        debug = Debug.getInstance((String)"PossibleLocales");
        DEFAULT_LOCALES = new HashSet();
        DEFAULT_LOCALES.add("locale=en|charset=UTF-8;ISO-8859-1");
        DEFAULT_LOCALES.add("locale=ja|charset=UTF-8;Shift_JIS;EUC-JP");
        DEFAULT_LOCALES.add("locale=fr|charset=UTF-8;ISO-8859-15");
        DEFAULT_LOCALES.add("locale=de|charset=UTF-8;ISO-8859-15");
        DEFAULT_LOCALES.add("locale=es|charset=UTF-8;ISO-8859-15");
        DEFAULT_LOCALES.add("locale=ko|charset=UTF-8;EUC-KR");
        DEFAULT_LOCALES.add("locale=zh|charset=UTF-8;GB2312");
        DEFAULT_LOCALES.add("locale=ar|charset=UTF-8;ISO-8859-6");
        DEFAULT_LOCALES.add("locale=th|charset=UTF-8;TIS-620");
        DEFAULT_LOCALES.add("locale=zh_TW|charset=UTF-8;BIG5");
    }
}

