/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.PolicyReferralViewBeanBase;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.web.ui.model.CCPageTitleModel;
import java.io.Serializable;
import java.text.MessageFormat;

public class PolicyReferralEditViewBean
extends PolicyReferralViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/PolicyReferralEdit.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";

    public PolicyReferralEditViewBean() {
        super("PolicyReferralEdit", DEFAULT_DISPLAY_URL);
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
        this.ptModel.setPageTitleText("page.title.policy.edit");
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        PolicyModel model = (PolicyModel)this.getModel();
        String cacheID = (String)this.getPageSessionAttribute("policyCacheID");
        try {
            CachedPolicy cachedPolicy = model.getCachedPolicy(cacheID);
            String policyName = cachedPolicy.getTrackPolicyName();
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            try {
                cacheID = model.cachePolicy(curRealm, policyName);
                this.setPageSessionAttribute("policyCacheID", (Serializable)((Object)cacheID));
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyReferralEditViewBean.handleButton2Request", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        String currentRealm = (String)this.getPageSessionAttribute("currentRealm");
        try {
            if (!this.reconstructPolicy()) {
                CachedPolicy cachedPolicy = this.getCachedPolicy();
                PolicyModel model = (PolicyModel)this.getModel();
                try {
                    model.replacePolicy(currentRealm, cachedPolicy.getPolicy());
                    this.setInlineAlertMessage("info", "message.information", "policy.modified.message");
                    cachedPolicy.setPolicyModified(false);
                }
                catch (AMConsoleException e) {
                    this.setInlineAlertMessage("error", "message.error", e.getMessage());
                }
            }
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyReferralEditViewBean.handleButton1Request", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    protected String getBreadCrumbDisplayName() {
        PolicyModel model = (PolicyModel)this.getModel();
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            String[] arg = new String[]{cachedPolicy.getTrackPolicyName()};
            return MessageFormat.format(model.getLocalizedString("breadcrumbs.editPolicy"), arg);
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyReferralEditViewBean.getBreadCrumbDisplayName", (Throwable)e);
            return "";
        }
    }

    protected boolean startPageTrail() {
        return false;
    }

    protected boolean isProfilePage() {
        return true;
    }
}

