/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AMIdentitySubject
implements Subject {
    private Set subjectValues = new HashSet();
    private static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map configParams) throws PolicyException {
    }

    public Syntax getValueSyntax(SSOToken token) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken token) throws SSOException, PolicyException {
        return this.getValidValues(token, "*");
    }

    public ValidValues getValidValues(SSOToken token, String pattern) throws SSOException, PolicyException {
        throw new PolicyException("amPolicy", "am_id_subject_does_not_support_getvalidvalues", null, null);
    }

    public String getDisplayNameForValue(String value, Locale locale) throws NameNotFoundException {
        return value;
    }

    public Set getValues() {
        if (this.subjectValues == null) {
            return Collections.EMPTY_SET;
        }
        return this.subjectValues;
    }

    public void setValues(Set names) throws InvalidNameException {
        if (names == null) {
            throw new InvalidNameException("amPolicy", "amidentity_subject_invalid_subject_values", null, null, 5);
        }
        this.subjectValues.addAll(names);
        if (debug.messageEnabled()) {
            debug.message("AMIdentitySubejct set subjectValues to: " + this.subjectValues);
        }
    }

    public boolean isMember(SSOToken token) throws SSOException, PolicyException {
        SSOTokenID tokenIDObject;
        String tokenID = null;
        String userDN = null;
        if (token != null && (tokenIDObject = token.getTokenID()) != null) {
            tokenID = ((Object)tokenIDObject).toString();
        }
        if (tokenID == null) {
            if (debug.warningEnabled()) {
                debug.warning("AMIdentitySubject.isMember():tokenID is null");
                debug.warning("AMIdentitySubject.isMember():returning false");
            }
            return false;
        }
        Principal principal = token.getPrincipal();
        if (principal != null) {
            userDN = principal.getName();
        }
        if (userDN == null) {
            if (debug.warningEnabled()) {
                debug.warning("AMIdentitySubject.isMember():userDN is null");
                debug.warning("AMIdentitySubject.isMember():returning false");
            }
            return false;
        }
        boolean listenerAdded = false;
        boolean subjectMatch = false;
        if (debug.messageEnabled()) {
            debug.message("AMIndentitySubject.isMember(): entering with userDN = " + userDN);
        }
        if (this.subjectValues.size() > 0) {
            Iterator valueIter = this.subjectValues.iterator();
            while (valueIter.hasNext()) {
                Boolean matchFound = null;
                String subjectValue = (String)valueIter.next();
                if (debug.messageEnabled()) {
                    debug.message("AMIndentitySubject.isMember(): checking membership with userDN = " + userDN + ", subjectValue = " + subjectValue);
                }
                if ((matchFound = SubjectEvaluationCache.isMember(tokenID, "AMIdentitySubject", subjectValue)) != null) {
                    boolean result;
                    if (debug.messageEnabled()) {
                        debug.message("AMIdentitySubject.isMember():got membership from SubjectEvaluationCache  for userDN = " + userDN + ", subjectValue = " + subjectValue + ", result = " + matchFound);
                    }
                    if (!(result = matchFound.booleanValue())) continue;
                    if (debug.messageEnabled()) {
                        debug.message("AMIndentitySubject.isMember():  returning membership status = " + result);
                    }
                    return result;
                }
                if (debug.messageEnabled()) {
                    debug.message("AMIdentitySubject:isMember():entry for " + subjectValue + " not in subject evaluation " + "cache, so compute using IDRepo api");
                }
                try {
                    AMIdentity subjectIdentity = IdUtils.getIdentity(this.getAdminToken(), subjectValue);
                    if (subjectIdentity == null) {
                        if (debug.messageEnabled()) {
                            debug.message("AMidentitySubject.isMember():subjectIdentity is null for subjectValue = " + subjectValue);
                            debug.message("AMidentitySubject.isMember():returning false");
                        }
                        return false;
                    }
                    AMIdentity tmpIdentity = IdUtils.getIdentity(token);
                    String univId = IdUtils.getUniversalId(tmpIdentity);
                    AMIdentity userIdentity = IdUtils.getIdentity(this.getAdminToken(), univId);
                    if (userIdentity == null) {
                        if (debug.messageEnabled()) {
                            debug.message("AMidentitySubject.isMember():userIdentity is null");
                            debug.message("AMidentitySubject.isMember():returning false");
                        }
                        return false;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMidentitySubject.isMember():user uuid = " + IdUtils.getUniversalId(userIdentity) + ", subject uuid = " + IdUtils.getUniversalId(subjectIdentity));
                    }
                    IdType userIdType = userIdentity.getType();
                    IdType subjectIdType = subjectIdentity.getType();
                    Set allowedMemberTypes = null;
                    if (userIdentity.equals(subjectIdentity)) {
                        if (debug.messageEnabled()) {
                            debug.message("AMidentitySubject.isMember():userIdentity equals subjectIdentity:membership=true");
                        }
                        subjectMatch = true;
                    } else {
                        allowedMemberTypes = subjectIdType.canHaveMembers();
                        if (allowedMemberTypes != null && allowedMemberTypes.contains(userIdType)) {
                            subjectMatch = userIdentity.isMember(subjectIdentity);
                            if (debug.messageEnabled()) {
                                debug.message("AMIdentitySubject.isMember():userIdentity type " + userIdType + " can be a member of " + "subjectIdentityType " + subjectIdType + ":membership=" + subjectMatch);
                            }
                        } else {
                            subjectMatch = false;
                            if (debug.messageEnabled()) {
                                debug.message("AMIdentitySubject.isMember():userIdentity type " + userIdType + " can not be a member of " + "subjectIdentityType " + subjectIdType + ":membership=" + subjectMatch);
                            }
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMIdentitySubject.isMember: adding entry in SubjectEvaluationCache for , for userDN = " + userDN + ", subjectValue = " + subjectValue + ", subjectMatch = " + subjectMatch);
                    }
                    SubjectEvaluationCache.addEntry(tokenID, "AMIdentitySubject", subjectValue, subjectMatch);
                    if (!listenerAdded && !PolicyEvaluator.ssoListenerRegistry.containsKey(tokenID)) {
                        token.addSSOTokenListener(PolicyEvaluator.ssoListener);
                        PolicyEvaluator.ssoListenerRegistry.put(tokenID, PolicyEvaluator.ssoListener);
                        if (debug.messageEnabled()) {
                            debug.message("AMIdentitySubject.isMember(): sso listener added ");
                        }
                        listenerAdded = true;
                    }
                    if (!subjectMatch) continue;
                    break;
                }
                catch (IdRepoException ire) {
                    debug.warning("AMidentitySubject.isMember():can not check membership for user " + userDN + ", subject " + subjectValue, (Throwable)ire);
                    Object[] args = new String[]{userDN, subjectValue};
                    throw new PolicyException("amPolicy", "am_id_subject_membership_evaluation_error", args, ire);
                }
            }
        }
        if (debug.messageEnabled()) {
            if (!subjectMatch) {
                debug.message("AMIdentitySubject.isMember(): user " + userDN + " is not a member of this subject");
            } else {
                debug.message("AMIdentitySubject.isMember(): User " + userDN + " is a member of this subject");
            }
        }
        return subjectMatch;
    }

    public int hashCode() {
        return ((Object)this.subjectValues).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AMIdentitySubject) {
            AMIdentitySubject subject = (AMIdentitySubject)o;
            return ((Object)this.subjectValues).equals(subject.subjectValues);
        }
        return false;
    }

    public Object clone() {
        AMIdentitySubject theClone = null;
        try {
            theClone = (AMIdentitySubject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.subjectValues != null) {
            theClone.subjectValues = new HashSet();
            theClone.subjectValues.addAll(this.subjectValues);
        }
        return theClone;
    }

    private SSOToken getAdminToken() throws SSOException {
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (token == null) {
            throw new SSOException(new PolicyException("amPolicy", "invalid_admin", null, null));
        }
        return token;
    }
}

