/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.criteria.KeyNameCriteria;
import org.opensaml.xml.security.criteria.PublicKeyCriteria;
import org.opensaml.xml.security.keyinfo.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoProvider;
import org.opensaml.xml.security.keyinfo.KeyInfoResolutionContext;

public class LocalKeyInfoCredentialResolver
extends BasicProviderKeyInfoCredentialResolver {
    private CredentialResolver localCredResolver;

    public LocalKeyInfoCredentialResolver(List<KeyInfoProvider> keyInfoProviders, CredentialResolver localCredentialResolver) {
        super(keyInfoProviders);
        if (localCredentialResolver == null) {
            throw new IllegalArgumentException("Local credential resolver must be supplied");
        }
        this.localCredResolver = localCredentialResolver;
    }

    public CredentialResolver getLocalCredentialResolver() {
        return this.localCredResolver;
    }

    @Override
    protected void postProcess(KeyInfoResolutionContext kiContext, CriteriaSet criteriaSet, List<Credential> credentials) throws SecurityException {
        ArrayList<Credential> localCreds = new ArrayList<Credential>();
        for (Credential cred : credentials) {
            if (this.isLocalCredential(cred)) {
                localCreds.add(cred);
                continue;
            }
            if (cred.getPublicKey() == null) continue;
            localCreds.addAll(this.resolveByPublicKey(cred.getPublicKey()));
        }
        for (String keyName : kiContext.getKeyNames()) {
            localCreds.addAll(this.resolveByKeyName(keyName));
        }
        credentials.clear();
        credentials.addAll(localCreds);
    }

    protected boolean isLocalCredential(Credential credential) {
        return credential.getPrivateKey() != null || credential.getSecretKey() != null;
    }

    protected Collection<? extends Credential> resolveByKeyName(String keyName) throws SecurityException {
        ArrayList<Credential> localCreds = new ArrayList<Credential>();
        CriteriaSet criteriaSet = new CriteriaSet(new KeyNameCriteria(keyName));
        for (Credential cred : this.getLocalCredentialResolver().resolve(criteriaSet)) {
            if (!this.isLocalCredential(cred)) continue;
            localCreds.add(cred);
        }
        return localCreds;
    }

    protected Collection<? extends Credential> resolveByPublicKey(PublicKey publicKey) throws SecurityException {
        ArrayList<Credential> localCreds = new ArrayList<Credential>();
        CriteriaSet criteriaSet = new CriteriaSet(new PublicKeyCriteria(publicKey));
        for (Credential cred : this.getLocalCredentialResolver().resolve(criteriaSet)) {
            if (!this.isLocalCredential(cred)) continue;
            localCreds.add(cred);
        }
        return localCreds;
    }
}

