/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.FormatUtils;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.util.Set;
import java.util.logging.Level;

public class RealmGetAssignedServices
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        boolean incMandatory = this.isOptionSet("mandatory");
        String strMandatory = incMandatory ? "include mandatory" : "exclude mandatory";
        String[] params = new String[]{realm, strMandatory};
        this.writeLog(0, Level.INFO, "ATTEMPT_GET_ASSIGNED_SERVICES_OF_REALM", params);
        try {
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            Set serviceNames = ocm.getAssignedServices(incMandatory);
            Set dynamicServiceNames = this.getAssignedDynamicServiceNames(adminSSOToken, realm);
            if (dynamicServiceNames != null && !dynamicServiceNames.isEmpty()) {
                if (serviceNames != null && !serviceNames.isEmpty()) {
                    serviceNames.addAll(dynamicServiceNames);
                } else {
                    serviceNames = dynamicServiceNames;
                }
            }
            IOutput outputWriter = this.getOutputWriter();
            if (serviceNames != null && !serviceNames.isEmpty()) {
                String msg = this.getResourceString("realm-get-assigned-services-results");
                outputWriter.printlnMessage(FormatUtils.printServiceNames(serviceNames, msg, adminSSOToken));
                outputWriter.printlnMessage(this.getResourceString("realm-get-assigned-services-succeed"));
            } else {
                outputWriter.printlnMessage(this.getResourceString("realm-get-assigned-services-no-services"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_GET_ASSIGNED_SERVICES_OF_REALM", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmGetAssignedServices.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_GET_ASSIGNED_SERVICES_OF_REALM", args);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmGetAssignedServices.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_ASSIGNED_SERVICES_OF_REALM", args);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmGetAssignedServices.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_ASSIGNED_SERVICES_OF_REALM", args);
            throw new CLIException(e, 127);
        }
    }

    private Set getAssignedDynamicServiceNames(SSOToken adminSSOToken, String realm) throws SMSException, IdRepoException, SSOException {
        AMIdentityRepository repo = new AMIdentityRepository(adminSSOToken, realm);
        AMIdentity ai = repo.getRealmIdentity();
        return ai.getAssignedServices();
    }
}

